/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.KingpinLDAPConnection;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class ChangeDirectoryDialog
extends AbstractDialog {
    private static final String PREFERENCES_SEARCH_DIRECTORY = "SearchBaseDN";
    private static final String PREFERENCE_HOST = "Host";
    private static final String PREFERENCE_PORT = "Port";
    private static final String PREFERENCE_BASE_DN = "BaseDN";
    private static final String PREFERENCE_AUTH_DN = "AuthDN";
    private static final String PREFERENCE_AUTH_PASSWORD = "AuthPassword";
    private static final String PREFERENCE_SSL = "SSL";
    ConsoleInfo _info;
    boolean _fChanged;
    JCheckBox _ssl;
    JTextField _host;
    JTextField _port;
    JTextField _baseDN;
    JTextField _username;
    SingleBytePasswordField _password;
    ResourceSet _resource = TopologyInitializer._resource;
    static final String _sChangeDirectory = "ChangeDirectory";
    private Help _helpSession = new Help(this._resource);

    public ChangeDirectoryDialog(JFrame jFrame, ConsoleInfo consoleInfo) {
        super((Frame)jFrame, TopologyInitializer._resource.getString("General", _sChangeDirectory), true, 11);
        this._info = consoleInfo;
        this._fChanged = false;
        this.initializeUI();
    }

    private void initializeUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(this._resource.getString(_sChangeDirectory, PREFERENCE_HOST), 4);
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, 0, 0, 0, 0);
        JLabel jLabel2 = new JLabel(this._resource.getString(_sChangeDirectory, PREFERENCE_PORT), 4);
        GridBagUtil.constrain(jPanel, jLabel2, 0, 1, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        JLabel jLabel3 = new JLabel(this._resource.getString(_sChangeDirectory, PREFERENCE_BASE_DN), 4);
        GridBagUtil.constrain(jPanel, jLabel3, 0, 2, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        JLabel jLabel4 = new JLabel(this._resource.getString(_sChangeDirectory, "Username"), 4);
        GridBagUtil.constrain(jPanel, jLabel4, 0, 3, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        JLabel jLabel5 = new JLabel(this._resource.getString(_sChangeDirectory, "Password"), 4);
        GridBagUtil.constrain(jPanel, jLabel5, 0, 4, 1, 1, 0.0, 0.0, 17, 2, 12, 0, 0, 0);
        JLabel jLabel6 = new JLabel("");
        GridBagUtil.constrain(jPanel, jLabel6, 0, 5, 0, 0, 1.0, 1.0, 17, 1, 12, 0, 0, 0);
        this._host = new JTextField();
        jLabel.setLabelFor(this._host);
        this._host.setText(this._info.getUserHost());
        GridBagUtil.constrain(jPanel, this._host, 1, 0, 0, 1, 1.0, 0.0, 17, 2, 0, 9, 0, 0);
        this._port = new JTextField();
        jLabel2.setLabelFor(this._port);
        this._port.setText(Integer.toString(this._info.getUserPort()));
        GridBagUtil.constrain(jPanel, this._port, 1, 1, -1, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        this._ssl = new JCheckBox(this._resource.getString(_sChangeDirectory, "ssl"));
        GridBagUtil.constrain(jPanel, this._ssl, 2, 1, 1, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            this._ssl.setSelected(this._info.getUserLDAPConnection().getSocketFactory() != null);
        }
        this._baseDN = new JTextField();
        jLabel3.setLabelFor(this._baseDN);
        this._baseDN.setText(this._info.getUserBaseDN());
        GridBagUtil.constrain(jPanel, this._baseDN, 1, 2, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        this._username = new JTextField();
        jLabel4.setLabelFor(this._username);
        this._username.setText(this._info.getAuthenticationDN());
        GridBagUtil.constrain(jPanel, this._username, 1, 3, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        this._password = new SingleBytePasswordField();
        jLabel5.setLabelFor((Component)((Object)this._password));
        GridBagUtil.constrain(jPanel, (Component)((Object)this._password), 1, 4, 0, 1, 1.0, 0.0, 17, 2, 12, 9, 0, 0);
        this.setPanel(jPanel);
        this.setMinimumSize(this.getPreferredSize());
    }

    public boolean isDirectoryChange() {
        return this._fChanged;
    }

    public void show() {
        this.reinitializeFields();
        super.show();
    }

    private void reinitializeFields() {
        this._host.setText(this._info.getUserHost());
        this._port.setText(Integer.toString(this._info.getUserPort()));
        LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            this._ssl.setSelected(this._info.getUserLDAPConnection().getSocketFactory() != null);
        }
        this._baseDN.setText(this._info.getUserBaseDN());
        String string = LDAPUtil.getUIDFromDN(lDAPConnection, this._info.getAuthenticationDN());
        if (string != null && string.length() > 0) {
            this._username.setText(string);
        } else {
            this._username.setText(this._info.getAuthenticationDN());
        }
        this._password.setText(null);
    }

    protected void okInvoked() {
        String string = LDAPUtil.getDNFromUID(this._host.getText(), Integer.parseInt(this._port.getText()), this._ssl.isSelected(), LDAPUtil.getConfigurationRoot(), this._username.getText());
        if (string == null) {
            string = this._username.getText();
        }
        try {
            KingpinLDAPConnection kingpinLDAPConnection = this._ssl.isSelected() ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), string, this._password.getText()) : new KingpinLDAPConnection(string, this._password.getText());
            kingpinLDAPConnection.connect(3, this._host.getText(), Integer.parseInt(this._port.getText()), string, this._password.getText());
            if (this.isValidBaseDN(kingpinLDAPConnection, this._baseDN.getText())) {
                LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
                this._info.setUserHost(this._host.getText());
                this._info.setUserPort(Integer.parseInt(this._port.getText()));
                this._info.setAuthenticationDN(string);
                this._info.setAuthenticationPassword(this._password.getText());
                this._info.setUserBaseDN(this._baseDN.getText());
                this._info.setUserLDAPConnection((LDAPConnection)kingpinLDAPConnection);
                if (lDAPConnection != null && lDAPConnection.isConnected()) {
                    lDAPConnection.disconnect();
                }
                this._fChanged = true;
                super.okInvoked();
            }
        }
        catch (Exception exception) {
            SuiOptionPane.showMessageDialog(null, (Object)(this._resource.getString("error", "cannotconnect") + exception), (String)this._resource.getString("error", "title"), (int)0);
            ModalDialogUtil.sleep();
        }
    }

    private boolean isValidBaseDN(LDAPConnection lDAPConnection, String string) {
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, "(objectclass=*)", null, false);
            return true;
        }
        catch (LDAPException lDAPException) {
            SuiOptionPane.showMessageDialog(null, (Object)(this._resource.getString("error", "invalidbasedn") + (Object)((Object)lDAPException)), (String)this._resource.getString("error", "title"), (int)0);
            ModalDialogUtil.sleep();
            return false;
        }
    }

    protected void helpInvoked() {
        this._helpSession.contextHelp("ug", _sChangeDirectory);
    }

    private void loadPreferences() {
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_SEARCH_DIRECTORY);
        String string = preferences.getString(PREFERENCE_HOST, this._info.getUserHost());
        int n = preferences.getInt(PREFERENCE_PORT, this._info.getUserPort());
        String string2 = preferences.getString(PREFERENCE_BASE_DN, this._info.getUserBaseDN());
        String string3 = preferences.getString(PREFERENCE_AUTH_DN, this._info.getAuthenticationDN());
        String string4 = preferences.getString(PREFERENCE_AUTH_PASSWORD, this._info.getAuthenticationPassword());
        LDAPConnection lDAPConnection = this._info.getUserLDAPConnection();
        boolean bl = preferences.getBoolean(PREFERENCE_SSL, lDAPConnection != null && lDAPConnection.getSocketFactory() != null);
        KingpinLDAPConnection kingpinLDAPConnection = null;
        kingpinLDAPConnection = bl ? new KingpinLDAPConnection(UtilConsoleGlobals.getLDAPSSLSocketFactory(), string3, string4) : new KingpinLDAPConnection(string3, string4);
        try {
            kingpinLDAPConnection.connect(3, string, n, string3, string4);
            this._info.setUserLDAPConnection((LDAPConnection)kingpinLDAPConnection);
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                lDAPConnection.disconnect();
            }
            this._info.setUserHost(string);
            this._info.setUserPort(n);
            this._info.setUserBaseDN(string2);
            this._info.setAuthenticationDN(string3);
            this._info.setAuthenticationPassword(string4);
        }
        catch (LDAPException lDAPException) {
            Debug.println("ChangeDirectoryDialog:loadPreferences:cannot connect to the directory server at " + string + ":" + n);
        }
    }

    private void savePreferences() {
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager("Console", "4.0");
        Preferences preferences = preferenceManager.getPreferences(PREFERENCES_SEARCH_DIRECTORY);
        preferences.set(PREFERENCE_HOST, this._info.getUserHost());
        preferences.set(PREFERENCE_PORT, this._info.getUserPort());
        preferences.set(PREFERENCE_BASE_DN, this._info.getUserBaseDN());
        preferences.set(PREFERENCE_AUTH_DN, this._info.getAuthenticationDN());
        preferences.set(PREFERENCE_AUTH_PASSWORD, this._info.getAuthenticationPassword());
        preferences.set(PREFERENCE_SSL, this._info.getUserLDAPConnection() != null && this._info.getUserLDAPConnection().getSocketFactory() != null);
        PreferenceManager.saveAllPreferences();
    }
}

