/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.ICustomView;
import com.netscape.management.client.topology.customview.CustomView;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

public class ViewInfo {
    boolean isAdded = false;
    boolean isDeleted = false;
    boolean isRenamed = false;
    boolean isModified = false;
    boolean isPublic = false;
    String viewID;
    String displayName;
    String className;
    boolean isPlugin;
    LDAPEntry ldapEntry;

    public ViewInfo(String string, String string2, String string3) {
        this.viewID = string;
        this.displayName = string2;
        this.className = string3;
        this.isPlugin = false;
    }

    public ViewInfo(LDAPEntry lDAPEntry) {
        this.ldapEntry = lDAPEntry;
        this.viewID = ViewInfo.getFirstAttributeValue(lDAPEntry, "cn");
        this.displayName = ViewInfo.getFirstAttributeValue(lDAPEntry, "nsDisplayName");
        if (this.displayName == null) {
            this.displayName = this.viewID;
        }
        this.className = ViewInfo.getFirstAttributeValue(lDAPEntry, "nsClassName");
        this.isPlugin = !ViewInfo.hasAttributeValue(lDAPEntry, "objectclass", "nsTopologyCustomView");
    }

    static String getFirstAttributeValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null) {
            try {
                return (String)enumeration.nextElement();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static boolean hasAttributeValue(LDAPEntry lDAPEntry, String string, String string2) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean bl) {
        this.isPublic = bl;
    }

    public String getID() {
        return this.viewID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setViewID(String string) {
        this.viewID = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setAdded(boolean bl) {
        this.isAdded = bl;
    }

    public void setLdapEntry(LDAPEntry lDAPEntry) {
        this.ldapEntry = lDAPEntry;
    }

    public void setDeleted(boolean bl) {
        this.isDeleted = bl;
        this.setAdded(false);
    }

    public void setRenamed(boolean bl) {
        this.isRenamed = bl;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public ICustomView getClassInstance() {
        if (!this.isPlugin && this.ldapEntry != null) {
            return new CustomView(this.ldapEntry);
        }
        if (this.className == null) {
            return null;
        }
        Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)Console.getConsoleInfo(), (String)this.className);
        if (clazz != null) {
            try {
                return (ICustomView)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.println("ViewInfo.getClassInstance() " + this.className + " " + exception);
            }
        }
        return null;
    }
}

