/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.UserListRenderer;
import com.netscape.management.client.ug.IRPCallBack;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class PermissionDlg
extends AbstractDialog
implements ActionListener,
ListSelectionListener,
IRPCallBack {
    JList _list;
    JScrollPane _scrollPane;
    JButton _bAddUser;
    JButton _bDeleteUser;
    JButton _bOK;
    JButton _bCancel;
    JButton _bHelp;
    String _sSIEDN;
    ConsoleInfo _info;
    Vector _vValues;
    Vector _vExtra;
    boolean _fModified;
    ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");

    public PermissionDlg(ConsoleInfo consoleInfo, String string) {
        super((Frame)null, true);
        this._info = consoleInfo;
        this._sSIEDN = string;
        this.initialize();
        this.setMinimumSize(300, 400);
    }

    private JPanel createListPanel() {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this._resource.getString("PermissionDlg", "users"));
        titledBorder.setTitlePosition(3);
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout(12, 12));
        this._list = new JList();
        this._list.getAccessibleContext().setAccessibleDescription(this._resource.getString("PermissionDlg", "users"));
        this._list.addListSelectionListener(this);
        this._list.addMouseMotionListener(new ListMouseMotionListener());
        this._list.setCellRenderer(new UserListRenderer());
        this._list.setSelectionMode(0);
        this._scrollPane = new JScrollPane();
        this._scrollPane.getViewport().add(this._list);
        jPanel.add("Center", this._scrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this._bAddUser = new JButton(this._resource.getString("PermissionDlg", "add"));
        this._bAddUser.setToolTipText(this._resource.getString("PermissionDlg", "add_tt"));
        this._bAddUser.addActionListener(this);
        jPanel2.add(this._bAddUser);
        this._bDeleteUser = new JButton(this._resource.getString("PermissionDlg", "delete"));
        this._bDeleteUser.setToolTipText(this._resource.getString("PermissionDlg", "delete_tt"));
        this._bDeleteUser.addActionListener(this);
        this._bDeleteUser.setEnabled(false);
        jPanel2.add(this._bDeleteUser);
        jPanel.add("South", jPanel2);
        return jPanel;
    }

    void initialize() {
        block7: {
            this._vValues = new Vector();
            this._vExtra = new Vector();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.createListPanel());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2));
            this._bOK = new JButton(this._resource.getString("General", "OK"));
            this._bOK.addActionListener(this);
            jPanel.add(this._bOK);
            this._bCancel = new JButton(this._resource.getString("General", "Cancel"));
            this._bCancel.addActionListener(this);
            jPanel.add(this._bCancel);
            this._bHelp = new JButton(this._resource.getString("General", "Help"));
            this._bHelp.addActionListener(this);
            jPanel.add(this._bHelp);
            this.getContentPane().add("South", jPanel);
            this.setTitle(this._resource.getString("PermissionDlg", "title"));
            try {
                LDAPConnection lDAPConnection = this._info.getLDAPConnection();
                if (lDAPConnection == null) break block7;
                LDAPEntry lDAPEntry = lDAPConnection.read(this._sSIEDN);
                LDAPAttribute lDAPAttribute = null;
                if (lDAPEntry == null || (lDAPAttribute = lDAPEntry.getAttribute("uniquemember")) == null) break block7;
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    String string = (String)e;
                    boolean bl = true;
                    try {
                        String[] stringArray = new String[]{"objectclass"};
                        LDAPEntry lDAPEntry2 = lDAPConnection.read(string, stringArray);
                        LDAPAttributeSet lDAPAttributeSet = lDAPEntry2.getAttributeSet();
                        Enumeration enumeration2 = lDAPAttributeSet.getAttributes();
                        block5: while (enumeration2.hasMoreElements()) {
                            LDAPAttribute lDAPAttribute2 = (LDAPAttribute)enumeration2.nextElement();
                            Enumeration enumeration3 = lDAPAttribute2.getStringValues();
                            while (enumeration3.hasMoreElements()) {
                                String string2 = (String)enumeration3.nextElement();
                                if (!string2.equalsIgnoreCase("netscapeserver")) continue;
                                bl = false;
                                this._vExtra.addElement(e);
                                continue block5;
                            }
                        }
                    }
                    catch (LDAPException lDAPException) {
                        Debug.println("PermissionDlg: Cannot load entry: " + string);
                    }
                    if (!bl) continue;
                    this._vValues.addElement(e);
                }
                this._list.setListData(this._vValues);
                this._list.repaint();
            }
            catch (LDAPException lDAPException) {
                Debug.println("Cannot read the member values for: " + this._sSIEDN);
            }
        }
        this._fModified = false;
    }

    public void getResults(Vector vector) {
        Enumeration enumeration = vector.elements();
        LDAPEntry lDAPEntry = null;
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            var4_4 = enumeration.nextElement();
            if (!(var4_4 instanceof LDAPEntry) || (lDAPEntry = (LDAPEntry)var4_4) == null) continue;
            if (!this._vValues.contains(lDAPEntry.getDN())) {
                this._vValues.addElement(lDAPEntry.getDN());
                this._fModified = true;
                continue;
            }
            SuiOptionPane.showMessageDialog((Component)this._info.getFrame(), (Object)this._resource.getString("error", "EntryExisted"), (String)this._resource.getString("error", "title"), (int)0);
            ModalDialogUtil.sleep();
        }
        this._list.setListData(this._vValues);
        this._list.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bAddUser)) {
            this.setBusyCursor(true);
            ResourcePickerDlg resourcePickerDlg = new ResourcePickerDlg(this._info, this);
            resourcePickerDlg.setAllowChangeDirectory(true);
            resourcePickerDlg.show();
            this.setBusyCursor(false);
        } else if (actionEvent.getSource().equals(this._bDeleteUser)) {
            String string = (String)this._list.getSelectedValue();
            this._vValues.removeElement(string);
            this._fModified = true;
            this._list.setListData(this._vValues);
            this._list.repaint();
        } else if (actionEvent.getSource().equals(this._bOK)) {
            if (this._fModified) {
                try {
                    LDAPConnection lDAPConnection = this._info.getLDAPConnection();
                    if (lDAPConnection != null) {
                        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                        String[] stringArray = new String[this._vValues.size() + this._vExtra.size()];
                        Enumeration enumeration = this._vValues.elements();
                        Enumeration enumeration2 = this._vExtra.elements();
                        int n = 0;
                        while (enumeration2.hasMoreElements()) {
                            stringArray[n] = (String)enumeration2.nextElement();
                            ++n;
                        }
                        while (enumeration.hasMoreElements()) {
                            stringArray[n] = (String)enumeration.nextElement();
                            ++n;
                        }
                        LDAPAttribute lDAPAttribute = new LDAPAttribute("uniqueMember", stringArray);
                        lDAPModificationSet.add(2, lDAPAttribute);
                        lDAPConnection.modify(this._sSIEDN, lDAPModificationSet);
                    }
                }
                catch (LDAPException lDAPException) {
                    SuiOptionPane.showMessageDialog((Component)this._info.getFrame(), (Object)this._resource.getString("error", "CannotChangePermission"), (String)this._resource.getString("error", "title"), (int)0);
                    ModalDialogUtil.sleep();
                    Debug.println("cannot save the result to " + this._sSIEDN + " because: " + (Object)((Object)lDAPException));
                }
            }
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this._bCancel)) {
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this._bHelp)) {
            Help help = new Help(this._resource);
            help.contextHelp("topology", "Permission");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._bDeleteUser.setEnabled(!this._list.isSelectionEmpty());
    }

    class ListMouseMotionListener
    implements MouseMotionListener {
        ListMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = PermissionDlg.this._list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < PermissionDlg.this._vValues.size()) {
                PermissionDlg.this._list.setToolTipText((String)PermissionDlg.this._vValues.elementAt(n));
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = PermissionDlg.this._list.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < PermissionDlg.this._vValues.size()) {
                PermissionDlg.this._list.setToolTipText((String)PermissionDlg.this._vValues.elementAt(n));
            }
        }
    }
}

