/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.console.SplashScreen;
import com.netscape.management.client.topology.DefaultTopologyPlugin;
import com.netscape.management.client.topology.HostNode;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.topology.ServerLocNode;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleBytePasswordField;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPasswordField;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;

public class DomainNode
extends ServerLocNode
implements IMenuInfo,
INodeInfo {
    private static final String MENU_CONFIGURATION = "CONFIGURATION";
    private static ResourceSet _resource;
    private RemoteImage _icon;
    private ConsoleInfo _consoleInfo;
    private LDAPEntry _infoData;
    private NodeData[] _nodeData;
    private NodeData _nameNodeData;
    protected NodeDataPanel _nodeDataPanel;
    private Vector _changeListeners = new Vector();
    private String _LDAPHost = null;
    private String _LDAPPort = null;
    private String _subTree = null;
    private String _bindDN = null;
    private String _bindPassword = null;
    private boolean _isSecure = false;
    private IPage _viewInstance;
    private String _dn;

    public DomainNode(ServiceLocator serviceLocator, LDAPEntry lDAPEntry) {
        super(serviceLocator);
        _resource = new ResourceSet("com.netscape.management.client.topology.topology");
        this._icon = new RemoteImage(_resource.getString("tree", "domainIcon"));
        this._icon.setDescription(_resource.getString("tree", "domainIcon-description"));
        this._consoleInfo = (ConsoleInfo)serviceLocator.getConsoleInfo().clone();
        this._infoData = lDAPEntry;
        this.initialize(this._infoData);
    }

    static String i18n(String string) {
        return _resource.getString("DomainNode", string);
    }

    private void initialize(LDAPEntry lDAPEntry) {
        this.setIcon(this._icon);
        if (lDAPEntry == null) {
            Debug.println("ERROR AdminGroupNode.initialize: LDAPEntry is null");
            return;
        }
        this._dn = lDAPEntry.getDN();
        this.setDN(this._dn);
        String string = null;
        String string2 = null;
        JCheckBox jCheckBox = new JCheckBox();
        SingleBytePasswordField singleBytePasswordField = new SingleBytePasswordField();
        singleBytePasswordField.setTransparentBorder(true);
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            LDAPEntry lDAPEntry2 = lDAPConnection.read(lDAPEntry.getDN());
            String string3 = LDAPUtil.getLDAPAttributeLocale();
            LDAPAttribute lDAPAttribute = lDAPEntry2.getAttribute("description", string3);
            string2 = LDAPUtil.flatting(lDAPAttribute);
            lDAPAttribute = lDAPEntry2.getAttribute("nsAdminDomainName", string3);
            string = LDAPUtil.flatting(lDAPAttribute);
            if (string == null) {
                lDAPAttribute = lDAPEntry2.getAttribute("ou", string3);
                string = LDAPUtil.flatting(lDAPAttribute);
            }
            this.setName(string);
            String string4 = "cn=UserDirectory, ou=Global Preferences," + lDAPEntry.getDN();
            lDAPEntry2 = lDAPConnection.read(string4);
            String string5 = "";
            lDAPAttribute = lDAPEntry2.getAttribute("nsDirectoryURL");
            if (lDAPAttribute != null) {
                StringBuffer stringBuffer = new StringBuffer(LDAPUtil.flatting(lDAPAttribute));
                lDAPAttribute = lDAPEntry2.getAttribute("nsDirectoryFailoverList");
                if (lDAPAttribute != null && !LDAPUtil.flatting(lDAPAttribute).equals("")) {
                    stringBuffer.insert(stringBuffer.toString().lastIndexOf("/"), " " + LDAPUtil.flatting(lDAPAttribute));
                }
                string5 = stringBuffer.toString();
            }
            if (string5.regionMatches(true, 0, "ldaps", 0, 5)) {
                this._isSecure = true;
                jCheckBox.setSelected(this._isSecure);
                this._LDAPPort = "636";
            } else {
                this._LDAPPort = "389";
            }
            int n = string5.indexOf("://") + 3;
            int n2 = string5.indexOf(47, n);
            if (n != -1 && n2 != -1) {
                this._LDAPHost = string5.substring(n, n2);
                this._subTree = string5.substring(n2 + 1);
            }
            lDAPAttribute = lDAPEntry2.getAttribute("nsBindDN");
            this._bindDN = LDAPUtil.flatting(lDAPAttribute);
            lDAPAttribute = lDAPEntry2.getAttribute("nsBindPassword");
            this._bindPassword = LDAPUtil.flatting(lDAPAttribute);
            singleBytePasswordField.setText(this._bindPassword);
        }
        catch (LDAPException lDAPException) {
            System.err.println((Object)lDAPException);
        }
        this._nodeData = new NodeData[]{this._nameNodeData = new NodeData("nsAdminDomainName", DomainNode.i18n("nsAdminDomainName"), this.getName(), true, false), new NodeData("description", DomainNode.i18n("description"), string2, true), new NodeData("LDAPHost", DomainNode.i18n("LDAPHost"), this._LDAPHost, true, true), new NodeData("SSL", DomainNode.i18n("SSL"), jCheckBox, true), new NodeData("Subtree", DomainNode.i18n("Subtree"), this._subTree, true), new NodeData("BindDN", DomainNode.i18n("BindDN"), this._bindDN, true), new NodeData("BindPassword", DomainNode.i18n("BindPassword"), (Object)singleBytePasswordField, true, true)};
    }

    public void select(IPage iPage) {
        this._viewInstance = iPage;
    }

    public void reload() {
        Hashtable hashtable;
        String string;
        Object object;
        Object object2;
        LDAPSearchResults lDAPSearchResults;
        super.reload();
        this.removeAllChildren();
        ResourceSet resourceSet = Console._resource == null ? new ResourceSet("com.netscape.management.client.console.console") : Console._resource;
        String string2 = resourceSet.getString("splash", "hostsCreatedOutOf");
        String string3 = resourceSet.getString("splash", "hostsCreated");
        long l = System.currentTimeMillis();
        int n = 0;
        SplashScreen splashScreen = SplashScreen.getInstance();
        this.removeAllChildren();
        int n2 = this._sl.getHostCount(this.getDN());
        if (splashScreen != null && n2 > 0 && System.getProperty("profile") != null) {
            splashScreen.setStatusText(MessageFormat.format(resourceSet.getString("splash", "hostsCount"), new Integer(n2), this.getName()));
        }
        if ((lDAPSearchResults = (LDAPSearchResults)this.getServiceLocator().getHosts(this.getDN())) != null) {
            long l2 = l;
            try {
                while (lDAPSearchResults.hasMoreElements()) {
                    object2 = lDAPSearchResults.next();
                    if (++n >= 20 && n % 20 == 0) {
                        long l3;
                        l2 = l3 = System.currentTimeMillis();
                        if (splashScreen != null) {
                            if (n2 > 0) {
                                splashScreen.setStatusText(MessageFormat.format(string2, new Integer(n), new Integer(n2), this.getName()));
                            } else {
                                splashScreen.setStatusText(MessageFormat.format(string3, new Integer(n), this.getName()));
                            }
                        }
                    }
                    string = (object = object2.getAttribute("serverhostname")) == null ? _resource.getString("General", "noname") : LDAPUtil.flatting((LDAPAttribute)object);
                    HostNode hostNode = new HostNode(this.getServiceLocator(), object2.getDN(), string);
                    object2 = null;
                    if (this.searchChildByName(hostNode.getName()) != null) continue;
                    this.add((MutableTreeNode)((Object)hostNode));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (splashScreen != null && n > 1) {
            splashScreen.setStatusText(resourceSet.getString("splash", "startingConsole"));
        }
        if ((hashtable = TopologyInitializer.getNetworkTopologyPlugin()) != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ITopologyPlugin iTopologyPlugin;
                String string4 = (String)enumeration.nextElement();
                if (string4.equals(DefaultTopologyPlugin.name) || (object2 = (iTopologyPlugin = (ITopologyPlugin)hashtable.get(string4)).getAdditionalChildren(this)) == null) continue;
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    string = (IResourceObject)object.nextElement();
                    if (this.searchChildByName(string.getName()) != null) continue;
                    if (string instanceof MutableTreeNode) {
                        this.add((MutableTreeNode)((Object)string));
                        continue;
                    }
                    Debug.println(string.getName() + " is not a MutableTreeNode .");
                }
            }
        }
    }

    public String[] getMenuCategoryIDs() {
        return null;
    }

    public IMenuItem[] getMenuItems(String string) {
        return null;
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
    }

    public Component getCustomPanel() {
        if (this._nodeDataPanel == null) {
            this._nodeDataPanel = new NodeDataPanel(this.getIcon(), this.getName(), this);
            this._nodeDataPanel.setHelpTopic("admin", "topology-domainnode");
        }
        return this._nodeDataPanel;
    }

    public void unselect(IPage iPage) {
        this._nodeDataPanel = null;
    }

    public int getNodeDataCount() {
        return this._nodeData.length;
    }

    public NodeData getNodeData(int n) {
        return this._nodeData[n];
    }

    public void replaceNodeDataValue(NodeData nodeData) {
        int n = 0;
        while (n < this._nodeData.length) {
            if (this._nodeData[n].getName().equals(nodeData.getName())) {
                this._nodeData[n].setValue(nodeData.getValue());
                return;
            }
            ++n;
        }
    }

    public void actionNodeDataChanged(NodeData nodeData) {
        Object object;
        Object object2;
        boolean bl;
        block23: {
            String string = this._dn;
            bl = false;
            this.replaceNodeDataValue(nodeData);
            if (nodeData.getID().equals("description") || nodeData.getID().equals("nsAdminDomainName")) {
                if (nodeData.getID().equals("nsAdminDomainName")) {
                    this.setName((String)nodeData.getValue());
                    this._nameNodeData.setValue(nodeData.getValue());
                    this._nodeDataPanel.setTitle((String)nodeData.getValue());
                    if (this._viewInstance != null && this._viewInstance instanceof ResourcePage && ((ResourcePage)(object2 = (ResourcePage)this._viewInstance)).getTreeModel() instanceof ResourceModel) {
                        ((ResourceModel)((ResourcePage)object2).getTreeModel()).fireTreeNodeChanged(this);
                    }
                }
                object2 = new LDAPAttribute(nodeData.getID(), (String)nodeData.getValue());
                object = new LDAPModification(2, (LDAPAttribute)object2);
                LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
                try {
                    lDAPConnection.modify(string, object);
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 16) {
                        try {
                            object = new LDAPModification(0, (LDAPAttribute)object2);
                            lDAPConnection.modify(string, object);
                        }
                        catch (LDAPException lDAPException2) {
                            Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException2));
                        }
                        break block23;
                    }
                    Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException));
                }
            } else if (nodeData.getID().equals("LDAPHost")) {
                this._LDAPHost = (String)nodeData.getValue();
                bl = true;
            } else if (nodeData.getID().equals("LDAPPort")) {
                this._LDAPPort = (String)nodeData.getValue();
                bl = true;
            } else if (nodeData.getID().equals("SSL")) {
                this._isSecure = ((JCheckBox)nodeData.getValue()).isSelected();
                bl = true;
            } else if (nodeData.getID().equals("Subtree")) {
                this._subTree = (String)nodeData.getValue();
                bl = true;
            } else if (nodeData.getID().equals("BindDN")) {
                this._bindDN = (String)nodeData.getValue();
                this.changeUGAttribute("nsBindDN", this._bindDN);
            } else if (nodeData.getID().equals("BindPassword")) {
                this._bindPassword = ((JPasswordField)nodeData.getValue()).getText();
                this.changeUGAttribute("nsBindPassword", this._bindPassword);
            }
        }
        if (bl) {
            int n = this._LDAPHost.indexOf(" ");
            if (n != -1) {
                object2 = this._isSecure ? "ldaps://" + this._LDAPHost.substring(0, n) + "/" + this._subTree : "ldap://" + this._LDAPHost.substring(0, n) + "/" + this._subTree;
                object = this._LDAPHost.substring(n + 1);
            } else {
                object2 = this._isSecure ? "ldaps://" + this._LDAPHost + "/" + this._subTree : "ldap://" + this._LDAPHost + "/" + this._subTree;
                object = "";
            }
            this.changeUGAttribute("nsDirectoryURL", (String)object2);
            this.changeUGAttribute("nsDirectoryFailoverList", (String)object);
        }
    }

    private void changeUGAttribute(String string, String string2) {
        String string3 = "cn=UserDirectory, ou=Global Preferences," + this._dn;
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, string2);
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        try {
            lDAPConnection.modify(string3, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 16) {
                try {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPConnection.modify(string3, lDAPModification);
                }
                catch (LDAPException lDAPException2) {
                    Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException2));
                }
            }
            Debug.println("DomainNode.actionNodeDataChanged() " + (Object)((Object)lDAPException));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.removeElement(changeListener);
    }
}

