/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.ErrorDialog;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CertificateList;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiScrollPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class KeyCertUtility {
    static ResourceSet _resource = null;
    static Help _help = null;

    KeyCertUtility() {
    }

    public static ResourceSet getResourceSet() {
        if (_resource == null) {
            _resource = new ResourceSet("com.netscape.management.client.security.KeyCertWizardResource");
        }
        return _resource;
    }

    public static Help getHelp() {
        if (_help == null) {
            _help = new Help(_resource);
        }
        return _help;
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        String string4 = new String(string);
        while ((n = string4.indexOf(string2)) != -1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
        }
        return string4;
    }

    public static String getCertName(Hashtable hashtable) {
        Hashtable hashtable2;
        String string = "";
        if (hashtable != null && (string = (String)(hashtable2 = (Hashtable)hashtable.get("SUBJECT")).get("CN")).equals("(null)") && (string = (String)hashtable2.get("OU")).equals("(null)") && (string = (String)hashtable2.get("O")).equals("(null)")) {
            string = (String)hashtable.get("SUBJECT_DN");
        }
        return string;
    }

    public static String getIssuerName(Hashtable hashtable) {
        Hashtable hashtable2;
        String string = "";
        if (hashtable != null && (string = (String)(hashtable2 = (Hashtable)hashtable.get("ISSUER")).get("CN")).equals("(null)") && (string = (String)hashtable2.get("OU")).equals("(null)") && (string = (String)hashtable2.get("O")).equals("(null)")) {
            string = (String)hashtable2.get("ISSUER_DN");
        }
        return string;
    }

    public static String getIssuerOrSubject(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)hashtable.get("CN");
        String string2 = (String)hashtable.get("O");
        String string3 = (String)hashtable.get("OU");
        String string4 = (String)hashtable.get("L");
        String string5 = (String)hashtable.get("ST");
        String string6 = (String)hashtable.get("C");
        if (!string.equals("(null)")) {
            stringBuffer.append(string);
        }
        if (!string2.equals("(null)")) {
            stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
            stringBuffer.append(string2);
        }
        if (!string3.equals("(null)")) {
            stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
            stringBuffer.append(string3);
        }
        if (!string4.equals("(null)")) {
            stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
            stringBuffer.append(string4);
        }
        if (!string5.equals("(null)")) {
            stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
            stringBuffer.append(string5);
        }
        if (!string6.equals("(null)")) {
            stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "");
            stringBuffer.append(string6);
        }
        return stringBuffer.toString();
    }

    public static void getCert(Component component, ConsoleInfo consoleInfo, String string, String string2) {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        try {
            serializable = new Hashtable<String, String>();
            ((Hashtable)serializable).put("formop", "FIND_CERTIFICATE");
            ((Hashtable)serializable).put("sie", string);
            ((Hashtable)serializable).put("certname", string2);
            AdmTask admTask = new AdmTask(new URL(consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
            admTask.setArguments((Hashtable)serializable);
            admTask.exec();
            Debug.println(admTask.getResultString().toString());
            if (admTask.getStatus() != 0) {
                ErrorDialog errorDialog = new ErrorDialog(null, (String)admTask.getResult("NMC_ErrType"), (String)admTask.getResult("NMC_ErrDetail"));
                errorDialog.hideDetail();
                errorDialog.show();
                return;
            }
            CertificateList certificateList = new CertificateList(admTask.getResultString().toString());
            JPanel jPanel2 = null;
            if (certificateList.getCACerts().size() != 0) {
                jPanel2 = KeyCertUtility.createCertDetailInfo((Hashtable)certificateList.getCACerts().elementAt(0));
            } else if (certificateList.getServerCerts().size() != 0) {
                jPanel2 = KeyCertUtility.createCertDetailInfo((Hashtable)certificateList.getServerCerts().elementAt(0));
            }
            ResourceSet resourceSet = KeyCertUtility.getResourceSet();
            JLabel jLabel = new JLabel(resourceSet.getString("CertInfoPage", "certNameLabel") + " " + string2);
            jLabel.setLabelFor(jPanel2);
            GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 1.0, 0.0, 11, 2, 0, 0, 0, 0);
            SuiScrollPane suiScrollPane = new SuiScrollPane((Component)jPanel2);
            suiScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            GridBagUtil.constrain(jPanel, (Component)suiScrollPane, 0, 1, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        }
        catch (Exception exception) {
            Debug.println(exception.toString());
        }
        serializable = new AbstractDialog(component instanceof Frame ? (Frame)component : null, "", 1){};
        ((Window)serializable).setSize(400, 300);
        ((AbstractDialog)serializable).getContentPane().add(jPanel);
        ((Dialog)serializable).setVisible(true);
    }

    public static boolean deleteCert(Component component, ConsoleInfo consoleInfo, String string, String string2) {
        boolean bl = true;
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("formop", "DELETE_CACERT");
            hashtable.put("sie", string);
            hashtable.put("certname", string2);
            AdmTask admTask = new AdmTask(new URL(consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
            admTask.setArguments(hashtable);
            admTask.exec();
            if (admTask.getStatus() != 0) {
                ErrorDialog errorDialog = new ErrorDialog(component instanceof Frame ? (Frame)component : null, (String)admTask.getResult("NMC_ErrType"), (String)admTask.getResult("NMC_ErrDetail"));
                errorDialog.hideDetail();
                errorDialog.show();
                bl = false;
            }
        }
        catch (Exception exception) {
            Debug.println(exception.toString());
        }
        return bl;
    }

    public static JPanel createCertDetailInfo(Hashtable hashtable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        ResourceSet resourceSet = KeyCertUtility.getResourceSet();
        stringBuffer.append(resourceSet.getString("CertInfoPage", "issuer"));
        stringBuffer.append(KeyCertUtility.getIssuerOrSubject((Hashtable)hashtable.get("ISSUER")));
        stringBuffer.append("\n\n");
        stringBuffer.append(resourceSet.getString("CertInfoPage", "subject"));
        stringBuffer.append(KeyCertUtility.getIssuerOrSubject((Hashtable)hashtable.get("SUBJECT")));
        stringBuffer2.append(resourceSet.getString("CertInfoPage", "validAfter"));
        stringBuffer2.append(hashtable.get("BEFOREDATE"));
        stringBuffer2.append("\n\n");
        stringBuffer2.append(resourceSet.getString("CertInfoPage", "validBefore"));
        stringBuffer2.append(hashtable.get("AFTERDATE"));
        stringBuffer2.append("\n\n");
        stringBuffer2.append(resourceSet.getString("CertInfoPage", "fingerPrint"));
        stringBuffer2.append(hashtable.get("FINGERPRINT"));
        stringBuffer2.append("\n\n");
        stringBuffer2.append(resourceSet.getString("CertInfoPage", "serialNum"));
        stringBuffer2.append(hashtable.get("SERIAL"));
        MultilineLabel multilineLabel = new MultilineLabel(stringBuffer.toString());
        MultilineLabel multilineLabel2 = new MultilineLabel(stringBuffer2.toString());
        GridBagUtil.constrain(jPanel, multilineLabel, 0, 0, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel, multilineLabel2, 1, 0, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        return jPanel;
    }
}

