/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.Table;
import com.netscape.management.client.security.KeyCertUtility;
import com.netscape.management.client.security.ListTableModel;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

class CertificateInfoPanels
implements SuiConstants {
    ResourceSet resource = new ResourceSet("com.netscape.management.client.security.securityResource");
    Hashtable _cert;
    Border defaultBorder;
    int top = 9;
    int left = 9;
    int bottom = 9;
    int right = 9;

    JLabel getBoldAlignLabel(String string, int n) {
        JLabel jLabel = new JLabel(string, n);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
        return jLabel;
    }

    JLabel getBoldRightAlignLabel(String string) {
        return this.getBoldAlignLabel(string, 4);
    }

    JLabel getBoldLabel(String string) {
        return this.getBoldAlignLabel(string, 2);
    }

    private String convertNullString(Object object) {
        if (object.toString().equals("(null)")) {
            return this.resource.getString("CertificateDetailDialog", "invalidFQDN");
        }
        return object.toString();
    }

    public JComponent getCertChainInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Hashtable hashtable = (Hashtable)this._cert.get("CERT_CHAIN");
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = new DefaultMutableTreeNode(this.convertNullString(hashtable.get("CERT" + Integer.toString(hashtable.size() - 1))));
        int n = hashtable.size() - 2;
        while (n >= 0) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.convertNullString(hashtable.get("CERT" + n)));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            --n;
        }
        JTree jTree = new JTree(defaultMutableTreeNode){

            public void processMouseEvent(MouseEvent mouseEvent) {
                int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1) {
                    this.setSelectionRow(n);
                }
            }
        };
        jTree.setCellRenderer((TreeCellRenderer)((Object)new CertTreeCellRenderer()));
        int n2 = 0;
        while (n2 <= hashtable.size()) {
            jTree.expandRow(n2);
            ++n2;
        }
        jTree.setSelectionRow(hashtable.size() - 1);
        jTree.scrollRowToVisible(hashtable.size() - 1);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jTree);
        jScrollPane.setPreferredSize(new Dimension(125, 75));
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        jScrollPane.setBorder(this.defaultBorder);
        return this.setInset(jScrollPane);
    }

    JPanel getGeneralInfo() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        JLabel jLabel = this.getBoldRightAlignLabel(this.resource.getString("CertificateDetailDialog", "issuedTo"));
        JLabel jLabel2 = this.getBoldRightAlignLabel(this.resource.getString("CertificateDetailDialog", "issuedBy"));
        JLabel jLabel3 = this.getBoldRightAlignLabel(this.resource.getString("CertificateDetailDialog", "serialNum"));
        JLabel jLabel4 = this.getBoldRightAlignLabel(this.resource.getString("CertificateDetailDialog", "fingerprint"));
        JLabel jLabel5 = this.getBoldLabel(this.resource.getString("CertificateDetailDialog", "intendedTo"));
        int n = 0;
        GridBagUtil.constrain(jPanel, jLabel, 0, n, 1, 1, 0.0, 0.0, 11, 2, 9, 6, 0, 0);
        String string = KeyCertUtility.getCertName(this._cert);
        JLabel jLabel6 = new JLabel(string.equals("(null)") ? "" : string);
        jLabel.setLabelFor(jLabel6);
        GridBagUtil.constrain(jPanel, jLabel6, 1, n, 1, 1, 1.0, 0.0, 11, 2, 9, 6, 0, 6);
        GridBagUtil.constrain(jPanel, jLabel2, 0, ++n, 1, 1, 0.0, 0.0, 11, 2, 6, 6, 0, 0);
        String string2 = KeyCertUtility.getIssuerName(this._cert);
        JLabel jLabel7 = new JLabel(string2.equals("(null)") ? "" : string2);
        jLabel2.setLabelFor(jLabel7);
        GridBagUtil.constrain(jPanel, jLabel7, 1, n, 1, 1, 1.0, 0.0, 11, 2, 6, 6, 0, 6);
        GridBagUtil.constrain(jPanel, jLabel3, 0, ++n, 1, 1, 0.0, 0.0, 11, 2, 6, 6, 0, 0);
        JLabel jLabel8 = new JLabel((String)this._cert.get("SERIAL"));
        jLabel3.setLabelFor(jLabel8);
        GridBagUtil.constrain(jPanel, jLabel8, 1, n, 1, 1, 1.0, 0.0, 11, 2, 6, 6, 0, 6);
        GridBagUtil.constrain(jPanel, jLabel4, 0, ++n, 1, 1, 0.0, 0.0, 11, 2, 6, 6, 0, 0);
        JLabel jLabel9 = new JLabel((String)this._cert.get("FINGERPRINT"));
        jLabel4.setLabelFor(jLabel9);
        GridBagUtil.constrain(jPanel, jLabel9, 1, n, 1, 1, 1.0, 0.0, 11, 2, 6, 6, 0, 6);
        try {
            object4 = this.resource.getString("CertificateDetailDialog", "dateFormat");
            object3 = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
            object2 = new GregorianCalendar();
            ((Calendar)object2).setTime(((DateFormat)object3).parse((String)this._cert.get("BEFOREDATE")));
            object = new GregorianCalendar();
            ((Calendar)object).setTime(((DateFormat)object3).parse((String)this._cert.get("AFTERDATE")));
            String string3 = KeyCertUtility.replace(KeyCertUtility.replace(KeyCertUtility.replace((String)object4, "%Y%", Integer.toString(((Calendar)object2).get(1))), "%M%", Integer.toString(((Calendar)object2).get(2) + 1)), "%D%", Integer.toString(((Calendar)object2).get(5)));
            String string4 = KeyCertUtility.replace(KeyCertUtility.replace(KeyCertUtility.replace((String)object4, "%Y%", Integer.toString(((Calendar)object).get(1))), "%M%", Integer.toString(((Calendar)object).get(2) + 1)), "%D%", Integer.toString(((Calendar)object).get(5)));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            jPanel2.setBackground(jPanel.getBackground());
            int n2 = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(this.resource.getString("CertificateDetailDialog", "valid"), " ", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = (String)stringTokenizer.nextElement();
                JLabel jLabel10 = null;
                jLabel10 = string5.equals("%AFTERDATE%") ? new JLabel(string3) : (string5.equals("%BEFOREDATE%") ? new JLabel(string4) : this.getBoldLabel(this.resource.getString("CertificateDetailDialog", string5)));
                int n3 = 0;
                if (string5.equals("%AFTERDATE%") || string5.equals("%BEFOREDATE%")) {
                    n3 = 6;
                }
                GridBagUtil.constrain(jPanel2, jLabel10, ++n2, 0, 1, 1, 0.0, 0.0, 17, 0, 0, n3, 0, n3);
            }
            GridBagUtil.constrain(jPanel2, Box.createHorizontalGlue(), ++n2, 0, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
            GridBagUtil.constrain(jPanel, jPanel2, 0, ++n, 2, 1, 1.0, 0.0, 11, 2, 6, 18, 0, 6);
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertificateInfoPanels::getGeneralInfo()", exception);
            Debug.println("Fail to parse certificate validation date.");
            Debug.println("AFTERDATE : " + this._cert.get("AFTERDATE"));
            Debug.println("BEFOREDATE: " + this._cert.get("BEFOREDATE"));
        }
        object4 = (Hashtable)this._cert.get("PURPOSE");
        if (object4 != null) {
            GridBagUtil.constrain(jPanel, jLabel5, 0, ++n, 2, 1, 1.0, 0.0, 18, 2, 6, 6, 0, 6);
            object3 = ((Hashtable)object4).keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement().toString();
                if (((String)object2).equals("SSLClient")) {
                    object2 = this.resource.getString("CertificateDetailDialog", "sslclient");
                } else if (((String)object2).equals("SSLServer")) {
                    object2 = this.resource.getString("CertificateDetailDialog", "sslserver");
                } else if (((String)object2).equals("SSLCA")) {
                    object2 = this.resource.getString("CertificateDetailDialog", "sslca");
                } else if (((String)object2).equals("EmailSigner")) {
                    object2 = this.resource.getString("CertificateDetailDialog", "emailsigner");
                } else if (((String)object2).equals("EmailRecipient")) {
                    object2 = this.resource.getString("CertificateDetailDialog", "emailrecipient");
                } else if (((String)object2).equals("ObjectSigner")) {
                    object2 = this.resource.getString("CertificateDetailDialog", "objectsigner");
                }
                object = new JLabel((String)object2);
                jLabel5.setLabelFor((Component)object);
                GridBagUtil.constrain(jPanel, (Component)object, 0, ++n, 2, 1, 1.0, 0.0, 18, 2, 6, 30, 0, 6);
            }
        }
        if ((object3 = (Hashtable)this._cert.get("REASONS")) != null) {
            GridBagUtil.constrain(jPanel, jLabel5, 0, ++n, 2, 1, 1.0, 0.0, 18, 2, 6, 6, 0, 6);
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                object = ((Hashtable)object3).get(object2.nextElement()).toString();
                GridBagUtil.constrain(jPanel, new JLabel((String)object), 0, ++n, 2, 1, 1.0, 0.0, 18, 2, 6, 30, 0, 6);
            }
        }
        GridBagUtil.constrain(jPanel, Box.createVerticalGlue(), 0, ++n, 1, 1, 0.0, 1.0, 11, 3, 0, 0, 0, 0);
        object2 = new JScrollPane(jPanel);
        return this.setInset((Component)object2);
    }

    private void setRowValue(Vector vector, String string, Object object) {
        if (object != null && object.toString().length() != 0 && !object.toString().equals("(null)")) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.addElement(string);
            vector2.addElement(object);
            vector.addElement(vector2);
        }
    }

    JComponent getDetailInfo() {
        JPanel jPanel = new JPanel();
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.resource.getString("CertificateDetailDialog", "fieldTitle"));
        vector.addElement(this.resource.getString("CertificateDetailDialog", "valueTitle"));
        Hashtable hashtable = (Hashtable)this._cert.get("SUBJECT");
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        Hashtable hashtable2 = (Hashtable)this._cert.get("ISSUER");
        Vector vector2 = new Vector();
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "subject"), hashtable.get("CN"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "issuer"), hashtable2.get("CN"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "validFrom"), this._cert.get("BEFOREDATE"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "validTo"), this._cert.get("AFTERDATE"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "email"), hashtable.get("EMAIL"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "locality"), hashtable.get("L"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "org"), hashtable.get("O"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "orgUnit"), hashtable.get("OU"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "state"), hashtable.get("ST"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "country"), hashtable.get("C"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "fingerprint"), this._cert.get("FINGERPRINT"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "signature"), this._cert.get("SIGNATURE"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "algorithm"), this._cert.get("ALGORITHM"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "keystrength"), this._cert.get("KEYSTRENGTH"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "version"), this._cert.get("VERSION"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "serial"), this._cert.get("SERIAL"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "subjectDN"), this._cert.get("SUBJECT_DN"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "issuerDN"), this._cert.get("ISSUER_DN"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "effectiveDate"), this._cert.get("LAST_UPDATE"));
        this.setRowValue(vector2, this.resource.getString("CertificateDetailDialog", "nextUpdate"), this._cert.get("NEXT_UPDATE"));
        Table table = new Table(new ListTableModel(vector, vector2));
        JScrollPane jScrollPane = Table.createScrollPaneForTable(table);
        return this.setInset(jScrollPane);
    }

    public JComponent getRevocationList() {
        Serializable serializable;
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.resource.getString("CertificateDetailDialog", "serial"));
        vector.addElement(this.resource.getString("CertificateDetailDialog", "revocationDate"));
        Vector vector2 = new Vector();
        int n = 0;
        while ((serializable = (Hashtable)this._cert.get("ENTRY" + n)) != null) {
            try {
                this.setRowValue(vector2, (String)serializable.get("SERIAL_NUMBER"), (String)serializable.get("REVOKE_DATE"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        serializable = new Table(new ListTableModel(vector, vector2));
        JScrollPane jScrollPane = Table.createScrollPaneForTable((JTable)serializable);
        return this.setInset(jScrollPane);
    }

    private JPanel setInset(Component component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagUtil.constrain(jPanel, component, 0, 0, 1, 1, 1.0, 1.0, 11, 1, this.top, this.left, this.bottom, this.right);
        return jPanel;
    }

    public void setInset(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.bottom = n3;
        this.right = n4;
    }

    public CertificateInfoPanels(Hashtable hashtable) {
        this._cert = hashtable;
        this.defaultBorder = BorderFactory.createLoweredBevelBorder();
    }

    class CertTreeCellRenderer
    extends SuiTreeCellRenderer {
    }
}

