/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPInputStream;
import com.netscape.management.client.util.LDAPOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPPreferences
extends Preferences {
    private static String _attribute = "nsPreference";
    private LDAPConnection _ldc;
    private String _dn;
    private String _group;

    public LDAPPreferences(LDAPConnection lDAPConnection, String string, String string2) {
        this._ldc = lDAPConnection;
        this._group = string;
        this._dn = LDAPPreferences.createPreferenceEntry(this._ldc, string, string2);
    }

    public LDAPPreferences(String string, int n, String string2, String string3, String string4, String string5) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(string, n);
        lDAPConnection.authenticate(string2, string3);
        this._ldc = lDAPConnection;
        this._group = string4;
        this._dn = LDAPPreferences.createPreferenceEntry(this._ldc, string4, string5);
    }

    public String toString() {
        return this._group + ":" + super.toString();
    }

    public String getDN() {
        return this._dn;
    }

    public void setDN(String string) {
        this._dn = string;
    }

    protected InputStream getInputStream() {
        return new LDAPInputStream(this._ldc, this._dn, _attribute);
    }

    protected OutputStream getOutputStream() {
        return new LDAPOutputStream(this._ldc, this._dn, _attribute);
    }

    public void clear() {
        super.clear();
    }

    public void delete() {
        try {
            OutputStream outputStream = this.getOutputStream();
            ((LDAPOutputStream)outputStream).delete();
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot delete preferences: " + (Object)((Object)lDAPException));
        }
    }

    public static String createPreferenceEntry(LDAPConnection lDAPConnection, String string, String string2) {
        String string3;
        block4: {
            string3 = "cn=" + string + "," + string2;
            LDAPSearchResults lDAPSearchResults = null;
            try {
                lDAPSearchResults = lDAPConnection.search(string3, 2, "(objectclass=*)", null, false);
            }
            catch (LDAPException lDAPException) {
                Debug.println("Cannot find: " + string3);
                Debug.println("Creating: " + string3);
                if (lDAPSearchResults != null) break block4;
                try {
                    LDAPAttribute lDAPAttribute = new LDAPAttribute("cn", string);
                    LDAPAttribute lDAPAttribute2 = new LDAPAttribute("objectclass", "top");
                    LDAPAttribute lDAPAttribute3 = new LDAPAttribute("objectclass", "nsAdminConsoleUser");
                    LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                    lDAPAttributeSet.add(lDAPAttribute);
                    lDAPAttributeSet.add(lDAPAttribute2);
                    lDAPAttributeSet.add(lDAPAttribute3);
                    lDAPConnection.add(new LDAPEntry(string3, lDAPAttributeSet));
                }
                catch (LDAPException lDAPException2) {
                    Debug.println("Cannot create: " + string3);
                }
            }
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "ou=UserPreferences, ou=Netscape SuiteSpot, o=NetscapeRoot";
            LDAPPreferences lDAPPreferences = new LDAPPreferences("localhost", 389, "cn=Directory Manager", "adminadmin", "testgroup", string);
            int n = lDAPPreferences.getInt("integer", 0);
            Debug.println("read: " + n);
            boolean bl = lDAPPreferences.getBoolean("boolean");
            Debug.println("read: " + bl);
            String string2 = lDAPPreferences.getString("string", "A long string of a's...");
            Debug.println("read: " + string2);
            lDAPPreferences.set("integer", ++n);
            lDAPPreferences.set("boolean", !bl);
            lDAPPreferences.set("string", string2 + "a");
            lDAPPreferences.save();
        }
        catch (LDAPException lDAPException) {
            Debug.println("Unable to connect to ldap host");
        }
        System.exit(0);
    }
}

