/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.legacy.plugin;

import com.netscape.management.client.Framework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.legacy.plugin.LegacyAdminGroupNode;
import com.netscape.management.client.legacy.plugin.LegacyServerLocNode;
import com.netscape.management.client.legacy.plugin.LegacyServiceLocator;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.topology.PermissionDlg;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.applet.Applet;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LegacyServerNode
extends LegacyServerLocNode
implements INodeInfo,
IMenuInfo {
    private static final String NAVIGATOR = "netscape";
    private static final String ID_DESCRIPTION = "DESCRIPTION";
    private static final String ID_URL = "URL";
    private static final String ID_PRODUCTNAME = "PRODUCTNAME";
    private static final String ID_SERVERNAME = "SERVERNAME";
    private static final String ID_VENDOR = "VENDOR";
    private static final String MENU_SET_ACL = "SETACL";
    private static final String MENU_OPEN_SERVER = "OPENSERVER";
    URL _url;
    IResourceObject[] _selection;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.legacy.plugin.default");
    private static RemoteImage _icon = null;
    private static Vector _changeListeners = new Vector();
    private String _description;
    private String _serverName;
    private String _productName = "Netscape SuiteSpot";
    private String _vendor = "Netscape Communications Corp.";
    private IPage _viewInstance;
    private ConsoleInfo _consoleInfo;
    protected NodeDataPanel _nodeDataPanel;
    protected NodeData[] _nodeData;

    public LegacyServerNode(LegacyServiceLocator legacyServiceLocator, LDAPEntry lDAPEntry) {
        super(legacyServiceLocator);
        this.setDN(lDAPEntry.getDN());
        _icon = new RemoteImage(_resource.getString("tree", "legacyServerIcon"));
        _icon.setDescription(_resource.getString("tree", "legacyServerIcon-description"));
        this.initialize(lDAPEntry);
    }

    public void initialize(LDAPEntry lDAPEntry) {
        this.setIcon(_icon);
        if (lDAPEntry != null) {
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            this.setName(LDAPUtil.flatting(lDAPEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale())));
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string = lDAPAttribute.getName();
                if (string.equalsIgnoreCase(ID_URL)) {
                    try {
                        this._url = new URL(LDAPUtil.flatting(lDAPAttribute.getStringValues()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.println("ERROR while trying to create URL for LegacyServerNode");
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("description")) {
                    this._description = LDAPUtil.flatting(lDAPAttribute.getStringValues());
                    continue;
                }
                if (!string.equalsIgnoreCase("serverProductName")) continue;
                this._serverName = LDAPUtil.flatting(lDAPAttribute.getStringValues());
            }
            if (this._serverName != null) {
                this.setName(this._serverName);
            }
            this._nodeData = new NodeData[]{new NodeData(ID_SERVERNAME, "Server Name", this._serverName, true, true), new NodeData(ID_DESCRIPTION, "Description", this._description, true), new NodeData(ID_PRODUCTNAME, "Product Name", this._productName, false), new NodeData(ID_VENDOR, "Vendor", "Netscape Communications Corp.", false), new NodeData(ID_URL, ID_URL, this._url.toString(), true, true)};
            this._consoleInfo = this.getServiceLocator().getConsoleInfo();
        }
    }

    public void unselect(Object object) {
    }

    public void select(IPage iPage) {
        super.select(iPage);
        this._viewInstance = iPage;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        Applet applet = this.getServiceLocator().getConsoleInfo().getApplet();
        if (applet != null) {
            applet.getAppletContext().showDocument(this._url, "serverManager");
        } else {
            Browser browser = new Browser();
            boolean bl = browser.open(this._url, 3);
        }
        return true;
    }

    public int deleteLDAPentry() {
        LegacyServiceLocator legacyServiceLocator = this.getServiceLocator();
        legacyServiceLocator.getConsoleInfo();
        int n = SuiOptionPane.showConfirmDialog((Component)ConsoleInfo.frame, (Object)_resource.getString("legacyplugin", "ServerNodedelConfirm"), (String)_resource.getString("legacyplugin", "ServerNodeDelTitle"), (int)0);
        ModalDialogUtil.sleep();
        if (n == 1) {
            return -1;
        }
        try {
            LDAPConnection lDAPConnection = legacyServiceLocator.getConsoleInfo().getLDAPConnection();
            if (lDAPConnection != null) {
                lDAPConnection.delete(this.getDN());
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("LDAP Error: " + (Object)((Object)lDAPException));
            return -1;
        }
        return 0;
    }

    public ResourceObject pruneParents(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        LegacyAdminGroupNode legacyAdminGroupNode = (LegacyAdminGroupNode)((Object)this.getParent());
        String string2 = legacyAdminGroupNode.getDN();
        Debug.println("DN of Suitespot Group  -> " + legacyAdminGroupNode.getDN());
        LegacyServiceLocator legacyServiceLocator = this.getServiceLocator();
        LDAPConnection lDAPConnection = legacyServiceLocator.getConsoleInfo().getLDAPConnection();
        if (lDAPConnection != null) {
            int n;
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            String string3 = new String("(objectclass=nsLegacyServer)");
            try {
                lDAPSearchResults = lDAPConnection.search(string2, 2, string3, null, false, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                n = lDAPException.getLDAPResultCode();
                Debug.println("LDAPException: F..return code:" + n);
            }
            if (lDAPSearchResults.hasMoreElements()) {
                Debug.println("Found other children in Suitespot Group\n");
                return this;
            }
            Debug.println("Found no other servers in suitespot host -> " + legacyAdminGroupNode.getDN());
            legacyAdminGroupNode.deleteLDAPentry(1);
            string3 = new String("(objectclass=nsLegacyAdminGroup)");
            try {
                lDAPSearchResults = lDAPConnection.search(string, 1, string3, null, false, lDAPSearchConstraints);
            }
            catch (LDAPException lDAPException) {
                n = lDAPException.getLDAPResultCode();
                Debug.println("LDAPException: G..return code:" + n);
            }
            if (lDAPSearchResults.hasMoreElements()) {
                Debug.println("Found other children under host\n");
                return legacyAdminGroupNode;
            }
            Debug.println("Found nothing under host\n");
            return (ResourceObject)legacyAdminGroupNode.getParent();
        }
        Debug.println("Connection to Directory Server lost.  Internal Error");
        return this;
    }

    public int getNodeDataCount() {
        return this._nodeData.length;
    }

    public NodeData getNodeData(int n) {
        return this._nodeData[n];
    }

    public void replaceNodeDataValue(NodeData nodeData) {
        int n = 0;
        while (n < this._nodeData.length) {
            if (this._nodeData[n].getName().equals(nodeData.getName())) {
                this._nodeData[n].setValue(nodeData.getValue());
                return;
            }
            ++n;
        }
    }

    public void actionNodeDataChanged(NodeData nodeData) {
        String string;
        this.replaceNodeDataValue(nodeData);
        if (nodeData.getID().equals(NodeDataPanel.ID_OPEN)) {
            this.run(this._viewInstance, new IResourceObject[]{this});
            return;
        }
        if (nodeData.getID().equals(ID_DESCRIPTION)) {
            string = "description";
        } else if (nodeData.getID().equals(ID_SERVERNAME)) {
            string = "serverProductName";
        } else if (nodeData.getID().equals(ID_URL)) {
            string = "url";
        } else {
            return;
        }
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, (String)nodeData.getValue());
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        LDAPConnection lDAPConnection = this.getServiceLocator().getConnection();
        try {
            lDAPConnection.modify(this.getDN(), lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 16) {
                try {
                    lDAPModification = new LDAPModification(0, lDAPAttribute);
                    lDAPConnection.modify(this.getDN(), lDAPModification);
                }
                catch (LDAPException lDAPException2) {
                    Debug.println("actionNodeDataChanged() " + (Object)((Object)lDAPException2));
                }
            }
            Debug.println("actionNodeDataChanged() " + (Object)((Object)lDAPException));
        }
        if (nodeData.getID().equals(ID_SERVERNAME)) {
            this._nodeDataPanel.setTitle((String)nodeData.getValue());
            this.setName((String)nodeData.getValue());
            if (this._viewInstance != null && this._viewInstance instanceof ResourcePage) {
                ResourcePage resourcePage = (ResourcePage)this._viewInstance;
                IResourceObject[] iResourceObjectArray = resourcePage.getSelection();
                ResourceObject resourceObject = (ResourceObject)iResourceObjectArray[0];
                if (resourcePage.getTreeModel() instanceof ResourceModel && resourceObject != null) {
                    resourceObject.setName(this.getName());
                    ((ResourceModel)resourcePage.getTreeModel()).fireTreeNodeChanged(resourceObject);
                }
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        _changeListeners.addElement(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        _changeListeners.removeElement(changeListener);
    }

    public Component getCustomPanel() {
        this._nodeDataPanel = new NodeDataPanel(this.getIcon(), this.getName(), this, true);
        return this._nodeDataPanel;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("OBJECT") || string.equals("CONTEXT")) {
            return new IMenuItem[]{new MenuItemText(MENU_OPEN_SERVER, _resource.getString("legacy", "open"), "", true), new MenuItemSeparator(), new MenuItemText(MENU_SET_ACL, Framework._resource.getString("menu", "EditSetACL"), "", true)};
        }
        return null;
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(MENU_SET_ACL)) {
            PermissionDlg permissionDlg = new PermissionDlg(this._consoleInfo, this.getDN());
            permissionDlg.show();
            ModalDialogUtil.disposeAndRaise(permissionDlg, iPage.getFramework().getJFrame());
        } else if (iMenuItem.getID().equals(MENU_OPEN_SERVER)) {
            this.run(this._viewInstance, new IResourceObject[]{this});
        }
    }
}

