/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.IDataCollectionModel;
import com.netscape.management.client.components.IWizardSequenceManager;
import com.netscape.management.client.components.WizardDataCollectionModel;
import com.netscape.management.client.components.WizardNavigator;
import com.netscape.management.client.components.WizardPage;
import com.netscape.management.client.components.WizardSequenceManager;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Wizard
extends JDialog {
    WizardNavigator m_nav;
    IWizardSequenceManager m_manager;
    IDataCollectionModel m_model;
    private PageList m_pageList;
    JPanel m_displayPane;
    JLabel m_stepName;
    JLabel m_stepOf;
    int m_currentStep;
    String m_stepN_of_M;
    ResourceSet m_resource = new ResourceSet("com.netscape.management.client.components.Wizard");

    public Wizard(Frame frame, String string, boolean bl) {
        this(frame, string, bl, new WizardSequenceManager(), new WizardDataCollectionModel());
    }

    public Wizard(Frame frame, String string, boolean bl, IWizardSequenceManager iWizardSequenceManager, IDataCollectionModel iDataCollectionModel) {
        super(frame, string, bl);
        this.setSize(425, 425);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_manager = iWizardSequenceManager;
        this.m_model = iDataCollectionModel;
        this.m_pageList = new PageList();
        this.m_stepN_of_M = this.m_resource.getString(null, "stepN_of_M");
        this.m_displayPane = new JPanel();
        this.m_displayPane.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_stepName = new JLabel();
        Font font = this.m_stepName.getFont();
        this.m_stepName.setFont(font.deriveFont(font.getStyle() | 1, font.getSize() + 2));
        this.m_stepName.setBorder(new EmptyBorder(new Insets(3, 3, 3, 0)));
        this.m_stepOf = new JLabel("", 4);
        this.m_stepOf.setFont(font.deriveFont(font.getStyle() | 1, font.getSize() + 2));
        this.m_stepOf.setBorder(new EmptyBorder(new Insets(3, 0, 3, 3)));
        GridBagUtil.constrain(jPanel, this.m_stepName, 0, 0, 1, 1, 1.0, 1.0, 17, 1, 9, 9, 9, 0);
        GridBagUtil.constrain(jPanel, this.m_stepOf, 1, 0, 1, 1, 1.0, 1.0, 13, 1, 9, 0, 9, 9);
        this.getContentPane().add("North", jPanel);
        this.getContentPane().add("Center", this.m_displayPane);
        this.m_nav = new WizardNavigator(this, this.m_manager);
        this.getContentPane().add("South", this.m_nav);
    }

    public void addPage(String string, WizardPage wizardPage) {
        wizardPage.setDataModel(this.m_model);
        wizardPage.setSequenceManager(this.m_manager);
        int n = this.m_pageList.getTotalPage() - 1;
        if (n < 0) {
            this.m_manager.setFirst(string);
            this.m_manager.setCurrent(string);
        } else {
            this.m_manager.setPrevious(string, this.m_pageList.getID(n));
        }
        this.m_pageList.addPage(string, wizardPage);
    }

    void setFirst() {
        this.m_nav.setPanel(this.m_manager.getFirst());
        this.m_model.addChangeListener(this.m_nav);
        this.m_model.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = Wizard.this.getPage(Wizard.this.m_manager.getCurrent()).getMaxSteps();
                Wizard.this.m_stepOf.setText(Wizard.this.replace(Wizard.this.replace(Wizard.this.m_stepN_of_M, "$N", Integer.toString(Wizard.this.m_currentStep)), "$M", Integer.toString(n <= 0 ? Wizard.this.getMaxSteps() : n)));
            }
        });
    }

    String replace(String string, String string2, String string3) {
        int n;
        String string4 = new String(string);
        while ((n = string4.indexOf(string2)) != -1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + string2.length());
        }
        return string4;
    }

    int getMaxSteps() {
        return this.m_pageList.getTotalPage();
    }

    void setPanel(String string, int n) {
        if (string == "") {
            return;
        }
        this.m_manager.setCurrent(string);
        WizardPage wizardPage = this.getPage(string);
        WizardPage wizardPage2 = this.getPage(this.m_manager.getPrevious(this.m_manager.getCurrent()));
        this.m_stepName.setText(wizardPage.getStepName());
        this.m_currentStep = n;
        int n2 = wizardPage.getMaxSteps();
        this.m_stepOf.setText(this.replace(this.replace(this.m_stepN_of_M, "$N", Integer.toString(n)), "$M", Integer.toString(n2 <= 0 ? this.getMaxSteps() : n2)));
        this.m_displayPane.removeAll();
        int n3 = 12;
        if (wizardPage.getGraphicComponent() != null) {
            GridBagUtil.constrain(this.m_displayPane, wizardPage.getGraphicComponent(), 0, 1, 1, 1, 0.0, 0.0, 11, 0, 0, 12, 0, 0);
        }
        GridBagUtil.constrain(this.m_displayPane, wizardPage, 1, 1, 1, 1, 1.0, 1.0, 11, 1, 0, wizardPage.getGraphicComponent() == null ? n3 : 0, 0, 9);
        this.validate();
        this.repaint();
    }

    WizardPage getPage(String string) {
        return this.m_pageList.getPage(string);
    }

    public void show() {
        this.setFirst();
        super.show();
    }

    class PageList {
        Hashtable m_stringIndex = new Hashtable();
        Hashtable m_objectIndex = new Hashtable();
        Vector m_intIndex = new Vector();

        public void addPage(String string, Component component) {
            this.m_intIndex.addElement(component);
            this.m_stringIndex.put(string, component);
            this.m_objectIndex.put(component, string);
        }

        public int getTotalPage() {
            return this.m_intIndex.size();
        }

        public WizardPage getPage(String string) {
            Object v = this.m_stringIndex.get(string);
            if (v == null) {
                return null;
            }
            return (WizardPage)v;
        }

        public String getID(int n) {
            try {
                return (String)this.m_objectIndex.get(this.m_intIndex.elementAt(n));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

