/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.ISortableTableModel;
import com.netscape.management.client.components.TableCheckBoxEditor;
import com.netscape.management.client.components.TableCheckBoxRenderer;
import com.netscape.management.client.components.TableLabelRenderer;
import com.netscape.management.client.components.TableSorter;
import com.netscape.management.client.components.TextHeaderRenderer;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class Table
extends JTable {
    public static final int AUTO_RESIZE_DATA = 5;
    private static final int COLUMN_WIDTH_MULTIPLE = 20;
    private static int ROWS_TO_SCAN = 20;
    protected int autoResizeMode = 0;
    private HeaderMouseListener headerMouseListener = new HeaderMouseListener();
    boolean isInitialized = false;
    boolean enableClientSideSorting = false;
    protected boolean showTableScollBars = true;
    static /* synthetic */ Class class$javax$swing$JCheckBox;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Boolean;

    public Table() {
        this(null, null, null);
    }

    public Table(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public Table(TableModel tableModel, boolean bl) {
        this(bl ? new TableSorter(tableModel) : tableModel, null, null);
        this.enableClientSideSorting = bl;
    }

    public Table(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public Table(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initialize();
        TableModel tableModel2 = this.getModel();
        this.initializeColumnHeaders();
    }

    public Table(int n, int n2) {
        this(new DefaultTableModel(n, n2));
    }

    public Table(final Vector vector, final Vector vector2) {
        this(new AbstractTableModel(){

            public String getColumnName(int n) {
                return vector2.elementAt(n).toString();
            }

            public int getRowCount() {
                return vector.size();
            }

            public int getColumnCount() {
                return vector2.size();
            }

            public Object getValueAt(int n, int n2) {
                return ((Vector)vector.elementAt(n)).elementAt(n2);
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                ((Vector)vector.elementAt(n)).setElementAt(object, n2);
                this.fireTableCellUpdated(n, n2);
            }
        });
        if (!this.isInitialized) {
            this.initialize();
        }
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    private void initializeColumnHeaders() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        int n = 0;
        TableModel tableModel = this.getModel();
        while (enumeration.hasMoreElements()) {
            int n2 = this.convertColumnIndexToModel(n);
            int n3 = this.getTableHeaderAlignmentByClass(tableModel.getColumnClass(n2));
            TextHeaderRenderer textHeaderRenderer = new TextHeaderRenderer(n3, this.enableClientSideSorting);
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(textHeaderRenderer);
            ++n;
        }
    }

    protected void initialize() {
        this.isInitialized = true;
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setAutoResizeMode(5);
        this.setDefaultRenderer(class$javax$swing$JCheckBox == null ? (class$javax$swing$JCheckBox = Table.class$("javax.swing.JCheckBox")) : class$javax$swing$JCheckBox, new TableCheckBoxRenderer());
        this.setDefaultEditor(class$javax$swing$JCheckBox == null ? (class$javax$swing$JCheckBox = Table.class$("javax.swing.JCheckBox")) : class$javax$swing$JCheckBox, new TableCheckBoxEditor());
        this.setDefaultRenderer(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = Table.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, new TableLabelRenderer());
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = Table.class$("java.lang.Object")) : class$java$lang$Object, new TableLabelRenderer());
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setUpdateTableInRealTime(false);
            jTableHeader.addMouseListener(this.headerMouseListener);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Table.this.autoResizeMode == 5) {
                    Table.this.sizeColumnsByData();
                }
                Table.this.removeComponentListener(this);
            }
        });
    }

    protected int getTableHeaderAlignmentByClass(Class clazz) {
        if (clazz.equals(class$java$lang$Number == null ? (class$java$lang$Number = Table.class$("java.lang.Number")) : class$java$lang$Number)) {
            return 4;
        }
        if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = Table.class$("java.util.Date")) : class$java$util$Date)) {
            return 4;
        }
        if (clazz.equals(class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = Table.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon)) {
            return 0;
        }
        if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Table.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 0;
        }
        if (clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = Table.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 2;
        }
        return this.getTableHeaderAlignmentByClass(clazz.getSuperclass());
    }

    public void setModel(TableModel tableModel) throws IllegalArgumentException {
        if (this.enableClientSideSorting) {
            super.setModel(new TableSorter(tableModel));
        } else {
            super.setModel(tableModel);
        }
        this.initializeColumnHeaders();
    }

    public TableModel getModel() {
        return super.getModel();
    }

    public void setColumnModel(TableColumnModel tableColumnModel) throws IllegalArgumentException {
        super.setColumnModel(tableColumnModel);
        this.initializeColumnHeaders();
    }

    public void setAutoResizeMode(int n) {
        this.autoResizeMode = n;
        if (n == 5) {
            n = 0;
        }
        super.setAutoResizeMode(n);
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    protected void sizeColumnsByData() {
        if (!this.isInitialized) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (this.getRowCount() > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.sizeColumnByData(n2);
                ++n2;
            }
        } else {
            this.sizeColumnByData(n - 1);
        }
        this.repaintHeader();
        this.repaintTable();
    }

    protected void sizeColumnByData(int n) {
        if (!this.isInitialized) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        if (!tableColumn.getResizable()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = Math.min(ROWS_TO_SCAN, this.getRowCount());
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            return;
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, n);
        n2 = component.getPreferredSize().width;
        int n5 = tableColumnModel.getColumnCount();
        if (n != n5 - 1) {
            int n6 = 0;
            while (n6 < n4) {
                TableCellRenderer tableCellRenderer2 = this.getCellRenderer(n6, n);
                component = tableCellRenderer2.getTableCellRendererComponent(this, this.getValueAt(n6, n), false, false, n6, n);
                n3 = component.getPreferredSize().width;
                if (n3 > n2) {
                    n2 = n3;
                }
                ++n6;
            }
            n2 /= 20;
            ++n2;
            n2 *= 20;
            n2 = Math.min(tableColumn.getMaxWidth(), n2);
            n2 = Math.max(tableColumn.getMinWidth(), n2);
        } else {
            int n7 = this.getSize().width;
            Container container = this.getParent();
            if (container != null) {
                n7 = container.getSize().width;
            }
            int n8 = 0;
            int n9 = 0;
            while (n9 < n5 - 1) {
                n8 += tableColumnModel.getColumn(n9).getPreferredWidth();
                ++n9;
            }
            n2 = Math.max(tableColumn.getMinWidth(), n7 - n8);
        }
        tableColumn.setPreferredWidth(n2);
        tableColumn.setWidth(n2);
    }

    private void repaintHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.validate();
        jTableHeader.repaint();
    }

    private void repaintTable() {
        this.validate();
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class HeaderMouseListener
    extends MouseAdapter {
        Object lastColIdentifier = null;
        boolean ascending = true;

        HeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n;
                Object object;
                Object object2;
                int n2;
                Serializable serializable;
                int n3 = this.getResizingColumn(mouseEvent.getPoint());
                if (n3 != -1) {
                    Table.this.sizeColumnByData(n3);
                    Table.this.repaintHeader();
                    Table.this.repaintTable();
                    return;
                }
                if (!Table.this.enableClientSideSorting) {
                    Debug.println("Table.mouseClicked: clientSideSorting=" + Table.this.enableClientSideSorting);
                    return;
                }
                TableColumnModel tableColumnModel = Table.this.getColumnModel();
                int n4 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n4 == -1) {
                    return;
                }
                TableColumn tableColumn = tableColumnModel.getColumn(n4);
                if (tableColumn.getIdentifier().equals(this.lastColIdentifier)) {
                    this.ascending = !this.ascending;
                } else if (this.lastColIdentifier != null && (serializable = tableColumnModel.getColumn(n2 = tableColumnModel.getColumnIndex(this.lastColIdentifier))) != null && (object2 = ((TableColumn)serializable).getHeaderRenderer()) instanceof TextHeaderRenderer) {
                    object = (TextHeaderRenderer)object2;
                    ((TextHeaderRenderer)object).hideSortIndicator();
                }
                this.lastColIdentifier = tableColumn.getIdentifier();
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer instanceof TextHeaderRenderer) {
                    serializable = (TextHeaderRenderer)tableCellRenderer;
                    ((TextHeaderRenderer)serializable).showSortIndicator(this.ascending);
                }
                if ((n = Table.this.convertColumnIndexToModel(n4)) != -1) {
                    object2 = Table.this.getModel();
                    object = (ISortableTableModel)object2;
                    object.sortByColumn(n, this.ascending);
                }
                Table.this.repaintHeader();
                Table.this.repaintTable();
            }
        }

        private int getResizingColumn(Point point) {
            int n = 0;
            JTableHeader jTableHeader = Table.this.getTableHeader();
            Rectangle rectangle = new Rectangle(-3, 0, 6, jTableHeader.getSize().height);
            int n2 = jTableHeader.getColumnModel().getColumnMargin();
            Enumeration<TableColumn> enumeration = jTableHeader.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                rectangle.x += tableColumn.getWidth() + n2;
                if (rectangle.x > point.x) break;
                if (rectangle.contains(point)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }
}

