/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.comm;

import com.netscape.management.client.util.IProgressListener;
import java.io.IOException;
import java.io.InputStream;

public class AsyncByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int cnt;
    protected int pos = 0;
    protected int mark = 0;
    protected boolean eof = true;
    protected IProgressListener progressListener = null;

    public AsyncByteArrayInputStream() {
        this(32, null);
    }

    public AsyncByteArrayInputStream(int n, IProgressListener iProgressListener) {
        this.buf = new byte[n];
        this.progressListener = iProgressListener;
        this.cnt = 0;
        this.eof = false;
    }

    public AsyncByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.cnt = byArray.length;
    }

    public AsyncByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.cnt = Math.min(n + n2, byArray.length);
    }

    public synchronized int read() {
        while (this.pos >= this.cnt) {
            if (this.eof) {
                return -1;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        while (true) {
            if (this.pos >= this.cnt) {
                if (this.eof) {
                    return -1;
                }
            } else {
                if (this.pos + n2 > this.cnt) {
                    n2 = this.cnt - this.pos;
                }
                if (n2 > 0) {
                    System.arraycopy(this.buf, this.pos, byArray, n, n2);
                    this.pos += n2;
                    return n2;
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized long skip(long l) {
        if ((long)this.pos + l > (long)this.cnt) {
            l = this.cnt - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.cnt - this.pos;
    }

    public synchronized int size() {
        return this.cnt;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized void mark(int n) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int waitForData() {
        while (!this.eof) {
            int n = this.available();
            if (n > 0) {
                return n;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return -1;
    }

    protected synchronized void checkCapacity(int n) {
        int n2 = this.cnt + n;
        if (n2 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
            System.arraycopy(this.buf, 0, byArray, 0, this.cnt);
            this.buf = byArray;
        }
    }

    public synchronized boolean write(int n) {
        if (this.eof) {
            return false;
        }
        this.checkCapacity(1);
        this.buf[this.cnt++] = (byte)n;
        this.notifyAll();
        return true;
    }

    public synchronized boolean write(byte[] byArray, int n, int n2) {
        if (this.eof) {
            return false;
        }
        this.checkCapacity(n2);
        System.arraycopy(byArray, n, this.buf, this.cnt, n2);
        this.cnt += n2;
        this.notifyAll();
        return true;
    }

    public synchronized boolean write(InputStream inputStream, int n) throws IOException {
        if (this.eof) {
            return false;
        }
        this.checkCapacity(n);
        int n2 = n;
        while (n > 0) {
            int n3 = inputStream.read(this.buf, this.cnt, n);
            n -= n3;
            this.cnt += n3;
            if (this.progressListener == null) continue;
            this.progressListener.progressUpdate(null, n2, this.cnt);
        }
        this.notifyAll();
        return true;
    }

    public synchronized void setEOF() {
        this.eof = true;
        this.notifyAll();
    }

    public synchronized boolean getEOF() {
        return this.eof;
    }

    public synchronized String toString() {
        return new String(this.buf, 0, this.cnt);
    }

    public byte[] getBuf() {
        return this.buf;
    }
}

