/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;

public class TagCache {
    String shortTagName;
    Hashtable methodMaps;
    BeanInfo tagClassInfo;
    Class tagHandlerClass;

    TagCache(String string) {
        this.shortTagName = string;
        this.methodMaps = new Hashtable();
    }

    private void addSetterMethod(String string, Method method) {
        this.methodMaps.put(string, method);
    }

    Method getSetterMethod(String string) {
        return (Method)this.methodMaps.get(string);
    }

    BeanInfo getTagClassInfo() {
        return this.tagClassInfo;
    }

    Class getTagHandlerClass() {
        return this.tagHandlerClass;
    }

    void setTagHandlerClass(Class clazz) throws JasperException {
        try {
            this.tagClassInfo = Introspector.getBeanInfo(clazz);
            this.tagHandlerClass = clazz;
            PropertyDescriptor[] propertyDescriptorArray = this.tagClassInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getWriteMethod() != null) {
                    this.addSetterMethod(propertyDescriptorArray[n].getName(), propertyDescriptorArray[n].getWriteMethod());
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new JasperException(Constants.getString("jsp.error.unable.to_introspect", new Object[]{clazz.getName(), introspectionException.getMessage()}));
        }
    }
}

