/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ServletWriter;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;

    public Compiler(JspCompilationContext jspCompilationContext) {
        this.ctxt = jspCompilationContext;
    }

    public String changeEncodingIfNecessary(JspReader jspReader) throws ParseException {
        while (jspReader.skipUntil("<%@") != null) {
            jspReader.skipSpaces();
            if (!jspReader.matches("page")) continue;
            jspReader.advance(4);
            jspReader.skipSpaces();
            try {
                int n;
                Hashtable hashtable = jspReader.parseTagAttributes();
                String string = (String)hashtable.get("contentType");
                if (string == null || (n = string.indexOf("charset=")) <= 0) continue;
                String string2 = string.substring(n + 8);
                return string2;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        Object object;
        OutputStreamWriter outputStreamWriter;
        String string = this.mangler.getPackageName();
        this.ctxt.setServletPackageName(string);
        Constants.message("jsp.message.package_name_is", new Object[]{string == null ? "[default package]" : string}, 4);
        String string2 = this.mangler.getClassFileName();
        Constants.message("jsp.message.class_file_name_is", new Object[]{string2}, 4);
        String string3 = this.mangler.getJavaFileName();
        this.ctxt.setServletJavaFileName(string3);
        Constants.message("jsp.message.java_file_name_is", new Object[]{string3}, 4);
        String string4 = this.mangler.getClassName();
        this.ctxt.setServletClassName(string4);
        Constants.message("jsp.message.class_name_is", new Object[]{string4}, 4);
        if (!this.isOutDated()) {
            return false;
        }
        String string5 = "ISO-8859-1";
        String string6 = "UTF8";
        JspReader jspReader = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt, string5);
        String string7 = this.changeEncodingIfNecessary(jspReader);
        if (string7 != null) {
            string5 = string7;
        }
        JspReader jspReader2 = JspReader.createJspReader(this.ctxt.getJspFile(), this.ctxt, string5);
        this.makeOutputDirectory(string3);
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string6);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string6 = this.ctxt.getOptions().getJavaEncoding();
            if (string6 != null) {
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string6);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    throw new JasperException(Constants.getString("jsp.error.invalid.javaEncoding", new Object[]{"UTF8", string6}));
                }
            }
            throw new JasperException(Constants.getString("jsp.error.needAlternateJavaEncoding", new Object[]{"UTF8"}));
        }
        ServletWriter servletWriter = new ServletWriter(new PrintWriter(outputStreamWriter));
        this.ctxt.setReader(jspReader2);
        this.ctxt.setWriter(servletWriter);
        JspParseEventListener jspParseEventListener = new JspParseEventListener(this.ctxt);
        Parser parser = new Parser(jspReader2, jspParseEventListener);
        jspParseEventListener.beginPageProcessing();
        parser.parse();
        jspParseEventListener.endPageProcessing();
        servletWriter.close();
        String string8 = this.ctxt.getClassPath();
        String string9 = System.getProperty("path.separator");
        String[] stringArray = new String[]{"-encoding", string6, "-classpath", String.valueOf(System.getProperty("java.class.path")) + string9 + string8 + string9 + this.ctxt.getOutputDir(), "-d", this.ctxt.getOutputDir(), string3};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        Constants.message("jsp.message.compiling_with", new Object[]{stringBuffer.toString()}, 4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return true;
        }
        this.javac.setEncoding(string6);
        this.javac.setClasspath(String.valueOf(System.getProperty("java.class.path")) + string9 + string8 + string9 + this.ctxt.getOutputDir());
        this.javac.setOutputDir(this.ctxt.getOutputDir());
        this.javac.setMsgOutput(byteArrayOutputStream);
        this.javac.setClassDebugInfo(this.ctxt.getOptions().getClassDebugInfo());
        boolean bl = this.javac.compile(string3);
        if (!this.ctxt.keepGenerated()) {
            object = new File(string3);
            ((File)object).delete();
        }
        if (!bl) {
            object = byteArrayOutputStream.toString();
            throw new JasperException(String.valueOf(Constants.getString("jsp.error.unable.compile")) + (String)object);
        }
        object = String.valueOf(this.ctxt.getOutputDir()) + File.separatorChar;
        if (string != null && !string.equals("")) {
            object = String.valueOf(object) + string.replace('.', File.separatorChar) + File.separatorChar;
        }
        if (!((String)(object = String.valueOf(object) + string4 + ".class")).equals(string2)) {
            File file = new File((String)object);
            File file2 = new File(string2);
            if (file2.exists()) {
                file2.delete();
            }
            if (!file.renameTo(file2)) {
                throw new JasperException(Constants.getString("jsp.error.unable.rename", new Object[]{file, file2}));
            }
        }
        return true;
    }

    public void computeServletClassName() {
        String string = this.mangler.getClassName();
        this.ctxt.setServletClassName(string);
        Constants.message("jsp.message.class_name_is", new Object[]{string}, 4);
    }

    public boolean isOutDated() {
        return true;
    }

    private boolean makeOutputDirectory(String string) throws FileNotFoundException, Exception {
        String string2;
        File file;
        boolean bl = false;
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1 && !(bl = (file = new File(string2 = string.substring(0, n))).exists())) {
            bl = file.mkdirs();
        }
        return bl;
    }

    public void removeGeneratedFiles() {
        try {
            Object object;
            String string = this.mangler.getClassFileName();
            if (string != null) {
                object = new File(string);
                ((File)object).delete();
            }
            if ((object = this.mangler.getJavaFileName()) != null) {
                File file = new File((String)object);
                file.delete();
            }
        }
        catch (Exception exception) {}
    }

    public void setJavaCompiler(JavaCompiler javaCompiler) {
        this.javac = javaCompiler;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }
}

