/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ConstantPool;

public class ClassName {
    public static String getClassName(String string) throws JasperException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return ClassName.processClassData(fileInputStream);
        }
        catch (IOException iOException) {
            throw new JasperException(Constants.getString("jsp.error.classname"), iOException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n = 0;
            while (n < stringArray.length) {
                System.out.println("Filename: " + stringArray[n] + " Classname: " + ClassName.getClassName(stringArray[n]));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String printClassName(String string) {
        if (string.charAt(0) == '[') {
            return ClassName.typeString(string, "");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '/') {
                stringBuffer.append('.');
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static String processClassData(InputStream inputStream) throws JasperException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readInt();
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        ConstantPool[] constantPoolArray = new ConstantPool[n];
        constantPoolArray[0] = new ConstantPool();
        int n2 = 1;
        while (n2 < constantPoolArray.length) {
            constantPoolArray[n2] = new ConstantPool();
            if (!constantPoolArray[n2].read(dataInputStream)) {
                throw new JasperException(Constants.getString("jsp.error.classname"));
            }
            if (constantPoolArray[n2].type == 5 || constantPoolArray[n2].type == 6) {
                ++n2;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < constantPoolArray.length) {
            if (constantPoolArray[n3] != null) {
                if (constantPoolArray[n3].index1 > 0) {
                    constantPoolArray[n3].arg1 = constantPoolArray[constantPoolArray[n3].index1];
                }
                if (constantPoolArray[n3].index2 > 0) {
                    constantPoolArray[n3].arg2 = constantPoolArray[constantPoolArray[n3].index2];
                }
            }
            ++n3;
        }
        int n4 = dataInputStream.readUnsignedShort();
        ConstantPool constantPool = constantPoolArray[dataInputStream.readUnsignedShort()];
        dataInputStream.close();
        return ClassName.printClassName(constantPool.arg1.strValue);
    }

    private static String typeString(String string, String string2) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (string.charAt(n2) == '[') {
            ++n;
            ++n2;
        }
        switch (string.charAt(n2)) {
            case 'B': {
                stringBuffer.append("byte ");
                break;
            }
            case 'C': {
                stringBuffer.append("char ");
                break;
            }
            case 'D': {
                stringBuffer.append("double ");
                break;
            }
            case 'F': {
                stringBuffer.append("float ");
                break;
            }
            case 'I': {
                stringBuffer.append("int ");
                break;
            }
            case 'J': {
                stringBuffer.append("long ");
                break;
            }
            case 'L': {
                int n3 = n2 + 1;
                while (n3 < string.indexOf(59)) {
                    if (string.charAt(n3) != '/') {
                        stringBuffer.append(string.charAt(n3));
                    } else {
                        stringBuffer.append('.');
                    }
                    ++n3;
                }
                stringBuffer.append(" ");
                break;
            }
            case 'V': {
                stringBuffer.append("void ");
                break;
            }
            case 'S': {
                stringBuffer.append("short ");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean ");
                break;
            }
        }
        stringBuffer.append(string2);
        while (n > 0) {
            stringBuffer.append("[]");
            --n;
        }
        return stringBuffer.toString();
    }
}

