/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminFrameworkInitializer;
import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFrameworkInitializer;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.StatusItemSecureMode;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AbstractServerObject;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class AdminServer
extends AbstractServerObject
implements SuiConstants {
    public static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.admserv");
    ConsoleInfo _consoleInfo;
    int _serverStatus;
    private int adminUrlNodeDataIndex = -1;
    protected boolean _needsAutoRestart = false;
    protected boolean _canRestartFromConsole;
    protected String _postRestartURL = null;
    protected boolean _isShutdown = false;
    private IRestartControl _restartControl = new IRestartControl(){

        public void setNeedsAutoRestart(boolean bl) {
            AdminServer.this._needsAutoRestart = bl;
        }

        public boolean needsAutoRestart() {
            return AdminServer.this._needsAutoRestart;
        }

        public void setCanRestartFromConsole(boolean bl) {
            AdminServer.this._canRestartFromConsole = bl;
        }

        public boolean canRestartFromConsole() {
            return AdminServer.this._canRestartFromConsole;
        }

        public void setPostRestartURL(String string) {
            AdminServer.this._postRestartURL = string;
        }

        public String getPostRestartURL() {
            return AdminServer.this._postRestartURL;
        }

        public void setServerShutdown(boolean bl) {
            AdminServer.this._isShutdown = bl;
        }

        public boolean isServerShutdown() {
            return AdminServer.this._isShutdown;
        }
    };
    private URL _serverURL = null;
    private URLConnection _serverConnection = null;

    public void initialize(ConsoleInfo consoleInfo) {
        super.initialize(consoleInfo);
        this._consoleInfo = consoleInfo;
        RemoteImage remoteImage = new RemoteImage(_resource.getString("admin", "smallIcon"));
        remoteImage.setDescription(_resource.getString("admin", "smallIcon-description"));
        this.setIcon((Icon)remoteImage);
        this._canRestartFromConsole = !consoleInfo.getAdminURL().startsWith("https");
    }

    private boolean run(IPage iPage) {
        if (this.getServerStatus() == 2) {
            JFrame jFrame = iPage.getFramework().getJFrame();
            String string = _resource.getString("error", "OpenServerTitle");
            String string2 = MessageFormat.format(_resource.getString("error", "CanNotOpenServer"), this.getName());
            BaseConfigPanel.clearProgressIndicator((Component)iPage);
            SuiOptionPane.showMessageDialog((Component)jFrame, (Object)string2, (String)string, (int)0);
            return false;
        }
        this._consoleInfo.put("SIE", this.getSIE());
        this._consoleInfo.put("SIE_VERSION", this.getProductVersion());
        this._consoleInfo.put("SERVER_NAME", this.getName());
        this._consoleInfo.put("HOST_NAME", this.getHostName());
        this._consoleInfo.put("RESTART_CONTROL", this._restartControl);
        this.createFramework();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        if (iResourceObjectArray.length == 1) {
            return this.run(iPage);
        }
        if (this.getServerStatus() == 2) {
            JFrame jFrame = iPage.getFramework().getJFrame();
            String string = _resource.getString("error", "OpenServerTitle");
            String string2 = MessageFormat.format(_resource.getString("error", "CanNotOpenServer"), this.getName());
            BaseConfigPanel.clearProgressIndicator((Component)iPage);
            SuiOptionPane.showMessageDialog((Component)jFrame, (Object)string2, (String)string, (int)0);
            return false;
        }
        int n = 0;
        while (n < iResourceObjectArray.length) {
            if (!(iResourceObjectArray[n] instanceof ServerNode)) {
                Debug.println((String)("can't run, selection is " + iResourceObjectArray[n].getClass().getName()));
                return false;
            }
            ServerNode serverNode = (ServerNode)iResourceObjectArray[n];
            if (!(serverNode.getServerObject() instanceof AdminServer)) {
                Debug.println((String)("can't run, server is " + serverNode.getServerObject().getClass().getName()));
                return false;
            }
            ++n;
        }
        this.createFramework();
        return true;
    }

    protected void createFramework() {
        Framework framework = new Framework((IFrameworkInitializer)new AdminFrameworkInitializer(this._consoleInfo));
        StatusItemSecureMode statusItemSecureMode = new StatusItemSecureMode("StatusItemSecureMode");
        statusItemSecureMode.setSecureMode(this._consoleInfo.getAdminURL().startsWith("https"));
        framework.addStatusItem((IStatusItem)statusItemSecureMode, "LF");
        statusItemSecureMode.setToolTipText(this._consoleInfo.getAdminURL());
        try {
            framework.setHelpAdminURL(new URL(this._consoleInfo.getAdminURL()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected String getHostName() {
        return (String)this._nodeDataTable.get("serverHostName");
    }

    protected String getSIE() {
        return (String)this._nodeDataTable.get("cn");
    }

    protected String getProductVersion() {
        return (String)this._nodeDataTable.get("nsProductVersion");
    }

    public ConsoleInfo getConsoleInfo() {
        return this._consoleInfo;
    }

    public synchronized int getServerStatus() {
        if (this._consoleInfo == null) {
            return 0;
        }
        try {
            String string = this._consoleInfo.getAdminURL() + "admin-serv/tasks/operation/StatusPing";
            AdmTask admTask = new AdmTask(new URL(string), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            admTask.exec();
            int n = admTask.getStatus();
            this._serverStatus = n == 0 ? 1 : (admTask.getException() != null && admTask.getException() instanceof SocketException ? 2 : 0);
            return this._serverStatus;
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((String)("ERROR AdminConfigData.isRunning: bad URL " + this._consoleInfo.getAdminURL()));
            this._serverStatus = 0;
            return 0;
        }
    }

    public void cloneFrom(String string) {
        String string2 = "cn=configuration," + string;
        String string3 = null;
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            if (lDAPConnection == null) {
                lDAPConnection = new LDAPConnection();
            }
            if (!lDAPConnection.isConnected()) {
                lDAPConnection.connect(this._consoleInfo.getHost(), this._consoleInfo.getPort(), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            }
            LDAPEntry lDAPEntry = lDAPConnection.read(string2);
            String string4 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsadminaccessaddresses", LDAPUtil.getLDAPAttributeLocale()));
            String string5 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsadminaccesshosts", LDAPUtil.getLDAPAttributeLocale()));
            String string6 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsadmincachelifetime", LDAPUtil.getLDAPAttributeLocale()));
            String string7 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsadminenableenduser", LDAPUtil.getLDAPAttributeLocale()));
            String string8 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsadminoneacldir", LDAPUtil.getLDAPAttributeLocale()));
            String string9 = LDAPUtil.flatting((LDAPAttribute)lDAPEntry.getAttribute("nsdefaultacceptlanguage", LDAPUtil.getLDAPAttributeLocale()));
            boolean bl = string7 == null || !string7.equalsIgnoreCase("off");
            string3 = new String(this._consoleInfo.getAdminURL() + "admin-serv/tasks/Configuration/ServerSetup?op=force_set" + "&configuration.nsadminaccessaddresses=" + string4 + "&configuration.nsadminaccesshosts=" + string5 + "&configuration.nsadmincachelifetime=" + string6 + "&configuration.nsadminoneacldir=" + string8 + "&configuration.nsdefaultacceptlanguage=" + string9);
            string3 = bl ? string3 + "&configuration.nsadminenableenduser=" : string3 + "&configuration.nsadminenableenduser=off";
            Debug.println((String)("TRACE AdminServer.cloneFrom: configURL = " + string3));
            URL uRL = new URL(string3);
            AdmTask admTask = new AdmTask(uRL, this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            int n = admTask.exec();
            int n2 = admTask.getStatus();
            String string10 = _resource.getString("status", "cloneTitle");
            if (n == 0 && n2 == 0) {
                Debug.println((String)"TRACE AdminServer.cloneFrom: config CGI succeeded!");
                String string11 = MessageFormat.format(_resource.getString("status", "cloneSucceeded"), this.getName());
                SuiOptionPane.showMessageDialog(null, (Object)string11, (String)string10, (int)1);
            } else {
                Debug.println((String)("ERROR AdminServer.cloneFrom: config CGI status = " + (n == 0 ? n2 : n)));
                String string12 = MessageFormat.format(_resource.getString("status", "cloneFailed"), this.getName());
                SuiOptionPane.showMessageDialog(null, (Object)string12, (String)string10, (int)0);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR AdminServer.cloneFrom: LDAP read failed: " + string2));
        }
        catch (MalformedURLException malformedURLException) {
            Debug.println((String)("ERROR AdminServer.cloneFrom: Bad URL: " + string3));
        }
    }

    public boolean isMigrationEnabled() {
        return !this.getProductVersion().equals("4.0");
    }

    public int getNodeDataCount() {
        this.adminUrlNodeDataIndex = super.getNodeDataCount();
        return this.adminUrlNodeDataIndex + 1;
    }

    public NodeData getNodeData(int n) {
        if (n == this.adminUrlNodeDataIndex) {
            String string = null;
            String string2 = this._consoleInfo.getAdminURL();
            int n2 = string2.lastIndexOf(58);
            if (n2 != -1) {
                string = string2.substring(n2 + 1).replace('/', ' ').trim();
            }
            return new NodeData("", _resource.getString("infopanel", "Port"), (Object)string, false);
        }
        return super.getNodeData(n);
    }
}

