/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public abstract class KingpinClassLoader
extends ClassLoader {
    protected static Hashtable classLoaderCache = new Hashtable();
    protected static final String debugTag = "ClassLoader: ";
    protected Object loaderID;
    protected String className;
    protected Hashtable classCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KingpinClassLoader(Object object) {
        this.loaderID = object;
        String string = this.getClass().getName();
        this.className = string.substring(string.lastIndexOf(46) + 1);
        Hashtable hashtable = classLoaderCache;
        synchronized (hashtable) {
            KingpinClassLoader kingpinClassLoader = (KingpinClassLoader)classLoaderCache.get(this.loaderID);
            if (kingpinClassLoader != null) {
                this.classCache = kingpinClassLoader.classCache;
                return;
            }
            this.classCache = new Hashtable();
            classLoaderCache.put(this.loaderID, this);
        }
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.loadClass(string);
        if (bl) {
            Debug.println((int)9, (String)("ClassLoader: :loadClass():resolving " + string));
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (Debug.isEnabled()) {
            Debug.println((int)9, (String)("ClassLoader: :loadClass():name:" + string));
        }
        if (string.startsWith("java.")) {
            return this.findSystemClass(string);
        }
        try {
            Hashtable hashtable = this.classCache;
            synchronized (hashtable) {
                clazz = (Class<?>)this.classCache.get(string);
                if (clazz == null) {
                    String string2 = string.replace('.', '/') + ".class";
                    if (Debug.isEnabled()) {
                        Debug.println((int)9, (String)("ClassLoader: :loadClass():loading:" + string));
                    }
                    byte[] byArray = this.loadData(string2);
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                    this.classCache.put(string, clazz);
                } else if (Debug.isEnabled()) {
                    Debug.println((int)9, (String)("ClassLoader: :loadClass():cached class:" + string));
                }
            }
        }
        catch (Exception exception) {
            return this.findSystemClass(string);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            return new ByteArrayInputStream(this.loadData(string));
        }
        catch (Exception exception) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
    }

    public String toString() {
        return this.className + "[" + this.loaderID + "]";
    }

    protected abstract byte[] loadData(String var1) throws Exception;
}

