/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.servlet.WFilterDef;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.util.LogUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WFilterChain
implements FilterChain {
    private WFilterDef filterDef;
    private WebApplication webApp;
    private WFilterChain next;
    private NSServletWrapper sw;

    public WFilterChain(WFilterDef wFilterDef, WebApplication webApplication) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.webApp = webApplication;
        this.filterDef = wFilterDef;
        this.next = null;
    }

    public WFilterChain(WebApplication webApplication, NSServletWrapper nSServletWrapper) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.webApp = webApplication;
        this.filterDef = null;
        this.next = null;
        this.sw = nSServletWrapper;
        this.sw.acquire();
    }

    void destroy() {
        this.webApp = null;
        this.filterDef = null;
        if (this.sw != null) {
            this.sw.release();
        }
        this.sw = null;
        this.next = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        if (this.getNext() != null) {
            this.getNext().doFilter(servletRequest, servletResponse, (FilterChain)this.getNextChain());
        } else {
            NSServletWrapper nSServletWrapper = this.next.getServletWrapper();
            try {
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                HttpServlet httpServlet = (HttpServlet)nSServletWrapper.getServlet();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("WrapperServlet -- Invoking servlet.service() for " + nSServletWrapper.getServletName()));
                }
                httpServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (ClassCastException classCastException) {
                nSServletWrapper.getServlet().service(servletRequest, servletResponse);
            }
        }
    }

    Filter getFilter() {
        if (this.filterDef == null) {
            return null;
        }
        return this.filterDef.getFilter();
    }

    private Filter getNext() {
        if (this.next == null) {
            return null;
        }
        return this.next.getFilter();
    }

    WFilterChain getNextChain() {
        return this.next;
    }

    NSServletWrapper getServletWrapper() {
        return this.sw;
    }

    void setNextChain(WFilterChain wFilterChain) {
        this.next = wFilterChain;
    }

    void setServletWrapper(NSServletWrapper nSServletWrapper) {
        this.sw = nSServletWrapper;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WFilterChain[");
        stringBuffer.append("context=");
        stringBuffer.append(this.webApp.getContextPath());
        stringBuffer.append(", filterClass=");
        stringBuffer.append(this.filterDef.getFilterClass());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

