/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.util;

import java.util.Hashtable;

public class LockManager {
    public static final int DEFAULT_NUM_LOCKS = 10;
    private long nativePtr_;
    private int nLocks_;
    private Hashtable lockIDs_;

    static {
        System.loadLibrary("NSJavaUtil");
    }

    public LockManager(String string) {
        this(string, 10);
    }

    public LockManager(String string, int n) {
        this.nLocks_ = n <= 0 ? 10 : n;
        this.lockIDs_ = new Hashtable();
        this.nativePtr_ = this.createNativeObject(string, this.nLocks_);
    }

    private native long createNativeObject(String var1, int var2);

    public void destroy() {
        if (this.lockIDs_ != null) {
            this.lockIDs_.clear();
            this.lockIDs_ = null;
        }
        if (this.nativePtr_ != 0L) {
            this.destroyNativeObject(this.nativePtr_);
            this.nativePtr_ = 0L;
        }
    }

    private native void destroyNativeObject(long var1);

    private int getLockID(String string) {
        int n = 0;
        Object v = this.lockIDs_.get(string);
        if (v != null) {
            n = (Integer)v;
        } else {
            byte[] byArray = string.getBytes();
            int n2 = 0;
            while (n2 < byArray.length) {
                n += byArray[n2];
                ++n2;
            }
            this.lockIDs_.put(string, new Integer(n %= this.nLocks_));
        }
        return n;
    }

    public boolean lock(String string) {
        boolean bl = false;
        if (string != null && string.length() != 0 && this.nativePtr_ != 0L) {
            int n = this.getLockID(string);
            bl = this.nativeLock(this.nativePtr_, n);
        }
        return bl;
    }

    private native boolean nativeLock(long var1, int var3);

    private native boolean nativeUnlock(long var1, int var3);

    public void remove(String string) {
        if (string != null) {
            this.lockIDs_.remove(string);
        }
    }

    public boolean unlock(String string) {
        boolean bl = false;
        if (string != null && string.length() != 0 && this.nativePtr_ != 0L) {
            int n = this.getLockID(string);
            bl = this.nativeUnlock(this.nativePtr_, n);
        }
        return bl;
    }
}

