/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.DayPicker;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ISpinListener;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SpinControl;
import com.netscape.management.client.util.SpinEvent;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DatePicker
extends JPanel
implements SuiConstants {
    Calendar calendar;
    JComboBox monthField = new JComboBox();
    JTextField yearField = new JTextField(8);
    SpinControl yearSpinner;
    DayPicker dayPicker;
    private static final ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");
    private static final String JANUARY = _resource.getString("DatePicker", "January");
    private static final String FEBRUARY = _resource.getString("DatePicker", "February");
    private static final String MARCH = _resource.getString("DatePicker", "March");
    private static final String APRIL = _resource.getString("DatePicker", "April");
    private static final String MAY = _resource.getString("DatePicker", "May");
    private static final String JUNE = _resource.getString("DatePicker", "June");
    private static final String JULY = _resource.getString("DatePicker", "July");
    private static final String AUGUST = _resource.getString("DatePicker", "August");
    private static final String SEPTEMBER = _resource.getString("DatePicker", "September");
    private static final String OCTOBER = _resource.getString("DatePicker", "October");
    private static final String NOVEMBER = _resource.getString("DatePicker", "November");
    private static final String DECEMBER = _resource.getString("DatePicker", "December");
    int oldYear = 0;

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getDay() {
        return this.dayPicker.getDay();
    }

    public DatePicker(Calendar calendar) {
        this.calendar = calendar;
        String[] stringArray = new String[]{JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER};
        this.monthField.getAccessibleContext().setAccessibleDescription(_resource.getString("DatePicker", "month"));
        this.yearField.getAccessibleContext().setAccessibleDescription(_resource.getString("DatePicker", "year"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        GridBagUtil.constrain(this, this.monthField, 0, 0, 1, 1, 0.0, 0.0, 18, 1, 0, 0, 6, 6);
        GridBagUtil.constrain(this, this.yearField, 1, 0, 1, 1, 0.0, 0.0, 18, 1, 0, 0, 6, 0);
        this.yearSpinner = new SpinControl(this.yearField);
        this.yearSpinner.setToolTipText(_resource.getString("DatePicker", "year_tt"));
        GridBagUtil.constrain(this, this.yearSpinner, 2, 0, 1, 1, 0.0, 0.0, 18, 1, 0, 0, 6, 0);
        this.dayPicker = new DayPicker(calendar);
        GridBagUtil.constrain(this, this.dayPicker, 0, 1, 3, 1, 0.0, 0.0, 18, 1, 0, 0, 6, 0);
        int n = 0;
        while (n < stringArray.length) {
            this.monthField.addItem(stringArray[n]);
            ++n;
        }
        this.monthField.setSelectedIndex(calendar.get(2));
        this.yearField.setText(String.valueOf(calendar.get(1)));
        this.monthField.addActionListener(new MonthChangeListener());
        this.yearField.addFocusListener(new YearFocusListener());
        this.yearSpinner.addSpinListener(new YearSpinListener());
    }

    int getIntFromString(String string) {
        Integer n = new Integer(string);
        return n;
    }

    public void update() {
        int n = this.getYear();
        if (this.oldYear != n) {
            this.yearField.setText(String.valueOf(n));
            this.dayPicker.updatePicker();
            this.oldYear = n;
        }
    }

    class YearFocusListener
    implements FocusListener {
        YearFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            int n = DatePicker.this.getIntFromString(DatePicker.this.yearField.getText());
            if (n < 1900 || n > 9999) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                n = gregorianCalendar.get(1);
            }
            DatePicker.this.calendar.set(1, n);
            DatePicker.this.update();
        }
    }

    class YearSpinListener
    implements ISpinListener {
        YearSpinListener() {
        }

        public void actionUp(SpinEvent spinEvent) {
            DatePicker.this.calendar.add(1, 1);
            DatePicker.this.update();
        }

        public void actionDown(SpinEvent spinEvent) {
            DatePicker.this.calendar.add(1, -1);
            DatePicker.this.update();
        }
    }

    class MonthChangeListener
    implements ActionListener {
        MonthChangeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatePicker.this.calendar.set(2, DatePicker.this.monthField.getSelectedIndex());
            DatePicker.this.dayPicker.updatePicker();
        }
    }
}

