/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public abstract class AbstractDialog
extends JDialog
implements SwingConstants,
SuiConstants {
    static final int DO_NOTHING = 0;
    static final int DO_ACTION = 1;
    static final int DO_CANCEL = 2;
    public static final int HORIZONTAL_BUTTONS = 0;
    public static final int VERTICAL_BUTTONS = 1;
    public static final int NO_BUTTONS = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int HELP = 8;
    protected FocusListener _focusListener = new ButtonFocusListener();
    public JButton _defaultButton;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");
    private static final boolean _isSolaris = System.getProperty("os.name").equalsIgnoreCase("solaris");
    private static final boolean _isIrix = System.getProperty("os.name").equalsIgnoreCase("irix");
    private static final boolean _isWinNT = System.getProperty("os.name").equalsIgnoreCase("windows nt");
    private Component _buttonComponent;
    private JPanel _customPanel;
    private JButton _closeButton = null;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JButton _helpButton = null;
    private int _buttons = 0;
    private int _buttonOrientation = 0;
    private JComponent _focusComponent = null;
    private Frame _parentFrame = null;
    private int minWidth = 0;
    private int minHeight = 0;
    protected int _actionPerformed;
    private boolean _busyCursorOn;

    public AbstractDialog(Frame frame) {
        this(frame, null, false);
    }

    public AbstractDialog(Frame frame, boolean bl) {
        this(frame, null, bl);
    }

    public AbstractDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public AbstractDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, 0, 0);
    }

    public AbstractDialog(Frame frame, String string, int n) {
        this(frame, string, false, n);
    }

    public AbstractDialog(Frame frame, String string, boolean bl, int n) {
        this(frame, string, bl, n, 0);
    }

    public AbstractDialog(Frame frame, String string, boolean bl, int n, int n2) {
        super(frame == null ? UtilConsoleGlobals.getActivatedFrame() : frame, string, bl);
        Debug.println("memgc", "Create   " + Debug.getShortClassName(this.getClass().getName()) + " " + this.getName());
        this._parentFrame = frame == null ? UtilConsoleGlobals.getActivatedFrame() : frame;
        this.addComponentListener(new ResizeComponentListener());
        this.addWindowListener(new DialogWindowListener());
        Container container = super.getContentPane();
        container.setLayout(new GridBagLayout());
        this._buttons = n;
        this._buttonOrientation = n2;
        this._actionPerformed = 0;
        this._customPanel = new JPanel(new BorderLayout());
        GridBagUtil.constrain(container, this._customPanel, 0, 0, 1, 1, 1.0, 1.0, 18, 1, 9, 9, this._buttonOrientation == 0 ? 12 : 9, this._buttonOrientation == 0 ? 9 : 12);
        if (this._buttons != 0) {
            if (this._buttonOrientation == 0) {
                this._buttonComponent = new HorizontalButtonPanel(new DialogActionListener());
                GridBagUtil.constrain(container, this._buttonComponent, 0, 1, 1, 1, 1.0, 0.0, 17, 2, 0, 9, 9, 9);
            } else {
                this._buttonComponent = new VerticalButtonPanel(new DialogActionListener());
                GridBagUtil.constrain(container, this._buttonComponent, 1, 0, 1, 1, 0.0, 0.0, 11, 0, 9, 0, 9, 9);
            }
        }
        container.setBackground(UIManager.getColor("Label.background"));
        container.setForeground(UIManager.getColor("Label.foreground"));
    }

    protected void finalize() throws Throwable {
        Debug.println("memgc", "FINALIZE " + Debug.getShortClassName(this.getClass().getName()) + " " + this.getName());
        super.finalize();
    }

    protected Component getButtonComponent() {
        return this._buttonComponent;
    }

    public void setMinimumSize(Dimension dimension) {
        this.setMinimumSize(dimension.width, dimension.height);
    }

    public void setMinimumSize(int n, int n2) {
        this.minWidth = n;
        this.minHeight = n2;
        super.setSize(n, n2);
    }

    public void show() {
        if (this._parentFrame != null) {
            this.setDialogLocation(this._parentFrame);
        } else {
            this.center();
        }
        super.show();
    }

    protected void setParentFrame(JFrame jFrame) {
        this._parentFrame = jFrame;
    }

    protected void setDialogLocation(Frame frame) {
        ModalDialogUtil.setDialogLocation(this, frame);
    }

    public void showModal() {
        this.setModal(true);
        this.show();
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    public void dispose() {
        if ((_isIrix || _isSolaris) && this.isModal()) {
            super.setVisible(false);
        } else if (this._parentFrame != null) {
            super.dispose();
        }
    }

    public void disposeAndRaise() {
        this.setVisible(false);
        if (this._parentFrame != null) {
            ModalDialogUtil.raise(this._parentFrame);
        }
    }

    public void pack() {
        boolean bl = this.isResizable();
        this.setResizable(true);
        super.pack();
        this.setResizable(bl);
    }

    public void setDefaultButton(int n) {
        if (n == 1) {
            this.setDefaultButton(this._okButton);
        } else if (n == 2) {
            this.setDefaultButton(this._cancelButton);
        } else if (n == 4) {
            this.setDefaultButton(this._closeButton);
        } else if (n == 8) {
            this.setDefaultButton(this._helpButton);
        }
    }

    public void setDefaultButton(JButton jButton) {
        this._defaultButton = jButton;
        if (this._focusComponent != null && this._focusComponent instanceof JButton) {
            this.setFocusComponent(jButton);
        }
        this.getRootPane().setDefaultButton(jButton);
    }

    public boolean isCancel() {
        return this._actionPerformed == 2;
    }

    protected void closeInvoked() {
        this._actionPerformed = 1;
        this.setVisible(false);
    }

    protected void okInvoked() {
        this._actionPerformed = 1;
        this.setVisible(false);
    }

    protected void cancelInvoked() {
        this._actionPerformed = 2;
        this.setVisible(false);
    }

    protected void helpInvoked() {
        System.out.println("Help not implemented");
    }

    public Container getContentPane() {
        return this._customPanel;
    }

    public void setPanel(JPanel jPanel) {
        this.setComponent(jPanel);
    }

    public void setComponent(Component component) {
        this._customPanel.add("Center", component);
        this.pack();
        super.getContentPane().validate();
    }

    public void setFocusComponent(JComponent jComponent) {
        this._focusComponent = jComponent;
    }

    public void setOKButtonText(String string) {
        this._okButton.setText(string);
        JButtonFactory.resizeGroup(this._okButton, this._closeButton, this._cancelButton, this._helpButton);
        super.getContentPane().validate();
    }

    public void setOKButtonEnabled(boolean bl) {
        this._okButton.setEnabled(bl);
    }

    public void setOKButtonVisible(boolean bl) {
        this._okButton.setVisible(bl);
    }

    public void setCancelButtonText(String string) {
        this._cancelButton.setText(string);
        JButtonFactory.resizeGroup(this._okButton, this._closeButton, this._cancelButton, this._helpButton);
        super.getContentPane().validate();
    }

    public void setCancelButtonEnabled(boolean bl) {
        this._cancelButton.setEnabled(bl);
    }

    public void setCancelButtonVisible(boolean bl) {
        this._cancelButton.setVisible(bl);
    }

    public void setCursor(Cursor cursor) {
        if (this._busyCursorOn && cursor.getType() != 3) {
            Debug.println(9, "AbstractDialog.setCursor(): Discarding change of cursor");
            return;
        }
        super.setCursor(cursor);
    }

    public void setBusyCursor(boolean bl) {
        this._busyCursorOn = bl;
        Cursor cursor = Cursor.getPredefinedCursor(bl ? 3 : 0);
        super.setCursor(cursor);
        this.setCursorOnChildren(this, cursor);
        if (this._cancelButton != null) {
            this._cancelButton.setCursor(Cursor.getDefaultCursor());
        }
    }

    void setCursorOnChildren(Container container, Cursor cursor) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                this.setCursorOnChildren((Container)componentArray[n], cursor);
            }
            componentArray[n].setCursor(cursor);
            ++n;
        }
    }

    public void setCloseButtonText(String string) {
        this._closeButton.setText(string);
        JButtonFactory.resizeGroup(this._okButton, this._closeButton, this._cancelButton, this._helpButton);
        super.getContentPane().validate();
    }

    public void setCloseButtonEnabled(boolean bl) {
        this._closeButton.setEnabled(bl);
    }

    public void setCloseButtonVisible(boolean bl) {
        this._closeButton.setVisible(bl);
    }

    public void setHelpButtonText(String string) {
        this._helpButton.setText(string);
        JButtonFactory.resizeGroup(this._okButton, this._closeButton, this._cancelButton, this._helpButton);
        super.getContentPane().validate();
    }

    public void setHelpButtonEnabled(boolean bl) {
        this._helpButton.setEnabled(bl);
    }

    public void setHelpButtonVisible(boolean bl) {
        this._helpButton.setVisible(bl);
    }

    class ButtonFocusListener
    implements FocusListener {
        ButtonFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            AbstractDialog.this.setDefaultButton(AbstractDialog.this._defaultButton);
        }
    }

    class VerticalButtonPanel
    extends JPanel {
        VerticalButtonPanel(ActionListener actionListener) {
            int n = 0;
            this.setLayout(new GridBagLayout());
            Vector<JButton> vector = new Vector<JButton>();
            if ((AbstractDialog.this._buttons & 1) == 1) {
                AbstractDialog.this._okButton = JButtonFactory.createOKButton(actionListener);
                AbstractDialog.this._okButton.addFocusListener(AbstractDialog.this._focusListener);
                GridBagUtil.constrain(this, AbstractDialog.this._okButton, 0, n++, 1, 1, 1.0, 0.0, 11, 0, 0, 0, 0, 0);
                vector.addElement(AbstractDialog.this._okButton);
                AbstractDialog.this.setDefaultButton(1);
            }
            if ((AbstractDialog.this._buttons & 2) == 2) {
                AbstractDialog.this._cancelButton = JButtonFactory.createCancelButton(actionListener);
                AbstractDialog.this._cancelButton.addFocusListener(AbstractDialog.this._focusListener);
                AbstractDialog.this._focusComponent = AbstractDialog.this._cancelButton;
                GridBagUtil.constrain(this, AbstractDialog.this._cancelButton, 0, n++, 1, 1, 1.0, 0.0, 11, 0, 6, 0, 0, 0);
                vector.addElement(AbstractDialog.this._cancelButton);
            }
            if ((AbstractDialog.this._buttons & 4) == 4) {
                AbstractDialog.this._closeButton = JButtonFactory.createCloseButton(actionListener);
                AbstractDialog.this._closeButton.addFocusListener(AbstractDialog.this._focusListener);
                AbstractDialog.this._focusComponent = AbstractDialog.this._closeButton;
                GridBagUtil.constrain(this, AbstractDialog.this._closeButton, 0, n++, 1, 1, 1.0, 0.0, 11, 0, 0, 0, 0, 0);
                AbstractDialog.this.setDefaultButton(4);
                vector.addElement(AbstractDialog.this._closeButton);
            }
            if ((AbstractDialog.this._buttons & 8) == 8) {
                AbstractDialog.this._helpButton = JButtonFactory.createHelpButton(actionListener);
                AbstractDialog.this._helpButton.addFocusListener(AbstractDialog.this._focusListener);
                GridBagUtil.constrain(this, AbstractDialog.this._helpButton, 0, n++, 1, 1, 1.0, 0.0, 11, 0, 12, 0, 0, 0);
                vector.addElement(AbstractDialog.this._helpButton);
            }
            Object[] objectArray = new JButton[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null) {
                JButtonFactory.resize((JButton[])objectArray);
            }
        }
    }

    class HorizontalButtonPanel
    extends Box {
        HorizontalButtonPanel(ActionListener actionListener) {
            super(0);
            Vector<JButton> vector = new Vector<JButton>();
            this.add(Box.createHorizontalGlue());
            if ((AbstractDialog.this._buttons & 1) == 1) {
                AbstractDialog.this._okButton = JButtonFactory.createOKButton(actionListener);
                AbstractDialog.this._okButton.addFocusListener(AbstractDialog.this._focusListener);
                this.add(AbstractDialog.this._okButton);
                vector.addElement(AbstractDialog.this._okButton);
                AbstractDialog.this.setDefaultButton(1);
            }
            if ((AbstractDialog.this._buttons & 2) == 2) {
                AbstractDialog.this._cancelButton = JButtonFactory.createCancelButton(actionListener);
                AbstractDialog.this._cancelButton.addFocusListener(AbstractDialog.this._focusListener);
                AbstractDialog.this._focusComponent = AbstractDialog.this._cancelButton;
                this.add(Box.createHorizontalStrut(6));
                this.add(AbstractDialog.this._cancelButton);
                vector.addElement(AbstractDialog.this._cancelButton);
            }
            if ((AbstractDialog.this._buttons & 4) == 4) {
                AbstractDialog.this._closeButton = JButtonFactory.createCloseButton(actionListener);
                AbstractDialog.this._closeButton.addFocusListener(AbstractDialog.this._focusListener);
                AbstractDialog.this._focusComponent = AbstractDialog.this._closeButton;
                this.add(AbstractDialog.this._closeButton);
                AbstractDialog.this.setDefaultButton(4);
                vector.addElement(AbstractDialog.this._closeButton);
            }
            if ((AbstractDialog.this._buttons & 8) == 8) {
                AbstractDialog.this._helpButton = JButtonFactory.createHelpButton(actionListener);
                AbstractDialog.this._helpButton.addFocusListener(AbstractDialog.this._focusListener);
                this.add(Box.createHorizontalStrut(12));
                this.add(AbstractDialog.this._helpButton);
                vector.addElement(AbstractDialog.this._helpButton);
            }
            Object[] objectArray = new JButton[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray != null) {
                JButtonFactory.resize((JButton[])objectArray);
            }
        }
    }

    class DialogActionListener
    implements ActionListener {
        DialogActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                if (string.equals("OK")) {
                    AbstractDialog.this.okInvoked();
                } else if (string.equals("CLOSE")) {
                    AbstractDialog.this.closeInvoked();
                } else if (string.equals("CANCEL")) {
                    AbstractDialog.this.cancelInvoked();
                } else if (string.equals("HELP")) {
                    AbstractDialog.this.helpInvoked();
                }
            }
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        DialogWindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (AbstractDialog.this._focusComponent != null) {
                AbstractDialog.this._focusComponent.requestFocus();
            }
            if (Debug.timeTraceEnabled()) {
                Debug.println("rsptime", Debug.getShortClassName(AbstractDialog.this.getClass().getName()) + " shown");
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            AbstractDialog.this.cancelInvoked();
        }
    }

    class ResizeComponentListener
    implements ComponentListener {
        ResizeComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (AbstractDialog.this.isResizable()) {
                boolean bl;
                boolean bl2 = AbstractDialog.this.getSize().width < AbstractDialog.this.minWidth;
                boolean bl3 = bl = AbstractDialog.this.getSize().height < AbstractDialog.this.minHeight;
                if (bl2 || bl) {
                    AbstractDialog.this.setSize(bl2 ? AbstractDialog.this.minWidth : AbstractDialog.this.getSize().width, bl ? AbstractDialog.this.minHeight : AbstractDialog.this.getSize().height);
                }
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }
    }
}

