/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class Renamer
implements Runnable {
    private JFrame _frame;
    private JDialog _progressDialog;
    private LDAPConnection _ldc;
    private String _newRDN;
    private String _dnToRename;
    private boolean _deleteOldRdn;
    private LDAPException _lde;
    private final ResourceSet _resource = new ResourceSet("com.netscape.management.client.ug.PickerEditorResource");

    public Renamer(LDAPConnection lDAPConnection, String string, String string2, boolean bl, JFrame jFrame) {
        this._ldc = lDAPConnection;
        this._dnToRename = string;
        this._newRDN = string2;
        this._deleteOldRdn = bl;
        this._frame = jFrame;
    }

    public void execute() {
        this.createRenameProgressDialog();
        Thread thread = new Thread(this);
        thread.start();
        this._progressDialog.pack();
        this._progressDialog.show();
    }

    public LDAPException getLDAPException() {
        return this._lde;
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._ldc.rename(this._dnToRename, this._newRDN, this._deleteOldRdn);
        }
        catch (LDAPException lDAPException) {
            this._lde = lDAPException;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Renamer.this._progressDialog.hide();
                Renamer.this._progressDialog.dispose();
            }
        });
    }

    private void createRenameProgressDialog() {
        String string = this._resource.getString("renamer", "rename-object-title");
        DN dN = new DN(this._dnToRename);
        DN dN2 = dN.getParent();
        dN2.addRDN(new RDN(this._newRDN));
        String[] stringArray = new String[]{dN.toString(), dN2.toString()};
        String string2 = this._resource.getString("renamer", "renaming-object-label", stringArray);
        MultilineLabel multilineLabel = new MultilineLabel(string2, 2, 50);
        this._progressDialog = new JDialog(this._frame);
        this._progressDialog.getContentPane().add((Component)multilineLabel, "Center");
        this._progressDialog.setModal(true);
        if (this._frame != null) {
            ModalDialogUtil.setDialogLocation(this._progressDialog, this._frame);
        }
    }
}

