/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ug;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;

class LdapCriteria {
    public JLabel _label;
    public JComboBox _attribute;
    public JComboBox _condition;
    public JTextField _value;
    static String[] _userGroupAttributes = null;

    public LdapCriteria(ConsoleInfo consoleInfo, ResourceSet resourceSet, int n) {
        if (_userGroupAttributes == null) {
            this.getUserGroupAttributes(consoleInfo);
        }
        this._attribute = new JComboBox();
        if (_userGroupAttributes != null) {
            int n2 = 0;
            while (n2 < _userGroupAttributes.length) {
                this._attribute.addItem(_userGroupAttributes[n2]);
                ++n2;
            }
        }
        this._attribute.setMaximumRowCount(5);
        this._attribute.setSelectedItem("cn");
        this._condition = new JComboBox();
        this.populateComboBox(this._condition, resourceSet, "dynamicQueryConstructor", "conditionCount", "condition");
        this._condition.setMaximumRowCount(5);
        this._value = new JTextField();
        this._label = n == 0 ? new JLabel(resourceSet.getString("dynamicQueryConstructor", "whereLabel"), 4) : new JLabel(resourceSet.getString("dynamicQueryConstructor", "andLabel"), 4);
    }

    private void populateComboBox(JComboBox jComboBox, ResourceSet resourceSet, String string, String string2, String string3) {
        int n = Integer.parseInt(resourceSet.getString(string, string2));
        int n2 = 0;
        while (n2 < n) {
            jComboBox.addItem(resourceSet.getString(string, string3 + n2));
            ++n2;
        }
    }

    private void getUserGroupAttributes(ConsoleInfo consoleInfo) {
        LDAPSchema lDAPSchema = null;
        LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
        if (lDAPConnection != null && lDAPConnection.isConnected()) {
            try {
                lDAPSchema = new LDAPSchema();
                lDAPSchema.fetchSchema(lDAPConnection);
            }
            catch (LDAPException lDAPException) {
                lDAPSchema = null;
            }
        }
        if (lDAPSchema == null) {
            return;
        }
        Vector vector = new Vector();
        Vector vector2 = (Vector)ResourceEditor.getNewObjectClasses().get("newUserObjectClasses");
        Vector vector3 = (Vector)ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses");
        if (vector2 == null || vector3 == null) {
            Debug.println("LdapQueryBuilderDialog: cannot get attributes since one or more objectclasses are null");
            return;
        }
        this.getAllAttributesFor(vector, vector2, lDAPSchema);
        this.getAllAttributesFor(vector, vector3, lDAPSchema);
        if (vector.size() > 0) {
            _userGroupAttributes = new String[vector.size()];
            vector.copyInto(_userGroupAttributes);
            this.sort(_userGroupAttributes, 0, _userGroupAttributes.length - 1);
        }
    }

    private void getAllAttributesFor(Vector vector, Vector vector2, LDAPSchema lDAPSchema) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LDAPObjectClassSchema lDAPObjectClassSchema = lDAPSchema.getObjectClass(string);
            Enumeration enumeration2 = lDAPObjectClassSchema.getRequiredAttributes();
            Enumeration enumeration3 = lDAPObjectClassSchema.getOptionalAttributes();
            Object e = null;
            while (enumeration2.hasMoreElements()) {
                e = enumeration2.nextElement();
                if (((String)e).equals("objectclass") || vector.indexOf(e) != -1) continue;
                vector.addElement(e);
            }
            while (enumeration3.hasMoreElements()) {
                e = enumeration3.nextElement();
                if (((String)e).indexOf("binary") != -1 || ((String)e).equals("aci") || ((String)e).equals("jpegphoto") || ((String)e).equals("userpassword") || ((String)e).equals("audio") || ((String)e).equals("seealso") || vector.indexOf(e) != -1) continue;
                vector.addElement(e);
            }
        }
    }

    private void sort(String[] stringArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        String string = stringArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (this.isGreater(stringArray[--n4], string)) {
                continue;
            }
            while (this.isGreater(string, stringArray[++n3])) {
            }
            if (n3 >= n4) break;
            String string2 = stringArray[n3];
            stringArray[n3] = stringArray[n4];
            stringArray[n4] = string2;
        }
        this.sort(stringArray, n, n4);
        this.sort(stringArray, n4 + 1, n2);
    }

    private boolean isGreater(String string, String string2) {
        return string.compareTo(string2) > 0;
    }
}

