/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.ug;

import com.netscape.management.client.Framework;
import com.netscape.management.client.MenuItemCategory;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.components.PopupMenuButton;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.ug.OUPickerDialog;
import com.netscape.management.client.topology.ug.UGPage;
import com.netscape.management.client.ug.ChangeDirectoryDialog;
import com.netscape.management.client.ug.IRPCallBack;
import com.netscape.management.client.ug.IResourceDeleteCallBack;
import com.netscape.management.client.ug.ISearchResultCallBack;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;

public class EditUserGroupPane
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
IRPCallBack {
    private static final String EDIT_ID = "Edit";
    private static final String DELETE_ID = "Delete";
    private static final String CREATE_ID = "Create";
    private static final String CHDIR_ID = "ChDir";
    private static final String SEARCH_ID = "Search";
    private static final String ADVSEARCH_ID = "AdvSearch";
    private static final String CREATEOBJ_PREFIX = "New_";
    private static final String CREATEUSER_ID = "New_User";
    private static final String CREATEGROUP_ID = "New_Group";
    private static final String CREATEOU_ID = "New_OU";
    private static final String CREATEADMIN_ID = "New_Admin";
    private static final String ADMIN_BASE_DN = "ou=Administrators, ou=TopologyManagement, o=netscapeRoot";
    private static final String ADMIN_GROUP_DN = "cn=Configuration Administrators, ou=Groups, ou=TopologyManagement, o=netscapeRoot";
    static final String ATTR_UNIQUE_MEMBER = "uniquemember";
    private ResourceSet _resource;
    private RemoteImage _userIcon;
    private RemoteImage _groupIcon;
    private RemoteImage _ouIcon;
    private ConsoleInfo _consoleInfo;
    private UGPage _parent;
    private String _uniqueAttribute;
    private ChangeDirectoryDialog _searchDirectoryDialog;
    private OUPickerDialog _ouPicker;
    private String _filter;
    private String _filterAttribute;
    private SearchResultPanel _resultPanel;
    private JTextField _queryField;
    private Document _queryFieldDoc;
    private JButton _searchButton;
    private JButton _advancedSearchButton;
    private JButton _editButton;
    private JButton _deleteButton;
    private JButton _createButton;
    private JButton _helpButton;
    private JPopupMenu _contextMenu;
    private JMenuItem _editMenuItem;
    private JMenuItem _deleteMenuItem;
    private JComponent[] _userMenu;
    private JMenuItem _userEditMenuItem;
    private JMenuItem _userDeleteMenuItem;
    private boolean _canEditUG = true;
    private ISearchResultCallBack _resultCB = new ISearchResultCallBack(){

        public void update() {
            EditUserGroupPane.this.setSearchField("");
            String string = EditUserGroupPane.this.getResultCountString();
            EditUserGroupPane.this.setStatusText(string);
            if (EditUserGroupPane.this.getResultCount() == 0) {
                EditUserGroupPane.this._resultPanel.addElement(string);
            }
        }
    };
    private FocusAdapter _focusAdaptor = new FocusAdapter(){

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getComponent() == EditUserGroupPane.this._queryField) {
                EditUserGroupPane.this._searchButton.getRootPane().setDefaultButton(EditUserGroupPane.this._searchButton);
            }
        }
    };

    public EditUserGroupPane(ConsoleInfo consoleInfo, UGPage uGPage, boolean bl) {
        this._consoleInfo = (ConsoleInfo)consoleInfo.clone();
        this._parent = uGPage;
        this._canEditUG = bl;
        this._uniqueAttribute = ResourceEditor.getUniqueAttribute();
        this._resource = new ResourceSet("com.netscape.management.client.topology.topology");
        this._userIcon = new RemoteImage("com/netscape/management/nmclf/icons/user24.gif");
        this._userIcon.setDescription(this._resource.getString("EditUserGroupPane", "userIcon-description"));
        this._groupIcon = new RemoteImage("com/netscape/management/nmclf/icons/group24.gif");
        this._groupIcon.setDescription(this._resource.getString("EditUserGroupPane", "groupIcon-description"));
        this._ouIcon = new RemoteImage("com/netscape/management/nmclf/icons/ou24.gif");
        this._ouIcon.setDescription(this._resource.getString("EditUserGroupPane", "ouIcon-description"));
        this._ouPicker = null;
        this._searchDirectoryDialog = new ChangeDirectoryDialog(null, this._consoleInfo);
        this._filter = this.getFilter();
        this._filterAttribute = this.getFilterAttribute();
        this._searchButton = JButtonFactory.create(this._resource.getString("UGPage", SEARCH_ID), this, SEARCH_ID);
        this._searchButton.setToolTipText(this._resource.getString("UGPage", "Search_tt"));
        this._advancedSearchButton = JButtonFactory.create(this._resource.getString("UGPage", "AdvancedSearch"), this, ADVSEARCH_ID);
        this._advancedSearchButton.setToolTipText(this._resource.getString("UGPage", "AdvancedSearch_tt"));
        JLabel jLabel = new JLabel(this.getSearchLabel());
        this._queryField = new JTextField();
        this._queryField.addActionListener(this);
        this._queryField.addFocusListener(this._focusAdaptor);
        jLabel.setLabelFor(this._queryField);
        JLabel jLabel2 = new JLabel(this._resource.getString("UGPage", "SearchResults"));
        this._resultPanel = new SearchResultPanel(this._consoleInfo, this);
        this._resultPanel.addListSelectionListener(this);
        this._resultPanel.addTableMouseListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 0, 1, 1.0, 0.0, 16, 2, 9, 9, 0, 0);
        GridBagUtil.constrain(jPanel, this._queryField, 0, 1, 1, 1, 1.0, 0.0, 17, 2, 0, 9, 0, 0);
        GridBagUtil.constrain(jPanel, this._searchButton, 1, 1, -1, 1, 0.0, 0.0, 13, 0, 0, 9, 0, 0);
        GridBagUtil.constrain(jPanel, this._advancedSearchButton, 2, 1, 0, 1, 0.0, 0.0, 13, 0, 0, 12, 0, 9);
        GridBagUtil.constrain(jPanel, jLabel2, 0, 2, 0, 1, 1.0, 0.0, 18, 2, 12, 9, 0, 9);
        GridBagUtil.constrain(jPanel, this._resultPanel, 0, 3, 0, 0, 1.0, 1.0, 18, 1, 0, 9, 0, 9);
        this._editButton = JButtonFactory.create(this._resource.getString("General", EDIT_ID), this, EDIT_ID);
        this._editButton.setToolTipText(this._resource.getString("UGPage", "edit_tt"));
        this._editButton.setEnabled(false);
        this._deleteButton = JButtonFactory.create(this._resource.getString("General", DELETE_ID), this, DELETE_ID);
        this._deleteButton.setToolTipText(this._resource.getString("UGPage", "delete_tt"));
        this._deleteButton.setEnabled(false);
        this._editMenuItem = new JMenuItem(this._editButton.getText());
        this._editMenuItem.setActionCommand(EDIT_ID);
        this._editMenuItem.addActionListener(this);
        this._editMenuItem.setEnabled(false);
        this._deleteMenuItem = new JMenuItem(this._deleteButton.getText());
        this._deleteMenuItem.setActionCommand(DELETE_ID);
        this._deleteMenuItem.addActionListener(this);
        this._deleteMenuItem.setEnabled(false);
        this._contextMenu = new JPopupMenu();
        this._contextMenu.add(this._editMenuItem);
        this._contextMenu.add(this._deleteMenuItem);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addCreateMenuItems(jPopupMenu);
        this._createButton = new PopupMenuButton(this._resource.getString("General", "CreateButton"), jPopupMenu);
        this._createButton.setToolTipText(this._resource.getString("UGPage", "create_tt"));
        this._helpButton = JButtonFactory.createHelpButton(this);
        JLabel jLabel3 = new JLabel("");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        if (this._canEditUG) {
            GridBagUtil.constrain(jPanel2, this._editButton, 0, 0, 1, 1, 0.0, 0.0, 17, 0, 6, 9, 0, 0);
            GridBagUtil.constrain(jPanel2, this._deleteButton, 1, 0, 1, 1, 0.0, 0.0, 17, 0, 6, 6, 0, 0);
            GridBagUtil.constrain(jPanel2, this._createButton, 2, 0, 1, 1, 0.0, 0.0, 17, 0, 6, 6, 0, 0);
        }
        GridBagUtil.constrain(jPanel2, jLabel3, 3, 0, 1, 1, 1.0, 0.0, 17, 2, 6, 12, 0, 0);
        GridBagUtil.constrain(jPanel2, this._helpButton, 4, 0, 0, 0, 0.0, 0.0, 13, 0, 12, 0, 9, 9);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", jPanel);
        this.add("South", jPanel2);
    }

    void initUserMenu() {
        int n = 0;
        MenuItemText menuItemText = null;
        if (this._canEditUG) {
            this._userMenu = new JComponent[5];
            this._userMenu[n++] = new MenuItemCategory(CREATE_ID, this._resource.getString("menu", "CreateButton"));
            JMenuItem jMenuItem = (JMenuItem)this._userMenu[0];
            this.addCreateMenuItems(jMenuItem);
            int n2 = n++;
            menuItemText = new MenuItemText(EDIT_ID, this._resource.getString("menu", EDIT_ID), "");
            this._userMenu[n2] = menuItemText;
            menuItemText.setActionCommand(EDIT_ID);
            menuItemText.addActionListener(this);
            menuItemText.setEnabled(false);
            this._userEditMenuItem = menuItemText;
            int n3 = n++;
            menuItemText = new MenuItemText(DELETE_ID, this._resource.getString("menu", DELETE_ID), "");
            this._userMenu[n3] = menuItemText;
            menuItemText.setActionCommand(DELETE_ID);
            menuItemText.addActionListener(this);
            menuItemText.setEnabled(false);
            this._userDeleteMenuItem = menuItemText;
            this._userMenu[n++] = new JSeparator();
        } else {
            this._userMenu = new JComponent[1];
        }
        int n4 = n++;
        menuItemText = new MenuItemText(CHDIR_ID, this._resource.getString("menu", "ChangeDirectory"), "");
        this._userMenu[n4] = menuItemText;
        menuItemText.setActionCommand(CHDIR_ID);
        menuItemText.addActionListener(this);
    }

    private void addCreateMenuItems(JComponent jComponent) {
        MenuItemText menuItemText = null;
        boolean bl = jComponent instanceof JPopupMenu;
        String string = null;
        int n = -1;
        string = bl ? this._resource.getString("menu-nomnemonics", "CreateUser") : this._resource.getString("menu", "CreateUser");
        menuItemText = new MenuItemText(CREATEUSER_ID, string, "");
        jComponent.add(menuItemText);
        menuItemText.setActionCommand(CREATEUSER_ID);
        menuItemText.addActionListener(this);
        string = bl ? this._resource.getString("menu-nomnemonics", "CreateGroup") : this._resource.getString("menu", "CreateGroup");
        menuItemText = new MenuItemText(CREATEGROUP_ID, string, "");
        jComponent.add(menuItemText);
        menuItemText.setActionCommand(CREATEGROUP_ID);
        menuItemText.addActionListener(this);
        string = bl ? this._resource.getString("menu-nomnemonics", "CreateOU") : this._resource.getString("menu", "CreateOU");
        menuItemText = new MenuItemText(CREATEOU_ID, string, "");
        jComponent.add(menuItemText);
        menuItemText.setActionCommand(CREATEOU_ID);
        menuItemText.addActionListener(this);
        jComponent.add(new JSeparator());
        string = bl ? this._resource.getString("menu-nomnemonics", "CreateAdmin") : this._resource.getString("menu", "CreateAdmin");
        menuItemText = new MenuItemText(CREATEADMIN_ID, string, "");
        jComponent.add(menuItemText);
        menuItemText.setActionCommand(CREATEADMIN_ID);
        menuItemText.addActionListener(this);
    }

    JComponent[] getUserMenuItems() {
        if (this._userMenu == null) {
            this.initUserMenu();
        }
        return this._userMenu;
    }

    public String getSearchDirectory() {
        LDAPConnection lDAPConnection = this._consoleInfo.getUserLDAPConnection();
        String string = lDAPConnection != null && lDAPConnection.getSocketFactory() != null ? "ldaps://" : "ldap://";
        return this._resource.getString("UGPage", "SearchUserAndGroupIn") + " " + string + this._consoleInfo.getUserHost() + ":" + this._consoleInfo.getUserPort() + "/" + this._consoleInfo.getUserBaseDN();
    }

    private boolean isConnected() {
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getUserLDAPConnection();
            if (lDAPConnection == null) {
                return false;
            }
            if (!lDAPConnection.isConnected()) {
                lDAPConnection.connect(3, this._consoleInfo.getUserHost(), this._consoleInfo.getUserPort(), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            } else if (!lDAPConnection.isAuthenticated()) {
                lDAPConnection.authenticate(this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            }
            return lDAPConnection.isConnected() && lDAPConnection.isAuthenticated();
        }
        catch (LDAPException lDAPException) {
            Debug.println("EditUserGroupPane.isConnectionAvailable: Could not connect to LDAP server: " + (Object)((Object)lDAPException));
            return false;
        }
    }

    private void displayCannotContinueMsg() {
        JOptionPane.showMessageDialog((Frame)this._parent.getFramework(), this._resource.getString("error", "OpCannotContinue") + this._resource.getString("error", "NoConnection"), this._resource.getString("error", "title"), 0);
        ModalDialogUtil.sleep();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.timeTraceEnabled()) {
            Debug.println("rsptime", "Button \"" + actionEvent.getActionCommand() + "\" pressed ...");
        }
        if (actionEvent.getSource().equals(this._searchButton)) {
            this.doSearch();
            this.valueChanged(null);
        } else if (actionEvent.getSource().equals(this._queryField)) {
            this.doSearch();
            this.valueChanged(null);
        } else if (actionEvent.getSource().equals(this._advancedSearchButton)) {
            this.setBusyCursor(true);
            ResourcePickerDlg resourcePickerDlg = new ResourcePickerDlg(this._consoleInfo, null, this._resultPanel);
            resourcePickerDlg.setSearchResultCallBack(this._resultCB);
            resourcePickerDlg.enableAdminSearch();
            this.setBusyCursor(false);
            resourcePickerDlg.show();
            resourcePickerDlg.dispose();
            this.valueChanged(null);
        } else if (actionEvent.getActionCommand().equals(EDIT_ID)) {
            if (!this.isConnected()) {
                if (JOptionPane.showConfirmDialog((Frame)this._parent.getFramework(), this._resource.getString("error", "OpCannotContinue") + this._resource.getString("error", "ReConnect"), this._resource.getString("error", "title"), 0) == 0) {
                    this._searchDirectoryDialog.show();
                    if (this._searchDirectoryDialog.isCancel()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.editEntry();
        } else if (actionEvent.getActionCommand().equals(CHDIR_ID)) {
            this._searchDirectoryDialog.show();
            if (this._searchDirectoryDialog.isCancel()) {
                return;
            }
        } else if (actionEvent.getActionCommand().startsWith(CREATEOBJ_PREFIX)) {
            if (!this.isConnected()) {
                if (JOptionPane.showConfirmDialog((Frame)this._parent.getFramework(), this._resource.getString("error", "OpCannotContinue") + this._resource.getString("error", "ReConnect"), this._resource.getString("error", "title"), 0) == 0) {
                    this._searchDirectoryDialog.show();
                    if (this._searchDirectoryDialog.isCancel()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this._createButton.setEnabled(false);
            this.setBusyCursor(true);
            this.createEntry(actionEvent.getActionCommand());
            this.setBusyCursor(false);
            this._createButton.setEnabled(true);
        } else if (actionEvent.getActionCommand().equals(DELETE_ID) || actionEvent.getSource().equals(this._deleteMenuItem)) {
            if (!this.isConnected()) {
                if (JOptionPane.showConfirmDialog((Frame)this._parent.getFramework(), this._resource.getString("error", "OpCannotContinue") + this._resource.getString("error", "ReConnect"), this._resource.getString("error", "title"), 0) == 0) {
                    this._searchDirectoryDialog.show();
                    if (this._searchDirectoryDialog.isCancel()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.setBusyCursor(true);
            this.deleteEntry();
            this.setBusyCursor(false);
        } else if (actionEvent.getSource().equals(this._helpButton)) {
            Help help = new Help(this._resource);
            help.contextHelp("topology", "ugpanel");
        }
    }

    private void createEntry(String string) {
        String string2 = null;
        String string3 = null;
        RemoteImage remoteImage = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        if (string.equals(CREATEADMIN_ID)) {
            string3 = "newUserObjectClasses";
            string2 = this._resource.getString("UGPage", "CreateAdmin");
            remoteImage = this._userIcon;
            string4 = ADMIN_BASE_DN;
            bl = true;
        }
        if (string.equals(CREATEUSER_ID)) {
            string3 = "newUserObjectClasses";
            string2 = this._resource.getString("UGPage", "CreateUser");
            remoteImage = this._userIcon;
        }
        if (string.equals(CREATEGROUP_ID)) {
            string3 = "newGroupObjectClasses";
            string2 = this._resource.getString("UGPage", "CreateGroup");
            remoteImage = this._groupIcon;
        }
        if (string.equals(CREATEOU_ID)) {
            string3 = "newOUObjectClasses";
            string2 = this._resource.getString("UGPage", "CreateOU");
            remoteImage = this._ouIcon;
            string5 = "ou";
        }
        if (string4 == null) {
            if (this._ouPicker == null) {
                this._ouPicker = new OUPickerDialog(this._consoleInfo);
            }
            this._ouPicker.show(this._consoleInfo);
            if (this._ouPicker.isCancel()) {
                ModalDialogUtil.disposeAndRaise(this._ouPicker, this.getJFrame());
                return;
            }
            string4 = (String)this._ouPicker.getSelectedValue();
            ModalDialogUtil.disposeAndRaise(this._ouPicker, this.getJFrame());
        }
        if (string4 != null && !string4.equals("")) {
            LDAPEntry lDAPEntry;
            ConsoleInfo consoleInfo = (ConsoleInfo)this._consoleInfo.clone();
            if (bl) {
                Debug.println(5, "Create Configuration Administrator");
                consoleInfo.setUserLDAPConnection(consoleInfo.getLDAPConnection());
            }
            Vector vector = new Vector();
            vector = (Vector)ResourceEditor.getNewObjectClasses().get(string3);
            ResourceEditor resourceEditor = new ResourceEditor(null, consoleInfo, vector, string4, this._resultPanel);
            if (string5 != null) {
                resourceEditor.setIndexAttribute(string5);
            }
            TitlePanel titlePanel = new TitlePanel();
            titlePanel.setText(string2);
            titlePanel.setIcon(remoteImage);
            resourceEditor.setTitlePanel(titlePanel);
            resourceEditor.setTitle(string2);
            resourceEditor.showModal();
            ModalDialogUtil.sleep();
            if (resourceEditor.getSaveStatus() && (lDAPEntry = resourceEditor.getLDAPEntry()) != null) {
                String string6 = LDAPUtil.flatting(lDAPEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
                if (string6 == null || string6.equals("")) {
                    string6 = LDAPUtil.flatting(lDAPEntry.getAttribute("ou", LDAPUtil.getLDAPAttributeLocale()));
                }
                if (bl) {
                    this.addToAdminGroup(lDAPEntry.getDN());
                } else {
                    this.setSearchField(string6);
                }
                this.setStatusText("");
            }
            ModalDialogUtil.disposeAndRaise(resourceEditor, this.getJFrame());
        }
    }

    private void addToAdminGroup(String string) {
        try {
            LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
            LDAPModification lDAPModification = new LDAPModification(0, new LDAPAttribute(ATTR_UNIQUE_MEMBER, string));
            lDAPConnection.modify(ADMIN_GROUP_DN, lDAPModification);
        }
        catch (Exception exception) {
            Debug.println(0, "Failed to add config admin to the admin group " + exception);
        }
    }

    private void editEntry() {
        if (!this._canEditUG) {
            return;
        }
        LDAPEntry lDAPEntry = this._resultPanel.getSelectedItem();
        if (lDAPEntry == null) {
            return;
        }
        this.setBusyCursor(true);
        ConsoleInfo consoleInfo = this._consoleInfo;
        if (this.isAdminUser(lDAPEntry.getDN())) {
            Debug.println(5, "Edit Configuration Administrator");
            consoleInfo = (ConsoleInfo)this._consoleInfo.clone();
            consoleInfo.setUserLDAPConnection(consoleInfo.getLDAPConnection());
        }
        ResourceEditor resourceEditor = new ResourceEditor(null, consoleInfo, lDAPEntry, this._resultPanel);
        this.setBusyCursor(false);
        resourceEditor.showModal();
        ModalDialogUtil.sleep();
        if (resourceEditor.getSaveStatus() && (lDAPEntry = resourceEditor.getLDAPEntry()) != null) {
            String string = LDAPUtil.flatting(lDAPEntry.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
            if (string == null || string.equals("")) {
                string = LDAPUtil.flatting(lDAPEntry.getAttribute("ou", LDAPUtil.getLDAPAttributeLocale()));
            }
            this.setSearchField(string);
            this.setStatusText("");
        }
        ModalDialogUtil.disposeAndRaise(resourceEditor, this.getJFrame());
    }

    private void showPopupMenu(Component component, int n, int n2) {
        Debug.println("TRACE EditUserGroupPane.showPopupMenu: _contextMenu = " + this._contextMenu);
        this._contextMenu.show(component, n, n2);
    }

    private boolean isUserEntry(LDAPEntry lDAPEntry) {
        String string = LDAPUtil.flatting(lDAPEntry.getAttribute("objectclass", LDAPUtil.getLDAPAttributeLocale())).toLowerCase();
        return string != null && string.indexOf("person") != -1;
    }

    private boolean isGroupEntry(LDAPEntry lDAPEntry) {
        String string = LDAPUtil.flatting(lDAPEntry.getAttribute("objectclass", LDAPUtil.getLDAPAttributeLocale())).toLowerCase();
        return string != null && string.indexOf("groupofuniquenames") != -1;
    }

    private boolean isOkayToDelete(LDAPEntry lDAPEntry) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        Enumeration enumeration = lDAPAttribute.getStringValues();
        Hashtable hashtable = ResourceEditor.getDeleteResourceEditorExtension();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string.toLowerCase());
            if (vector == null) continue;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = "";
                try {
                    Class clazz = (Class)enumeration2.nextElement();
                    string2 = clazz.getName();
                    Object t = clazz.newInstance();
                    if (t instanceof IResourceDeleteCallBack) {
                        boolean bl = ((IResourceDeleteCallBack)t).deleteResource(this._consoleInfo, lDAPEntry.getDN());
                        if (bl) continue;
                        return false;
                    }
                    Debug.println("TRACE EditUserGroupPane: " + string2 + " is not an instance of IResourceDeleteCallBack.");
                }
                catch (Exception exception) {
                    Debug.println("ERROR EditUserGroupPane: cannot create class: " + string2);
                }
            }
        }
        return true;
    }

    private void deleteEntry() {
        String string;
        String string2;
        Object object;
        Vector vector = this._resultPanel.getSelectedEntries();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            object = (LDAPEntry)vector.elementAt(0);
            string2 = LDAPUtil.flatting(object.getAttribute("cn", LDAPUtil.getLDAPAttributeLocale()));
            if (string2 == null || string2.equals("")) {
                string2 = LDAPUtil.flatting(object.getAttribute("ou", LDAPUtil.getLDAPAttributeLocale()));
            }
            string = this._resource.getString("UGPage", "ConfirmDelete") + " '" + string2 + "'?";
        } else {
            string = this._resource.getString("UGPage", "ConfirmDelete") + " " + this._resource.getString("UGPage", "ConfirmDeleteMultiple1") + " " + n + " " + this._resource.getString("UGPage", "ConfirmDeleteMultiple2") + "?";
        }
        if (JOptionPane.showConfirmDialog((Frame)this._parent.getFramework(), string, this._resource.getString("UGPage", "ConfirmDeleteTitle"), 0) == 0) {
            ModalDialogUtil.sleep();
            ModalDialogUtil.raise(this.getJFrame());
            try {
                if (!this.isConnected()) {
                    this.displayCannotContinueMsg();
                    return;
                }
                object = vector.elements();
                Vector<String> vector2 = new Vector<String>();
                while (object.hasMoreElements()) {
                    string2 = (LDAPEntry)object.nextElement();
                    if (!this.isOkayToDelete((LDAPEntry)string2)) continue;
                    LDAPConnection lDAPConnection = this._consoleInfo.getUserLDAPConnection();
                    if (this.isAdminUser(string2.getDN())) {
                        Debug.println(5, "Delete configuration administrator");
                        lDAPConnection = this._consoleInfo.getLDAPConnection();
                    }
                    lDAPConnection.delete(string2.getDN());
                    vector2.addElement(string2);
                }
                this._resultPanel.deleteRows(vector2);
                this.setStatusText("");
            }
            catch (LDAPException lDAPException) {
                JOptionPane.showMessageDialog((Frame)this._parent.getFramework(), this._resource.getString("UGPage", "DeleteFailed") + (Object)((Object)lDAPException), this._resource.getString("UGPage", "DeleteErrorTitle"), 0);
                ModalDialogUtil.sleep();
                ModalDialogUtil.raise(this.getJFrame());
            }
        } else {
            ModalDialogUtil.sleep();
            ModalDialogUtil.raise(this.getJFrame());
        }
    }

    public String getSearchLabel() {
        return this._resource.getString("UGPage", "SearchUserAndGroup");
    }

    public String getFilter() {
        return "(|(objectclass=person)(objectclass=groupofuniquenames)(objectclass=organizationalunit))";
    }

    public String getFilterAttribute() {
        return this._uniqueAttribute;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._canEditUG) {
            Vector vector = this._resultPanel.getSelectedEntries();
            int n = vector.size();
            boolean bl = n == 1;
            this._editButton.setEnabled(bl);
            this._editMenuItem.setEnabled(bl);
            this._userEditMenuItem.setEnabled(bl);
            boolean bl2 = false;
            if (bl) {
                LDAPEntry lDAPEntry = (LDAPEntry)vector.elementAt(0);
                bl2 = this.isUserEntry(lDAPEntry);
            }
            boolean bl3 = n > 0;
            this._deleteButton.setEnabled(bl3);
            this._deleteMenuItem.setEnabled(bl3);
            this._userDeleteMenuItem.setEnabled(bl3);
        }
    }

    public void setStatusText(String string) {
        if (this._parent != null) {
            this._parent.setStatusText(string);
        }
    }

    public void setBusyCursor(boolean bl) {
        if (this._parent != null) {
            ((Framework)this._parent.getFramework()).setBusyCursor(bl);
        }
    }

    public Cursor getCursor() {
        if (this._parent != null) {
            return this._parent.getFramework().getCursor();
        }
        return null;
    }

    public JFrame getJFrame() {
        if (this._parent != null) {
            return this._parent.getFramework().getJFrame();
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && this._resultPanel.rowAtPoint(mouseEvent.getPoint()) != -1) {
            this.editEntry();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this._resultPanel.rowAtPoint(mouseEvent.getPoint()) != -1 && this._resultPanel.getSelectedItem() != null) {
            this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this._resultPanel.rowAtPoint(mouseEvent.getPoint()) != -1 && this._resultPanel.getSelectedItem() != null) {
            this.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void doSearch() {
        String string;
        String string2;
        if (!this.isConnected()) {
            if (JOptionPane.showConfirmDialog((Frame)this._parent.getFramework(), this._resource.getString("error", "OpCannotContinue") + this._resource.getString("error", "ReConnect"), this._resource.getString("error", "title"), 0) == 0) {
                this._searchDirectoryDialog.show();
                if (this._searchDirectoryDialog.isCancel()) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((string2 = this._queryField.getText()) == null || string2.equals("") || string2.equals("*")) {
            string = "(|(objectclass=person)(objectclass=groupofuniquenames)(objectclass=organizationalunit))";
        } else {
            if (string2.indexOf(42) == -1) {
                string2 = "*" + string2 + "*";
            }
            if (this._filterAttribute.equals("cn")) {
                string = "(|(&(objectclass=person)(cn=" + string2 + "))(&(objectclass=groupofuniquenames)(cn=" + string2 + "))(&(objectclass=organizationalunit)(ou=" + string2 + ")))";
            } else if (this._filterAttribute.equals("uid")) {
                String string3 = this._queryField.getText();
                string = "(|(&(objectclass=person)(cn=" + string2 + "))(&(objectclass=groupofuniquenames)(cn=" + string2 + "))(&(objectclass=organizationalunit)(ou=" + string2 + "))(&(objectclass=person)(uid=" + string3 + ")))";
            } else {
                string = "(|(&(objectclass=person)(cn=" + string2 + "))(&(objectclass=groupofuniquenames)(cn=" + string2 + "))(&(objectclass=organizationalunit)(ou=" + string2 + "))(&(objectclass=person)(" + this._filterAttribute + "=" + string2 + ")))";
            }
        }
        Debug.println("Search: " + string);
        this._resultPanel.removeAllElements();
        this._resultPanel.doSearch(this._consoleInfo.getUserLDAPConnection(), this._consoleInfo.getUserBaseDN(), string);
        int n = this._resultPanel.getListCount();
        this.setStatusText(this._resource.getString("UGPage", "TotalFind") + n);
        if (n == 0) {
            this._resultPanel.addElement(this._resource.getString("UGPage", "TotalFind") + n);
        }
    }

    private boolean isAdminUser(String string) {
        String[] stringArray = new DN(ADMIN_BASE_DN).explodeDN(false);
        String[] stringArray2 = new DN(string).explodeDN(false);
        if (stringArray2.length != stringArray.length + 1) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equalsIgnoreCase(stringArray2[n + 1])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getResultCount() {
        return this._resultPanel.getListCount();
    }

    public String getResultCountString() {
        return this._resource.getString("UGPage", "TotalFind") + this.getResultCount();
    }

    public void setFocus() {
        this._queryField.requestFocus();
    }

    public void setSearchField(String string) {
        if (string != null) {
            this._queryField.setText(string);
        }
    }

    public void getResults(Vector vector) {
        this._resultPanel.removeAllElements();
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
            this._resultPanel.addElement(lDAPEntry);
            ++n;
        }
        this.setStatusText(this._resource.getString("UGPage", "TotalFind") + n);
    }
}

