/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.ICustomView;
import com.netscape.management.client.topology.IServerObject;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.topology.customview.ViewObject;
import com.netscape.management.client.util.ClassLoaderUtil;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;

public class CustomView
implements ICustomView {
    String _cn;
    String _displayNameRaw = null;
    String _displayIconRaw = null;
    String _descriptionRaw = null;
    String _configuration = null;
    String _className = null;
    String _resourceRef = null;
    boolean _fSystemView = false;
    boolean _fShowTopContainer = false;
    boolean _fHideContainerIfEmpty = false;
    String _customViewDN;
    LDAPConnection _ldc;
    LDAPEntry _ldapEntry;
    CustomView _parentView;
    Vector _childViews;
    ResourceModel _model;
    ConsoleInfo _info;
    ImageIcon _icon;
    String _name;
    String _description;
    private static RemoteImage _defaultIcon = new RemoteImage(TopologyInitializer._resource.getString("image", "folder"));

    public CustomView() {
        _defaultIcon.setDescription(TopologyInitializer._resource.getString("image", "folder-description"));
    }

    public CustomView(LDAPEntry lDAPEntry) {
        if (lDAPEntry == null) {
            Debug.println(0, "CustomView(LDAPEntry ldapEntry) ldapEntry is null");
            return;
        }
        this._ldapEntry = lDAPEntry;
        this._customViewDN = this._ldapEntry.getDN();
        this._info = Console.getConsoleInfo();
        this._displayNameRaw = CustomView.getFirstAttributeValue(this._ldapEntry, "nsDisplayName");
        this._cn = CustomView.getFirstAttributeValue(this._ldapEntry, "cn");
        this._displayIconRaw = CustomView.getFirstAttributeValue(this._ldapEntry, "nsDisplayIcon");
        this._configuration = CustomView.getFirstAttributeValue(this._ldapEntry, "nsViewConfiguration");
        this._className = CustomView.getFirstAttributeValue(this._ldapEntry, "nsClassName");
        this._resourceRef = CustomView.getFirstAttributeValue(this._ldapEntry, "seeAlso");
        this._descriptionRaw = CustomView.getFirstAttributeValue(this._ldapEntry, "description");
        this.getViewFlags(this._ldapEntry, "nsViewFlags");
        _defaultIcon.setDescription(TopologyInitializer._resource.getString("image", "folder-description"));
    }

    public void initialize(LDAPConnection lDAPConnection, String string) {
        this._ldc = lDAPConnection;
        this._customViewDN = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CustomView:{");
        stringBuffer.append(" <displayName>=").append(this._displayNameRaw);
        stringBuffer.append(" <displayIcon>=").append(this._displayIconRaw);
        stringBuffer.append(" <configuration>=").append(this._configuration);
        stringBuffer.append(" <className>=").append(this._className);
        stringBuffer.append(" <resourceRef>=").append(this._resourceRef);
        stringBuffer.append(" <description>=").append(this._descriptionRaw);
        stringBuffer.append(" <flags>=");
        if (this._fSystemView) {
            stringBuffer.append("systemView ");
        }
        if (this._fShowTopContainer) {
            stringBuffer.append("showTopContainer ");
        }
        if (this._fHideContainerIfEmpty) {
            stringBuffer.append("hideContainerIfEmpty ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getFirstAttributeValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null) {
            try {
                return (String)enumeration.nextElement();
            }
            catch (Exception exception) {
                Debug.println(0, "CustomView: no configuration data");
            }
        }
        return null;
    }

    void getViewFlags(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute == null) {
            return;
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string2 = ((String)enumeration.nextElement()).trim();
            if (string2.equalsIgnoreCase("showTopContainer")) {
                this._fShowTopContainer = true;
                continue;
            }
            if (string2.equalsIgnoreCase("hideContainerIfEmpty")) {
                this._fHideContainerIfEmpty = true;
                continue;
            }
            if (string2.equalsIgnoreCase("systemView")) {
                this._fSystemView = true;
                continue;
            }
            Debug.println(1, "CustomView.getViewFlags() unknown flag <" + string2 + ">");
        }
    }

    public String getDisplayName() {
        if (this._name != null) {
            return this._name;
        }
        if (this._displayNameRaw != null) {
            this._name = this.getStringAsProperty(this._displayNameRaw);
            return this._name;
        }
        return this._name;
    }

    public String getID() {
        return this._cn;
    }

    public String getDescription() {
        if (this._description != null) {
            return this._description;
        }
        this._description = this.getStringAsProperty(this._descriptionRaw);
        return this._description;
    }

    public boolean isSystemView() {
        return this._fSystemView;
    }

    String getStringAsProperty(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("@");
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = ClassLoaderUtil.getResourceAsStream((ConsoleInfo)this._info, (String)string3, null);
                if (inputStream != null) {
                    properties.load(inputStream);
                    String string4 = properties.getProperty(string2);
                    if (string4 != null) {
                        return string4;
                    }
                }
            }
            catch (Exception exception) {
                Debug.println(0, "Can not load " + string3);
            }
        }
        return string;
    }

    public ImageIcon getDisplayIcon() {
        if (this._icon != null) {
            return this._icon;
        }
        if (this._displayIconRaw != null) {
            byte[] byArray = ClassLoaderUtil.getResource((ConsoleInfo)this._info, (String)this._displayIconRaw);
            this._icon = byArray != null ? new ImageIcon(Toolkit.getDefaultToolkit().createImage(byArray)) : _defaultIcon;
        } else if (this._resourceRef == null) {
            this._icon = _defaultIcon;
        }
        return this._icon;
    }

    public ResourceObject getResourceRef() {
        return this.getTopologyResource(this._resourceRef);
    }

    public CustomView getParentView() {
        return this._parentView;
    }

    public void setParentView(CustomView customView) {
        this._parentView = customView;
    }

    private void loadChildViews() {
        this._childViews = new Vector();
        if (this._ldapEntry == null) {
            return;
        }
        LDAPEntry lDAPEntry = null;
        CustomView customView = null;
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = this._ldc.search(this._ldapEntry.getDN(), 1, "(objectclass=nsTopologyCustomView)", null, false);
            if (lDAPSearchResults != null) {
                while (lDAPSearchResults.hasMoreElements()) {
                    lDAPEntry = lDAPSearchResults.next();
                    customView = new CustomView(lDAPEntry);
                    customView.setParentView(this);
                    customView.initialize(this._ldc, lDAPEntry.getDN());
                    this._childViews.addElement(customView);
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "Cannot load custom views, error code= " + lDAPException.getLDAPResultCode() + " <dn=" + this._ldapEntry.getDN() + ">");
        }
    }

    static CustomView getChildView(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            CustomView customView = (CustomView)vector.elementAt(n);
            String string2 = customView._ldapEntry.getDN();
            if (string2.equalsIgnoreCase(string)) {
                return customView;
            }
            ++n;
        }
        return null;
    }

    public ResourceObject parseConfiguration(String string, ResourceObject resourceObject) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Hashtable hashtable = TopologyInitializer.getNetworkTopologyPlugin();
                ResourceObject resourceObject2 = null;
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements() && resourceObject2 == null) {
                    ITopologyPlugin iTopologyPlugin = (ITopologyPlugin)enumeration.nextElement();
                    resourceObject2 = iTopologyPlugin.getResourceObjectByID(string2);
                }
                if (resourceObject2 == null) continue;
                resourceObject.add(resourceObject2);
            }
        }
        return resourceObject;
    }

    void createTreeModel(ResourceObject resourceObject) {
        Vector vector = (Vector)this._childViews.clone();
        if (this._configuration != null && this._configuration.length() > 0) {
            String string = "|";
            if (!Character.isLetterOrDigit(this._configuration.charAt(0))) {
                string = String.valueOf(this._configuration.charAt(0));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this._configuration, string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.length() == 0) continue;
                if (string3.startsWith("ldap://")) {
                    try {
                        string2 = new LDAPUrl(string3);
                        this.addDynamicNodes(resourceObject, (LDAPUrl)string2);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                string2 = string3;
                CustomView customView = CustomView.getChildView(vector, string2);
                if (customView != null) {
                    vector.removeElement(customView);
                    this.addChildViewNodes(resourceObject, customView);
                    continue;
                }
                ResourceObject resourceObject2 = this.getTopologyResource(string2);
                if (resourceObject2 == null) continue;
                resourceObject.add((MutableTreeNode)resourceObject2);
            }
        }
        int n = 0;
        while (n < vector.size()) {
            this.addChildViewNodes(resourceObject, (CustomView)vector.elementAt(n));
            ++n;
        }
    }

    void addChildViewNodes(ResourceObject resourceObject, CustomView customView) {
        TreeModel treeModel = customView.getTreeModel();
        if (!(treeModel == null || customView._fHideContainerIfEmpty && treeModel.getChildCount(treeModel.getRoot()) <= 0)) {
            resourceObject.add((MutableTreeNode)treeModel.getRoot());
        }
    }

    void addDynamicNodes(ResourceObject resourceObject, LDAPUrl lDAPUrl) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = this._ldc.search(lDAPUrl.getDN().trim(), lDAPUrl.getScope(), lDAPUrl.getFilter().trim(), new String[]{"1.1"}, false);
            while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                ResourceObject resourceObject2 = this.getTopologyResource(lDAPEntry.getDN());
                if (resourceObject2 != null) {
                    resourceObject.add((MutableTreeNode)resourceObject2);
                    continue;
                }
                Debug.println(0, "CustomView.addDynamicNodes(), Topology resouce not found " + lDAPEntry.getDN());
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println(0, "CustomView.addDynamicNodes() Cannot create dynamic view for , <url=" + lDAPUrl + "> " + (Object)((Object)lDAPException));
        }
    }

    ResourceObject createRootNode() {
        if (this._className != null && this._className.endsWith("customview.CustomView")) {
            this._className = null;
        }
        if (this._className != null) {
            Class clazz = ClassLoaderUtil.getClass((ConsoleInfo)this._info, (String)this._className);
            if (clazz != null) {
                try {
                    ResourceObject resourceObject = (ResourceObject)clazz.newInstance();
                    if (resourceObject instanceof IServerObject) {
                        ((IServerObject)resourceObject).initialize(this._info);
                    }
                    return resourceObject;
                }
                catch (Exception exception) {
                    Debug.println(0, "Failed to instantiate ResourceObject from " + this._className + " " + exception);
                }
            }
            return null;
        }
        return new ViewObject(this);
    }

    ResourceObject getTopologyResource(String string) {
        if (string == null) {
            return null;
        }
        Hashtable hashtable = TopologyInitializer.getNetworkTopologyPlugin();
        ResourceObject resourceObject = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements() && resourceObject == null) {
            ITopologyPlugin iTopologyPlugin = (ITopologyPlugin)enumeration.nextElement();
            resourceObject = iTopologyPlugin.getResourceObjectByID(string);
        }
        return resourceObject;
    }

    public TreeModel getTreeModel() {
        if (this._model != null) {
            return this._model;
        }
        if (this._childViews == null) {
            this.loadChildViews();
        }
        ResourceObject resourceObject = this.createRootNode();
        this.createTreeModel(resourceObject);
        this._model = new ResourceModel((IResourceObject)resourceObject);
        this._model.setRootVisible(this._fShowTopContainer);
        return this._model;
    }

    public void setTreeModel(TreeModel treeModel) {
        Hashtable hashtable;
        ResourceObject resourceObject;
        this._model = (ResourceModel)treeModel;
        this._configuration = new String();
        ResourceObject resourceObject2 = (ResourceObject)treeModel.getRoot();
        int n = treeModel.getChildCount(resourceObject2);
        Debug.println(7, "CustomView.setTreeModel: count=" + n);
        int n2 = 0;
        while (n2 < n) {
            resourceObject = (ResourceObject)treeModel.getChild(resourceObject2, n2);
            hashtable = TopologyInitializer.getNetworkTopologyPlugin();
            String string = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements() && string == null) {
                ITopologyPlugin iTopologyPlugin = (ITopologyPlugin)enumeration.nextElement();
                string = iTopologyPlugin.getIDByResourceObject(resourceObject);
            }
            if (string != null) {
                this._configuration = this._configuration.concat(string + "|");
            }
            ++n2;
        }
        if (this._configuration != null) {
            try {
                resourceObject = new LDAPAttribute("nsViewConfiguration", this._configuration);
                hashtable = new LDAPModification(2, (LDAPAttribute)resourceObject);
                this._ldc.modify(this._customViewDN, (LDAPModification)hashtable);
                Debug.println("CustomView.setTreeModel: " + this._configuration + " modification complete");
            }
            catch (LDAPException lDAPException) {
                Debug.println(0, "Cannot save custom view.");
                Debug.println(0, "<dn=" + this._customViewDN + " Error code: " + lDAPException.getLDAPResultCode() + ">");
            }
        } else {
            Debug.println(0, "CustomView.setTreeModel:  null configuration");
        }
    }
}

