/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.preferences.LDAPPreferences;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.LDAPUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPPreferenceManager
extends PreferenceManager {
    private Hashtable _prefTable = new Hashtable();
    private LDAPConnection _ldc;
    private String _baseName;

    public LDAPPreferenceManager(LDAPConnection lDAPConnection, String string, String string2, String string3) {
        super(string2, string3);
        this._ldc = lDAPConnection;
        string = LDAPUtil.createEntry(lDAPConnection, string2, string);
        this._baseName = LDAPUtil.createEntry(lDAPConnection, string3, string);
    }

    public String getBaseName() {
        return this._baseName;
    }

    public String[] getPreferencesList() {
        Object[] objectArray;
        String string = "(objectclass=*)";
        String[] stringArray = new String[]{"nsPreference"};
        LDAPSearchResults lDAPSearchResults = null;
        Vector<String> vector = new Vector<String>();
        try {
            lDAPSearchResults = this._ldc.search(this._baseName, 1, string, stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                objectArray = lDAPSearchResults.next();
                String string2 = objectArray.getDN();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "=,");
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (string4 == null) continue;
                vector.addElement(string4);
            }
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            System.err.println("LDAPException: return code:" + n);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Preferences getPreferences(String string) {
        Preferences preferences = (Preferences)this._prefTable.get(string);
        if (preferences == null) {
            preferences = new LDAPPreferences(this._ldc, string, this._baseName);
            this._prefTable.put(string, preferences);
        }
        return preferences;
    }

    public boolean isPreferencesDirty() {
        Enumeration enumeration = this._prefTable.elements();
        while (enumeration.hasMoreElements()) {
            Preferences preferences = (Preferences)enumeration.nextElement();
            if (!preferences.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void savePreferences() {
        Enumeration enumeration = this._prefTable.elements();
        while (enumeration.hasMoreElements()) {
            Preferences preferences = (Preferences)enumeration.nextElement();
            preferences.save();
        }
    }
}

