/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.DirNodeEvent;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.components.IDirNode;
import com.netscape.management.client.components.IDirNodeListener;
import com.netscape.management.client.components.TreePanelCellRenderer;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class DirTree
extends JTree
implements TreeSelectionListener,
MouseListener,
KeyListener {
    protected IDirModel _model;
    protected TreeCellRenderer _treeRenderer;
    protected EventListenerList _listenerList = new EventListenerList();
    protected JPopupMenu _contextMenu = new JPopupMenu();
    static /* synthetic */ Class class$com$netscape$management$client$components$IDirNodeListener;

    public DirTree(IDirModel iDirModel) {
        super(iDirModel);
        this._treeRenderer = new TreePanelCellRenderer();
        this._model = iDirModel;
        this.initialize();
    }

    public DirTree() {
        this((IDirModel)null);
    }

    protected void initialize() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.getSelectionModel().setSelectionMode(1);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JTree jTree = (JTree)focusEvent.getSource();
                jTree.validate();
                jTree.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                JTree jTree = (JTree)focusEvent.getSource();
                jTree.validate();
                jTree.repaint();
            }
        });
        this.setCellRenderer(this._treeRenderer);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setModel(IDirModel iDirModel) {
        super.setModel(iDirModel);
        this._model = iDirModel;
    }

    public void addDirNodeListener(IDirNodeListener iDirNodeListener) {
        this._listenerList.add(class$com$netscape$management$client$components$IDirNodeListener == null ? (class$com$netscape$management$client$components$IDirNodeListener = DirTree.class$("com.netscape.management.client.components.IDirNodeListener")) : class$com$netscape$management$client$components$IDirNodeListener, iDirNodeListener);
    }

    public void removeDirNodeListener(IDirNodeListener iDirNodeListener) {
        this._listenerList.remove(class$com$netscape$management$client$components$IDirNodeListener == null ? (class$com$netscape$management$client$components$IDirNodeListener = DirTree.class$("com.netscape.management.client.components.IDirNodeListener")) : class$com$netscape$management$client$components$IDirNodeListener, iDirNodeListener);
    }

    protected void select(IDirNode[] iDirNodeArray) {
        this.fireSelectionChanged(iDirNodeArray);
    }

    protected void run(IDirNode[] iDirNodeArray, String string) {
        this.fireActionInvoked(iDirNodeArray, 0, string);
    }

    protected void fireSelectionChanged(IDirNode[] iDirNodeArray) {
        Object[] objectArray = this._listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$netscape$management$client$components$IDirNodeListener == null ? DirTree.class$("com.netscape.management.client.components.IDirNodeListener") : class$com$netscape$management$client$components$IDirNodeListener)) {
                IDirNodeListener iDirNodeListener = (IDirNodeListener)objectArray[n + 1];
                iDirNodeListener.selectionChanged(iDirNodeArray);
            }
            n -= 2;
        }
    }

    protected void fireActionInvoked(IDirNode[] iDirNodeArray, int n, String string) {
        Object[] objectArray = this._listenerList.getListenerList();
        DirNodeEvent dirNodeEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$netscape$management$client$components$IDirNodeListener == null ? DirTree.class$("com.netscape.management.client.components.IDirNodeListener") : class$com$netscape$management$client$components$IDirNodeListener)) {
                if (dirNodeEvent == null) {
                    dirNodeEvent = new DirNodeEvent(iDirNodeArray, n, string);
                }
                IDirNodeListener iDirNodeListener = (IDirNodeListener)objectArray[n2 + 1];
                iDirNodeListener.actionInvoked(dirNodeEvent);
            }
            n2 -= 2;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Debug.println(9, "Tree.valueChanged: " + treeSelectionEvent.getPath().getLastPathComponent());
        IDirNode[] iDirNodeArray = this.getSelection();
        if (iDirNodeArray != null) {
            Debug.println(9, "Tree.valueChanged: selection = " + iDirNodeArray[0]);
            this.select(iDirNodeArray);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        IDirNode[] iDirNodeArray = this.getSelection();
        if (iDirNodeArray != null && mouseEvent.getClickCount() == 2) {
            this.run(iDirNodeArray, "");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._contextMenu != null && mouseEvent.isPopupTrigger() && this._contextMenu.getComponentCount() > 0) {
            Component component = mouseEvent.getComponent();
            Point point = component.getLocation();
            this._contextMenu.show(component, mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._contextMenu != null && mouseEvent.isPopupTrigger() && this._contextMenu.getComponentCount() > 0) {
            Component component = mouseEvent.getComponent();
            Point point = component.getLocation();
            this._contextMenu.show(component, mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        IDirNode[] iDirNodeArray;
        if (keyEvent.getKeyCode() == 10 && (iDirNodeArray = this.getSelection()) != null) {
            this.run(iDirNodeArray, "");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public IDirNode[] getSelection() {
        IDirNode[] iDirNodeArray = null;
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            iDirNodeArray = new IDirNode[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                iDirNodeArray[n] = (IDirNode)treePathArray[n].getLastPathComponent();
                ++n;
            }
        }
        return iDirNodeArray;
    }

    public void setSelectedNode(IDirNode iDirNode) {
        if (iDirNode != null) {
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)iDirNode)).getPath());
            this.expandPath(treePath);
            this.makeVisible(treePath);
            this.scrollPathToVisible(treePath);
            this.repaint();
            this.setSelectionPath(treePath);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

