/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.KeyActionListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ComponentFactory {
    public static JPanel createLabelComponent(String string, JComponent jComponent) {
        char c;
        JScrollPane jScrollPane;
        Component component;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        JLabel jLabel = new JLabel(ComponentFactory.stripAmpersand(string));
        jLabel.setLabelFor(jComponent);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        if (jComponent instanceof JScrollPane && (component = (jScrollPane = (JScrollPane)jComponent).getViewport().getView()) instanceof JComponent) {
            jComponent = (JComponent)component;
        }
        if (Character.isLetter(c = ComponentFactory.getMnemonic(string))) {
            jLabel.setDisplayedMnemonic(c);
            ComponentFactory.makeKeyboardShortcut(jLabel, jComponent, c);
        }
        return jPanel;
    }

    public static void makeKeyboardShortcut(JComponent jComponent, JComponent jComponent2, char c) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
        jComponent.registerKeyboardAction(new KeyActionListener(jComponent2), keyStroke, 2);
    }

    public static String stripAmpersand(String string) {
        int n;
        if (string != null && (n = string.indexOf(38)) != -1) {
            try {
                char c = string.charAt(n + 1);
                String string2 = string.substring(0, n);
                String string3 = string2.concat(string.substring(n + 1));
                return string3;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println("Error parsing label: " + string);
            }
        }
        return string;
    }

    public static char getMnemonic(String string) {
        int n;
        if (string != null && (n = string.indexOf(38)) != -1) {
            try {
                char c = string.charAt(n + 1);
                return c;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println("Error parsing mnemonic: " + string);
            }
        }
        return '\u0000';
    }
}

