/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.ComponentFactory;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ButtonFactory {
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.components.components");
    private static final JPanel scratchPanel = new JPanel();
    private static final String IMAGE_PATH = "com/netscape/management/client/components/images/";
    private static final int BUTTON_SIZE_MULTIPLE = 10;
    public static ImageIcon UP_ICON = ButtonFactory.createUpIcon();
    public static ImageIcon DOWN_ICON = ButtonFactory.createDownIcon();
    public static ImageIcon LEFT_ICON = ButtonFactory.createLeftIcon();
    public static ImageIcon RIGHT_ICON = ButtonFactory.createRightIcon();
    public static final String OK = "OK";
    public static final String CANCEL = "CANCEL";
    public static final String CLOSE = "CLOSE";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String BROWSE = "BROWSE";
    public static final String ADD = "ADD";
    public static final String NEW = "NEW";
    public static final String EDIT = "EDIT";
    public static final String REMOVE = "REMOVE";
    public static final String HELP = "HELP";

    private static RemoteImage createUpIcon() {
        RemoteImage remoteImage = new RemoteImage("com/netscape/management/client/components/images/upArrow.gif");
        remoteImage.setDescription(resource.getString("buttons", "upicon-description"));
        return remoteImage;
    }

    private static RemoteImage createDownIcon() {
        RemoteImage remoteImage = new RemoteImage("com/netscape/management/client/components/images/downArrow.gif");
        remoteImage.setDescription(resource.getString("buttons", "downicon-description"));
        return remoteImage;
    }

    private static RemoteImage createLeftIcon() {
        RemoteImage remoteImage = new RemoteImage("com/netscape/management/client/components/images/leftArrow.gif");
        remoteImage.setDescription(resource.getString("buttons", "lefticon-description"));
        return remoteImage;
    }

    private static RemoteImage createRightIcon() {
        RemoteImage remoteImage = new RemoteImage("com/netscape/management/client/components/images/rightArrow.gif");
        remoteImage.setDescription(resource.getString("buttons", "righticon-description"));
        return remoteImage;
    }

    private static String i18n(String string) {
        return resource.getString("buttons", string);
    }

    public static void setButtonText(JButton jButton, String string) {
        jButton.setText(ComponentFactory.stripAmpersand(string));
        char c = ComponentFactory.getMnemonic(string);
        if (c != '\u0000') {
            jButton.setMnemonic(c);
        }
    }

    public static JButton createButton(String string) {
        JButton jButton = new JButton();
        ButtonFactory.setButtonText(jButton, string);
        ButtonFactory.resizeButton(jButton);
        return jButton;
    }

    public static JButton createButton(String string, ActionListener actionListener, String string2) {
        JButton jButton = ButtonFactory.createButton(string);
        jButton.addActionListener(actionListener);
        jButton.setActionCommand(string2);
        return jButton;
    }

    public static JButton createPredefinedButton(String string, ActionListener actionListener) {
        String string2 = ButtonFactory.i18n(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Invalid button type: " + string);
        }
        JButton jButton = ButtonFactory.createButton(string2, actionListener, string);
        if (string.equals(OK) || string.equals(YES)) {
            jButton.registerKeyboardAction(actionListener, string, KeyStroke.getKeyStroke(10, 0), 2);
        } else if (string.equals(CANCEL) || string.equals(NO)) {
            jButton.registerKeyboardAction(actionListener, string, KeyStroke.getKeyStroke(27, 0), 2);
        } else if (string.equals(HELP)) {
            jButton.registerKeyboardAction(actionListener, string, KeyStroke.getKeyStroke(112, 0), 2);
        }
        return jButton;
    }

    public static void resizeButton(JButton jButton) {
        JButton jButton2 = new JButton(jButton.getText(), jButton.getIcon());
        scratchPanel.removeAll();
        scratchPanel.add(jButton2);
        scratchPanel.doLayout();
        scratchPanel.remove(jButton2);
        int n = jButton2.getWidth();
        n += 10 - n % 10;
        Dimension dimension = new Dimension(n, jButton2.getHeight());
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
    }

    public static void resizeButtons(JButton[] jButtonArray) {
        if (jButtonArray.length == 0) {
            return;
        }
        int n = ButtonFactory.getWidth(jButtonArray[0]);
        int n2 = ButtonFactory.getHeight(jButtonArray[0]);
        int n3 = n;
        int n4 = n2;
        int n5 = 1;
        while (n5 < jButtonArray.length) {
            n = ButtonFactory.getWidth(jButtonArray[n5]);
            n2 = ButtonFactory.getHeight(jButtonArray[n5]);
            n3 = Math.max(n3, n);
            n4 = Math.max(n4, n2);
            ++n5;
        }
        Dimension dimension = new Dimension(n3, n4);
        int n6 = 0;
        while (n6 < jButtonArray.length) {
            if (jButtonArray[n6] != null) {
                jButtonArray[n6].setPreferredSize(dimension);
                jButtonArray[n6].setMinimumSize(dimension);
            }
            ++n6;
        }
    }

    public static void resizeButtons(JButton jButton, JButton jButton2) {
        JButton[] jButtonArray = new JButton[]{jButton, jButton2};
        ButtonFactory.resizeButtons(jButtonArray);
    }

    public static void resizeButtons(JButton jButton, JButton jButton2, JButton jButton3) {
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3};
        ButtonFactory.resizeButtons(jButtonArray);
    }

    public static void resizeButtons(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3, jButton4};
        ButtonFactory.resizeButtons(jButtonArray);
    }

    private static int getHeight(JButton jButton) {
        JButton jButton2 = new JButton(jButton.getText(), jButton.getIcon());
        scratchPanel.removeAll();
        scratchPanel.add(jButton2);
        scratchPanel.doLayout();
        scratchPanel.remove(jButton2);
        return jButton2.getHeight();
    }

    private static int getWidth(JButton jButton) {
        JButton jButton2 = new JButton(jButton.getText(), jButton.getIcon());
        scratchPanel.removeAll();
        scratchPanel.add(jButton2);
        scratchPanel.doLayout();
        scratchPanel.remove(jButton2);
        int n = jButton2.getWidth();
        n = n + 10 - n % 10;
        return n;
    }
}

