/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.ACL;
import com.netscape.management.client.acl.AttributeList;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.CallbackAction;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.acleditor.DataModelFactory;
import com.netscape.management.client.acleditor.SelectionListener;
import com.netscape.management.client.acleditor.WindowFactory;
import com.netscape.management.client.console.ConsoleInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;

public class TableDataModel
extends DataModelAdapter
implements SelectionListener {
    protected static final String RULE = "Rule";
    protected static final String USERGROUPS = "UserGroups";
    protected static final String HOSTS = "Hosts";
    protected static final String TIME = "Time";
    protected static final String ALLOWDENY = "AllowDeny";
    protected static final String RIGHTS = "Rights";
    protected static final String itemSeparator = " || ";
    protected static final String ldapPrefix = "ldap:///";
    protected static String[] defaultHeaders = new String[]{"Rule", "AllowDeny", "UserGroups", "Hosts", "Time", "Rights"};
    protected ConsoleInfo info;
    protected DataModelFactory dataFactory;
    protected WindowFactory windowFactory;
    protected String allow;
    protected String deny;
    protected Hashtable windows;
    protected ACL acl;

    public TableDataModel(DataModelFactory dataModelFactory, WindowFactory windowFactory, ConsoleInfo consoleInfo) {
        this(dataModelFactory, windowFactory, consoleInfo, defaultHeaders);
    }

    public TableDataModel(DataModelFactory dataModelFactory, WindowFactory windowFactory, ConsoleInfo consoleInfo, String[] stringArray) {
        super(dataModelFactory.getResourceSet(), "table", stringArray);
        this.info = consoleInfo;
        this.dataFactory = dataModelFactory;
        this.windowFactory = windowFactory;
        this.allow = this.resources.getString("acl", "allow");
        this.deny = this.resources.getString("acl", "deny");
        this.windows = new Hashtable();
        this.acl = this.dataFactory.getACL(this.info, this.windowFactory);
    }

    public TableCellEditor getColumnCellEditor(int n) {
        String string = (String)this.getColumnIdentifier(n);
        if (!string.equals(ALLOWDENY)) {
            try {
                return super.getColumnCellEditor(n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.allow);
        jComboBox.addItem(this.deny);
        jComboBox.setToolTipText(this.getColumnToolTip(n));
        return new DefaultCellEditor(jComboBox);
    }

    public boolean isCellEditable(int n, int n2) {
        String string = (String)this.getColumnIdentifier(n2);
        return string.equals(ALLOWDENY);
    }

    public int getRowCount() {
        return this.acl.getRuleCount();
    }

    public Object getValueAt(int n, int n2) {
        if (this.acl.syntaxOverrideSet()) {
            return this.checkValue("--");
        }
        Rule rule = this.acl.getRule(n);
        String string = (String)this.getColumnIdentifier(n2);
        if (string.equals(RULE)) {
            return n + 1 + "";
        }
        if (string.equals(RIGHTS)) {
            return this.checkValue(this.generateAttributeList(rule.getRightsList()));
        }
        if (string.equals(USERGROUPS)) {
            return this.checkValue(this.generateAttributeList(rule.getAttributeList("userdn"), rule.getAttributeList("groupdn"), ldapPrefix));
        }
        if (string.equals(HOSTS)) {
            return this.checkValue(this.generateAttributeList(rule.getAttributeList("dns"), rule.getAttributeList("ip")));
        }
        if (string.equals(TIME)) {
            return this.checkValue(this.generateAttributeList(rule.getAttributeList("timeofday"), rule.getAttributeList("dayofweek")));
        }
        if (string.equals(ALLOWDENY)) {
            return this.checkValue(rule.getAllow() ? this.allow : this.deny);
        }
        return this.checkValue("");
    }

    protected String checkValue(String string) {
        if (!string.equals("")) {
            return string;
        }
        return this.resources.getString("table", "emptyCellValue");
    }

    protected String generateAttributeList(AttributeList attributeList) {
        if (attributeList != null) {
            return attributeList.generateList(",");
        }
        return "";
    }

    protected String generateAttributeList(AttributeList attributeList, AttributeList attributeList2) {
        return this.generateAttributeList(attributeList, attributeList2, null);
    }

    protected String generateAttributeList(AttributeList attributeList, AttributeList attributeList2, String string) {
        if (attributeList == null) {
            if (attributeList2 == null) {
                return "";
            }
            return attributeList2.generateList(itemSeparator, string, null);
        }
        if (attributeList2 == null) {
            return attributeList.generateList(itemSeparator, string, null);
        }
        return attributeList.generateList(itemSeparator, string, null) + "," + attributeList2.generateList(itemSeparator, string, null);
    }

    protected void saveData() throws Exception {
        this.acl.updateACL(this.dataFactory.getACLRef(this.info));
    }

    protected void addRow(int n) {
        if (n == -1) {
            this.acl.appendRule();
        } else {
            this.acl.insertRule(n);
        }
    }

    protected void deleteRow(int n) {
        if (n == -1) {
            return;
        }
        this.acl.deleteRule(n);
    }

    protected void moveRow(int n, boolean bl) {
        if (n == -1) {
            return;
        }
        if (bl) {
            if (n != 0) {
                this.acl.swapRules(n, n - 1);
                return;
            }
        } else if (n != this.getRowCount() - 1) {
            this.acl.swapRules(n, n + 1);
            return;
        }
        System.err.println("TableDataModel:moveRow():invalid parameters:selection=" + n + ", up=" + bl);
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = (String)this.getColumnIdentifier(n2);
        if (!string.equals(ALLOWDENY)) {
            return;
        }
        this.acl.getRule(n).setAllow(((String)object).equals(this.allow));
    }

    public void show(ACLEditorWindow aCLEditorWindow, CallbackAction callbackAction) {
        this.windows.put(aCLEditorWindow.getWindowName(), aCLEditorWindow);
        aCLEditorWindow.setCompletionCallback(new CallbackAction(callbackAction){

            public void callback(Object object) {
                TableDataModel.this.removeWindow((String)object);
            }
        });
        aCLEditorWindow.show();
    }

    public void removeWindow(String string) {
        this.windows.remove(string);
    }

    public void dispose() {
        Enumeration enumeration = this.windows.elements();
        while (enumeration.hasMoreElements()) {
            ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)enumeration.nextElement();
            aCLEditorWindow.dispose();
        }
        this.windows.clear();
    }

    protected boolean isFocusEnabled() {
        return !this.acl.syntaxOverrideSet();
    }

    public void showSyntaxWindow(CallbackAction callbackAction) {
        ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)this.windows.get("syntax");
        if (aCLEditorWindow == null) {
            this.show(this.windowFactory.createSyntaxWindow(this.acl), callbackAction);
        } else {
            aCLEditorWindow.toFront();
        }
    }

    public void showAttributesWindow(CallbackAction callbackAction) {
        ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)this.windows.get("attributes");
        if (aCLEditorWindow == null) {
            this.show(this.windowFactory.createAttributesWindow(this.acl), callbackAction);
        } else {
            aCLEditorWindow.toFront();
        }
    }

    public void showTestACLWindow(CallbackAction callbackAction) {
        this.show(this.windowFactory.createTestACLWindow(this.info, this.dataFactory.getACLRef(this.info)), callbackAction);
    }

    public boolean isTestACLAvailable() {
        return false;
    }

    public void selectionNotify(int n, int n2, int n3, CallbackAction callbackAction) {
        if (n == -1) {
            return;
        }
        if (this.acl.syntaxOverrideSet()) {
            return;
        }
        if (n3 != 2) {
            return;
        }
        Rule rule = this.acl.getRule(n);
        String string = (String)this.getColumnIdentifier(n2);
        if (string.equals(USERGROUPS)) {
            ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)this.windows.get("userGroup");
            if (aCLEditorWindow == null) {
                DataModelAdapter dataModelAdapter = this.dataFactory.getUserGroupDataModel(rule);
                dataModelAdapter.setCallerData(this.acl);
                this.show(this.windowFactory.createUserGroupWindow(dataModelAdapter, this.info), callbackAction);
            } else {
                aCLEditorWindow.toFront();
            }
            return;
        }
        if (string.equals(HOSTS)) {
            ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)this.windows.get("hosts");
            if (aCLEditorWindow == null) {
                this.show(this.windowFactory.createHostsWindow(this.dataFactory.getHostsDataModel(rule), this.info), callbackAction);
            } else {
                aCLEditorWindow.toFront();
            }
            return;
        }
        if (string.equals(RIGHTS)) {
            ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)this.windows.get("rights");
            if (aCLEditorWindow == null) {
                this.show(this.windowFactory.createRightsWindow(this.dataFactory.getRightsDataModel(rule)), callbackAction);
            } else {
                aCLEditorWindow.toFront();
            }
            return;
        }
        if (string.equals(TIME)) {
            ACLEditorWindow aCLEditorWindow = (ACLEditorWindow)this.windows.get("time");
            if (aCLEditorWindow == null) {
                this.show(this.windowFactory.createTimeWindow(rule), callbackAction);
            } else {
                aCLEditorWindow.toFront();
            }
            return;
        }
    }
}

