/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.ACL;
import com.netscape.management.client.acl.LdapACL;
import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.WindowFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttributesWindow
extends ACLEditorWindow {
    protected LdapACL acl;
    protected String equal;
    protected String notEqual;
    protected JTextField aclName;
    protected JTextField target;
    protected JComboBox targetEq;
    protected JTextField filter;
    protected JComboBox filterEq;
    protected JTextField attributes;
    protected JComboBox attributesEq;

    public AttributesWindow(String string, WindowFactory windowFactory, ACL aCL) {
        super(windowFactory, string, windowFactory.getSessionIdentifier());
        this.acl = (LdapACL)aCL;
        this.equal = this.resources.getString(string, "equalItem");
        this.notEqual = this.resources.getString(string, "notEqualItem");
        JPanel jPanel = this.createStandardLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add(this.createInstruction("aclName"));
        this.aclName = this.createTextField("aclName", 25, null);
        jPanel2.add(this.aclName);
        jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add(this.createInstruction("target"));
        this.targetEq = this.createComboBox("targetEq", null);
        jPanel2.add(this.targetEq);
        this.target = this.createTextField("target", 25, null);
        jPanel2.add(this.target);
        this.populateComboBoxEq(this.targetEq);
        jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add(this.createInstruction("filter"));
        this.filterEq = this.createComboBox("filterEq", null);
        jPanel2.add(this.filterEq);
        this.filter = this.createTextField("filter", 25, null);
        jPanel2.add(this.filter);
        this.populateComboBoxEq(this.filterEq);
        jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add(this.createInstruction("attributes"));
        this.attributesEq = this.createComboBox("attributesEq", null);
        jPanel2.add(this.attributesEq);
        this.attributes = this.createTextField("attributes", 25, null);
        jPanel2.add(this.attributes);
        this.populateComboBoxEq(this.attributesEq);
        this.setResizable(false);
        this.populate();
        this.pack();
    }

    protected void populateComboBoxEq(JComboBox jComboBox) {
        jComboBox.addItem(this.equal);
        jComboBox.addItem(this.notEqual);
    }

    protected void populate() {
        String string = this.acl.getResourceString();
        if (string != null) {
            this.aclName.setText(string);
            this.aclName.setScrollOffset(0);
        }
        if ((string = this.acl.getTarget()) != null) {
            this.target.setText(string);
            this.target.setScrollOffset(0);
        }
        if ((string = this.acl.getTargetFilter()) != null) {
            this.filter.setText(string);
            this.filter.setScrollOffset(0);
        }
        if ((string = this.acl.getTargetAttributes()) != null) {
            this.attributes.setText(string);
            this.attributes.setScrollOffset(0);
        }
        this.targetEq.setSelectedItem(this.acl.getTargetEq() ? this.equal : this.notEqual);
        this.filterEq.setSelectedItem(this.acl.getTargetFilterEq() ? this.equal : this.notEqual);
        this.attributesEq.setSelectedItem(this.acl.getTargetAttributesEq() ? this.equal : this.notEqual);
    }

    protected boolean check_values() {
        if (this.target.getText().equals("")) {
            this.showErrorDialog("targetErrorText", "targetErrorTitle");
            return false;
        }
        if (this.attributes.getText().equals("")) {
            this.showErrorDialog("attributesErrorText", "attributesErrorTitle");
            return false;
        }
        return true;
    }

    protected void save(ActionEvent actionEvent) {
        if (!this.check_values()) {
            return;
        }
        String string = this.aclName.getText();
        this.acl.setResourceString(string.equals("") ? "unknown" : string);
        string = this.target.getText();
        this.acl.setTarget(string.equals("") ? null : string);
        string = this.filter.getText();
        this.acl.setTargetFilter(string.equals("") ? null : string);
        string = this.attributes.getText();
        this.acl.setTargetAttributes(string.equals("") ? null : string);
        this.acl.setTargetEq(this.targetEq.getSelectedItem().equals(this.equal));
        this.acl.setTargetFilterEq(this.filterEq.getSelectedItem().equals(this.equal));
        this.acl.setTargetAttributesEq(this.attributesEq.getSelectedItem().equals(this.equal));
        super.save(actionEvent);
    }
}

