/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acleditor.ACLEditorConstants;
import com.netscape.management.client.acleditor.CallbackAction;
import com.netscape.management.client.acleditor.HorizontalLine;
import com.netscape.management.client.acleditor.PopupErrorDialog;
import com.netscape.management.client.acleditor.PopupInputDialog;
import com.netscape.management.client.acleditor.WindowFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleByteTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public abstract class ACLEditorWindow
extends JDialog
implements ACLEditorConstants {
    protected static Image iconImage = null;
    protected String windowName;
    protected String titleArg;
    protected WindowFactory windowFactory;
    protected ResourceSet resources;
    protected Hashtable components;
    protected CallbackAction completionCallback;

    public ACLEditorWindow(WindowFactory windowFactory, String string) {
        this(windowFactory, string, null);
    }

    public ACLEditorWindow(WindowFactory windowFactory, String string, String string2) {
        this.windowName = string;
        this.titleArg = string2;
        this.windowFactory = windowFactory;
        this.resources = windowFactory.getResourceSet();
        this.components = new Hashtable();
        this.completionCallback = null;
        this.setTitle(this.resources.getString(this.windowName, "WindowTitle", this.titleArg));
        this.getContentPane().setLayout(new GridBagLayout());
    }

    public void setCompletionCallback(CallbackAction callbackAction) {
        this.completionCallback = callbackAction;
    }

    protected void resetConstraints(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
    }

    protected void addInstructionLineHack(GridBagConstraints gridBagConstraints, String string, ActionListener actionListener) {
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._add(this.createInstruction(string), gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        jPanel.add(this.createButton(string, actionListener));
        this._add(jPanel, gridBagConstraints);
    }

    protected void addInstructionLine(GridBagConstraints gridBagConstraints, String string, ActionListener actionListener) {
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this._add(this.createInstruction(string), gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridx = -1;
        jPanel.add(this.createButton(string, actionListener));
        this._add(jPanel, gridBagConstraints);
    }

    protected JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(this.resources.getString(this.windowName, string + "Button"));
        jButton.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        this.components.put(string, jButton);
        jButton.setFocusPainted(false);
        return jButton;
    }

    protected JTextField createTextField(String string, int n, ActionListener actionListener) {
        JTextField jTextField = new JTextField(n);
        jTextField.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        if (actionListener != null) {
            jTextField.addActionListener(actionListener);
        }
        this.components.put(string, jTextField);
        return jTextField;
    }

    protected JTextField createSingleByteTextField(String string, int n, ActionListener actionListener) {
        SingleByteTextField singleByteTextField = new SingleByteTextField(n);
        singleByteTextField.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        if (actionListener != null) {
            singleByteTextField.addActionListener(actionListener);
        }
        this.components.put(string, singleByteTextField);
        return singleByteTextField;
    }

    protected JTextArea createTextArea(String string, int n, int n2, ActionListener actionListener) {
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        this.components.put(string, jTextArea);
        return jTextArea;
    }

    protected JTextArea createTextArea(String string, ActionListener actionListener) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        this.components.put(string, jTextArea);
        return jTextArea;
    }

    protected JCheckBox createCheckBox(String string, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(this.resources.getString(this.windowName, string + "CheckBox"));
        jCheckBox.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        this.components.put(string, jCheckBox);
        jCheckBox.setFocusPainted(false);
        return jCheckBox;
    }

    protected JComboBox createComboBox(String string, ActionListener actionListener) {
        return this.createComboBox(string, 0, actionListener);
    }

    protected JComboBox createComboBox(String string, int n, ActionListener actionListener) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setToolTipText(this.resources.getString(this.windowName, string + "ToolTip"));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
        this.components.put(string, jComboBox);
        if (n > 0) {
            jComboBox.setMaximumSize(new Dimension(n, Integer.MAX_VALUE));
        }
        return jComboBox;
    }

    protected JLabel createInstruction(String string) {
        String string2 = this.resources.getString(this.windowName, string + "Instruction");
        JLabel jLabel = new JLabel(string2);
        this.components.put(string, jLabel);
        return jLabel;
    }

    protected JComponent getComponent(String string) {
        return (JComponent)this.components.get(string);
    }

    protected JPanel createStandardFooter() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        jPanel.add(this.createButton("save", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLEditorWindow.this.save(actionEvent);
            }
        }));
        jPanel.add(this.createButton("cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLEditorWindow.this.cancel(actionEvent);
            }
        }));
        jPanel.add(this.createButton("help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLEditorWindow.this.help(actionEvent);
            }
        }));
        return jPanel;
    }

    protected JScrollPane createScrollPane(int n, int n2) {
        JScrollPane jScrollPane = new JScrollPane(){

            public float getAlignmentX() {
                return 0.0f;
            }
        };
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        return jScrollPane;
    }

    protected Component createHorizontalLine() {
        return new HorizontalLine(10, 1);
    }

    protected JPanel createStandardLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 15, 10, 15);
        this._add(this.createInstruction("main"), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this._add(jPanel, gridBagConstraints);
        JPanel jPanel2 = this.createStandardFooter();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this._add(jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected void help(ActionEvent actionEvent) {
        this.windowFactory.getHelp().contextHelp(this.getWindowName(), "AclEditorHelp");
    }

    protected void save(ActionEvent actionEvent) {
        this.dispose();
    }

    public void dispose() {
        if (this.completionCallback != null) {
            this.completionCallback.go(this.getWindowName());
        }
        super.dispose();
    }

    protected void cancel(ActionEvent actionEvent) {
        this.dispose();
    }

    protected void unimplemented(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        System.err.println(string + " Unimplemented");
    }

    protected String getTitleArg() {
        return this.titleArg;
    }

    protected String getWindowName() {
        return this.windowName;
    }

    protected void _add(Component component, Object object) {
        this.getContentPane().add(component, object);
    }

    public void show() {
        ModalDialogUtil.setDialogLocation(this, null);
        super.show();
    }

    public void showErrorDialog(String string) {
        this.showErrorDialog(string, "errorTitle");
    }

    public void showErrorDialog() {
        this.showErrorDialog("errorText", "errorTitle");
    }

    public void showErrorDialog(String string, String string2) {
        new PopupErrorDialog(this, this.resources.getString(this.windowName, string), this.resources.getString(this.windowName, string2));
    }

    public void showErrorDialog(Exception exception) {
        this.showErrorDialog(exception, "errorTitle");
    }

    public void showErrorDialog(Exception exception, String string) {
        new PopupErrorDialog(this, exception.getMessage(), this.resources.getString(this.windowName, string));
    }

    public String showInputDialog(String string) {
        PopupInputDialog popupInputDialog = new PopupInputDialog(this, this.resources.getString(this.windowName, string), this.resources.getString(this.windowName, "inputTitle"));
        return popupInputDialog.getInput();
    }
}

