/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.ace;

import com.netscape.management.client.ace.ACIAttribute;
import com.netscape.management.client.ace.ACIEditor;
import com.netscape.management.client.ace.ACIParser;
import com.netscape.management.client.ace.IACITab;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.ErrorDialog;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.console.Console;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;

public class ACIManager
extends GenericDialog {
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.ace.ace");
    private static boolean showInheritedACIs = false;
    private JFrame parentFrame = null;
    private JButton newButton;
    private JButton editButton;
    private JButton removeButton;
    private String title;
    private IACITab[] tabs = null;
    private String ugDN;
    private String aciDN;
    private Vector aciVector;
    private JList aciList;
    private LDAPConnection aciLdc;
    private LDAPConnection ugLdc;
    private Vector extraACITabs = new Vector();

    private static String i18n(String string) {
        return i18n.getString("mgr", string);
    }

    public ACIManager(JFrame jFrame, String string, String string2) {
        this(jFrame, string, Console.getConsoleInfo().getLDAPConnection(), string2, Console.getConsoleInfo().getUserLDAPConnection(), Console.getConsoleInfo().getUserBaseDN());
    }

    public ACIManager(JFrame jFrame, String string, LDAPConnection lDAPConnection, String string2, LDAPConnection lDAPConnection2, String string3) {
        super(jFrame, "", 11, 0);
        this.parentFrame = jFrame;
        this.title = string;
        this.aciLdc = lDAPConnection;
        this.ugLdc = lDAPConnection2;
        this.aciDN = string2;
        this.ugDN = string3;
        String string4 = MessageFormat.format(ACIManager.i18n("title"), string);
        this.setTitle(string4);
        this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(ACIManager.i18n("description"), string));
    }

    public void show() {
        this.getContentPane().add(this.createContentPanel());
        super.show();
    }

    public void addACIEditorTab(IACITab iACITab) {
        this.extraACITabs.addElement(iACITab);
    }

    public void removeACIEditorTab(IACITab iACITab) {
        this.extraACITabs.removeElement(iACITab);
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setPreferredSize(new Dimension(250, 48));
        jTextArea.setBackground(UIManager.getColor("control"));
        jTextArea.setText(ACIManager.i18n("info"));
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.getAccessibleContext().setAccessibleDescription(jTextArea.getText());
        jPanel.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.aciList = new JList(new DefaultListModel());
        this.aciList.setToolTipText(ACIManager.i18n("aci_tt"));
        this.aciList.setSelectionMode(0);
        this.aciList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ACIManager.this.enableButtons();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.aciList);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        JPanel jPanel2 = this.createButtonPanel();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JCheckBox jCheckBox = new JCheckBox(ACIManager.i18n("inherited"), showInheritedACIs);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                showInheritedACIs = jCheckBox.isSelected();
                ACIManager.this.updateACIList(ACIManager.this.aciVector);
            }
        });
        this.setButtonComponent(jCheckBox);
        this.aciVector = new Vector();
        this.loadACIs(this.aciVector, this.aciDN, false);
        int n = this.aciDN.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.aciDN.charAt(n2) == ',') {
                String string = this.aciDN.substring(n2 + 1);
                this.loadACIs(this.aciVector, string, true);
            }
            ++n2;
        }
        this.updateACIList(this.aciVector);
        return jPanel;
    }

    private void loadACIs(Vector vector, String string, boolean bl) {
        Enumeration enumeration = this.readACIsFromDN(string);
        while (enumeration.hasMoreElements()) {
            ACI aCI = new ACI((String)enumeration.nextElement(), string, bl, false);
            vector.addElement(aCI);
        }
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        this.newButton = ButtonFactory.createPredefinedButton("NEW", buttonActionListener);
        this.newButton.setToolTipText(ACIManager.i18n("new_tt"));
        jPanel.add((Component)this.newButton, gridBagConstraints);
        this.editButton = ButtonFactory.createPredefinedButton("EDIT", buttonActionListener);
        this.editButton.setToolTipText(ACIManager.i18n("edit_tt"));
        jPanel.add((Component)this.editButton, gridBagConstraints);
        this.removeButton = ButtonFactory.createPredefinedButton("REMOVE", buttonActionListener);
        this.removeButton.setToolTipText(ACIManager.i18n("remove_tt"));
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        ButtonFactory.resizeButtons(this.newButton, this.editButton, this.removeButton);
        this.enableButtons();
        return jPanel;
    }

    private void enableButtons() {
        Object e;
        ListModel listModel = this.aciList.getModel();
        boolean bl = listModel.getSize() > 0;
        ListSelectionModel listSelectionModel = this.aciList.getSelectionModel();
        if (bl && listSelectionModel.isSelectionEmpty()) {
            listSelectionModel.setSelectionInterval(0, 0);
        }
        if (bl && (e = this.aciList.getSelectedValue()) != null && ((ACI)e).isInherited()) {
            bl = false;
        }
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    private void updateACIList(Vector vector) {
        DefaultListModel defaultListModel = (DefaultListModel)this.aciList.getModel();
        defaultListModel.removeAllElements();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ACI aCI = (ACI)enumeration.nextElement();
            if (aCI.isDeleted() || !showInheritedACIs && (showInheritedACIs || aCI.isInherited())) continue;
            defaultListModel.addElement(aCI);
        }
        this.enableButtons();
    }

    private void newACI() {
        Object object;
        ACIEditor aCIEditor = new ACIEditor(this.parentFrame, this.title, this.aciLdc, this.aciDN, this.ugLdc, this.ugDN, "");
        Enumeration enumeration = this.extraACITabs.elements();
        while (enumeration.hasMoreElements()) {
            object = (IACITab)enumeration.nextElement();
            aCIEditor.addACITab((IACITab)object);
        }
        aCIEditor.show();
        if (!aCIEditor.isCancel()) {
            object = new ACI(aCIEditor.getACI(), this.aciDN, false, true);
            this.aciVector.addElement(object);
            this.updateACIList(this.aciVector);
            ListSelectionModel listSelectionModel = this.aciList.getSelectionModel();
            ListModel listModel = this.aciList.getModel();
            listSelectionModel.setLeadSelectionIndex(listModel.getSize() - 1);
        }
    }

    private void editACI() {
        ListSelectionModel listSelectionModel = this.aciList.getSelectionModel();
        int n = listSelectionModel.getLeadSelectionIndex();
        if (n >= 0) {
            ACI aCI = (ACI)this.aciList.getSelectedValue();
            ACIEditor aCIEditor = new ACIEditor(this.parentFrame, this.title, this.aciLdc, this.aciDN, this.ugLdc, this.ugDN, aCI.getData());
            Enumeration enumeration = this.extraACITabs.elements();
            while (enumeration.hasMoreElements()) {
                IACITab iACITab = (IACITab)enumeration.nextElement();
                aCIEditor.addACITab(iACITab);
            }
            aCIEditor.show();
            if (!aCIEditor.isCancel()) {
                aCI.setData(aCIEditor.getACI());
                aCI.setModified(true);
                this.updateACIList(this.aciVector);
                listSelectionModel.setLeadSelectionIndex(n);
            }
        }
    }

    private void removeACI() {
        ListSelectionModel listSelectionModel = this.aciList.getSelectionModel();
        int n = listSelectionModel.getLeadSelectionIndex();
        if (n >= 0) {
            ACI aCI = (ACI)this.aciList.getSelectedValue();
            String string = ACIManager.i18n("removeTitle");
            String string2 = MessageFormat.format(ACIManager.i18n("removeMsg"), aCI.getName());
            int n2 = JOptionPane.showConfirmDialog(null, string2, string, 0, 3);
            if (n2 == 0) {
                aCI.setDeleted(true);
                this.updateACIList(this.aciVector);
                ListModel listModel = this.aciList.getModel();
                int n3 = listModel.getSize() - 1;
                if (n >= n3) {
                    n = n3;
                }
                listSelectionModel.setLeadSelectionIndex(n);
            }
        }
    }

    protected void helpInvoked() {
        ConsoleHelp.showContextHelp("ace-manager");
    }

    protected void okInvoked() {
        try {
            this.writeACIsFromDN(this.aciDN, this.aciVector.elements());
            int n = this.aciDN.length();
            int n2 = 0;
            while (n2 < n) {
                if (this.aciDN.charAt(n2) == ',') {
                    String string = this.aciDN.substring(n2 + 1);
                    this.writeACIsFromDN(string, this.aciVector.elements());
                }
                ++n2;
            }
            super.okInvoked();
        }
        catch (LDAPException lDAPException) {
            String string = ACIManager.i18n("errorTitle");
            String string2 = ACIManager.i18n("errorMsg");
            String string3 = ACIManager.i18n("errorTip");
            String string4 = lDAPException.getMatchedDN();
            String string5 = "LDAPException: " + lDAPException.errorCodeToString() + " (" + lDAPException.getLDAPResultCode() + ")\n" + (string4 == null ? "" : string4);
            ErrorDialog errorDialog = new ErrorDialog(this, string, string2, string3, string5, 1, 1);
            errorDialog.setVisible(true);
        }
    }

    private Enumeration readACIsFromDN(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            lDAPSearchResults = this.aciLdc.search(string, 0, "(objectclass=*)", new String[]{"aci"}, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                Enumeration enumeration = lDAPAttributeSet.getAttributes();
                if (!enumeration.hasMoreElements()) continue;
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                return lDAPAttribute.getStringValues();
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("Error reading ACI: " + lDAPException.getLDAPResultCode());
            Debug.println("Message: " + lDAPException.getLDAPErrorMessage());
            Debug.println("Matched DN: " + lDAPException.getMatchedDN());
        }
        return new Vector().elements();
    }

    private void writeACIsFromDN(String string, Enumeration enumeration) throws LDAPException {
        ACI aCI = null;
        try {
            Object object;
            boolean bl = false;
            LDAPAttribute lDAPAttribute = new LDAPAttribute("aci");
            while (enumeration.hasMoreElements()) {
                aCI = (ACI)enumeration.nextElement();
                if (!aCI.getDN().equals(string)) continue;
                if (aCI.isModified()) {
                    bl = true;
                }
                if (aCI.isDeleted()) continue;
                object = aCI.getData();
                lDAPAttribute.addValue((String)object);
            }
            if (bl) {
                object = new LDAPModification(2, lDAPAttribute);
                this.aciLdc.modify(string, object);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("ACI Write Error: " + lDAPException.getLDAPResultCode());
            Debug.println("Message: " + lDAPException.getLDAPErrorMessage());
            throw lDAPException;
        }
    }

    class ACI {
        String dn;
        String data;
        String name;
        boolean isInherited = false;
        boolean isModified = false;
        boolean isDeleted = false;

        ACI(String string, String string2, boolean bl, boolean bl2) {
            this.dn = string2;
            this.isInherited = bl;
            this.setData(string);
            this.setModified(bl2);
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            if (this.name == null || this.name.length() == 0) {
                return ACIManager.i18n("nonameACI");
            }
            return this.name;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String string) {
            this.data = string;
            Object var2_2 = null;
            ACIAttribute aCIAttribute = ACIAttribute.getAttribute("acl", ACIAttribute.toArray(ACIParser.getACIAttributes(string)));
            if (aCIAttribute == null) {
                aCIAttribute = ACIAttribute.getAttribute("aci", ACIAttribute.toArray(ACIParser.getACIAttributes(string)));
            }
            if (aCIAttribute != null) {
                this.setName(aCIAttribute.getValue());
            }
        }

        public String getDN() {
            return this.dn;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public boolean isModified() {
            return this.isModified;
        }

        public void setModified(boolean bl) {
            this.isModified = bl;
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public void setDeleted(boolean bl) {
            this.isDeleted = bl;
            this.setModified(true);
        }

        public String toString() {
            if (this.isInherited) {
                return this.getName() + " " + ACIManager.i18n("inheritedACI");
            }
            return this.getName();
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("NEW")) {
                ACIManager.this.newACI();
            } else if (string.equals("EDIT")) {
                ACIManager.this.editACI();
            } else if (string.equals("REMOVE")) {
                ACIManager.this.removeACI();
            }
        }
    }
}

