/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.tools;

import com.sun.symon.apps.details.HostdetailsBean;
import com.sun.symon.apps.wci.fmconf.common.SMFmAbsentHW;
import com.sun.symon.apps.wci.fmconf.common.SMFmException;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmRemoteEnd;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciData;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmAlarmHandler;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmExceptionHandler;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmProgressThread;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SMFmResourceAccess {
    public static SMFmResourceAccess resAcc;
    public static final String ADHOC_COMMAND_GET_FABRICS_LIST = "GetFabricsList";
    public static final String ADHOC_COMMAND_UPDATE_FABRIC_DATA = "GetFabricObject";
    public static final String ADHOC_COMMAND_GET_FILE_LIST = "GetFileList";
    public static final String ADHOC_COMMAND_GET_TEXT_FILE = "GetTextFile";
    public static final String ADHOC_COMMAND_SAVE_TEXT_FILE = "SaveTextFile";
    public static final String ADHOC_COMMAND_APPLY_CFG_TO_FAB = "ApplyCfgToFab";
    public static final String ADHOC_COMMAND_CREATE_PARTITION = "CreatePartition";
    public static final String ADHOC_COMMAND_DELETE_PARTITION = "DeletePartition";
    public static final String ADHOC_COMMAND_UPGRADE_PARTITION_MAP = "UpgradePartitionMap";
    public static final String ADHOC_COMMAND_UPGRADE_PARTITION_LIST = "UpgradePartitionList";
    public static final String ADHOC_COMMAND_UPGRADE_PARTITION_STRIPE = "UpgradePartitionStripe";
    public static final String ADHOC_COMMAND_DOWNGRADE_PARTITION = "DowngradePartition";
    public static final String ADHOC_COMMAND_UPDATE_NODES = "UpdateNodes";
    public static final String ADHOC_COMMAND_UPDATE_PARTITION = "UpdatePartition";
    public static final String ADHOC_COMMAND_START_DISCOVERY = "StartDiscovery";
    public static final String ADHOC_COMMAND_IS_DISCOVERY_DONE = "IsDiscoveryDone";
    public static final String ADHOC_COMMAND_STOP_DISCOVERY = "StopDiscovery";
    public static final String ADHOC_COMMAND_GET_DISCOVERY_DATA = "GetDiscoveryData";
    public static final String ADHOC_COMMAND_ADD_NODE_TO_FAB = "AddNodeToFabric";
    public static final String ADHOC_COMMAND_REM_NODE_FROM_FAB = "RemNodeFromFabric";
    public static final String ADHOC_COMMAND_UPDATE_NODE_PROPERTIES = "UpdateNodeProperties";
    public static final String ADHOC_COMMAND_UPDATE_NODE_NC_SLICES = "UpdateNodeNCSlices";
    public static final String ALARM_COMMAND_FABRIC_STATE_CHANGED = "fabricAlarmStateChanged";
    private Socket sock;
    private SMRawDataRequest req;
    private SMResourceAccess resacc;
    private String errorMsg;
    private String agentHost;
    private int agentPort;
    private String moduleName;
    private ObjectInputStream ois;
    private ObjectOutputStream oos;
    public static final int RA_ERROR = 0;
    public static final int RA_OK = 1;
    public boolean errorMsgLocked = false;
    public boolean errorMsgQueued = false;
    private JLabel statusLabel;
    private boolean overrideDefaultStatus = false;
    private Runnable sendVectorRunnable;
    private boolean isSendingVector = false;
    private boolean fabricUpdating = false;
    private String probeURL;
    private String cmd;
    private Vector vdata;
    private Vector rdata;
    int retValue = 1;
    private static final String helpDir1 = "/opt/SUNWsymon/lib/locale/";
    private static final String helpDir2 = "/help/wci";
    private Vector resourceAccessListeners = new Vector();
    private List statusLabels = new ArrayList();
    private SMFmAlarmHandler alarmHandler;
    private SMFmFabricData fabricData;

    public SMFmResourceAccess(SMRawDataRequest sMRawDataRequest, String string, int n, String string2) {
        resAcc = this;
        this.sock = null;
        this.errorMsg = null;
        this.agentHost = string;
        this.agentPort = n;
        this.moduleName = string2;
        this.ois = null;
        this.oos = null;
        this.req = sMRawDataRequest;
        this.resacc = new SMResourceAccess(sMRawDataRequest);
        this.createSendVectorRunnable();
        this.alarmHandler = new SMFmAlarmHandler(this, string, n, string2);
        this.fabricData = new SMFmFabricData();
    }

    static /* synthetic */ boolean access$2(SMFmResourceAccess sMFmResourceAccess) {
        return sMFmResourceAccess.isSendingVector;
    }

    public SMFmNodeData addNodeToFabric(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(string2);
        this.vdata.add(string3);
        this.vdata.add(string4);
        this.vdata.add(new Integer(SMFmConfGlobal.getChassisInt(string5)));
        this.vdata.add(string6);
        this.vdata.add(string7);
        this.vdata.add(string8);
        this.vdata.add(new Integer(SMFmConfGlobal.getNodeTypeInt(string9)));
        this.vdata.add(string10);
        this.vdata.add(string11);
        this.vdata.add(string12);
        SMFmNodeData sMFmNodeData = null;
        this.cmd = ADHOC_COMMAND_ADD_NODE_TO_FAB;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmNodeData = (SMFmNodeData)this.rdata.elementAt(1);
            this.fabricData.addMember(sMFmNodeData);
            this.fireFabricUpdated(sMFmNodeData, this.cmd);
        }
        return sMFmNodeData;
    }

    public void addSMFmResourceAccessListener(SMFmResourceAccessListener sMFmResourceAccessListener) {
        if (this.resourceAccessListeners.contains(sMFmResourceAccessListener)) {
            return;
        }
        this.resourceAccessListeners.add(sMFmResourceAccessListener);
    }

    public void addStatusJLabel(JLabel jLabel) {
        if (jLabel == null) {
            return;
        }
        this.statusLabels.add(jLabel);
    }

    public void applyCfgToFab(String string) {
        this.vdata = new Vector();
        this.vdata.add(string.toCharArray());
        this.cmd = ADHOC_COMMAND_APPLY_CFG_TO_FAB;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            try {
                this.alarmHandler.getAndSetLastXMLChangedTime();
            }
            catch (Exception exception) {
                System.out.println(SMFmConfGlobal.getI18NString("ERROR_REFRESH_GET_XML_MOD_TIME"));
                exception.printStackTrace();
            }
            this.updateFabricData(false);
        }
    }

    private void clearEMsg() {
        this.lockErrorMsg();
        this.errorMsg = null;
        this.errorMsgQueued = false;
        this.releaseErrorMsg();
    }

    public void clearStatusJLabel() {
        this.postStatus(SMFmConfGlobal.getI18NString("STATUS_IDLE"));
    }

    private synchronized void connect(String string) throws IOException, StreamCorruptedException, SMAPIException {
        this.sock = this.req.probeConnect(string, null);
        this.ois = new ObjectInputStream(this.sock.getInputStream());
        this.oos = new ObjectOutputStream(this.sock.getOutputStream());
    }

    public SMFmPartitionData createPartition(String string, String string2, String string3, int n, String string4) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(new Integer(SMFmConfGlobal.getModeInt(string2)));
        this.vdata.add(new Integer(SMFmConfGlobal.getTopoInt(string3)));
        this.vdata.add(new Integer(n));
        if (string4 != null) {
            this.vdata.add(string4);
        }
        SMFmPartitionData sMFmPartitionData = null;
        this.cmd = ADHOC_COMMAND_CREATE_PARTITION;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = (SMFmPartitionData)this.rdata.get(1);
            this.fabricData.addPartition(sMFmPartitionData);
            this.fireFabricUpdated(sMFmPartitionData, this.cmd);
        }
        return sMFmPartitionData;
    }

    private void createSendVectorRunnable() {
        this.sendVectorRunnable = new Runnable(){

            public void run() {
                SMFmResourceAccess.this.rdata = null;
                SMFmResourceAccess.this.isSendingVector = true;
                SMFmResourceAccess.this.retValue = 0;
                SMFmResourceAccess.this.clearEMsg();
                String string = "";
                String string2 = SMFmConfGlobal.getI18NString("STATUS_CONNECTING");
                String string3 = "";
                try {
                    try {
                        SMFmResourceAccess.this.postStatus(string2);
                        SMFmResourceAccess.this.connect(SMFmResourceAccess.this.probeURL);
                        string = String.valueOf(SMFmConfGlobal.getI18NString("STATUS_CONNECTION_ESTABLISHED")) + ". ";
                        string2 = SMFmConfGlobal.getI18NString("STATUS_SENDING_REQUEST");
                        SMFmResourceAccess.this.postStatus(String.valueOf(string) + string2);
                        SMFmResourceAccess.this.sendVector(SMFmResourceAccess.this.vdata);
                        string = String.valueOf(SMFmConfGlobal.getI18NString("STATUS_REQUEST_SENT")) + ". ";
                        string2 = SMFmConfGlobal.getI18NString("STATUS_RECIEVING_RESPONSE");
                        SMFmResourceAccess.this.postStatus(String.valueOf(string) + string2);
                        SMFmResourceAccess.this.rdata = SMFmResourceAccess.this.getVector();
                        string3 = (String)SMFmResourceAccess.this.rdata.get(0);
                        if (!string3.equals("CPT")) {
                            SMFmResourceAccess.this.retValue = 0;
                            if (string3.equals("EXC")) {
                                SMFmResourceAccess.this.setEMsg(SMFmExceptionHandler.handleException(SMFmResourceAccess.this.cmd, (SMFmException)SMFmResourceAccess.this.rdata.get(1)));
                                if (SMFmResourceAccess.this.fabricUpdating) {
                                    SMFmResourceAccess.this.fireFabricUpdateFailed(new String(SMFmResourceAccess.this.errorMsg), SMFmResourceAccess.this.cmd);
                                }
                            } else if (string3.equals("ABS")) {
                                SMFmResourceAccess.this.setEMsg(String.valueOf(SMFmExceptionHandler.getADHOCCommandString(SMFmResourceAccess.this.cmd)) + ": " + SMFmConfGlobal.getI18NString("ABSENT_HW_HEADING") + ", " + SMFmConfGlobal.getI18NString("LAUNCHING_NETSCAPE"));
                                if (SMFmResourceAccess.this.fabricUpdating) {
                                    SMFmResourceAccess.this.fireFabricUpdateFailed((SMFmAbsentHW)SMFmResourceAccess.this.rdata.get(1), SMFmResourceAccess.this.cmd);
                                }
                            } else {
                                SMFmResourceAccess.this.setEMsg(String.valueOf(SMFmExceptionHandler.getADHOCCommandString(SMFmResourceAccess.this.cmd)) + ": " + SMFmConfGlobal.getI18NString("UNKOWN_EXCEPTION"));
                                if (SMFmResourceAccess.this.fabricUpdating) {
                                    SMFmResourceAccess.this.fireFabricUpdateFailed(new String(SMFmResourceAccess.this.errorMsg), SMFmResourceAccess.this.cmd);
                                }
                            }
                        } else {
                            SMFmResourceAccess.this.retValue = 1;
                        }
                    }
                    catch (Exception exception) {
                        string2 = String.valueOf(SMFmConfGlobal.getI18NString("STATUS_ERROR")) + string2;
                        SMFmResourceAccess.this.postStatus(String.valueOf(string) + string2);
                        SMFmResourceAccess.this.setEMsg(String.valueOf(string2) + ":" + exception.getMessage());
                        SMFmConfGlobal.DebugPrint(String.valueOf(string2) + ":" + exception.getMessage());
                        SMFmResourceAccess.this.retValue = 0;
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    SMFmResourceAccess.this.disconnect();
                    if (SMFmResourceAccess.this.retValue != 0) {
                        string = String.valueOf(SMFmConfGlobal.getI18NString("STATUS_RECIEVED_RESPONSE")) + ". ";
                        SMFmResourceAccess.this.postStatus(String.valueOf(string) + SMFmConfGlobal.getI18NString("STATUS_DISCONNECTED") + ".");
                    }
                    throw throwable;
                }
                SMFmResourceAccess.this.disconnect();
                if (SMFmResourceAccess.this.retValue != 0) {
                    string = String.valueOf(SMFmConfGlobal.getI18NString("STATUS_RECIEVED_RESPONSE")) + ". ";
                    SMFmResourceAccess.this.postStatus(String.valueOf(string) + SMFmConfGlobal.getI18NString("STATUS_DISCONNECTED") + ".");
                }
                SMFmResourceAccess.this.isSendingVector = false;
            }
        };
    }

    public void deletePartition(String string) {
        this.vdata = new Vector();
        this.vdata.add(string);
        SMFmPartitionData sMFmPartitionData = null;
        this.cmd = ADHOC_COMMAND_DELETE_PARTITION;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = this.fabricData.getPartitionByName(string);
            this.fabricData.removePartition(sMFmPartitionData);
            this.fireFabricUpdated(sMFmPartitionData, this.cmd);
        }
    }

    private synchronized void disconnect() {
        try {
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.flush();
                this.oos.close();
            }
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public SMFmPartitionData downgradePartition(String string, List list) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(list);
        this.cmd = ADHOC_COMMAND_DOWNGRADE_PARTITION;
        SMFmPartitionData sMFmPartitionData = null;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = (SMFmPartitionData)this.rdata.get(1);
            this.fabricData.addPartition(sMFmPartitionData);
            this.fireFabricUpdated(this.fabricData, this.cmd);
            this.updateNodes(list);
        }
        return sMFmPartitionData;
    }

    public void fabricAlarmStateChanged() {
        this.fireFabricUpdated(this.fabricData, ALARM_COMMAND_FABRIC_STATE_CHANGED);
    }

    private void fireFabricUpdateFailed(Object object, String string) {
        Vector vector;
        SMFmConfGlobal.DebugPrint("Notifying listeners: fabric update failed");
        this.fabricUpdating = false;
        SMFmResourceAccess sMFmResourceAccess = this;
        synchronized (sMFmResourceAccess) {
            vector = (Vector)this.resourceAccessListeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        SMFmResourceAccessEvent sMFmResourceAccessEvent = new SMFmResourceAccessEvent(this, object, string);
        int n2 = 0;
        while (n2 < n) {
            SMFmResourceAccessListener sMFmResourceAccessListener = (SMFmResourceAccessListener)vector.get(n2);
            sMFmResourceAccessListener.fabricUpdateFailed(sMFmResourceAccessEvent);
            ++n2;
        }
    }

    private void fireFabricUpdated(Object object, String string) {
        Vector vector;
        SMFmConfGlobal.DebugPrint("Notifying listeners: fabric updated");
        this.fabricUpdating = false;
        SMFmResourceAccess sMFmResourceAccess = this;
        synchronized (sMFmResourceAccess) {
            vector = (Vector)this.resourceAccessListeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        SMFmResourceAccessEvent sMFmResourceAccessEvent = new SMFmResourceAccessEvent(this, object, string);
        int n2 = 0;
        while (n2 < n) {
            SMFmResourceAccessListener sMFmResourceAccessListener = (SMFmResourceAccessListener)vector.get(n2);
            sMFmResourceAccessListener.fabricUpdated(sMFmResourceAccessEvent);
            ++n2;
        }
    }

    private void fireFabricUpdating(String string) {
        Vector vector;
        SMFmConfGlobal.DebugPrint("Notifying listeners: fabric updating on command: " + string);
        this.fabricUpdating = true;
        SMFmResourceAccess sMFmResourceAccess = this;
        synchronized (sMFmResourceAccess) {
            vector = (Vector)this.resourceAccessListeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        SMFmResourceAccessEvent sMFmResourceAccessEvent = new SMFmResourceAccessEvent(this, null, string);
        int n2 = 0;
        while (n2 < n) {
            SMFmResourceAccessListener sMFmResourceAccessListener = (SMFmResourceAccessListener)vector.get(n2);
            sMFmResourceAccessListener.fabricUpdating(sMFmResourceAccessEvent);
            ++n2;
        }
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public String getAgentModule() {
        return this.moduleName;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public List getDiscoveryData() {
        this.cmd = ADHOC_COMMAND_GET_DISCOVERY_DATA;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            return (List)this.rdata.elementAt(1);
        }
        return null;
    }

    public String getErrorMessage() {
        this.lockErrorMsg();
        if (this.errorMsgQueued) {
            this.errorMsgQueued = false;
            String string = new String(this.errorMsg);
            this.errorMsg = null;
            this.releaseErrorMsg();
            return string;
        }
        this.releaseErrorMsg();
        return null;
    }

    public SMFmFabricData getFabricData() {
        return this.fabricData;
    }

    public Vector getFabricsList() {
        Vector vector = null;
        this.cmd = ADHOC_COMMAND_GET_FABRICS_LIST;
        this.vdata = null;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            vector = (Vector)this.rdata.elementAt(1);
        }
        return vector;
    }

    public Vector getFileList(String string) {
        Vector vector = null;
        this.vdata = new Vector();
        this.vdata.add(string);
        this.cmd = ADHOC_COMMAND_GET_FILE_LIST;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            vector = (Vector)this.rdata.get(1);
        }
        return vector;
    }

    public URL getHelpFileURL(String string) {
        this.clearEMsg();
        URL uRL = null;
        String string2 = "";
        String string3 = "";
        if (string.startsWith("file:")) {
            string2 = string;
        } else {
            string3 = this.req.getLocale().getLanguage();
            if (string3.compareTo("en") == 0) {
                string3 = "C";
            }
            string2 = "file:/opt/SUNWsymon/lib/locale/" + string3 + helpDir2 + "/" + string;
        }
        try {
            uRL = new URL(string2);
        }
        catch (Exception exception) {
            SMFmConfGlobal.DebugPrint(exception.toString());
        }
        return uRL;
    }

    public Image getImage(String string) {
        this.clearEMsg();
        return this.resacc.getImage(string);
    }

    public JLabel getStatusJLabel() {
        JLabel jLabel = new JLabel();
        this.statusLabels.add(jLabel);
        return jLabel;
    }

    public String getTextFile(String string, String string2) {
        String string3 = new String();
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(string2);
        this.cmd = ADHOC_COMMAND_GET_TEXT_FILE;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
        if (this.retValue == 1 && this.rdata.size() > 1) {
            string3 = new String((char[])this.rdata.elementAt(1));
        }
        return string3;
    }

    private synchronized Vector getVector() throws OptionalDataException, ClassNotFoundException, IOException {
        return (Vector)this.ois.readObject();
    }

    public boolean isDiscoveryDone() {
        this.vdata = new Vector();
        this.cmd = ADHOC_COMMAND_IS_DISCOVERY_DONE;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            return (Boolean)this.rdata.elementAt(1);
        }
        return false;
    }

    public void launchHostdetails(final String string) {
        Thread thread = new Thread(){

            public void run() {
                SMFmConfGlobal.DebugPrint("Launching host details");
                HostdetailsBean hostdetailsBean = new HostdetailsBean(SMConsoleContext.getInstance().getAPIHandle(), string){

                    public void doExitAction() {
                        SMFmConfGlobal.DebugPrint("Host details exiting safely");
                    }
                };
                hostdetailsBean.addPropertyChangeListener(new PropertyChangeListener(string){
                    private final /* synthetic */ String val$host;
                    {
                        this.val$host = string;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("HostdetailsError")) {
                            String string = SMFmConfGlobal.getI18NString("ERROR_IN_CORE_HOST_DET");
                            SMFmConfGlobal.DebugPrint(String.valueOf(string) + "for host: " + this.val$host + " - " + propertyChangeEvent.getNewValue());
                            JOptionPane.showMessageDialog(null, string, SMFmConfGlobal.getI18NString("ERROR"), 0);
                        }
                    }
                });
                hostdetailsBean.doLaunchHostdetails();
            }
        };
        thread.start();
    }

    public void launchNetscape(String string) {
        String string2 = "netscape " + string;
        try {
            Process process = Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Cannot launch netscape: " + exception.getMessage(), SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
            exception.printStackTrace();
        }
    }

    private synchronized void lockErrorMsg() {
        try {
            while (this.errorMsgLocked) {
                Thread.sleep(3000L);
            }
        }
        catch (InterruptedException interruptedException) {}
        this.errorMsgLocked = true;
    }

    public void overrideDefaultStatus(boolean bl) {
        this.overrideDefaultStatus = bl;
    }

    public synchronized void postStatus(final String string) {
        if (string == null) {
            System.out.println("Message was null");
            return;
        }
        if (this.overrideDefaultStatus) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = statusLabels.size();
                if (n == 0) {
                    return;
                }
                int n2 = 0;
                while (n2 < n) {
                    JLabel jLabel = (JLabel)statusLabels.get(n2);
                    jLabel.setText(new String(string));
                    ++n2;
                }
            }
        });
    }

    private synchronized void releaseErrorMsg() {
        this.errorMsgLocked = false;
    }

    public void remNodeFromFabric(List list) {
        this.vdata = new Vector();
        this.vdata.add(list);
        this.cmd = ADHOC_COMMAND_REM_NODE_FROM_FAB;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            int n = 0;
            while (n < list.size()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)list.get(n), ":");
                if (stringTokenizer.countTokens() == 2) {
                    this.fabricData.removeMember(this.fabricData.getMemberByName(stringTokenizer.nextToken(), stringTokenizer.nextToken()));
                } else if (stringTokenizer.countTokens() == 1) {
                    this.fabricData.removeMember(this.fabricData.getMemberByName(stringTokenizer.nextToken(), ""));
                }
                ++n;
            }
            this.fireFabricUpdated(list, this.cmd);
        }
    }

    public void removeSMFmResourceAccessListenr(SMFmResourceAccessListener sMFmResourceAccessListener) {
        boolean bl = this.resourceAccessListeners.remove(sMFmResourceAccessListener);
        if (bl) {
            System.out.println("Listener removed");
        } else {
            System.out.println("ERROR: Listner not removed");
        }
    }

    public void removeStatusJLabel(JLabel jLabel) {
        this.statusLabels.remove(jLabel);
    }

    public void saveTextFile(String string, String string2, String string3) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(string2);
        this.vdata.add(string3.toCharArray());
        this.cmd = ADHOC_COMMAND_SAVE_TEXT_FILE;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
    }

    private synchronized void sendVector(Vector vector) throws IOException {
        if (vector != null) {
            vector.trimToSize();
            this.oos.writeObject(vector);
            this.oos.flush();
        }
    }

    private void sendVectorAndWait() {
        try {
            System.out.println("Starting send vector and wait");
            this.isSendingVector = true;
            Thread thread = new Thread(this.sendVectorRunnable);
            thread.start();
            SMFmProgressThread sMFmProgressThread = new SMFmProgressThread(thread, this.statusLabels);
            sMFmProgressThread.start();
            while (this.isSendingVector) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {}
    }

    private void setEMsg(String string) {
        this.lockErrorMsg();
        if (string != null && this.errorMsg == null && !this.errorMsgQueued) {
            this.errorMsg = new String(string);
            this.errorMsgQueued = true;
        }
        this.releaseErrorMsg();
    }

    public int startDiscovery(Map map) {
        this.vdata = new Vector();
        this.vdata.add(map);
        this.cmd = ADHOC_COMMAND_START_DISCOVERY;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            return (Integer)this.rdata.elementAt(1);
        }
        return -1;
    }

    public void stopDiscovery() {
        this.cmd = ADHOC_COMMAND_STOP_DISCOVERY;
        this.vdata = new Vector();
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.sendVectorAndWait();
    }

    public Map updateDiscoveryData() {
        HashMap<String, SMFmNodeData> hashMap = new HashMap<String, SMFmNodeData>();
        List list = this.getDiscoveryData();
        if (list == null) {
            return null;
        }
        int n = 0;
        while (n < list.size()) {
            SMFmRemoteEnd[] sMFmRemoteEndArray = (SMFmRemoteEnd[])list.get(n);
            SMFmNodeData sMFmNodeData = this.fabricData.getMemberByName(sMFmRemoteEndArray[0].getSCName(), sMFmRemoteEndArray[0].getSCDomain());
            if (sMFmNodeData == null) {
                SMFmConfGlobal.DebugPrint("Could not find node for: " + sMFmRemoteEndArray[0]);
            } else {
                SMFmWciData sMFmWciData = sMFmNodeData.getWci(sMFmRemoteEndArray[0].getSlot(), sMFmRemoteEndArray[0].getWci());
                if (sMFmWciData == null) {
                    SMFmConfGlobal.DebugPrint("Could not find wci for: " + sMFmRemoteEndArray[0]);
                } else {
                    SMFmNodeData sMFmNodeData2 = this.fabricData.getMemberByName(sMFmRemoteEndArray[1].getSCName(), sMFmRemoteEndArray[1].getSCDomain());
                    if (sMFmRemoteEndArray == null) {
                        SMFmConfGlobal.DebugPrint("Coult not find node for: " + sMFmRemoteEndArray[1]);
                    } else {
                        SMFmWciData sMFmWciData2 = sMFmNodeData2.getWci(sMFmRemoteEndArray[1].getSlot(), sMFmRemoteEndArray[1].getWci());
                        if (sMFmWciData2 == null) {
                            SMFmConfGlobal.DebugPrint("Could not find wci for: " + sMFmRemoteEndArray[1]);
                        } else {
                            sMFmWciData.setRemoteEnd(sMFmRemoteEndArray[0].getPort(), sMFmRemoteEndArray[1]);
                            sMFmWciData2.setRemoteEnd(sMFmRemoteEndArray[1].getPort(), sMFmRemoteEndArray[0]);
                            hashMap.put(String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId(), sMFmNodeData);
                            hashMap.put(String.valueOf(sMFmNodeData2.getScHost()) + ":" + sMFmNodeData2.getDomainId(), sMFmNodeData2);
                        }
                    }
                }
            }
            ++n;
        }
        return hashMap;
    }

    public void updateFabricData(boolean bl) {
        this.vdata = new Vector();
        this.vdata.add(new Boolean(bl));
        this.cmd = ADHOC_COMMAND_UPDATE_FABRIC_DATA;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            this.fabricData.updateFabricData((SMFmFabricData)this.rdata.elementAt(1));
            try {
                this.alarmHandler.getAndSetLastXMLChangedTime();
            }
            catch (Exception exception) {
                System.out.println(SMFmConfGlobal.getI18NString("ERROR_REFRESH_GET_XML_MOD_TIME"));
                exception.printStackTrace();
            }
            this.fireFabricUpdated(this.fabricData, this.cmd);
        }
    }

    public SMFmNodeData updateNodeNCSlices(String string, String string2, int n) {
        SMFmNodeData sMFmNodeData = null;
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(string2);
        this.vdata.add(new Integer(n));
        this.cmd = ADHOC_COMMAND_UPDATE_NODE_NC_SLICES;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmNodeData = (SMFmNodeData)this.rdata.get(1);
            this.fabricData.updateMemberData(sMFmNodeData);
            this.fireFabricUpdated(sMFmNodeData, this.cmd);
        }
        return sMFmNodeData;
    }

    public SMFmNodeData updateNodeProperties(String string, String string2, Map map) {
        SMFmNodeData sMFmNodeData = null;
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(string2);
        this.vdata.add(map);
        this.cmd = ADHOC_COMMAND_UPDATE_NODE_PROPERTIES;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmNodeData = (SMFmNodeData)this.rdata.get(1);
            this.fabricData.updateMemberData(sMFmNodeData);
            this.fireFabricUpdated(sMFmNodeData, this.cmd);
        }
        return sMFmNodeData;
    }

    public Map updateNodes(List list) {
        Map map = null;
        this.vdata = new Vector();
        this.vdata.add(list);
        this.cmd = ADHOC_COMMAND_UPDATE_NODES;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            map = (Map)this.rdata.get(1);
            this.fabricData.updateMemberData(new ArrayList(map.values()));
            this.fireFabricUpdated(map, this.cmd);
        }
        return map;
    }

    public SMFmPartitionData updatePartition(String string) {
        SMFmPartitionData sMFmPartitionData = null;
        this.vdata = new Vector();
        this.vdata.add(string);
        this.cmd = ADHOC_COMMAND_UPDATE_PARTITION;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = (SMFmPartitionData)this.rdata.get(1);
            this.fabricData.addPartition(sMFmPartitionData);
            this.fireFabricUpdated(sMFmPartitionData, this.cmd);
        }
        return sMFmPartitionData;
    }

    public SMFmPartitionData upgradePartition(String string, int n) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(new Integer(n));
        SMFmPartitionData sMFmPartitionData = null;
        this.cmd = ADHOC_COMMAND_UPGRADE_PARTITION_STRIPE;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = (SMFmPartitionData)this.rdata.get(1);
            this.fabricData.addPartition(sMFmPartitionData);
            this.fireFabricUpdated(sMFmPartitionData, this.cmd);
        }
        return sMFmPartitionData;
    }

    public SMFmPartitionData upgradePartition(String string, List list, Map map) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(list);
        this.vdata.add(map);
        SMFmPartitionData sMFmPartitionData = null;
        this.cmd = ADHOC_COMMAND_UPGRADE_PARTITION_LIST;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = (SMFmPartitionData)this.rdata.get(1);
            this.fabricData.addPartition(sMFmPartitionData);
            this.fireFabricUpdated(sMFmPartitionData, this.cmd);
        }
        return sMFmPartitionData;
    }

    public SMFmPartitionData upgradePartition(String string, Map map, Map map2) {
        this.vdata = new Vector();
        this.vdata.add(string);
        this.vdata.add(map);
        this.vdata.add(map2);
        SMFmPartitionData sMFmPartitionData = null;
        this.cmd = ADHOC_COMMAND_UPGRADE_PARTITION_MAP;
        this.probeURL = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + this.moduleName + "/fmsio/?runadhoccommand." + this.cmd;
        this.fireFabricUpdating(this.cmd);
        this.sendVectorAndWait();
        if (this.retValue == 1) {
            sMFmPartitionData = (SMFmPartitionData)this.rdata.get(1);
            this.fabricData.addPartition(sMFmPartitionData);
            this.fireFabricUpdated(sMFmPartitionData, this.cmd);
        }
        return sMFmPartitionData;
    }
}

