/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.tools;

import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class SMFmDiscoveryThread
extends Thread {
    private boolean stop = false;
    private Map scNameDomainWcis;
    private String error;
    private SMFmResourceAccess resAcc;

    public SMFmDiscoveryThread(Map map, SMFmResourceAccess sMFmResourceAccess) {
        this.scNameDomainWcis = map;
        this.resAcc = sMFmResourceAccess;
    }

    private synchronized void doStopDiscovery() {
        if (!this.resAcc.isDiscoveryDone()) {
            this.resAcc.stopDiscovery();
        }
        this.error = this.resAcc.getErrorMessage();
        if (this.error != null) {
            this.showErrorDialog(this.error);
        }
    }

    private synchronized void doUpdateDiscoveryData() {
        block4: {
            if (this.stop) break block4;
            final Map map = this.resAcc.updateDiscoveryData();
            this.error = this.resAcc.getErrorMessage();
            if (this.error != null) {
                this.showErrorDialog(this.error);
                this.stop = true;
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            this.updateDialogInformation(map);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public abstract void performPostDiscoveryActions();

    public abstract void performPreDiscoveryActions();

    public void run() {
        this.performPreDiscoveryActions();
        this.resAcc.postStatus(SMFmConfGlobal.getI18NString("DISCOVERING_LINKS"));
        this.resAcc.overrideDefaultStatus(true);
        int n = this.resAcc.startDiscovery(this.scNameDomainWcis);
        this.error = this.resAcc.getErrorMessage();
        if (this.error != null) {
            this.showErrorDialog(this.error);
        } else {
            int n2 = 0;
            while (n2 < n && !this.stop) {
                boolean bl = this.resAcc.isDiscoveryDone();
                this.error = this.resAcc.getErrorMessage();
                if (this.error != null) {
                    this.showErrorDialog(this.error);
                    break;
                }
                this.doUpdateDiscoveryData();
                this.error = this.resAcc.getErrorMessage();
                if (this.error != null) {
                    this.showErrorDialog(this.error);
                    break;
                }
                if (bl) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                ++n2;
            }
            if (this.stop) {
                this.doStopDiscovery();
            }
        }
        this.resAcc.overrideDefaultStatus(false);
        this.resAcc.postStatus(SMFmConfGlobal.getI18NString("FINISHED"));
        this.performPostDiscoveryActions();
    }

    public abstract void showErrorDialog(String var1);

    public synchronized void stopDiscovery() {
        this.stop = true;
    }

    public abstract void updateDialogInformation(Map var1);
}

