/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.tools;

import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMRawDataRequestHandle;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmPortIdUtil;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmIteratorAsync;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.alarm.SMAlarmObjectResponse;
import com.sun.symon.base.server.types.StInteger;
import com.sun.symon.base.server.types.StString;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SMFmAlarmHandler
implements SMAlarmObjectResponse,
SMFmResourceAccessListener {
    private static final String MODULE_WRSM = "wci-wrsm";
    private static final String MODULE_WSSM = "wci-wssm";
    private static final String MANAGED_OBJECT_FMCONF_FM_PROPERTIES = "fm/properties";
    private static final String MANAGED_OBJECT_WRSM_LINK_STATUS_TABLE = "node/cluster/linkStatusTable";
    private static final String MANAGED_OBJECT_WRSM_LINK_STATUS_ENTRY = "node/cluster/linkStatusTable/linkStatusEntry";
    private static final String MANAGED_OBJECT_WSSM_LINK_STATUS_ENTRY = "globalDomain/linkStatusTable/linkStatusEntry";
    private static final String PROPERTY_FMCONF_XML_FILE_MOD_STATUS = "fabricXMLFileModStatus";
    private static final String PROPERTY_FMCONF_XML_FILE_MOD_TIME = "fabricXMLFileModTime";
    private static final String PROPERTY_FMCONF_XML_FILE_MOD_TRIGGER = "fabricXMLFileModTrigger";
    private static final String PROPERTY_FMCONF_FABRIC_STATUS = "status";
    private static final String[] PROPERTY_FMCONF = new String[]{"fabricXMLFileModStatus", "status"};
    private static final String PROPERTY_WRSM_LINK_VALID = "linkValid";
    private static final String PROPERTY_WRSM_LINK_STATE = "linkStatus";
    private static final String PROPERTY_WRSM_LINK_ERROR_TAKEDOWNS = "linkErrorTakedowns";
    private static final String PROPERTY_WRSM_LINK_CFG_TAKEDOWNS = "linkCFGTakedowns";
    private static final String PROPERTY_WRSM_LINK_FAILED_BRINGUPS = "linkFailedBringups";
    private static final String PROPERTY_WRSM_MAX_LINK_ERRORS = "maxLinkErrors";
    private static final String PROPERTY_WRSM_AVG_LINK_ERRORS = "avgLinkErrors";
    private static final String[] PROPERTY_WRSM = new String[]{"linkValid", "linkStatus", "linkErrorTakedowns", "linkCFGTakedowns", "linkFailedBringups", "maxLinkErrors", "avgLinkErrors"};
    private static final String PROPERTY_WSSM_LINK_STATE = "linkState";
    private static final String PROPERTY_WSSM_LINK_FAILOVER_CAUSE = "linkFailoverCause";
    private static final String PROPERTY_WSSM_MAX_LINK_ERRORS = "maxLinkErrors";
    private static final String PROPERTY_WSSM_AVG_LINK_ERRORS = "avgLinkErrors";
    private static final String[] PROPERTY_WSSM = new String[]{"linkState", "linkFailoverCause", "maxLinkErrors", "avgLinkErrors"};
    SMFmResourceAccess resAcc;
    String agentHostIP;
    String agentHostName;
    int agentPort;
    String fmconfModule;
    SMAlarmObjectRequest alreq = null;
    SMFmFabricData fabricData = null;
    long lastXMLChangedTime = 0L;

    public SMFmAlarmHandler(SMFmResourceAccess sMFmResourceAccess, String string, int n, String string2) {
        this.resAcc = sMFmResourceAccess;
        this.agentHostIP = string;
        this.agentHostName = this.getHostNameFromIp(string);
        this.agentPort = n;
        this.fmconfModule = string2;
        try {
            this.alreq = new SMAlarmObjectRequest(SMRawDataRequestHandle.dataReq, null);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace();
        }
        sMFmResourceAccess.addSMFmResourceAccessListener(this);
    }

    private void closeAsyncAlarmConnections() {
        SMFmConfGlobal.DebugPrint("AlarmHandler : NOTICE Closing async alarm connections");
        try {
            this.alreq.closeConnection();
            this.alreq = new SMAlarmObjectRequest(SMRawDataRequestHandle.dataReq, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        this.handleFabricUpdate(sMFmResourceAccessEvent);
    }

    public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        this.handleFabricUpdate(sMFmResourceAccessEvent);
    }

    public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        String string = sMFmResourceAccessEvent.getResAccCommand();
        if (string.equals("GetFabricObject") || string.equals("ApplyCfgToFab") || string.equals("RemNodeFromFabric")) {
            this.closeAsyncAlarmConnections();
        }
    }

    public void getAlarmResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object, SMAlarmIteratorAsync sMAlarmIteratorAsync) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        SMFmConfGlobal.DebugPrint("\nAlarmHandler : Received new set of alarms. size " + vector.size());
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < vector.size()) {
            block48: {
                String string;
                SMFmConfGlobal.DebugPrint("\nAlarmHandler : alarm " + n);
                SMAlarmObjectData sMAlarmObjectData = (SMAlarmObjectData)vector.get(n);
                String string2 = sMAlarmObjectData.getModule();
                String string3 = sMAlarmObjectData.getManagedObject();
                SMFmConfGlobal.DebugPrint("AlarmHandler : Module: " + string2);
                if (string2.equals(this.fmconfModule)) {
                    string = sMAlarmObjectData.getProperty();
                    SMFmConfGlobal.DebugPrint("AlarmHandler : Got Alarm For: " + string);
                    if (string.equals(PROPERTY_FMCONF_XML_FILE_MOD_STATUS)) {
                        try {
                            long l = this.getFabricXMLModTime();
                            if (l > this.lastXMLChangedTime) {
                                bl2 = true;
                                break;
                            }
                            SMFmConfGlobal.DebugPrint("AlarmHandler : No need to update for: fabricXMLFileModStatus:" + new Date(l) + ", we have this data");
                        }
                        catch (Exception exception) {
                            SMFmConfGlobal.DebugPrint("AlarmHandler : Could not get fabricXMLModTime");
                            exception.printStackTrace();
                        }
                    } else {
                        SMFmConfGlobal.DebugPrint("AlarmHandler : Ignoring");
                    }
                } else if (string2.endsWith(MODULE_WRSM) && string3.equals(MANAGED_OBJECT_WRSM_LINK_STATUS_ENTRY)) {
                    string = sMAlarmObjectData.getHost();
                    String string4 = sMAlarmObjectData.getMoURL();
                    String string5 = sMAlarmObjectData.getProperty();
                    String string6 = sMAlarmObjectData.getPropertyInstance();
                    String string7 = sMAlarmObjectData.getAlarmState();
                    String string8 = sMAlarmObjectData.getSeverity();
                    String string9 = sMAlarmObjectData.getAlarmId();
                    SMFmConfGlobal.DebugPrint("AlarmHandler : Alarm Recieved for RSM links");
                    SMFmConfGlobal.DebugPrint("AlarmHandler : moURL: " + string4);
                    SMFmConfGlobal.DebugPrint("AlarmHandler : For property: " + string5);
                    SMFmNodeData sMFmNodeData = this.fabricData.getMemberByHostName(string);
                    if (sMFmNodeData == null) {
                        SMFmConfGlobal.DebugPrint("AlarmHandler : Cannot find node for hostName: " + string);
                    } else {
                        SMFmConfGlobal.DebugPrint("AlarmHandler : Found corresponding node:" + sMFmNodeData.getScHost() + ":" + sMFmNodeData.getDomainId());
                        SMFmChassisData sMFmChassisData = this.fabricData.getChassisByName(sMFmNodeData.getScHost());
                        if (sMFmChassisData == null) {
                            SMFmConfGlobal.DebugPrint("AlarmHandler : Cannont find chassis for scHost: " + sMFmNodeData.getScHost());
                        } else {
                            SMFmConfGlobal.DebugPrint("AlarmHandler : Found corresponding chassis:" + sMFmChassisData.getScHost());
                            StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                            if (stringTokenizer.countTokens() != 3) {
                                SMFmConfGlobal.DebugPrint("AlarmHandler : Could not parse property instance " + string6);
                            } else {
                                stringTokenizer.nextToken();
                                String string10 = stringTokenizer.nextToken();
                                int n2 = SMFmPortIdUtil.getSlotNumber(string10, sMFmNodeData.getChassisType());
                                int n3 = SMFmPortIdUtil.getWciNumber(string10, sMFmNodeData.getChassisType());
                                int n4 = Integer.parseInt(stringTokenizer.nextToken().substring(0, 1));
                                String string11 = "\tsafariPortId: " + string10 + "\n" + "\tslot: " + n2 + "\n" + "\twci: " + n3 + "\n" + "\tparoli: " + n4;
                                SMFmConfGlobal.DebugPrint("AlarmHandler : Searching data structures for alarming link:\n" + string11);
                                SMFmPartitionData sMFmPartitionData = this.fabricData.getPartitionByLink(sMFmNodeData.getScHost(), sMFmNodeData.getDomainId(), n2, n3, n4);
                                if (sMFmPartitionData == null) {
                                    SMFmConfGlobal.DebugPrint("Cannot find partition for: " + sMFmNodeData.getScHost() + ":" + sMFmNodeData.getDomainId() + "." + n2 + "." + n3 + "." + n4);
                                } else {
                                    SMFmConfGlobal.DebugPrint("AlarmHandler : Found link in partition:" + sMFmPartitionData.getName());
                                    SMFmWciLinkData sMFmWciLinkData = sMFmPartitionData.getLinkByName(sMFmNodeData.getScHost(), sMFmNodeData.getDomainId(), n2, n3, n4);
                                    if (sMFmWciLinkData == null) {
                                        SMFmConfGlobal.DebugPrint("AlarmHandler : Could not find link for: " + string11);
                                    } else {
                                        AbstractList abstractList;
                                        SMFmConfGlobal.DebugPrint("AlarmHandler : Link is: " + sMFmWciLinkData);
                                        int n5 = 12;
                                        if (string5.equals(PROPERTY_WRSM_LINK_STATE)) {
                                            SMFmConfGlobal.DebugPrint("AlarmHandler : Getting current status for: " + string4);
                                            abstractList = new Vector<Object>();
                                            abstractList.add(string4);
                                            Vector vector2 = null;
                                            try {
                                                vector2 = SMRawDataRequestHandle.dataReq.getURLValue(abstractList);
                                            }
                                            catch (Exception exception) {
                                                SMFmConfGlobal.DebugPrint("Could not get state for: " + sMFmWciLinkData);
                                                exception.printStackTrace();
                                                break block48;
                                            }
                                            String string12 = ((StString)((Vector)vector2.get(0)).get(0)).getValue();
                                            n5 = SMFmConfGlobal.getRSMDriverLinkStatus(string12);
                                            SMFmConfGlobal.DebugPrint("AlarmHandler : Alarm Status reported by WRSM agent: " + SMFmConfGlobal.getLinkStatusString(n5));
                                            SMFmConfGlobal.DebugPrint("AlarmHandler : Current Status of link: " + SMFmConfGlobal.getLinkStatusString(sMFmWciLinkData.getStatus(PROPERTY_WRSM_LINK_STATE)));
                                            if (sMFmWciLinkData.getStatus(PROPERTY_WRSM_LINK_STATE) == n5) {
                                                SMFmConfGlobal.DebugPrint("AlarmHandler : NOTICE Alarm already known to handler");
                                            } else {
                                                SMFmConfGlobal.DebugPrint("AlarmHandler : NOTICE Connecting to FM to resolve alarm");
                                                this.resAcc.updatePartition(sMFmPartitionData.getName());
                                            }
                                            if (!string7.equals("C")) {
                                                this.registerForCloseAlarm(string9);
                                            }
                                        } else {
                                            abstractList = sMFmPartitionData.getLinksInRoutesByLinkName(sMFmNodeData.getScHost(), sMFmNodeData.getDomainId(), n2, n3, n4);
                                            if (abstractList == null) {
                                                SMFmConfGlobal.DebugPrint("AlarmHandler : Could not find a route containing: " + string11);
                                                abstractList = new ArrayList();
                                            } else {
                                                abstractList.addAll(abstractList);
                                            }
                                            abstractList.add(sMFmWciLinkData);
                                            if (string7.equals("C")) {
                                                SMFmAlarmHandler.removeLinkStatusEntrys(abstractList, string5);
                                            } else {
                                                if (string5.equals(PROPERTY_WRSM_LINK_VALID)) {
                                                    n5 = 6;
                                                } else if (string5.equals(PROPERTY_WRSM_LINK_ERROR_TAKEDOWNS)) {
                                                    n5 = 7;
                                                } else if (string5.equals(PROPERTY_WRSM_LINK_CFG_TAKEDOWNS)) {
                                                    n5 = 8;
                                                } else if (string5.equals(PROPERTY_WRSM_LINK_FAILED_BRINGUPS)) {
                                                    n5 = 9;
                                                } else if (string5.equals("maxLinkErrors")) {
                                                    n5 = 10;
                                                } else if (string5.equals("avgLinkErrors")) {
                                                    n5 = 11;
                                                }
                                                SMFmConfGlobal.DebugPrint("AlarmHandler : Alarm Status reported by WRSM agent: " + SMFmConfGlobal.getLinkStatusString(n5));
                                                SMFmAlarmHandler.setLinkStatusEntrys(abstractList, string5, n5, SMFmConfGlobal.getAlarmSeverity(string8));
                                                this.registerForCloseAlarm(string9);
                                            }
                                        }
                                        sMFmPartitionData.updateRouteStatusAndSeverity();
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    SMFmConfGlobal.DebugPrint("AlarmHandler : ignoring");
                }
            }
            ++n;
        }
        SMFmConfGlobal.DebugPrint("\nAlarmHandler : Processed alarm set");
        if (bl) {
            this.fabricData.updateNodeStatusAndSeverity();
            this.fabricData.updateChassisStatusAndSeverity();
            SMFmConfGlobal.DebugPrint("AlarmHandler : Updating the Agent");
            try {
                this.getAndSetLastXMLChangedTime();
            }
            catch (Exception exception) {
                SMFmConfGlobal.DebugPrint("AlarmHandler: Could not get fabricXMLModTime");
                exception.printStackTrace();
            }
            SMFmConfGlobal.DebugPrint("AlarmHandler : Updating the GUI");
            this.resAcc.fabricAlarmStateChanged();
        } else if (bl2) {
            SMFmConfGlobal.DebugPrint("AlarmHandler : Doing fabricUpdate");
            this.resAcc.updateFabricData(false);
        }
    }

    public void getAndSetLastXMLChangedTime() throws SMAPIException {
        this.lastXMLChangedTime = this.getFabricXMLModTime();
    }

    public long getFabricXMLModTime() throws SMAPIException {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        Vector<StString> vector3 = new Vector<StString>();
        String string = SMRawDataRequest.createURL((String)this.agentHostIP, (int)this.agentPort, (String)this.fmconfModule, (String)"", (String)"", (String)"", (String)"", (String)"");
        String string2 = SMRawDataRequest.createURL((String)string, (String)"fm.properties", (String)"fabricXMLFileModTrigger#0", (String)"", (String)"");
        vector.addElement(string2);
        vector3.addElement(new StString("1"));
        vector2.addElement(vector3);
        SMRawDataRequestHandle.dataReq.setURLValue(vector, vector2);
        string2 = SMRawDataRequest.createURL((String)string, (String)"fm.properties", (String)"fabricXMLFileModTime#0", (String)"", (String)"");
        vector.clear();
        vector.add(string2);
        vector2 = SMRawDataRequestHandle.dataReq.getURLValue(vector);
        long l = 1000L * ((StInteger)((Vector)vector2.get(0)).get(0)).getValue().longValue();
        SMFmConfGlobal.DebugPrint("Got xmlModTime: " + new Date(l));
        return l;
    }

    private String getHostNameFromIp(String string) {
        try {
            if (string != null && !string.equals("")) {
                return InetAddress.getByName(string).getHostName();
            }
            SMFmConfGlobal.DebugPrint("Error: Attempt to lookup null IP address");
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return null;
    }

    private String getIPFromHostName(String string) {
        try {
            if (string != null && !string.equals("")) {
                return InetAddress.getByName(string).getHostAddress();
            }
            SMFmConfGlobal.DebugPrint("Error: Attempt to lookup null IP address");
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return null;
    }

    private void handleFabricUpdate(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
        this.fabricData = sMFmResourceAccessEvent.getFabricData();
        String string = sMFmResourceAccessEvent.getResAccCommand();
        SMFmConfGlobal.DebugPrint("Alarm handler got update notice for: " + string);
        if (string.equals("GetFabricObject")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.agentHostName);
            arrayList.addAll(this.fabricData.getMembersHostNames());
            SMFmConfGlobal.DebugPrint("Trying to open: " + arrayList);
            this.openAsyncAlarmConnections(arrayList.toArray(new String[arrayList.size()]));
        } else if (string.equals("AddNodeToFabric")) {
            if (sMFmResourceAccessEvent.getEventObject() instanceof SMFmNodeData) {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)sMFmResourceAccessEvent.getEventObject();
                if (sMFmNodeData == null) {
                    SMFmConfGlobal.DebugPrint("Warning: no node with associated event");
                    return;
                }
                String[] stringArray = new String[]{sMFmNodeData.getHostName()};
                this.openAsyncAlarmConnections(stringArray);
            } else {
                SMFmConfGlobal.DebugPrint("Notice: will not open alarms for attempted add node");
            }
        } else if (string.equals("RemNodeFromFabric")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.agentHostName);
            arrayList.addAll(this.fabricData.getMembersHostNames());
            SMFmConfGlobal.DebugPrint("Trying to open: " + arrayList);
            this.openAsyncAlarmConnections(arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private void openAsyncAlarmConnections(String[] stringArray) {
        try {
            if (stringArray == null) {
                return;
            }
            SMFmConfGlobal.DebugPrint("**** Registering for alarms ****");
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && !stringArray[n].equals("")) {
                    string = String.valueOf(string) + " {" + stringArray[n].trim() + "}";
                }
                ++n;
            }
            if ((string = string.trim()).equals("")) {
                return;
            }
            SMFmConfGlobal.DebugPrint("Requesting alarms for: <" + string + ">");
            this.alreq.getAlarms("0", string, null, null, "{O}", null, null, null, null, (SMAlarmObjectResponse)this, new Object());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void registerForCloseAlarm(String string) {
        try {
            SMFmConfGlobal.DebugPrint("AlarmHandler : Registering for close alarmID" + string);
            this.alreq.getAlarms("1", null, null, null, "{C}", null, null, null, string, (SMAlarmObjectResponse)this, new Object());
        }
        catch (Exception exception) {
            SMFmConfGlobal.DebugPrint("AlarmHandler : Could not register for return alarmID: " + string);
            exception.printStackTrace();
        }
    }

    private static void removeLinkStatusEntrys(List list, String string) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)list.get(n);
            sMFmWciLinkData.removeStatusEntry(string);
            ++n;
        }
    }

    public void setAlarmResponse(SMRequestStatus sMRequestStatus, Object object) {
    }

    private static void setLinkStatusEntrys(List list, String string, int n, int n2) {
        int n3 = 0;
        while (n3 < list.size()) {
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)list.get(n3);
            sMFmWciLinkData.setStatus(string, n, n2);
            ++n3;
        }
    }
}

