/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmGraphicInterface;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmNodePopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMRawDataRequestHandle;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.base.client.SMResourceAccess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SMFmWnodeGraphic
extends JLabel
implements SMFmGraphicInterface {
    private static final int LG_TEXT_WIDTH = 80;
    private static final int LG_TEXT_HEIGHT = 12;
    private static final float LG_FONT_SIZE = 11.0f;
    private static final int SM_TEXT_WIDTH = 50;
    private static final int SM_TEXT_HEIGHT = 10;
    private static final float SM_FONT_SIZE = 8.0f;
    private static final int ICON_TEXT_GAP = 2;
    private int type;
    private SMFmNodePopupMenu POPUP_MENU;
    private int xCoord;
    private int yCoord;
    private int iconWidth;
    private int iconHeight;
    int size;
    private int textWidth;
    private int textHeight;
    float fontSize;
    private SMFmFabricData fabricData;
    private SMFmNodeData nodeData;
    JLabel textLabel;
    SMFmResourceAccess resAcc;

    public SMFmWnodeGraphic(SMFmNodeData sMFmNodeData, int n, int n2, int n3, SMFmResourceAccess sMFmResourceAccess) {
        this.resAcc = sMFmResourceAccess;
        this.POPUP_MENU = new SMFmNodePopupMenu(sMFmResourceAccess);
        this.textLabel = new JLabel();
        this.fabricData = this.fabricData;
        this.nodeData = sMFmNodeData;
        this.type = 0;
        this.setOpaque(false);
        this.xCoord = n;
        this.yCoord = n2;
        this.setIconSize(n3);
        this.setIconTextGap(2);
        this.setToolTipText(SMFmConfGlobal.getI18NString("WILDCAT_NODE"));
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public static int getIconHeight(int n) {
        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMRawDataRequestHandle.dataReq);
        if (n == 0) {
            ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("fmimages/wnode_sm.gif"));
            return imageIcon.getIconHeight();
        }
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("fmimages/wnode_lg.gif"));
        return imageIcon.getIconHeight();
    }

    public int getIconSize() {
        return this.size;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public static int getIconWidth(int n) {
        SMResourceAccess sMResourceAccess = new SMResourceAccess(SMRawDataRequestHandle.dataReq);
        if (n == 0) {
            ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("fmimages/wnode_sm.gif"));
            return imageIcon.getIconWidth();
        }
        ImageIcon imageIcon = new ImageIcon(sMResourceAccess.getImage("fmimages/wnode_lg.gif"));
        return imageIcon.getIconWidth();
    }

    public String getInfobarText() {
        String string = String.valueOf(SMFmConfGlobal.getI18NString("SC_HOST_COLON")) + " " + this.nodeData.getScHost() + " " + SMFmConfGlobal.getI18NString("DOMAIN_ID_COLON") + " " + this.nodeData.getDomainId();
        return string;
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }

    public int getTotalHeight() {
        return this.iconHeight + this.textHeight + this.getIconTextGap();
    }

    public static int getTotalHeight(int n) {
        int n2 = n == 1 ? 12 : 10;
        return SMFmWnodeGraphic.getIconHeight(n) + n2 + 2;
    }

    public int getTotalWidth() {
        return this.iconWidth > this.textWidth ? this.iconWidth : this.textWidth;
    }

    public static int getTotalWidth(int n) {
        int n2 = n == 1 ? 80 : 50;
        return SMFmWnodeGraphic.getIconWidth(n) > n2 ? SMFmWnodeGraphic.getIconWidth(n) : n2;
    }

    public int getType() {
        return this.type;
    }

    public Object getUserObject() {
        return this.nodeData;
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public void grayOut() {
        this.setEnabled(false);
    }

    public void highlight() {
        this.setBorder(BorderFactory.createLineBorder(SMFmGraphicInterface.HIGHLIGHT_COLOR, 1));
        ++this.iconWidth;
        ++this.iconHeight;
        --this.xCoord;
        --this.yCoord;
        this.setIconTextGap(this.getIconTextGap() - 1);
        this.setBounds(this.xCoord, this.yCoord, this.iconWidth, this.iconHeight);
        this.setPreferredSize(new Dimension(this.iconWidth, this.iconHeight));
        this.setSize(new Dimension(this.iconWidth, this.iconHeight));
        this.setMaximumSize(new Dimension(this.iconWidth, this.iconHeight));
        this.repaint();
        this.revalidate();
    }

    public void redraw() {
        Image image = null;
        int n = this.nodeData.getStatusSeverity();
        if (this.size == 1) {
            image = this.resAcc.getImage("fmimages/wnode_lg.gif");
            this.setDisabledIcon(new ImageIcon(this.resAcc.getImage("fmimages/wnode_gray_lg.gif")));
            this.textWidth = 80;
            this.textHeight = 12;
            this.fontSize = 11.0f;
        } else if (this.size == 0) {
            image = this.resAcc.getImage("fmimages/wnode_sm.gif");
            this.setDisabledIcon(new ImageIcon(this.resAcc.getImage("fmimages/wnode_gray_sm.gif")));
            this.textWidth = 50;
            this.textHeight = 10;
            this.fontSize = 8.0f;
        }
        this.setIcon(new ImageIcon(image));
        this.iconWidth = this.getIcon().getIconWidth();
        this.iconHeight = this.getIcon().getIconHeight();
        this.setBounds(this.xCoord, this.yCoord, this.iconWidth, this.iconHeight);
        this.setPreferredSize(new Dimension(this.iconWidth, this.iconHeight));
        this.setSize(new Dimension(this.iconWidth, this.iconHeight));
        this.setMaximumSize(new Dimension(this.iconWidth, this.iconHeight));
        int n2 = this.xCoord + (this.iconWidth - this.textWidth) / 2;
        int n3 = this.yCoord + this.iconHeight + this.getIconTextGap();
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(this.fontSize));
        this.textLabel.setHorizontalAlignment(0);
        this.textLabel.setText(String.valueOf(this.nodeData.getScHost()) + ":" + this.nodeData.getDomainId());
        this.textLabel.setToolTipText(String.valueOf(this.nodeData.getScHost()) + ":" + this.nodeData.getDomainId());
        this.textLabel.setBounds(n2, n3, this.textWidth, this.textHeight);
    }

    public void setIconSize(int n) {
        this.size = n;
        this.redraw();
    }

    public void setLocation(int n, int n2) {
        this.xCoord = n;
        this.yCoord = n2;
        this.redraw();
    }

    public void setUserObject(Object object) {
        this.nodeData = (SMFmNodeData)object;
    }

    public void showDetailsDialog() {
        SMFmWnodeDetailsDialog sMFmWnodeDetailsDialog = new SMFmWnodeDetailsDialog((Frame)((JFrame)this.getTopLevelAncestor()), this.nodeData, this.resAcc);
        sMFmWnodeDetailsDialog.setLocationRelativeTo(this);
        sMFmWnodeDetailsDialog.show();
    }

    public void showPopupMenu(Component component, int n, int n2) {
        this.POPUP_MENU.show(component, n, n2);
    }

    public void unhighlight() {
        this.setBorder(null);
        --this.iconWidth;
        --this.iconHeight;
        ++this.xCoord;
        ++this.yCoord;
        this.setIconTextGap(this.getIconTextGap() + 1);
        this.setBounds(this.xCoord, this.yCoord, this.iconWidth, this.iconHeight);
        this.setPreferredSize(new Dimension(this.iconWidth, this.iconHeight));
        this.setSize(new Dimension(this.iconWidth, this.iconHeight));
        this.setMaximumSize(new Dimension(this.iconWidth, this.iconHeight));
        this.repaint();
        this.revalidate();
    }
}

