/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.AbstractTreeTableModel;
import com.sun.symon.apps.common.JTreeTable;
import com.sun.symon.apps.common.TreeTableModel;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmRemoteEnd;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmCommonTreeNode;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmToolTipTableHeader;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class SMFmWnodeDetailsDialog
extends SMFmAbstractBaseDialog {
    protected static String[] cNames = new String[]{SMFmConfGlobal.getI18NString("MODE"), SMFmConfGlobal.getI18NString("WCIS"), SMFmConfGlobal.getI18NString("LINK_INFO")};
    protected static String[] colToolTipStrings = new String[]{SMFmConfGlobal.getI18NString("TT_WN_DET_STATUS_COLUMN"), SMFmConfGlobal.getI18NString("TT_WN_DET_WCIS_COLUMN"), SMFmConfGlobal.getI18NString("TT_WN_DET_LINK_INFO_COLUMN")};
    protected static Class[] cTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SMFmWnodeDetailsDialog.class$("java.lang.String")), class$com$sun$symon$apps$common$TreeTableModel != null ? class$com$sun$symon$apps$common$TreeTableModel : (class$com$sun$symon$apps$common$TreeTableModel = SMFmWnodeDetailsDialog.class$("com.sun.symon.apps.common.TreeTableModel")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SMFmWnodeDetailsDialog.class$("java.lang.String"))};
    private JLabel nodeMode = new JLabel();
    private JLabel scHost = new JLabel();
    private JLabel scDomainId = new JLabel();
    private JLabel scIpAdd = new JLabel();
    private JLabel solarisHostName = new JLabel();
    private JLabel solarisIpAdd = new JLabel();
    private JLabel chassisType = new JLabel();
    private JTextField ncSlices = new JTextField();
    private JTextField agentPort = new JTextField();
    private JTextField proxyAgent = new JTextField();
    private JTextArea physicalLoc = new JTextArea(3, 0);
    private int chassisTypeInt;
    private int alarmSeverity;
    private boolean[] selection = new boolean[4];
    private String[] initValues = new String[4];
    private TreeTableModel tableModel;
    private SMFmCommonTreeNode rootNode = new SMFmCommonTreeNode("Root", 0);
    private SMFmCommonTreeNode wciNodes;
    private JButton closeButton;
    private JButton applyButton;
    private JTreeTable table;
    private JLabel nodeLabel;
    private JLabel hostLabel;
    private JLabel domainLabel;
    private JLabel scIpLabel;
    private JLabel typeLabel;
    private JLabel solHostLabel;
    private JLabel solIPLabel;
    private JPanel contentPanel;
    private SMFmNodeData node;
    private SMFmResourceAccessListener resAccListener;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$symon$apps$common$TreeTableModel;

    public SMFmWnodeDetailsDialog(Dialog dialog, SMFmNodeData sMFmNodeData, SMFmResourceAccess sMFmResourceAccess) {
        super(dialog, sMFmResourceAccess, String.valueOf(SMFmConfGlobal.getI18NString("NODE_DETAILS_TITLE")) + " " + sMFmNodeData.getScHost() + ":" + sMFmNodeData.getDomainId(), 2, true, false);
        this.node = sMFmNodeData;
        this.buildDialog();
    }

    public SMFmWnodeDetailsDialog(Frame frame, SMFmNodeData sMFmNodeData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, String.valueOf(SMFmConfGlobal.getI18NString("NODE_DETAILS_TITLE")) + " " + sMFmNodeData.getScHost() + ":" + sMFmNodeData.getDomainId(), 2, true, false);
        this.node = sMFmNodeData;
        this.buildDialog();
    }

    public void addButtonsToPanel() {
        this.applyButton = new JButton(SMFmConfGlobal.getI18NString("applyButton.label"));
        this.applyButton.setMnemonic(SMFmConfGlobal.getI18NString("applyButton.mnemonic").charAt(0));
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.applyButton);
    }

    private void addListeners() {
        this.ncSlices.getDocument().addDocumentListener(new DocListener(0));
        this.agentPort.getDocument().addDocumentListener(new DocListener(1));
        this.proxyAgent.getDocument().addDocumentListener(new DocListener(2));
        this.physicalLoc.getDocument().addDocumentListener(new DocListener(3));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SMFmWnodeDetailsDialog.this.checkInt(SMFmWnodeDetailsDialog.this.agentPort, SMFmConfGlobal.getI18NString("AGENT_PORT_MUST_BE_INTEGER")) && SMFmWnodeDetailsDialog.this.checkInt(SMFmWnodeDetailsDialog.this.ncSlices, SMFmConfGlobal.getI18NString("NC_SLICES_MUST_BE_INTEGER"))) {
                    if (SMFmWnodeDetailsDialog.this.selection[1] || SMFmWnodeDetailsDialog.this.selection[2] || SMFmWnodeDetailsDialog.this.selection[3]) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("agent_port", SMFmWnodeDetailsDialog.this.agentPort.getText().trim());
                        hashMap.put("proxy_host", SMFmWnodeDetailsDialog.this.proxyAgent.getText().trim());
                        hashMap.put("physical_loc", SMFmWnodeDetailsDialog.this.physicalLoc.getText().trim());
                        SMFmWnodeDetailsDialog.this.updateNodeProperties(SMFmWnodeDetailsDialog.this.node.getScHost(), SMFmWnodeDetailsDialog.this.node.getDomainId(), hashMap);
                    }
                    if (SMFmWnodeDetailsDialog.this.selection[0]) {
                        SMFmWnodeDetailsDialog.this.updateNodeNCSlices(SMFmWnodeDetailsDialog.this.node.getScHost(), SMFmWnodeDetailsDialog.this.node.getDomainId(), Integer.parseInt(SMFmWnodeDetailsDialog.this.ncSlices.getText().trim()));
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmWnodeDetailsDialog.this.closeDialog();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmWnodeDetailsDialog.this.closeDialog();
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmWnodeDetailsDialog.this.tryToEnableApply();
                SMFmWnodeDetailsDialog.this.enableEditableFields(true);
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmFabricData sMFmFabricData = sMFmResourceAccessEvent.getFabricData();
                if (sMFmFabricData != null) {
                    SMFmNodeData sMFmNodeData = sMFmFabricData.getMemberByName(SMFmWnodeDetailsDialog.this.node.getScHost(), SMFmWnodeDetailsDialog.this.node.getDomainId());
                    if (sMFmNodeData != null) {
                        SMFmWnodeDetailsDialog.this.node = sMFmNodeData;
                        SMFmWnodeDetailsDialog.this.procNodeForStatData();
                        SMFmWnodeDetailsDialog.this.procNodeForTableData();
                        SMFmWnodeDetailsDialog.this.applyButton.setEnabled(false);
                        SMFmWnodeDetailsDialog.this.enableEditableFields(true);
                    } else {
                        SMFmConfGlobal.DebugPrint("Warning: SMFmWnodeDeatialsDilaog: node " + SMFmWnodeDetailsDialog.this.node.getScHost() + ":" + SMFmWnodeDetailsDialog.this.node.getDomainId() + " was removed unexpectedly, exiting");
                        SMFmWnodeDetailsDialog.this.closeDialog();
                    }
                } else {
                    SMFmConfGlobal.DebugPrint("Warning: SMFmWnodeDeatialsDilaog: node " + SMFmWnodeDetailsDialog.this.node.getScHost() + ":" + SMFmWnodeDetailsDialog.this.node.getDomainId() + " was removed unexpectedly, exiting");
                    SMFmWnodeDetailsDialog.this.closeDialog();
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmWnodeDetailsDialog.this.applyButton.setEnabled(false);
                SMFmWnodeDetailsDialog.this.enableEditableFields(false);
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void addParolisToNode(SMFmCommonTreeNode sMFmCommonTreeNode, SMFmRemoteEnd[] sMFmRemoteEndArray) {
        if (sMFmRemoteEndArray == null || sMFmCommonTreeNode == null) {
            return;
        }
        int n = 0;
        while (n < sMFmRemoteEndArray.length) {
            if (sMFmRemoteEndArray[n] != null && sMFmRemoteEndArray[n].getSCName() != null) {
                SMFmCommonTreeNode sMFmCommonTreeNode2 = new SMFmCommonTreeNode(String.valueOf(SMFmConfGlobal.getI18NString("PAROLI_FIRST_LETTER")) + n, 8, false);
                sMFmCommonTreeNode2.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_PORT"));
                sMFmCommonTreeNode2.setOptTextNode(true);
                sMFmCommonTreeNode2.putOptText("LINK INFO", sMFmRemoteEndArray[n].toString());
                sMFmCommonTreeNode2.setUserObject(sMFmRemoteEndArray[n]);
                sMFmCommonTreeNode.add(sMFmCommonTreeNode2);
            }
            ++n;
        }
    }

    private void addWcisToNode(SMFmCommonTreeNode sMFmCommonTreeNode, List list) {
        if (list == null || sMFmCommonTreeNode == null) {
            return;
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            SMFmWciData sMFmWciData = (SMFmWciData)list.get(n2);
            SMFmCommonTreeNode sMFmCommonTreeNode2 = new SMFmCommonTreeNode(String.valueOf(SMFmConfGlobal.getI18NString("SLOT_FIRST_LETTER")) + sMFmWciData.getSlot() + "." + SMFmConfGlobal.getI18NString("WCI_FIRST_LETTER") + sMFmWciData.getWci(), 5);
            sMFmCommonTreeNode2.setUserObject(sMFmWciData);
            sMFmCommonTreeNode2.setOptTextNode(true);
            sMFmCommonTreeNode2.putOptText("STATUS", SMFmConfGlobal.getModeString(sMFmWciData.getMode()));
            sMFmCommonTreeNode2.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_WCI"));
            sMFmCommonTreeNode.add(sMFmCommonTreeNode2);
            this.addParolisToNode(sMFmCommonTreeNode2, sMFmWciData.getRemoteEnds());
            ++n2;
        }
    }

    private boolean anySelected(boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void buildDialog() {
        this.procNodeForStatData();
        this.procNodeForTableData();
        this.initComponents();
        this.addListeners();
        this.applyButton.setEnabled(false);
        this.pack();
    }

    private boolean checkInt(JTextComponent jTextComponent, String string) {
        String string2 = jTextComponent.getText().trim();
        if (string2 == null || string2.equals("") || !SMFmConfGlobal.isInteger(string2)) {
            JOptionPane.showMessageDialog(this, string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void closeDialog() {
        this.resAcc.removeStatusJLabel(this.status);
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private JPanel createDetailsPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(String.valueOf(SMFmConfGlobal.getI18NString("MEMORY")) + ":");
        jLabel.setHorizontalAlignment(2);
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_NC_SLICES"));
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("SUNMC_AGENT_PORT"));
        jLabel2.setHorizontalAlignment(2);
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_AGENT_PORT"));
        JLabel jLabel3 = new JLabel(SMFmConfGlobal.getI18NString("SUNMC_AGENT_PROXY_HOSTNAME"));
        jLabel3.setHorizontalAlignment(2);
        jLabel3.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_AGENT_PROXY_HOSTNAME"));
        this.ncSlices.setForeground(Color.black);
        this.ncSlices.setHorizontalAlignment(2);
        this.ncSlices.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_NC_SLICES"));
        this.agentPort.setForeground(Color.black);
        this.agentPort.setHorizontalAlignment(2);
        this.agentPort.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_AGENT_PORT"));
        this.proxyAgent.setForeground(Color.black);
        this.proxyAgent.setHorizontalAlignment(2);
        this.proxyAgent.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_AGENT_PROXY_HOSTNAME"));
        JLabel jLabel4 = new JLabel(SMFmConfGlobal.getI18NString("PHYSICAL_LOCATION"));
        jLabel4.setHorizontalAlignment(2);
        jLabel4.setVerticalAlignment(1);
        jLabel4.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_PHYSICAL_LOCATION"));
        this.physicalLoc.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_PHYSICAL_LOCATION"));
        this.physicalLoc.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)this.ncSlices, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.agentPort, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.proxyAgent, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.physicalLoc, gridBagConstraints);
        return jPanel;
    }

    private JPanel createNodeInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.hostLabel);
        jPanel.add(this.domainLabel);
        jPanel.add(this.scIpLabel);
        jPanel.add(this.typeLabel);
        jPanel.add(this.solHostLabel);
        jPanel.add(this.solIPLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(this.scHost);
        jPanel2.add(this.scDomainId);
        jPanel2.add(this.scIpAdd);
        jPanel2.add(this.chassisType);
        jPanel2.add(this.solarisHostName);
        jPanel2.add(this.solarisIpAdd);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        Image image = this.resAcc.getImage("fmimages/wnode_lg.gif");
        jPanel3.add(new JLabel(new ImageIcon(image)));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        return jPanel4;
    }

    private JPanel createSwitchInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.hostLabel);
        jPanel.add(this.scIpLabel);
        jPanel.add(this.typeLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(this.scHost);
        jPanel2.add(this.scIpAdd);
        jPanel2.add(this.chassisType);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        Image image = this.resAcc.getImage("fmimages/switch_large.gif");
        jPanel3.add(new JLabel(new ImageIcon(image)));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel4.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel4.add((Component)jPanel3, gridBagConstraints);
        return jPanel4;
    }

    private JPanel createTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("WCI_INFO_COLON"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.table = new JTreeTable(this.tableModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                    return null;
                }
                TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                return ((SMFmCommonTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1)).getToolTipText();
            }
        };
        this.table.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.table){

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
                super.paint(graphics);
            }
        };
        SMFmToolTipTableHeader sMFmToolTipTableHeader = new SMFmToolTipTableHeader(this.table.getColumnModel());
        sMFmToolTipTableHeader.setToolTipStrings(colToolTipStrings);
        this.table.setTableHeader(sMFmToolTipTableHeader);
        this.table.getTree().setRootVisible(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        Dimension dimension = new Dimension(340, 200);
        jPanel.setMinimumSize(dimension);
        jPanel.setPreferredSize(dimension);
        return jPanel;
    }

    private void enableEditableFields(boolean bl) {
        this.agentPort.setEnabled(bl);
        this.ncSlices.setEnabled(bl);
        this.proxyAgent.setEnabled(bl);
        this.physicalLoc.setEnabled(bl);
    }

    private void initCommonComponents() {
        this.nodeLabel = new JLabel(SMFmConfGlobal.getI18NString("MODE_COLON"));
        this.nodeLabel.setHorizontalAlignment(2);
        this.nodeLabel.setToolTipText(SMFmConfGlobal.getI18NString("MODE"));
        this.hostLabel = new JLabel(SMFmConfGlobal.getI18NString("SC_HOST_NAME"));
        this.hostLabel.setHorizontalAlignment(2);
        this.hostLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SC_HOSTNAME"));
        this.domainLabel = new JLabel(SMFmConfGlobal.getI18NString("DOMAIN_ID_COLON"));
        this.domainLabel.setHorizontalAlignment(2);
        this.domainLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_DOMAIN_ID"));
        this.scIpLabel = new JLabel(SMFmConfGlobal.getI18NString("SC_IP_ADDRESS"));
        this.scIpLabel.setHorizontalAlignment(2);
        this.scIpLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SC_IP_ADDRESS"));
        this.typeLabel = new JLabel(SMFmConfGlobal.getI18NString("CHASSIS_TYPE_COLON"));
        this.typeLabel.setHorizontalAlignment(2);
        this.typeLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_CHASSIS_TYPE"));
        this.solHostLabel = new JLabel(SMFmConfGlobal.getI18NString("SOLARIS_HOST_NAME_COLON"));
        this.solHostLabel.setHorizontalAlignment(2);
        this.solHostLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SOLARIS_HOSTNAME"));
        this.solIPLabel = new JLabel(SMFmConfGlobal.getI18NString("SOLARIS_IP_ADDRESS"));
        this.solIPLabel.setHorizontalAlignment(2);
        this.solIPLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SOLARIS_IP_ADDRESS"));
        this.nodeMode.setForeground(Color.black);
        this.nodeMode.setHorizontalAlignment(2);
        this.nodeMode.setToolTipText(SMFmConfGlobal.getI18NString("MODE"));
        this.scHost.setForeground(Color.black);
        this.scHost.setHorizontalAlignment(2);
        this.scHost.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SC_HOSTNAME"));
        this.scDomainId.setForeground(Color.black);
        this.scDomainId.setHorizontalAlignment(2);
        this.scDomainId.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_DOMAIN_ID"));
        this.scIpAdd.setForeground(Color.black);
        this.scIpAdd.setHorizontalAlignment(2);
        this.scIpAdd.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SC_IP_ADDRESS"));
        this.chassisType.setForeground(Color.black);
        this.chassisType.setHorizontalAlignment(2);
        this.chassisType.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_CHASSIS_TYPE"));
        this.solarisHostName.setForeground(Color.black);
        this.solarisHostName.setHorizontalAlignment(2);
        this.solarisHostName.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SOLARIS_HOSTNAME"));
        this.solarisIpAdd.setForeground(Color.black);
        this.solarisIpAdd.setHorizontalAlignment(2);
        this.solarisIpAdd.setToolTipText(SMFmConfGlobal.getI18NString("TT_WN_DET_SOLARIS_IP_ADDRESS"));
    }

    private void initComponents() {
        this.contentPanel = new JPanel(new GridBagLayout());
        this.initCommonComponents();
        JPanel jPanel = this.chassisTypeInt != 5 ? this.createNodeInfoPanel() : this.createSwitchInfoPanel();
        JPanel jPanel2 = this.createDetailsPanel();
        this.updateTableModel();
        JPanel jPanel3 = this.createTablePanel();
        this.addButtonsToPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.contentPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.contentPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.contentPanel.add((Component)jPanel3, gridBagConstraints);
        this.addToMainPanel(this.contentPanel);
    }

    private void procNodeForStatData() {
        if (this.node != null) {
            this.nodeMode.setText(SMFmConfGlobal.getModeString(this.node.getOpMode()));
            this.scHost.setText(this.node.getScHost());
            this.scDomainId.setText(this.node.getDomainId());
            this.scIpAdd.setText(this.node.getIpAddress());
            this.chassisType.setText(SMFmConfGlobal.getChassisString(this.node.getChassisType()));
            this.chassisTypeInt = this.node.getChassisType();
            this.alarmSeverity = this.node.getStatusSeverity();
            this.solarisHostName.setText(this.node.getHostName() == null ? "" : this.node.getHostName());
            this.solarisIpAdd.setText(this.node.getHostIpAddress() == null ? "" : this.node.getHostIpAddress());
            this.ncSlices.setText(String.valueOf(this.node.getNCSlice()));
            this.initValues[0] = this.ncSlices.getText();
            this.agentPort.setText(String.valueOf(this.node.getAgentPort()));
            this.initValues[1] = this.agentPort.getText();
            this.proxyAgent.setText(this.node.getProxyAgentHostName() == null ? "" : this.node.getProxyAgentHostName());
            this.initValues[2] = this.proxyAgent.getText();
            this.physicalLoc.setText(this.node.getPhysicalLocation() == null ? "" : this.node.getPhysicalLocation());
            this.initValues[3] = this.physicalLoc.getText();
            if (this.chassisTypeInt == 5) {
                this.setTitle(SMFmConfGlobal.getI18NString("SWITCH_DETAILS_TITLE"));
            }
            this.ncSlices.setEditable(false);
        }
    }

    private void procNodeForTableData() {
        this.rootNode.removeAllChildren();
        if (this.node != null) {
            this.addWcisToNode(this.rootNode, this.node.getInUseWcis());
            this.addWcisToNode(this.rootNode, this.node.getIdleWcis());
        }
    }

    private void tryToEnableApply() {
        if (this.anySelected(this.selection)) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    private void updateNodeNCSlices(final String string, final String string2, final int n) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                resAcc.updateNodeNCSlices(string, string2, n);
                String string3 = resAcc.getErrorMessage();
                if (string3 != null) {
                    JOptionPane.showMessageDialog(this, string3, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                }
            }
        });
        thread.start();
    }

    private void updateNodeProperties(final String string, final String string2, final Map map) {
        System.out.println(map);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                resAcc.updateNodeProperties(string, string2, map);
                String string3 = resAcc.getErrorMessage();
                if (string3 != null) {
                    JOptionPane.showMessageDialog(this, string3, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                }
            }
        });
        thread.start();
    }

    private void updateStringArray(String[] stringArray, JTextComponent[] jTextComponentArray) {
        if (stringArray.length != jTextComponentArray.length) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < jTextComponentArray.length) {
            stringArray[n] = jTextComponentArray[n].getText();
            ++n;
        }
    }

    private void updateTableModel() {
        this.tableModel = new SMFmNodeDetailsTreeModel(this.rootNode);
        if (this.table != null) {
            this.table.setModel((TableModel)((Object)this.tableModel));
        }
    }

    class DocListener
    implements DocumentListener {
        int selIndex;

        public DocListener(int n) {
            this.selIndex = n;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        private void checkLength(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = document.getLength();
            String string = "";
            try {
                string = document.getText(0, n).trim();
            }
            catch (Exception exception) {}
            if (!string.equals(SMFmWnodeDetailsDialog.this.initValues[this.selIndex])) {
                ((SMFmWnodeDetailsDialog)SMFmWnodeDetailsDialog.this).selection[this.selIndex] = true;
                SMFmWnodeDetailsDialog.this.tryToEnableApply();
            } else {
                ((SMFmWnodeDetailsDialog)SMFmWnodeDetailsDialog.this).selection[this.selIndex] = false;
                SMFmWnodeDetailsDialog.this.tryToEnableApply();
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }
    }

    class SMFmNodeDetailsTreeModel
    extends AbstractTreeTableModel
    implements TreeTableModel {
        public SMFmNodeDetailsTreeModel(SMFmCommonTreeNode sMFmCommonTreeNode) {
            super(sMFmCommonTreeNode);
        }

        public void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            super.fireTreeStructureChanged(object, objectArray, nArray, objectArray2);
        }

        public Object getChild(Object object, int n) {
            return ((SMFmCommonTreeNode)object).getChildAt(n);
        }

        public int getChildCount(Object object) {
            int n = ((SMFmCommonTreeNode)object).getChildCount();
            return n;
        }

        public Class getColumnClass(int n) {
            return cTypes[n];
        }

        public int getColumnCount() {
            return cNames.length;
        }

        public String getColumnName(int n) {
            return cNames[n];
        }

        public Object getValueAt(Object object, int n) {
            try {
                switch (n) {
                    case 0: {
                        return ((SMFmCommonTreeNode)object).isOptTextNode() ? ((SMFmCommonTreeNode)object).getOptText("STATUS") : null;
                    }
                    case 1: {
                        return ((SMFmCommonTreeNode)object).getName();
                    }
                    case 2: {
                        return ((SMFmCommonTreeNode)object).isOptTextNode() ? ((SMFmCommonTreeNode)object).getOptText("LINK INFO") : null;
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
        }

        public boolean isCellEditable(Object object, int n) {
            if (n == 1) {
                return true;
            }
            return super.isCellEditable(object, n);
        }

        public boolean isLeaf(Object object) {
            return ((SMFmCommonTreeNode)object).isLeaf();
        }

        public void setValueAt(Object object, Object object2, int n) {
            super.setValueAt(object, object2, n);
        }
    }
}

