/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.AbstractTreeTableModel;
import com.sun.symon.apps.common.JTreeTable;
import com.sun.symon.apps.common.TreeTableModel;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmRemoteEnd;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmCommonTreeNode;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmDiscoverDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SMFmWciInfoDialog
extends SMFmAbstractBaseDialog {
    protected static final int NO_CHANGES = 0;
    protected static final int NODES_CHOSEN = 1;
    protected static final int NODE_CHANGES = 2;
    private static final int BUTTON_HOROZONTAL_SPACE = 5;
    private static final int SECTION_VERTICAL_SPACE = 17;
    private static final int COMMON_SPACE = 12;
    protected TreeTableModel tableModel;
    protected JButton discoverButton;
    protected JButton chooseButton;
    protected JButton cancelButton;
    protected JPanel tablePanel;
    protected JTreeTable table;
    protected SMFmCommonTreeNode rootNode;
    protected SMFmCommonTreeNode[] nodes;
    protected int state;
    protected int state2;
    private Map updatedNodes;
    private SMFmResourceAccessListener resAccListener;
    protected SMFmFabricData fabricData;
    private static final int DISCOVERY_STOP_WAIT_TIME = 5000;
    protected int DIALOG_STATE = 0;
    protected JDialog dialog;
    private JPanel contentPanel;

    public SMFmWciInfoDialog(Dialog dialog, String string, boolean bl, SMFmFabricData sMFmFabricData, SMFmCommonTreeNode[] sMFmCommonTreeNodeArray, SMFmResourceAccess sMFmResourceAccess) {
        super(dialog, sMFmResourceAccess, string, 3, true, bl);
        ((Component)this).setSize(600, 250);
        this.fabricData = sMFmFabricData;
        this.nodes = this.cloneNodes(sMFmCommonTreeNodeArray);
        this.state = 0;
        this.dialog = this;
        this.updatedNodes = new HashMap();
        this.procNodesForTableData();
        this.initComponents();
        this.addListeners();
    }

    static /* synthetic */ void access$1(SMFmWciInfoDialog sMFmWciInfoDialog, Map map) {
        sMFmWciInfoDialog.updateNodeWcisParolisInTree(map);
    }

    public void addButtonsToPanel() {
        this.discoverButton = new JButton(SMFmConfGlobal.getI18NString("FAB_LINK_DISCOVERY"));
        this.discoverButton.setMnemonic(SMFmConfGlobal.getI18NString("FAB_LINK_DISCOVERY.mnemonic").charAt(0));
        this.buttonPanel.add(this.discoverButton);
        this.chooseButton = new JButton(SMFmConfGlobal.getI18NString("chooseButton.label"));
        this.chooseButton.setMnemonic(SMFmConfGlobal.getI18NString("chooseButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.chooseButton);
        this.cancelButton = new JButton(SMFmConfGlobal.getI18NString("cancelButton.label"));
        this.buttonPanel.add(this.cancelButton);
    }

    private void addListeners() {
        this.enableDiscoveryButton(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmWciInfoDialog.this.closeDialog();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmWciInfoDialog.this.closeDialog();
            }
        });
        this.chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmWciInfoDialog.this.nodes = SMFmWciInfoDialog.this.getCheckedFmNodes();
                if (SMFmWciInfoDialog.this.nodes.length > 0) {
                    SMFmWciInfoDialog.this.state = 1;
                    SMFmWciInfoDialog.this.closeDialog();
                } else {
                    JOptionPane.showMessageDialog(SMFmWciInfoDialog.this.getParent(), SMFmConfGlobal.getI18NString("NO_SLOT_WCIS_SELECTED"), SMFmConfGlobal.getI18NString("ERROR"), 0);
                }
            }
        });
        this.discoverButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cloneable cloneable;
                TreePath[] treePathArray = SMFmWciInfoDialog.this.table.getTree().getSelectionPaths();
                SMFmCommonTreeNode[] sMFmCommonTreeNodeArray = SMFmWciInfoDialog.this.extractFmNodesFromPaths(treePathArray);
                SMFmDiscoverDialog sMFmDiscoverDialog = new SMFmDiscoverDialog((Dialog)SMFmWciInfoDialog.this.dialog, true, sMFmCommonTreeNodeArray, SMFmWciInfoDialog.this.resAcc);
                sMFmDiscoverDialog.show();
                HashMap<String, SMFmNodeData> hashMap = new HashMap<String, SMFmNodeData>();
                int n = 0;
                while (n < SMFmWciInfoDialog.this.nodes.length) {
                    cloneable = SMFmWciInfoDialog.this.nodes[n];
                    if (((SMFmCommonTreeNode)cloneable).isHost() || ((SMFmCommonTreeNode)cloneable).isHostDomain() || ((SMFmCommonTreeNode)cloneable).isDomain()) {
                        hashMap.put(((SMFmCommonTreeNode)cloneable).getName(), (SMFmNodeData)((DefaultMutableTreeNode)cloneable).getUserObject());
                    }
                    ++n;
                }
                try {
                    cloneable = hashMap;
                    SwingUtilities.invokeLater(new Runnable(SMFmWciInfoDialog.this, (Map)((Object)cloneable)){
                        private final /* synthetic */ SMFmWciInfoDialog this$0;
                        private final /* synthetic */ Map val$uMap;
                        {
                            this.this$0 = sMFmWciInfoDialog;
                            this.val$uMap = map;
                        }

                        public void run() {
                            SMFmWciInfoDialog.access$1(this.this$0, this.val$uMap);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        });
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                Object v;
                ArrayList arrayList;
                Collection collection;
                Object object = sMFmResourceAccessEvent.getEventObject();
                boolean bl = false;
                if (object != null && object instanceof Map && (collection = ((Map)object).values()) != null && (arrayList = new ArrayList(collection)).size() > 0 && (v = arrayList.get(0)) instanceof SMFmNodeData) {
                    bl = true;
                    try {
                        SwingUtilities.invokeLater(new Runnable(object, SMFmWciInfoDialog.this){
                            private final /* synthetic */ SMFmWciInfoDialog this$0;
                            private final /* synthetic */ Object val$eventObject;
                            {
                                this.val$eventObject = object;
                                this.this$0 = sMFmWciInfoDialog;
                            }

                            public void run() {
                                SMFmWciInfoDialog.access$1(this.this$0, (Map)this.val$eventObject);
                            }
                        });
                    }
                    catch (Exception exception) {}
                }
                if (!bl) {
                    SMFmWciInfoDialog.this.closeDialog();
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    private void addParolisToNode(SMFmCommonTreeNode sMFmCommonTreeNode, SMFmRemoteEnd[] sMFmRemoteEndArray) {
        if (sMFmRemoteEndArray == null || sMFmCommonTreeNode == null) {
            return;
        }
        int n = 0;
        while (n < sMFmRemoteEndArray.length) {
            if (sMFmRemoteEndArray[n] != null && sMFmRemoteEndArray[n].getSCName() != null) {
                SMFmCommonTreeNode sMFmCommonTreeNode2 = new SMFmCommonTreeNode(String.valueOf(SMFmConfGlobal.getI18NString("PAROLI_FIRST_LETTER")) + n, 8, false);
                sMFmCommonTreeNode2.setOptTextNode(true);
                sMFmCommonTreeNode2.putOptText("LINK INFO", sMFmRemoteEndArray[n].toString());
                sMFmCommonTreeNode2.setUserObject(sMFmRemoteEndArray[n]);
                sMFmCommonTreeNode2.setToolTipText(SMFmConfGlobal.getI18NString("TT_WCI_INFO_PORT_TREE_ITEM"));
                sMFmCommonTreeNode.add(sMFmCommonTreeNode2);
            }
            ++n;
        }
    }

    protected void addToolTips() {
        this.discoverButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_WCI_INFO_DISCOVER_LINKS_BUTTON"));
        this.chooseButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_WCI_INFO_CHOOSE_WCIS_BUTTON"));
    }

    private void addWcisToNode(SMFmCommonTreeNode sMFmCommonTreeNode, List list, boolean bl) {
        if (list == null) {
            return;
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            SMFmWciData sMFmWciData = (SMFmWciData)list.get(n2);
            boolean bl2 = false;
            if (bl) {
                bl2 = sMFmWciData.getMode() == 0 || sMFmWciData.getMode() == 1 || sMFmWciData.getMode() == 4;
            }
            SMFmCommonTreeNode sMFmCommonTreeNode2 = new SMFmCommonTreeNode(String.valueOf(SMFmConfGlobal.getI18NString("SLOT_FIRST_LETTER")) + sMFmWciData.getSlot() + "." + SMFmConfGlobal.getI18NString("WCI_FIRST_LETTER") + sMFmWciData.getWci(), 5, bl2);
            sMFmCommonTreeNode2.setOptTextNode(true);
            sMFmCommonTreeNode2.putOptText("STATUS", SMFmConfGlobal.getModeString(sMFmWciData.getMode()));
            sMFmCommonTreeNode2.setUserObject(sMFmWciData);
            sMFmCommonTreeNode2.setToolTipText(SMFmConfGlobal.getI18NString("TT_WCI_INFO_SLOT_WCI_TREE_ITEM"));
            sMFmCommonTreeNode.add(sMFmCommonTreeNode2);
            this.addParolisToNode(sMFmCommonTreeNode2, sMFmWciData.getRemoteEnds());
            ++n2;
        }
    }

    protected SMFmCommonTreeNode cloneNode(SMFmCommonTreeNode sMFmCommonTreeNode) {
        if (sMFmCommonTreeNode.isLeaf()) {
            return (SMFmCommonTreeNode)sMFmCommonTreeNode.clone();
        }
        SMFmCommonTreeNode sMFmCommonTreeNode2 = (SMFmCommonTreeNode)sMFmCommonTreeNode.clone();
        Enumeration<TreeNode> enumeration = sMFmCommonTreeNode.children();
        while (enumeration.hasMoreElements()) {
            sMFmCommonTreeNode2.add(this.cloneNode((SMFmCommonTreeNode)enumeration.nextElement()));
        }
        return sMFmCommonTreeNode2;
    }

    protected SMFmCommonTreeNode[] cloneNodes(SMFmCommonTreeNode[] sMFmCommonTreeNodeArray) {
        Object object;
        ArrayList<SMFmCommonTreeNode> arrayList = new ArrayList<SMFmCommonTreeNode>();
        if (sMFmCommonTreeNodeArray == null || sMFmCommonTreeNodeArray.length < 0) {
            return null;
        }
        int n = 0;
        while (n < sMFmCommonTreeNodeArray.length) {
            object = sMFmCommonTreeNodeArray[n];
            arrayList.add(this.cloneNode((SMFmCommonTreeNode)object));
            ++n;
        }
        object = new SMFmCommonTreeNode[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    protected void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    protected void enableAllButtons(boolean bl) {
        this.discoverButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        this.chooseButton.setEnabled(bl);
    }

    protected void enableCancelChooseButton(boolean bl) {
        this.cancelButton.setEnabled(bl);
        this.chooseButton.setEnabled(bl);
    }

    protected void enableDiscoveryButton(boolean bl) {
        this.discoverButton.setEnabled(bl);
    }

    protected SMFmCommonTreeNode[] extractFmNodesFromPaths(TreePath[] treePathArray) {
        Object object;
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        TreeSet<SMFmCommonTreeNode> treeSet = new TreeSet<SMFmCommonTreeNode>();
        int n = 0;
        while (n < treePathArray.length) {
            object = treePathArray[n];
            SMFmCommonTreeNode sMFmCommonTreeNode = (SMFmCommonTreeNode)((TreePath)object).getLastPathComponent();
            if (sMFmCommonTreeNode.isSlotWCI()) {
                treeSet.add((SMFmCommonTreeNode)sMFmCommonTreeNode.getParent());
            } else if (sMFmCommonTreeNode.isParoli()) {
                treeSet.add((SMFmCommonTreeNode)sMFmCommonTreeNode.getParent().getParent());
            } else {
                Enumeration<TreeNode> enumeration = sMFmCommonTreeNode.depthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    SMFmCommonTreeNode sMFmCommonTreeNode2 = (SMFmCommonTreeNode)enumeration.nextElement();
                    if (!sMFmCommonTreeNode2.isHostDomain() && !sMFmCommonTreeNode2.isHost()) continue;
                    treeSet.add(sMFmCommonTreeNode2);
                }
            }
            ++n;
        }
        object = new SMFmCommonTreeNode[treeSet.size()];
        return (SMFmCommonTreeNode[])treeSet.toArray((T[])object);
    }

    protected Map extractScHostDomainAndWCIsMapFromPath(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath = treePathArray[n];
            SMFmCommonTreeNode sMFmCommonTreeNode = (SMFmCommonTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = sMFmCommonTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                String string;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Comparable comparable;
                SMFmCommonTreeNode sMFmCommonTreeNode2 = (SMFmCommonTreeNode)enumeration.nextElement();
                if (sMFmCommonTreeNode2.isHostDomain() || sMFmCommonTreeNode2.isHost()) {
                    comparable = (SMFmNodeData)sMFmCommonTreeNode2.getUserObject();
                    object5 = ((SMFmNodeData)comparable).getDomainId();
                    if (object5 == null || ((String)object5).equals("")) {
                        hashMap.put(((SMFmNodeData)comparable).getScHost(), new ArrayList());
                        continue;
                    }
                    hashMap.put(String.valueOf(((SMFmNodeData)comparable).getScHost()) + ":" + (String)object5, new ArrayList());
                    continue;
                }
                if (sMFmCommonTreeNode2.isSlotWCI()) {
                    comparable = (SMFmCommonTreeNode)sMFmCommonTreeNode2.getParent();
                    object5 = (SMFmNodeData)((DefaultMutableTreeNode)((Object)comparable)).getUserObject();
                    object4 = ((SMFmNodeData)object5).getDomainId();
                    if (object4 == null || ((String)object4).equals("")) {
                        hashMap.put(((SMFmNodeData)object5).getScHost(), new ArrayList());
                        continue;
                    }
                    object3 = (List)hashMap.get(String.valueOf(((SMFmNodeData)object5).getScHost()) + ":" + (String)object4);
                    if (object3 != null && object3.size() != 0) {
                        object2 = (SMFmWciData)sMFmCommonTreeNode2.getUserObject();
                        object = String.valueOf(((SMFmWciData)object2).getSlot()) + ":" + ((SMFmWciData)object2).getWci();
                        if (object3.contains(object)) continue;
                        object3.add(object);
                        continue;
                    }
                    if (object3 != null) continue;
                    object3 = new ArrayList<Object>();
                    hashMap.put(String.valueOf(((SMFmNodeData)object5).getScHost()) + ":" + ((SMFmNodeData)object5).getDomainId(), (Serializable)object3);
                    object2 = (SMFmWciData)sMFmCommonTreeNode2.getUserObject();
                    object = String.valueOf(((SMFmWciData)object2).getSlot()) + ":" + ((SMFmWciData)object2).getWci();
                    if (object3.contains(object)) continue;
                    object3.add(object);
                    continue;
                }
                if (!sMFmCommonTreeNode2.isParoli()) continue;
                comparable = (SMFmCommonTreeNode)sMFmCommonTreeNode2.getParent();
                object5 = (SMFmCommonTreeNode)((DefaultMutableTreeNode)((Object)comparable)).getParent();
                object4 = (SMFmNodeData)((DefaultMutableTreeNode)object5).getUserObject();
                object3 = ((SMFmNodeData)object4).getDomainId();
                if (object3 == null || ((String)object3).equals("")) {
                    hashMap.put(((SMFmNodeData)object4).getScHost(), new ArrayList());
                    continue;
                }
                object2 = (List)hashMap.get(String.valueOf(((SMFmNodeData)object4).getScHost()) + ":" + ((SMFmNodeData)object4).getDomainId());
                if (object2 != null && object2.size() != 0) {
                    object = (SMFmWciData)((DefaultMutableTreeNode)((Object)comparable)).getUserObject();
                    string = String.valueOf(((SMFmWciData)object).getSlot()) + ":" + ((SMFmWciData)object).getWci();
                    if (object2.contains(string)) continue;
                    object2.add(string);
                    continue;
                }
                if (object2 != null) continue;
                object2 = new ArrayList();
                hashMap.put(String.valueOf(((SMFmNodeData)object4).getScHost()) + ":" + ((SMFmNodeData)object4).getDomainId(), (Serializable)object2);
                object = (SMFmWciData)((DefaultMutableTreeNode)((Object)comparable)).getUserObject();
                string = String.valueOf(((SMFmWciData)object).getSlot()) + ":" + ((SMFmWciData)object).getWci();
                if (object2.contains(string)) continue;
                object2.add(string);
            }
            ++n;
        }
        return hashMap;
    }

    protected List extractscNameDomainsFromPath(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        SMFmCommonTreeNode[] sMFmCommonTreeNodeArray = this.extractFmNodesFromPaths(treePathArray);
        if (sMFmCommonTreeNodeArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < sMFmCommonTreeNodeArray.length) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)sMFmCommonTreeNodeArray[n].getUserObject();
            arrayList.add(String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId());
            ++n;
        }
        return arrayList;
    }

    private SMFmCommonTreeNode[] getCheckedFmNodes() {
        Object object;
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            object = (SMFmCommonTreeNode)enumeration.nextElement();
            if (!((SMFmCommonTreeNode)object).isSelected().booleanValue()) continue;
            arrayList.add(((DefaultMutableTreeNode)object).getParent());
        }
        object = new SMFmCommonTreeNode[arrayList.size()];
        return (SMFmCommonTreeNode[])arrayList.toArray((T[])object);
    }

    private TreePath[] getCheckedPath() {
        Object object;
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            object = (SMFmCommonTreeNode)enumeration.nextElement();
            if (!((SMFmCommonTreeNode)object).isSelected().booleanValue()) continue;
            arrayList.add(new TreePath(((DefaultMutableTreeNode)object).getPath()));
        }
        object = new TreePath[arrayList.size()];
        return (TreePath[])arrayList.toArray((T[])object);
    }

    public SMFmCommonTreeNode[] getChosenNodes() {
        return this.nodes;
    }

    public Map getUpdatedNodes() {
        if (this.state2 == 2) {
            return this.updatedNodes;
        }
        return null;
    }

    private void initBottomButtonPanel() {
        this.addButtonsToPanel();
        this.getRootPane().setDefaultButton(this.chooseButton);
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.initTablePanel();
        this.initBottomButtonPanel();
        this.addToMainPanel(this.contentPanel);
    }

    private void initTablePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tablePanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("NODES_COLON"));
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.tablePanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)this.tablePanel, gridBagConstraints);
        this.contentPanel.add((Component)jPanel, "Center");
    }

    public boolean isNodeChanges() {
        return this.state2 == 2;
    }

    public boolean isNodeChosen() {
        return this.state == 1;
    }

    protected void procNodesForTableData() {
        this.rootNode = new SMFmCommonTreeNode("Root", 0);
        if (this.nodes == null) {
            return;
        }
        int n = 0;
        while (n < this.nodes.length) {
            if (this.nodes[n] != null) {
                int n2 = 0;
                while (n2 < this.nodes[n].getChildCount()) {
                    SMFmCommonTreeNode sMFmCommonTreeNode = (SMFmCommonTreeNode)this.nodes[n].getChildAt(n2);
                    SMFmWciData sMFmWciData = (SMFmWciData)sMFmCommonTreeNode.getUserObject();
                    sMFmCommonTreeNode.setOptTextNode(true);
                    sMFmCommonTreeNode.putOptText("STATUS", SMFmConfGlobal.getModeString(sMFmWciData.getMode()));
                    this.addParolisToNode(sMFmCommonTreeNode, sMFmWciData.getRemoteEnds());
                    ++n2;
                }
                this.rootNode.add(this.nodes[n]);
            }
            ++n;
        }
    }

    private void refreshWciInventory(TreePath[] treePathArray) {
        if (this.resAcc == null) {
            return;
        }
        final List list = this.extractscNameDomainsFromPath(treePathArray);
        if (list == null || list.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Map map = resAcc.updateNodes(list);
                String string = resAcc.getErrorMessage();
                if (string != null) {
                    JOptionPane.showMessageDialog(this.getParent(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                    this.enableAllButtons(true);
                }
                this.enableCancelChooseButton(true);
            }
        };
        this.enableAllButtons(false);
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void updateNodeWcisParolisInTree(Map map) {
        if (map == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            SMFmNodeData sMFmNodeData;
            String string;
            SMFmNodeData sMFmNodeData2;
            SMFmCommonTreeNode sMFmCommonTreeNode = (SMFmCommonTreeNode)enumeration.nextElement();
            if (!sMFmCommonTreeNode.isHostDomain() && !sMFmCommonTreeNode.isHost() || (sMFmNodeData2 = (SMFmNodeData)map.get(string = (sMFmNodeData = (SMFmNodeData)sMFmCommonTreeNode.getUserObject()).getDomainId() == null || sMFmNodeData.getDomainId().equals("") ? sMFmNodeData.getScHost() : String.valueOf(sMFmNodeData.getScHost()) + ":" + sMFmNodeData.getDomainId())) == null) continue;
            sMFmCommonTreeNode.removeAllChildren();
            sMFmCommonTreeNode.setUserObject(sMFmNodeData2);
            this.addWcisToNode(sMFmCommonTreeNode, sMFmNodeData2.getIdleWcis(), true);
            this.addWcisToNode(sMFmCommonTreeNode, sMFmNodeData2.getInUseWcis(), false);
            sMFmCommonTreeNode.setSelectable(sMFmNodeData2.isIdleWcis());
            AbstractTreeTableModel abstractTreeTableModel = (AbstractTreeTableModel)this.table.getTree().getModel();
            abstractTreeTableModel.fireTreeStructureChanged(this, sMFmCommonTreeNode.getPath(), null, null);
        }
    }
}

