/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmConfBean;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTree;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreeNode;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class SMFmTreePanel
extends JPanel {
    SMFmData smfmData;
    SMFmTree wnodeTree;
    SMFmTree chassisTree;
    SMFmTree currentlyDisplayedTree;
    JLabel titleLabel;
    SMFmConfBean mainConsole;
    SMFmTreeNode matchingWnode;
    SMFmTreeNode matchingChassis;
    private SMFmResourceAccess resAcc;

    public SMFmTreePanel(SMFmConfBean sMFmConfBean, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        this.resAcc = sMFmResourceAccess;
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel(SMFmConfGlobal.getI18NString("NODES_AND_ROUTES"));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1, 12.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setHorizontalTextPosition(0);
        this.add((Component)this.titleLabel, "North");
        this.smfmData = new SMFmData(sMFmFabricData, sMFmResourceAccess);
        this.wnodeTree = new SMFmTree(this.smfmData.getWnodeViewTreeModel(), sMFmConfBean, this.smfmData, sMFmResourceAccess);
        this.chassisTree = new SMFmTree(this.smfmData.getChassisViewTreeModel(), sMFmConfBean, this.smfmData, sMFmResourceAccess);
        this.add((Component)this.wnodeTree, "West");
        this.currentlyDisplayedTree = this.wnodeTree;
        this.setBackground(Color.white);
        this.mainConsole = sMFmConfBean;
    }

    public void displayChassisTree() {
        this.removeAll();
        this.titleLabel.setText(SMFmConfGlobal.getI18NString("CHASSIS_AND_LINKS"));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.chassisTree, "West");
        this.currentlyDisplayedTree = this.chassisTree;
        this.chassisTree.repaint();
        this.repaint();
    }

    public void displayWnodeTree() {
        this.removeAll();
        this.titleLabel.setText(SMFmConfGlobal.getI18NString("NODES_AND_ROUTES"));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.wnodeTree, "West");
        this.currentlyDisplayedTree = this.wnodeTree;
        this.wnodeTree.repaint();
        this.repaint();
    }

    public SMFmTree getCurrentlyDisplayedTree() {
        return this.currentlyDisplayedTree;
    }

    private SMFmTreeNode getMatchingTreeNodeByLocation(SMFmTreeNode sMFmTreeNode, String string) {
        Enumeration<TreeNode> enumeration = sMFmTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            SMFmTreeNode sMFmTreeNode2 = (SMFmTreeNode)enumeration.nextElement();
            if (!sMFmTreeNode2.getLocation().equals(string)) continue;
            return sMFmTreeNode2;
        }
        return null;
    }

    public SMFmTopologyPanel getSelectedTopolgyPanel() {
        SMFmTreeNode sMFmTreeNode = this.currentlyDisplayedTree.getSelectedTreeNode();
        if (sMFmTreeNode == null) {
            sMFmTreeNode = (SMFmTreeNode)this.currentlyDisplayedTree.getModel().getRoot();
        }
        if (!(sMFmTreeNode.getType().equals(SMFmTreeNode.PARTITION_TYPE) || sMFmTreeNode.getType().equals(SMFmTreeNode.FABRIC_TYPE) || sMFmTreeNode.getType().equals("AVAIL_SWITCH_FOLDER") || sMFmTreeNode.getType().equals("AVAIL_NODE_FOLDER"))) {
            sMFmTreeNode = (SMFmTreeNode)sMFmTreeNode.getParent();
        }
        return this.smfmData.getTopologyPanel(sMFmTreeNode);
    }

    public SMFmTreeNode getSelectedTreeNode() {
        return this.currentlyDisplayedTree.getSelectedTreeNode();
    }

    public void refresh(SMFmFabricData sMFmFabricData) {
        SMFmTreeNode sMFmTreeNode = this.wnodeTree.getSelectedTreeNode();
        if (sMFmTreeNode == null) {
            sMFmTreeNode = (SMFmTreeNode)this.wnodeTree.getModel().getRoot();
        } else if (!(sMFmTreeNode.getType().equals(SMFmTreeNode.PARTITION_TYPE) || sMFmTreeNode.getType().equals(SMFmTreeNode.FABRIC_TYPE) || sMFmTreeNode.getType().equals("AVAIL_NODE_FOLDER") || sMFmTreeNode.getType().equals("AVAIL_SWITCH_FOLDER"))) {
            sMFmTreeNode = (SMFmTreeNode)sMFmTreeNode.getParent();
        }
        SMFmTreeNode sMFmTreeNode2 = this.chassisTree.getSelectedTreeNode();
        if (sMFmTreeNode2 == null) {
            sMFmTreeNode2 = (SMFmTreeNode)this.chassisTree.getModel().getRoot();
        } else if (!(sMFmTreeNode2.getType().equals(SMFmTreeNode.PARTITION_TYPE) || sMFmTreeNode2.getType().equals(SMFmTreeNode.FABRIC_TYPE) || sMFmTreeNode2.getType().equals("AVAIL_NODE_FOLDER") || sMFmTreeNode2.getType().equals("AVAIL_SWITCH_FOLDER"))) {
            sMFmTreeNode2 = (SMFmTreeNode)sMFmTreeNode2.getParent();
        }
        this.smfmData = new SMFmData(sMFmFabricData, this.resAcc);
        this.wnodeTree = new SMFmTree(this.smfmData.getWnodeViewTreeModel(), this.mainConsole, this.smfmData, this.resAcc);
        this.chassisTree = new SMFmTree(this.smfmData.getChassisViewTreeModel(), this.mainConsole, this.smfmData, this.resAcc);
        this.matchingWnode = this.getMatchingTreeNodeByLocation((SMFmTreeNode)this.wnodeTree.getModel().getRoot(), sMFmTreeNode.getLocation());
        this.matchingChassis = this.getMatchingTreeNodeByLocation((SMFmTreeNode)this.chassisTree.getModel().getRoot(), sMFmTreeNode2.getLocation());
        if (this.matchingWnode == null) {
            this.matchingWnode = (SMFmTreeNode)this.wnodeTree.getModel().getRoot();
        }
        if (this.matchingChassis == null) {
            this.matchingChassis = (SMFmTreeNode)this.chassisTree.getModel().getRoot();
        }
        this.wnodeTree.highlight(this.matchingWnode);
        this.chassisTree.highlight(this.matchingChassis);
        this.remove(this.currentlyDisplayedTree);
        if (this.titleLabel.getText().equals(SMFmConfGlobal.getI18NString("NODES_AND_ROUTES"))) {
            this.add((Component)this.wnodeTree, "West");
            this.currentlyDisplayedTree = this.wnodeTree;
        } else {
            this.add((Component)this.chassisTree, "West");
            this.currentlyDisplayedTree = this.chassisTree;
        }
        this.repaint();
        this.revalidate();
    }
}

