/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmStatusSeverityInterface;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreeNode;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

class SMFmTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    Image nodeImage;
    Image nodeMasterImage;
    Image chassisImage;
    Image switchImage;
    Image rsmImage;
    Image ssmImage;
    Image fabricImage;
    Image avialNodeFolderImage;
    Image avialSwitchFolderImage;
    Image[] alarmSeverityImages;
    private static final int dimensionBuffer = 7;

    public SMFmTreeCellRenderer(SMFmResourceAccess sMFmResourceAccess) {
        this.nodeImage = sMFmResourceAccess.getImage("fmimages/wnode_xsm.gif");
        this.nodeMasterImage = sMFmResourceAccess.getImage("fmimages/wnode_master_xsm.gif");
        this.chassisImage = sMFmResourceAccess.getImage("fmimages/chassis.gif");
        this.switchImage = sMFmResourceAccess.getImage("fmimages/switch_xsm.gif");
        this.rsmImage = sMFmResourceAccess.getImage("fmimages/rsm-small.gif");
        this.ssmImage = sMFmResourceAccess.getImage("fmimages/ssm-small.gif");
        this.fabricImage = sMFmResourceAccess.getImage("fmimages/fabric_xsm.gif");
        this.avialNodeFolderImage = sMFmResourceAccess.getImage("fmimages/available_nodes.gif");
        this.avialSwitchFolderImage = sMFmResourceAccess.getImage("fmimages/available_switches.gif");
        this.alarmSeverityImages = new Image[SMFmConfGlobal.alarmSeveritySmallIcons.length];
        int n = 0;
        while (n < SMFmConfGlobal.alarmSeveritySmallIcons.length) {
            this.alarmSeverityImages[n] = sMFmResourceAccess.getImage(SMFmConfGlobal.alarmSeveritySmallIcons[n]);
            ++n;
        }
    }

    public static Image addOverlayImage(Image image, Image image2) {
        if (image == null || image2 == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n + 7, n2 + 7, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(image2, n - image2.getWidth(null) + 7, n2 - image2.getHeight(null) + 7, null);
        return bufferedImage;
    }

    private Image getAlarmSeverityImage(int n) {
        if (n < 0 || n > this.alarmSeverityImages.length) {
            n = 6;
        }
        return this.alarmSeverityImages[n];
    }

    private int getHighestAlarmSeverity(int n, int n2) {
        if (n == 2) {
            return n;
        }
        if (n == 3 && n2 != 2) {
            return n;
        }
        return n2;
    }

    private int getHighestAlarmSeverity(Vector vector) {
        int n = 0;
        int n2 = vector == null ? 0 : vector.size();
        int n3 = 0;
        while (n3 < n2) {
            SMFmStatusSeverityInterface sMFmStatusSeverityInterface = (SMFmStatusSeverityInterface)vector.elementAt(n3);
            n = this.getHighestAlarmSeverity(sMFmStatusSeverityInterface.getStatusSeverity(), n);
            ++n3;
        }
        return n;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)object;
        this.setText(sMFmTreeNode.toString());
        this.setToolTipText(sMFmTreeNode.getToolTipText());
        this.setFont(this.getFont().deriveFont(0, 12.0f));
        if (sMFmTreeNode.getType().equals(SMFmTreeNode.NODE_TYPE)) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)sMFmTreeNode.getUserObject();
            int n2 = sMFmNodeData.getStatusSeverity();
            Image image = this.getAlarmSeverityImage(n2);
            Image image2 = sMFmNodeData.isMasterNode() ? this.nodeMasterImage : this.nodeImage;
            if (image != null) {
                image2 = SMFmTreeCellRenderer.addOverlayImage(image2, image);
            }
            this.setIcon(new ImageIcon(SMFmTreeCellRenderer.sizeImage(image2)));
        } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.PARTITION_TYPE)) {
            SMFmPartitionData sMFmPartitionData = (SMFmPartitionData)sMFmTreeNode.getUserObject();
            int n3 = sMFmPartitionData.getStatusSeverity();
            Image image = this.getAlarmSeverityImage(n3);
            Image image3 = sMFmPartitionData.getMode() == 2 ? this.ssmImage : this.rsmImage;
            if (image != null) {
                image3 = SMFmTreeCellRenderer.addOverlayImage(image3, image);
            }
            this.setIcon(new ImageIcon(SMFmTreeCellRenderer.sizeImage(image3)));
        } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.FABRIC_TYPE)) {
            this.setFabricIcon(sMFmTreeNode);
        } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.CHASSIS_TYPE)) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)sMFmTreeNode.getUserObject();
            int n4 = sMFmChassisData.getStatusSeverity();
            Image image = this.getAlarmSeverityImage(n4);
            Image image4 = this.chassisImage;
            if (image != null) {
                image4 = SMFmTreeCellRenderer.addOverlayImage(image4, image);
            }
            this.setIcon(new ImageIcon(SMFmTreeCellRenderer.sizeImage(image4)));
        } else if (sMFmTreeNode.getType().equals("AVAIL_NODE_FOLDER")) {
            this.setAvailabilityIcon(sMFmTreeNode, this.avialNodeFolderImage);
        } else if (sMFmTreeNode.getType().equals("AVAIL_SWITCH_FOLDER")) {
            this.setAvailabilityIcon(sMFmTreeNode, this.avialSwitchFolderImage);
        } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.SWITCH_TYPE)) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)sMFmTreeNode.getUserObject();
            int n5 = sMFmNodeData.getStatusSeverity();
            Image image = this.getAlarmSeverityImage(n5);
            Image image5 = this.switchImage;
            if (image != null) {
                image5 = SMFmTreeCellRenderer.addOverlayImage(image5, image);
            }
            this.setIcon(new ImageIcon(SMFmTreeCellRenderer.sizeImage(image5)));
        }
        if (bl) {
            this.setOpaque(true);
            this.setBackground(Color.blue);
            this.setForeground(Color.white);
        } else {
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
        }
        return this;
    }

    private void setAvailabilityIcon(SMFmTreeNode sMFmTreeNode, Image image) {
        Vector vector = (Vector)sMFmTreeNode.getUserObject();
        int n = this.getHighestAlarmSeverity(vector);
        Image image2 = image;
        Image image3 = this.getAlarmSeverityImage(n);
        if (image3 != null) {
            image2 = SMFmTreeCellRenderer.addOverlayImage(image2, image3);
        }
        this.setIcon(new ImageIcon(SMFmTreeCellRenderer.sizeImage(image2)));
    }

    private void setFabricIcon(SMFmTreeNode sMFmTreeNode) {
        Object object;
        SMFmFabricData sMFmFabricData = (SMFmFabricData)sMFmTreeNode.getUserObject();
        int n = 0;
        Vector vector = sMFmFabricData.getPartitions();
        int n2 = vector == null ? 0 : vector.size();
        int n3 = 0;
        while (n3 < n2) {
            object = (SMFmPartitionData)vector.elementAt(n3);
            n = this.getHighestAlarmSeverity(((SMFmPartitionData)object).getStatusSeverity(), n);
            ++n3;
        }
        if (n != 2) {
            int n4 = this.getHighestAlarmSeverity(sMFmFabricData.getAllAvailableChassisExcludingSwitches());
            int n5 = this.getHighestAlarmSeverity(sMFmFabricData.getAllAvailableSwitchChassis());
            int n6 = this.getHighestAlarmSeverity(n4, n5);
            n = this.getHighestAlarmSeverity(n6, n);
        }
        object = this.fabricImage;
        Image image = this.getAlarmSeverityImage(n);
        if (image != null) {
            object = SMFmTreeCellRenderer.addOverlayImage((Image)object, image);
        }
        this.setIcon(new ImageIcon(SMFmTreeCellRenderer.sizeImage((Image)object)));
    }

    private static Image sizeImage(Image image) {
        if (image == null) {
            return null;
        }
        int n = 25;
        BufferedImage bufferedImage = new BufferedImage(25, 25, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.fill(new Rectangle(0, 0, 25, 25));
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(image, 0, 3, null);
        return bufferedImage;
    }
}

