/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmChassisDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmChassisPopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmConfBean;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmFabricPopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmNodePopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPartitionPopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmSwitchPopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreeCellRenderer;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreeNode;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SMFmTree
extends JTree
implements MouseListener {
    DefaultTreeModel treeModel;
    SMFmConfBean mainConsole;
    Hashtable panels;
    Hashtable treeNodeHashtable;
    SMFmNodePopupMenu nodePopupMenu;
    SMFmPartitionPopupMenu partitionPopupMenu;
    SMFmFabricPopupMenu fabricPopupMenu;
    SMFmChassisPopupMenu chassisPopupMenu;
    SMFmSwitchPopupMenu switchPopupMenu;
    SMFmTreeNode selectedTreeNode;
    SMFmData fmData;
    private SMFmResourceAccess resAcc;

    public SMFmTree(DefaultTreeModel defaultTreeModel, SMFmConfBean sMFmConfBean, SMFmData sMFmData, SMFmResourceAccess sMFmResourceAccess) {
        super(defaultTreeModel);
        this.resAcc = sMFmResourceAccess;
        this.mainConsole = sMFmConfBean;
        this.treeModel = defaultTreeModel;
        this.setCellRenderer(new SMFmTreeCellRenderer(sMFmResourceAccess));
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.nodePopupMenu = new SMFmNodePopupMenu(sMFmResourceAccess);
        this.partitionPopupMenu = new SMFmPartitionPopupMenu(sMFmResourceAccess);
        this.fabricPopupMenu = new SMFmFabricPopupMenu(sMFmResourceAccess);
        this.chassisPopupMenu = new SMFmChassisPopupMenu(sMFmResourceAccess);
        this.switchPopupMenu = new SMFmSwitchPopupMenu(sMFmResourceAccess);
        this.fmData = sMFmData;
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.selectedTreeNode = null;
        this.initTreeNodeHashtable();
    }

    public SMFmTreeNode getSelectedTreeNode() {
        return this.selectedTreeNode;
    }

    public void handleSelectionChange(SMFmTreeNode sMFmTreeNode) {
        if (sMFmTreeNode == null) {
            return;
        }
        this.highlight(sMFmTreeNode);
        if (sMFmTreeNode.getType().equals(SMFmTreeNode.PARTITION_TYPE) || sMFmTreeNode.getType().equals(SMFmTreeNode.FABRIC_TYPE) || sMFmTreeNode.getType().equals("AVAIL_NODE_FOLDER") || sMFmTreeNode.getType().equals("AVAIL_SWITCH_FOLDER")) {
            this.mainConsole.setTopologyPanel(this.fmData.getTopologyPanel(sMFmTreeNode));
            SMFmTopologyPanel sMFmTopologyPanel = this.mainConsole.getTopologyPanel();
            sMFmTopologyPanel.highlight(null);
            sMFmTopologyPanel.setTree(this);
        } else {
            SMFmTopologyPanel sMFmTopologyPanel = this.fmData.getTopologyPanel((SMFmTreeNode)sMFmTreeNode.getParent());
            if (this.mainConsole.getTopologyPanel() != sMFmTopologyPanel) {
                this.mainConsole.setTopologyPanel(sMFmTopologyPanel);
            }
            SMFmTopologyPanel sMFmTopologyPanel2 = this.mainConsole.getTopologyPanel();
            sMFmTopologyPanel2.highlight(sMFmTreeNode.getUserObject());
            sMFmTopologyPanel2.setTree(this);
        }
    }

    public void highlight(SMFmTreeNode sMFmTreeNode) {
        Object[] objectArray;
        if (sMFmTreeNode != null && (objectArray = this.treeModel.getPathToRoot(sMFmTreeNode)) != null) {
            this.selectedTreeNode = sMFmTreeNode;
            this.setSelectionPath(new TreePath(objectArray));
            this.repaint();
            this.revalidate();
        }
    }

    public void highlight(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            TreePath[] treePathArray = new TreePath[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                Object[] objectArray;
                SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)this.treeNodeHashtable.get(vector.elementAt(n));
                if (sMFmTreeNode != null && (objectArray = this.treeModel.getPathToRoot(sMFmTreeNode)) != null) {
                    treePathArray[n] = new TreePath(objectArray);
                }
                ++n;
            }
            if (treePathArray != null) {
                this.setSelectionPaths(treePathArray);
                this.repaint();
                this.revalidate();
            }
        } else {
            SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)this.treeNodeHashtable.get(object);
            this.highlight(sMFmTreeNode);
        }
    }

    private void initTreeNodeHashtable() {
        Enumeration<TreeNode> enumeration;
        this.treeNodeHashtable = new Hashtable();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
        if (defaultMutableTreeNode != null && (enumeration = defaultMutableTreeNode.depthFirstEnumeration()) != null) {
            while (enumeration.hasMoreElements()) {
                SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)enumeration.nextElement();
                if (sMFmTreeNode.getUserObject() == null) continue;
                this.treeNodeHashtable.put(sMFmTreeNode.getUserObject(), sMFmTreeNode);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        } else {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)treePath.getLastPathComponent();
            if (mouseEvent.getClickCount() == 2) {
                if (sMFmTreeNode.getType().equals(SMFmTreeNode.CHASSIS_TYPE)) {
                    SMFmChassisData sMFmChassisData = (SMFmChassisData)sMFmTreeNode.getUserObject();
                    SMFmChassisDetailsDialog sMFmChassisDetailsDialog = new SMFmChassisDetailsDialog((Frame)((JFrame)this.getTopLevelAncestor()), sMFmChassisData, this.resAcc);
                    sMFmChassisDetailsDialog.show();
                } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.NODE_TYPE) || sMFmTreeNode.getType().equals(SMFmTreeNode.SWITCH_TYPE)) {
                    SMFmWnodeDetailsDialog sMFmWnodeDetailsDialog = new SMFmWnodeDetailsDialog((Frame)((JFrame)this.getTopLevelAncestor()), (SMFmNodeData)sMFmTreeNode.getUserObject(), this.resAcc);
                    sMFmWnodeDetailsDialog.show();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)treePath.getLastPathComponent();
        this.handleSelectionChange(sMFmTreeNode);
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popup(mouseEvent);
        }
    }

    private void popup(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)treePath.getLastPathComponent();
            if (sMFmTreeNode.getType().equals(SMFmTreeNode.NODE_TYPE)) {
                this.nodePopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.PARTITION_TYPE)) {
                this.partitionPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.FABRIC_TYPE)) {
                this.fabricPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.CHASSIS_TYPE)) {
                this.chassisPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            } else if (sMFmTreeNode.getType().equals(SMFmTreeNode.SWITCH_TYPE)) {
                this.switchPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

