/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmGraphicInterface;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTelnet;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTree;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTreeNode;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class SMFmSwitchPopupMenu
extends JPopupMenu
implements ActionListener {
    String[] menus = new String[]{SMFmConfGlobal.getI18NString("PROPERTIES_DIALOG_NoMnem.label"), "PROPERTIES_DIALOG", "", SMFmConfGlobal.getI18NString("DETAILS_OF_SWITCH_AGENT"), "DETAILS_OF_SWITCH_AGENT", "", SMFmConfGlobal.getI18NString("DELETE"), "DELETE"};
    SMFmNodeData nodeData;
    private SMFmPartitionData partition;
    private SMFmNodeData node;
    private SMFmResourceAccess resAcc;

    public SMFmSwitchPopupMenu(SMFmResourceAccess sMFmResourceAccess) {
        super(SMFmConfGlobal.getI18NString("SWITCH_MENU"));
        this.resAcc = sMFmResourceAccess;
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n].length() == 0) {
                this.addSeparator();
                ++n;
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(this.menus[n]);
            jMenuItem.setActionCommand(this.menus[++n]);
            jMenuItem.addActionListener(this);
            this.add(jMenuItem);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getActionCommand();
        if (string.equals("PROPERTIES_DIALOG")) {
            SMFmWnodeDetailsDialog sMFmWnodeDetailsDialog = new SMFmWnodeDetailsDialog((Frame)((JFrame)this.getTopLevelAncestor()), this.node, this.resAcc);
            sMFmWnodeDetailsDialog.show();
        } else if (string.equals("DETAILS_OF_SWITCH_AGENT")) {
            String string2 = null;
            try {
                string2 = InetAddress.getLocalHost().getHostName();
                this.resAcc.launchHostdetails(string2);
            }
            catch (Exception exception) {}
        } else if (string.equals("DELETE")) {
            if (this.node != null) {
                if (this.node.getOpMode() == 0) {
                    int n = JOptionPane.showConfirmDialog((JFrame)this.getTopLevelAncestor(), SMFmConfGlobal.getI18NString("EDIT_DEL_NODE_FROM_PAR_CONFIRM"), SMFmConfGlobal.getI18NString("WARNING"), 2);
                    if (n == 0) {
                        final ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(this.node.getScHost());
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                resAcc.remNodeFromFabric(arrayList);
                                String string = resAcc.getErrorMessage();
                                if (string != null) {
                                    JOptionPane.showMessageDialog((JFrame)this.getTopLevelAncestor(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                                }
                            }
                        });
                        thread.start();
                    }
                } else if (this.partition != null) {
                    if (this.partition.isDeleteAllowed(this.node)) {
                        int n = JOptionPane.showConfirmDialog((Frame)this.getTopLevelAncestor(), SMFmConfGlobal.getI18NString("EDIT_DEL_NODE_FROM_PAR_CONFIRM"), SMFmConfGlobal.getI18NString("WARNING"), 2);
                        if (n == 0) {
                            final String string3 = this.partition.getName();
                            final ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(this.node.getScHost());
                            Thread thread = new Thread(new Runnable(){

                                public void run() {
                                    resAcc.downgradePartition(string3, arrayList);
                                    String string = resAcc.getErrorMessage();
                                    if (string != null) {
                                        JOptionPane.showMessageDialog((JFrame)this.getTopLevelAncestor(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                                    }
                                }
                            });
                            thread.start();
                        }
                    } else {
                        JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), SMFmConfGlobal.getI18NString("CANNOT_DELETE_SWITCH"), SMFmConfGlobal.getI18NString("ERROR"), 0);
                    }
                }
            }
        } else if (string.equals("telnet") && this.node != null) {
            String string4 = this.node.getIpAddress();
            SMFmTelnet sMFmTelnet = new SMFmTelnet(string4);
            sMFmTelnet.init();
        }
    }

    public void show(Component component, int n, int n2) {
        SMFmConfGlobal.DebugPrint("Got Show popup command");
        if (component instanceof SMFmTree) {
            SMFmTree sMFmTree = (SMFmTree)component;
            SMFmTreeNode sMFmTreeNode = (SMFmTreeNode)sMFmTree.getLastSelectedPathComponent();
            this.node = (SMFmNodeData)sMFmTreeNode.getUserObject();
            SMFmTreeNode sMFmTreeNode2 = (SMFmTreeNode)sMFmTreeNode.getParent();
            Object object = sMFmTreeNode2.getUserObject();
            this.partition = object instanceof SMFmPartitionData ? (SMFmPartitionData)object : null;
            super.show(component, n, n2);
        } else if (component instanceof SMFmTopologyPanel) {
            SMFmTopologyPanel sMFmTopologyPanel = (SMFmTopologyPanel)component;
            Object object = sMFmTopologyPanel.getDisplayObject(null);
            if (object instanceof SMFmPartitionData) {
                this.partition = (SMFmPartitionData)sMFmTopologyPanel.getDisplayObject(null);
            } else if (object instanceof Vector) {
                this.partition = null;
            } else {
                this.partition = null;
                SMFmConfGlobal.DebugPrint("Unrecognized popup display object: " + object);
            }
            SMFmGraphicInterface sMFmGraphicInterface = sMFmTopologyPanel.getSelectedGraphicObject();
            this.node = (SMFmNodeData)sMFmGraphicInterface.getUserObject();
            super.show((Component)((Object)sMFmGraphicInterface), n, n2);
        } else {
            SMFmConfGlobal.DebugPrint("Unrecognized popup invoker:" + component);
            this.node = null;
            this.partition = null;
            return;
        }
    }
}

