/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.CustomLayout;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmGraphicInterface;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SMFmSanSwitchGraphic
extends JPanel
implements SMFmGraphicInterface {
    private static final int TYPE = 4;
    public static final int LEFT_SWITCH = 0;
    public static final int RIGHT_SWITCH = 1;
    private static final int LED_RADIUS = 5;
    private static final int PORT_WIDTH = 4;
    private static final int PORT_HEIGHT = 10;
    private static final int LED_PORT_HGAP = 3;
    private static final int TEXT_LABEL_WIDTH = 80;
    private static final int TEXT_LABEL_HEIGHT = 12;
    private static final float TEXT_LABEL_FONT_SIZE = 11.0f;
    private static final int HIGHLIGHTS_THICKNESS = 3;
    private int SWITCH_WIDTH;
    private int SWITCH_HEIGHT;
    private float LED_VGAP;
    private float PORT_VGAP;
    private static final Color PORT_COLOR = Color.black;
    private static final Color SWITCH_FOREGROUND_COLOR = new Color(220, 220, 220);
    private static final Color SWITCH_SELECTED_COLOR = new Color(100, 100, 150);
    private static final Color SWITCH_UNSELECTED_COLOR = Color.lightGray;
    private static final Color LED_ON_COLOR = new Color(0, 230, 0);
    private static final Color LED_OFF_COLOR = new Color(160, 160, 160);
    private static final Color LED_ERROR_COLOR = new Color(225, 0, 0);
    private boolean selected;
    private int numPorts;
    private LedGraphic[] leds;
    private JLabel[] ports;
    private Vector nDataV;
    private int orientation;
    private int xCoord;
    private int yCoord;

    public SMFmSanSwitchGraphic(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(null, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public SMFmSanSwitchGraphic(Vector vector, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.nDataV = vector;
        this.numPorts = n7;
        this.orientation = n8;
        this.xCoord = n;
        this.yCoord = n2;
        this.SWITCH_WIDTH = n3;
        this.SWITCH_HEIGHT = n4;
        this.LED_VGAP = n6 + n5 - 10;
        this.PORT_VGAP = n6 + n5 - 10;
        this.setLayout(new CustomLayout());
        this.setBounds(n, n2, this.SWITCH_WIDTH, this.SWITCH_HEIGHT);
        this.setBackground(SWITCH_SELECTED_COLOR);
        this.setForeground(SWITCH_FOREGROUND_COLOR);
        this.setOpaque(true);
        this.setToolTipText(SMFmConfGlobal.getI18NString("SAN_SWITCH_STRING"));
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("SAN"));
        jLabel.setForeground(SWITCH_FOREGROUND_COLOR);
        jLabel.setHorizontalAlignment(0);
        jLabel.setBounds(0, 3, this.SWITCH_WIDTH, 11);
        this.add(jLabel);
        jLabel = new JLabel(SMFmConfGlobal.getI18NString("SWITCH"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(SWITCH_FOREGROUND_COLOR);
        jLabel.setBounds(0, 14, this.SWITCH_WIDTH, 11);
        this.add(jLabel);
        if (n8 == 0) {
            this.initPortsRight();
            this.initLedsRight();
        } else {
            this.initLedsLeft();
            this.initPortsLeft();
        }
    }

    public int getIconHeight() {
        return this.SWITCH_HEIGHT;
    }

    public int getIconWidth() {
        return this.SWITCH_WIDTH;
    }

    public String getInfobarText() {
        String string = String.valueOf(SMFmConfGlobal.getI18NString("SWITCHBANK")) + " " + this.orientation;
        return string;
    }

    public JLabel getTextLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setText(String.valueOf(SMFmConfGlobal.getI18NString("SWITCHBANK")) + " " + this.orientation);
        jLabel.setToolTipText(String.valueOf(SMFmConfGlobal.getI18NString("SWITCHBANK")) + " " + this.orientation);
        jLabel.setFont(jLabel.getFont().deriveFont(11.0f));
        jLabel.setHorizontalTextPosition(0);
        jLabel.setHorizontalAlignment(0);
        int n = this.xCoord - (80 - this.SWITCH_WIDTH) / 2;
        int n2 = this.yCoord + this.SWITCH_HEIGHT;
        jLabel.setBounds(n, n2, 80, 12);
        return jLabel;
    }

    public int getTotalHeight() {
        return this.SWITCH_HEIGHT + 12;
    }

    public int getTotalWidth() {
        return this.SWITCH_WIDTH > 80 ? this.SWITCH_WIDTH : 80;
    }

    public int getType() {
        return 4;
    }

    public Object getUserObject() {
        return this.nDataV;
    }

    public void highlight() {
        this.setBorder(BorderFactory.createLineBorder(SMFmGraphicInterface.HIGHLIGHT_COLOR, 1));
        this.repaint();
        this.revalidate();
    }

    private void initLedsLeft() {
        this.leds = new LedGraphic[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            LedGraphic ledGraphic = new LedGraphic();
            ledGraphic.setBounds(7, (int)((10.0f + this.LED_VGAP) * (float)n + this.LED_VGAP + 5.0f), 10, 10);
            this.add(ledGraphic);
            this.leds[n] = ledGraphic;
            ++n;
        }
    }

    private void initLedsRight() {
        this.leds = new LedGraphic[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            LedGraphic ledGraphic = new LedGraphic();
            ledGraphic.setBounds(this.SWITCH_WIDTH - 4 - 3 - 10, (int)((10.0f + this.LED_VGAP) * (float)n + this.LED_VGAP + 5.0f), 10, 10);
            this.add(ledGraphic);
            this.leds[n] = ledGraphic;
            ++n;
        }
    }

    private void initPortsLeft() {
        this.ports = new JLabel[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(PORT_COLOR);
            jLabel.setOpaque(true);
            jLabel.setBounds(0, (int)((this.PORT_VGAP + 10.0f) * (float)n + this.PORT_VGAP + 5.0f), 4, 10);
            this.add(jLabel);
            this.ports[n] = jLabel;
            ++n;
        }
    }

    private void initPortsRight() {
        this.ports = new JLabel[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(PORT_COLOR);
            jLabel.setOpaque(true);
            jLabel.setBounds(this.SWITCH_WIDTH - 4, (int)((this.PORT_VGAP + 10.0f) * (float)n + this.PORT_VGAP + 5.0f), 4, 10);
            this.add(jLabel);
            this.ports[n] = jLabel;
            ++n;
        }
    }

    public void setLedError(int n) {
        this.leds[n].setLedError();
    }

    public void setLedOff(int n) {
        this.leds[n].setLedOff();
    }

    public void setLedOn(int n) {
        this.leds[n].setLedOn();
    }

    public void setUserObject(Object object) {
        this.nDataV = (Vector)object;
    }

    public void showDetailsDialog() {
    }

    public void showPopupMenu(Component component, int n, int n2) {
    }

    public void unhighlight() {
        this.setBorder(null);
        this.repaint();
        this.revalidate();
    }

    class LedGraphic
    extends JLabel {
        Color color;

        public LedGraphic() {
            this.setOpaque(false);
            this.color = LED_OFF_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("NOT_CONNECTED"));
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.fillArc(0, 0, 10, 10, 0, 360);
        }

        public void setLedError() {
            this.color = LED_ERROR_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("ERROR"));
            this.repaint();
        }

        public void setLedOff() {
            this.color = LED_OFF_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("NOT_CONNECTED"));
            this.repaint();
        }

        public void setLedOn() {
            this.color = LED_ON_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("CONNECTED"));
            this.repaint();
        }
    }
}

