/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmAbstractBaseDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SMFmRegisterDialog
extends SMFmAbstractBaseDialog {
    private static final String DEFAULT_AGENT_PORT = "161";
    private static final String[] CHASSIS_TYPES = new String[]{SMFmConfGlobal.CHASSIS_SERENGETI_DC_STRING, SMFmConfGlobal.CHASSIS_SERENGETI_MD_STRING, SMFmConfGlobal.CHASSIS_SERENGETI_ME_STRING, SMFmConfGlobal.CHASSIS_SERENGETI_SP_STRING, SMFmConfGlobal.CHASSIS_STARCAT_STRING};
    private static final String[] NODE_TYPES = new String[]{SMFmConfGlobal.NODE_TYPE_COMPUTE_STRING, SMFmConfGlobal.NODE_TYPE_WCIX_STRING};
    private static final String[] DOMAIN_IDS = SMFmConfGlobal.domainIdStrings;
    private boolean[] selection = new boolean[7];
    private JLabel fabricName = new JLabel();
    private JLabel solHostNameLabel;
    private JLabel rsmProxyLoginLabel;
    private JLabel rsmProxyPassLabel;
    private JLabel domainLabel;
    private JLabel domainLoginLabel;
    private JComboBox nodeTypeComboBox;
    private JTextField solHostNameTextField;
    private JTextField rsmProxyLoginTextField;
    private JPasswordField rsmProxyPasswordField;
    private CustomJComboBox chassisTypeComboBox;
    private JTextField agentTextField = new JTextField();
    private JTextField agentPortField;
    private JTextArea physicalLocTextArea;
    private JTextField scHostNameTextField;
    private CustomJComboBox domainIdComboBox;
    private JTextField domainLoginTextField;
    private JPasswordField domainPasswordField;
    private JButton applyButton;
    private JButton closeButton;
    private JPanel contentPanel;
    private String fabName;
    private SMFmFabricData fabricData;
    private JDialog dialog;
    private boolean buttonsDisabled;

    public SMFmRegisterDialog(Dialog dialog, String string, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        super(dialog, sMFmResourceAccess, SMFmConfGlobal.getI18NString("REGISTER_TITLE"), 2, true, true);
        this.fabName = string;
        this.fabricData = sMFmFabricData;
        this.dialog = this;
        this.buildDialog();
    }

    public SMFmRegisterDialog(Frame frame, String string, SMFmFabricData sMFmFabricData, SMFmResourceAccess sMFmResourceAccess) {
        super(frame, sMFmResourceAccess, SMFmConfGlobal.getI18NString("REGISTER_TITLE"), 2, true, true);
        this.fabName = string;
        this.fabricData = sMFmFabricData;
        this.dialog = this;
        this.buildDialog();
    }

    public void addActionListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmRegisterDialog.this.closeDialog();
            }
        });
        this.solHostNameTextField.getDocument().addDocumentListener(new DocListener(0));
        this.rsmProxyLoginTextField.getDocument().addDocumentListener(new DocListener(1));
        this.rsmProxyPasswordField.getDocument().addDocumentListener(new DocListener(2));
        this.scHostNameTextField.getDocument().addDocumentListener(new DocListener(3));
        this.domainLoginTextField.getDocument().addDocumentListener(new DocListener(4));
        this.domainPasswordField.getDocument().addDocumentListener(new DocListener(5));
        this.agentPortField.getDocument().addDocumentListener(new DocListener(6));
        this.nodeTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SMFmRegisterDialog.this.nodeTypeComboBox.getSelectedItem();
                if (string == null) {
                    return;
                }
                if (string.equals(SMFmConfGlobal.NODE_TYPE_WCIX_STRING)) {
                    SMFmRegisterDialog.this.solHostNameTextField.setText("");
                    SMFmRegisterDialog.this.rsmProxyLoginTextField.setText("");
                    ((JTextComponent)SMFmRegisterDialog.this.rsmProxyPasswordField).setText("");
                    SMFmRegisterDialog.this.solHostNameLabel.setEnabled(false);
                    SMFmRegisterDialog.this.solHostNameTextField.setEditable(false);
                    SMFmRegisterDialog.this.rsmProxyLoginLabel.setEnabled(false);
                    SMFmRegisterDialog.this.rsmProxyLoginTextField.setEditable(false);
                    SMFmRegisterDialog.this.rsmProxyPassLabel.setEnabled(false);
                    SMFmRegisterDialog.this.rsmProxyPasswordField.setEditable(false);
                    SMFmRegisterDialog.this.rsmProxyPasswordField.setBackground(SMFmRegisterDialog.this.solHostNameTextField.getBackground());
                    SMFmRegisterDialog.this.rsmProxyPasswordField.setBorder(SMFmRegisterDialog.this.solHostNameTextField.getBorder());
                    SMFmRegisterDialog.this.domainLabel.setEnabled(false);
                    SMFmRegisterDialog.this.domainIdComboBox.setEnabled(false);
                    SMFmRegisterDialog.this.domainIdComboBox.removeAllItems();
                    SMFmRegisterDialog.this.domainPasswordField.setEditable(true);
                    SMFmRegisterDialog.this.domainPasswordField.setBackground(SMFmRegisterDialog.this.scHostNameTextField.getBackground());
                    SMFmRegisterDialog.this.domainPasswordField.setBorder(SMFmRegisterDialog.this.scHostNameTextField.getBorder());
                    SMFmRegisterDialog.this.chassisTypeComboBox.removeAllItems();
                    SMFmRegisterDialog.this.chassisTypeComboBox.addItem(SMFmConfGlobal.CHASSIS_WCIX_STRING);
                } else {
                    SMFmRegisterDialog.this.solHostNameLabel.setEnabled(true);
                    SMFmRegisterDialog.this.solHostNameTextField.setEditable(true);
                    SMFmRegisterDialog.this.rsmProxyLoginLabel.setEnabled(true);
                    SMFmRegisterDialog.this.rsmProxyLoginTextField.setEditable(true);
                    SMFmRegisterDialog.this.rsmProxyPassLabel.setEnabled(true);
                    SMFmRegisterDialog.this.rsmProxyPasswordField.setEditable(true);
                    SMFmRegisterDialog.this.rsmProxyPasswordField.setBackground(SMFmRegisterDialog.this.solHostNameTextField.getBackground());
                    SMFmRegisterDialog.this.rsmProxyPasswordField.setBorder(SMFmRegisterDialog.this.solHostNameTextField.getBorder());
                    SMFmRegisterDialog.this.domainLabel.setEnabled(true);
                    SMFmRegisterDialog.this.domainIdComboBox.setEnabled(true);
                    SMFmRegisterDialog.this.domainIdComboBox.removeAllItems();
                    SMFmRegisterDialog.this.domainIdComboBox.addAll(DOMAIN_IDS);
                    SMFmRegisterDialog.this.domainPasswordField.setEditable(true);
                    SMFmRegisterDialog.this.domainPasswordField.setBackground(SMFmRegisterDialog.this.solHostNameTextField.getBackground());
                    SMFmRegisterDialog.this.domainPasswordField.setBorder(SMFmRegisterDialog.this.solHostNameTextField.getBorder());
                    SMFmRegisterDialog.this.chassisTypeComboBox.removeAllItems();
                    if (string.equals(SMFmConfGlobal.NODE_TYPE_CENTRAL_SWITCH_STRING)) {
                        SMFmRegisterDialog.this.chassisTypeComboBox.addItem(SMFmConfGlobal.CHASSIS_STARCAT_STRING);
                    } else {
                        SMFmRegisterDialog.this.chassisTypeComboBox.addAll(CHASSIS_TYPES);
                    }
                }
                SMFmRegisterDialog.this.tryToEnableApply();
            }
        });
        this.chassisTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SMFmRegisterDialog.this.chassisTypeComboBox.getSelectedItem();
                if (string == null) {
                    return;
                }
                if (string.equals(SMFmConfGlobal.CHASSIS_STARCAT_STRING)) {
                    SMFmRegisterDialog.this.agentTextField.setEditable(false);
                    SMFmRegisterDialog.this.agentTextField.setText("");
                    SMFmRegisterDialog.this.domainLoginLabel.setEnabled(true);
                    SMFmRegisterDialog.this.domainLoginTextField.setEditable(true);
                } else {
                    SMFmRegisterDialog.this.agentTextField.setEditable(true);
                    SMFmRegisterDialog.this.domainLoginLabel.setEnabled(false);
                    SMFmRegisterDialog.this.domainLoginTextField.setEditable(false);
                    SMFmRegisterDialog.this.domainLoginTextField.setText("");
                }
                SMFmRegisterDialog.this.tryToEnableApply();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmRegisterDialog.this.closeDialog();
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = SMFmRegisterDialog.this.agentPortField.getText();
                if (string != null && !string.equals("") && !SMFmConfGlobal.isInteger(string)) {
                    JOptionPane.showMessageDialog(SMFmRegisterDialog.this, SMFmConfGlobal.getI18NString("AGENT_PORT_MUST_BE_INTEGER"), SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                } else {
                    SMFmRegisterDialog.this.applyRegNode();
                }
            }
        });
    }

    public void addButtonsToPanel() {
        this.applyButton = new JButton(SMFmConfGlobal.getI18NString("applyButton.label"));
        this.applyButton.setMnemonic(SMFmConfGlobal.getI18NString("applyButton.mnemonic").charAt(0));
        this.applyButton.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_APPLY_BUTTON"));
        this.buttonPanel.add(this.applyButton);
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.applyButton);
    }

    private void applyRegNode() {
        this.enableAllButtons(false);
        Runnable runnable = new Runnable(){

            public void run() {
                String string;
                String string2;
                if (SMFmRegisterDialog.this.nodeTypeComboBox.getSelectedItem().equals(SMFmConfGlobal.NODE_TYPE_WCIX_STRING)) {
                    string2 = new String("sfluser");
                    string = (String)SMFmRegisterDialog.this.domainIdComboBox.getSelectedItem();
                } else {
                    string2 = SMFmRegisterDialog.this.domainLoginTextField.getText().trim();
                    string = (String)SMFmRegisterDialog.this.domainIdComboBox.getSelectedItem();
                }
                SMFmConfGlobal.DebugPrint("Node type = " + SMFmRegisterDialog.this.nodeTypeComboBox.getSelectedItem() + "  domLogin = " + string2 + "  domID = " + string);
                SMFmNodeData sMFmNodeData = SMFmRegisterDialog.this.resAcc.addNodeToFabric(SMFmRegisterDialog.this.scHostNameTextField.getText().trim(), string, string2, new String(SMFmRegisterDialog.this.domainPasswordField.getPassword()).trim(), (String)SMFmRegisterDialog.this.chassisTypeComboBox.getSelectedItem(), SMFmRegisterDialog.this.agentPortField.getText().trim(), SMFmRegisterDialog.this.agentTextField.getText().trim(), SMFmRegisterDialog.this.physicalLocTextArea.getText().trim(), (String)SMFmRegisterDialog.this.nodeTypeComboBox.getSelectedItem(), SMFmRegisterDialog.this.solHostNameTextField.getText().trim(), SMFmRegisterDialog.this.rsmProxyLoginTextField.getText().trim(), new String(SMFmRegisterDialog.this.rsmProxyPasswordField.getPassword()).trim());
                String string3 = SMFmRegisterDialog.this.resAcc.getErrorMessage();
                if (string3 != null) {
                    JOptionPane.showMessageDialog(SMFmRegisterDialog.this.dialog, string3, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                }
                SMFmRegisterDialog.this.enableAllButtons(true);
                SMFmRegisterDialog.this.tryToEnableApply();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void buildDialog() {
        this.setResizable(false);
        this.initComponents();
        this.pack();
        this.addActionListeners();
        this.nodeTypeComboBox.setSelectedItem(SMFmConfGlobal.NODE_TYPE_COMPUTE_STRING);
        this.chassisTypeComboBox.setSelectedItem(SMFmConfGlobal.CHASSIS_SERENGETI_DC_STRING);
        this.agentPortField.setText(DEFAULT_AGENT_PORT);
    }

    protected void closeDialog() {
        this.resAcc.removeStatusJLabel(this.status);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void enableAllButtons(boolean bl) {
        this.buttonsDisabled = bl ^ true;
        this.applyButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
    }

    public int initAgentPanel(JPanel jPanel, int n) {
        int n2 = n + 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 6, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 12, 6, 0), 100, 0);
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("SUNMC_AGENT_PORT"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_AGENT_PORT"));
        this.agentPortField = new JTextField();
        this.agentPortField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_AGENT_PORT"));
        jLabel.setLabelFor(this.agentPortField);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.agentPortField, gridBagConstraints2);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("PHYSICAL_LOCATION"));
        jLabel2.setVerticalAlignment(1);
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_PHYSICAL_LOCATION"));
        this.physicalLocTextArea = new JTextArea(3, 3);
        this.physicalLocTextArea.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_PHYSICAL_LOCATION"));
        gridBagConstraints.gridy = ++n2;
        gridBagConstraints2.gridy = n2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.insets = new Insets(0, 12, 6, 0);
        jLabel2.setLabelFor(this.physicalLocTextArea);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)new JScrollPane(this.physicalLocTextArea), gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(17, 12, 0, 0);
        gridBagConstraints3.anchor = 17;
        return n2;
    }

    private void initComponents() {
        this.contentPanel = new JPanel(new GridBagLayout());
        int n = 0;
        n = this.initTopLabelPanel(n);
        JPanel jPanel = new JPanel(new GridBagLayout());
        n = this.initNodeTypePanel(jPanel, n);
        n = this.initScPanel(jPanel, n);
        n = this.initAgentPanel(jPanel, n);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.contentPanel.add((Component)jPanel, gridBagConstraints);
        this.addButtonsToPanel();
        this.addToMainPanel(this.contentPanel);
    }

    public int initNodeTypePanel(JPanel jPanel, int n) {
        int n2 = n + 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 6, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 6, 0), 0, 0);
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("NODE_TYPE_COLON"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_NODE_TYPE"));
        this.nodeTypeComboBox = new JComboBox<String>(NODE_TYPES);
        this.nodeTypeComboBox.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_NODE_TYPE"));
        jLabel.setLabelFor(this.nodeTypeComboBox);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.nodeTypeComboBox, gridBagConstraints2);
        this.solHostNameLabel = new JLabel(SMFmConfGlobal.getI18NString("SOLARIS_HOST_NAME_COLON"));
        this.solHostNameLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_SOL_HOSTNAME"));
        this.solHostNameTextField = new JTextField();
        this.solHostNameTextField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_SOL_HOSTNAME"));
        gridBagConstraints.gridy = ++n2;
        gridBagConstraints2.gridy = n2++;
        this.solHostNameLabel.setLabelFor(this.solHostNameTextField);
        jPanel.add((Component)this.solHostNameLabel, gridBagConstraints);
        jPanel.add((Component)this.solHostNameTextField, gridBagConstraints2);
        this.rsmProxyLoginLabel = new JLabel(SMFmConfGlobal.getI18NString("RSM_PROXY_LOGIN_ID_COLON"));
        this.rsmProxyLoginLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_RSM_PROXY_LOGIN_ID"));
        this.rsmProxyLoginTextField = new JTextField();
        this.rsmProxyLoginTextField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_RSM_PROXY_LOGIN_ID"));
        gridBagConstraints.gridy = n2;
        gridBagConstraints2.gridy = n2++;
        this.rsmProxyLoginLabel.setLabelFor(this.rsmProxyLoginTextField);
        jPanel.add((Component)this.rsmProxyLoginLabel, gridBagConstraints);
        jPanel.add((Component)this.rsmProxyLoginTextField, gridBagConstraints2);
        this.rsmProxyPassLabel = new JLabel(SMFmConfGlobal.getI18NString("RSM_PROXY_PASSWORD_COLON"));
        this.rsmProxyPassLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_RSM_PROXY_PASSWORD"));
        this.rsmProxyPasswordField = new JPasswordField();
        this.rsmProxyPasswordField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_RSM_PROXY_PASSWORD"));
        gridBagConstraints.gridy = n2;
        gridBagConstraints2.gridy = n2;
        this.rsmProxyPassLabel.setLabelFor(this.rsmProxyPasswordField);
        jPanel.add((Component)this.rsmProxyPassLabel, gridBagConstraints);
        jPanel.add((Component)this.rsmProxyPasswordField, gridBagConstraints2);
        return n2;
    }

    public int initScPanel(JPanel jPanel, int n) {
        int n2 = n + 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 6, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 12, 6, 0), 0, 0);
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("CHASSIS_TYPE_COLON"));
        jLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_CHASSIS_TYPE"));
        this.chassisTypeComboBox = new CustomJComboBox();
        this.chassisTypeComboBox.addAll(CHASSIS_TYPES);
        this.chassisTypeComboBox.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_CHASSIS_TYPE"));
        jLabel.setLabelFor(this.chassisTypeComboBox);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)this.chassisTypeComboBox, gridBagConstraints2);
        JLabel jLabel2 = new JLabel(SMFmConfGlobal.getI18NString("SC_HOST_NAME"));
        jLabel2.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_SC_HOST_NAME"));
        this.scHostNameTextField = new JTextField();
        this.scHostNameTextField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_SC_HOST_NAME"));
        gridBagConstraints.gridy = ++n2;
        gridBagConstraints2.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.insets = new Insets(0, 12, 6, 0);
        jLabel2.setLabelFor(this.scHostNameTextField);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel.add((Component)this.scHostNameTextField, gridBagConstraints2);
        this.domainLabel = new JLabel(SMFmConfGlobal.getI18NString("DOMAIN_ID_COLON"));
        this.domainLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_DOMAIN_ID"));
        this.domainIdComboBox = new CustomJComboBox();
        this.domainIdComboBox.addAll(DOMAIN_IDS);
        this.domainIdComboBox.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_DOMAIN_ID"));
        gridBagConstraints.gridy = n2;
        gridBagConstraints2.gridy = n2++;
        this.domainLabel.setLabelFor(this.domainIdComboBox);
        jPanel.add((Component)this.domainLabel, gridBagConstraints);
        jPanel.add((Component)this.domainIdComboBox, gridBagConstraints2);
        this.domainLoginLabel = new JLabel(SMFmConfGlobal.getI18NString("DOMAIN_LOGIN_ID"));
        this.domainLoginLabel.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_DOMAIN_LOGIN_ID"));
        this.domainLoginTextField = new JTextField();
        this.domainLoginTextField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_DOMAIN_LOGIN_ID"));
        gridBagConstraints.gridy = n2;
        gridBagConstraints2.gridy = n2++;
        this.domainLoginLabel.setLabelFor(this.domainLoginTextField);
        jPanel.add((Component)this.domainLoginLabel, gridBagConstraints);
        jPanel.add((Component)this.domainLoginTextField, gridBagConstraints2);
        JLabel jLabel3 = new JLabel(SMFmConfGlobal.getI18NString("SC_PASSWORD"));
        jLabel3.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_SC_PASSWORD"));
        this.domainPasswordField = new JPasswordField();
        this.domainPasswordField.setToolTipText(SMFmConfGlobal.getI18NString("TT_REGISTER_SC_PASSWORD"));
        gridBagConstraints.gridy = n2;
        gridBagConstraints2.gridy = n2;
        jLabel3.setLabelFor(this.domainPasswordField);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jPanel.add((Component)this.domainPasswordField, gridBagConstraints2);
        return n2;
    }

    public int initTopLabelPanel(int n) {
        int n2 = n;
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("FABRIC_COLON"));
        this.fabricName = new JLabel(" " + this.fabName);
        this.fabricName.setForeground(Color.black);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.fabricName, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 18;
        this.contentPanel.add((Component)jPanel, gridBagConstraints2);
        return n2;
    }

    private boolean meetsRequiredSelections(boolean[] blArray, boolean[] blArray2) {
        int n = 0;
        while (n < blArray2.length) {
            if (blArray2[n] && !blArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private synchronized void tryToEnableApply() {
        boolean[] blArray = new boolean[]{this.solHostNameTextField.isEditable(), this.rsmProxyLoginTextField.isEditable(), this.rsmProxyPasswordField.isEditable(), this.scHostNameTextField.isEditable(), this.domainLoginTextField.isEditable(), this.domainPasswordField.isEditable(), this.agentPortField.isEditable()};
        if (!this.buttonsDisabled && this.meetsRequiredSelections(this.selection, blArray)) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    class CustomJComboBox
    extends JComboBox {
        CustomJComboBox() {
        }

        public void addAll(Object[] objectArray) {
            if (objectArray == null) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                this.addItem(objectArray[n]);
                ++n;
            }
        }
    }

    class DocListener
    implements DocumentListener {
        int selIndex;

        public DocListener(int n) {
            this.selIndex = n;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        private void checkLength(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = document.getLength();
            String string = "";
            try {
                string = document.getText(0, n).trim();
            }
            catch (Exception exception) {}
            if (string.length() > 0) {
                ((SMFmRegisterDialog)SMFmRegisterDialog.this).selection[this.selIndex] = true;
                SMFmRegisterDialog.this.tryToEnableApply();
            } else {
                ((SMFmRegisterDialog)SMFmRegisterDialog.this).selection[this.selIndex] = false;
                SMFmRegisterDialog.this.applyButton.setEnabled(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkLength(documentEvent);
        }
    }
}

