/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.CustomLayout;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmSanSwitchGraphic;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SMFmRSMSwitchGraphic
extends JPanel {
    public static final int LEFT_SWITCH = 0;
    public static final int RIGHT_SWITCH = 1;
    private static final int LED_RADIUS = 2;
    private static final int PORT_WIDTH = 4;
    private static final int PORT_HEIGHT = 4;
    private static final int LED_PORT_HGAP = 2;
    private static final int HIGHLIGHTS_THICKNESS = 3;
    private int SWITCH_WIDTH;
    private int SWITCH_HEIGHT;
    private float LED_VGAP;
    private float PORT_VGAP;
    private static final Color PORT_COLOR = Color.black;
    private static final Color SWITCH_LIGHT_COLOR = new Color(210, 210, 250);
    private static final Color SWITCH_DARK_COLOR = new Color(80, 80, 160);
    private static final Color SWITCH_FOREGROUND_COLOR = new Color(220, 220, 220);
    private static final Color SWITCH_SELECTED_COLOR = new Color(140, 140, 220);
    private static final Color SWITCH_UNSELECTED_COLOR = Color.lightGray;
    private static final Color LED_ON_COLOR = new Color(0, 230, 0);
    private static final Color LED_OFF_COLOR = new Color(160, 160, 160);
    private static final Color LED_ERROR_COLOR = new Color(225, 0, 0);
    private boolean selected;
    private int numPorts;
    private LedGraphic[] leds;
    private JLabel[] ports;

    public SMFmRSMSwitchGraphic(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.numPorts = n7;
        this.SWITCH_WIDTH = n3;
        this.SWITCH_HEIGHT = n4;
        this.LED_VGAP = n6 + n5 - 4;
        this.PORT_VGAP = n6 + n5 - 4;
        this.setLayout(new CustomLayout());
        this.setBounds(n, n2, this.SWITCH_WIDTH, this.SWITCH_HEIGHT);
        this.setBackground(SWITCH_SELECTED_COLOR);
        this.setForeground(SWITCH_FOREGROUND_COLOR);
        this.setOpaque(true);
        this.setToolTipText(SMFmConfGlobal.getI18NString("SAN_SWITCH_STRING"));
        this.leds = new LedGraphic[n7];
        this.ports = new JLabel[n7];
        this.initPortsRight();
        this.initLedsRight();
        this.initLedsLeft();
        this.initPortsLeft();
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setBackground(SWITCH_LIGHT_COLOR);
        jLabel.setBounds(0, 0, this.SWITCH_WIDTH, 3);
        this.add(jLabel);
        jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setBackground(SWITCH_LIGHT_COLOR);
        jLabel.setBounds(0, 0, 3, this.SWITCH_HEIGHT);
        this.add(jLabel);
        jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setBackground(SWITCH_DARK_COLOR);
        jLabel.setBounds(0, this.SWITCH_HEIGHT - 3, this.SWITCH_WIDTH, 3);
        this.add(jLabel);
        jLabel = new JLabel();
        jLabel.setOpaque(true);
        jLabel.setBackground(SWITCH_DARK_COLOR);
        jLabel.setBounds(this.SWITCH_WIDTH - 3, 0, 3, this.SWITCH_HEIGHT);
        this.add(jLabel);
    }

    private void initLedsLeft() {
        int n = 0;
        while (n < this.numPorts) {
            LedGraphic ledGraphic = new LedGraphic();
            ledGraphic.setBounds(6, (int)((4.0f + this.LED_VGAP) * (float)(n / 2) + this.LED_VGAP + 2.0f), 4, 4);
            this.add(ledGraphic);
            this.leds[n] = ledGraphic;
            n += 2;
        }
    }

    private void initLedsRight() {
        int n = 1;
        while (n < this.numPorts) {
            LedGraphic ledGraphic = new LedGraphic();
            ledGraphic.setBounds(this.SWITCH_WIDTH - 4 - 2 - 4, (int)((4.0f + this.LED_VGAP) * (float)((n - 1) / 2) + this.LED_VGAP + 2.0f), 4, 4);
            this.add(ledGraphic);
            this.leds[n] = ledGraphic;
            n += 2;
        }
    }

    private void initPortsLeft() {
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(PORT_COLOR);
            jLabel.setOpaque(true);
            jLabel.setBounds(0, (int)((this.PORT_VGAP + 4.0f) * (float)(n / 2) + this.PORT_VGAP + 2.0f), 4, 4);
            this.add(jLabel);
            this.ports[n] = jLabel;
            n += 2;
        }
    }

    private void initPortsRight() {
        int n = 1;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(PORT_COLOR);
            jLabel.setOpaque(true);
            jLabel.setBounds(this.SWITCH_WIDTH - 4, (int)((this.PORT_VGAP + 4.0f) * (float)((n - 1) / 2) + this.PORT_VGAP + 2.0f), 4, 4);
            this.add(jLabel);
            this.ports[n] = jLabel;
            n += 2;
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        ((Component)jFrame).setSize(500, 500);
        SMFmSanSwitchGraphic sMFmSanSwitchGraphic = new SMFmSanSwitchGraphic(0, 0, 50, 700, 50, 20, 8, 1);
        jFrame.getContentPane().setLayout(new CustomLayout());
        jFrame.getContentPane().add(sMFmSanSwitchGraphic);
        ((Component)jFrame).setVisible(true);
        sMFmSanSwitchGraphic.setLedOn(0);
        sMFmSanSwitchGraphic.setLedOn(1);
        sMFmSanSwitchGraphic.setLedOn(2);
        sMFmSanSwitchGraphic.setLedError(3);
        sMFmSanSwitchGraphic.setLedOn(4);
        sMFmSanSwitchGraphic.setLedOn(5);
    }

    public void setLedError(int n) {
        this.leds[n].setLedError();
    }

    public void setLedOff(int n) {
        this.leds[n].setLedOff();
    }

    public void setLedOn(int n) {
        if (n < this.numPorts) {
            this.leds[n].setLedOn();
        }
    }

    class LedGraphic
    extends JLabel {
        Color color;

        public LedGraphic() {
            this.setOpaque(false);
            this.color = LED_OFF_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("NOT_CONNECTED"));
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.fillArc(0, 0, 4, 4, 0, 360);
        }

        public void setLedError() {
            this.color = LED_ERROR_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("ERROR"));
            this.repaint();
        }

        public void setLedOff() {
            this.color = LED_OFF_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("NOT_CONNECTED"));
            this.repaint();
        }

        public void setLedOn() {
            this.color = LED_ON_COLOR;
            this.setToolTipText(SMFmConfGlobal.getI18NString("CONNECTED"));
            this.repaint();
        }
    }
}

