/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.CustomLayout;
import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmConfGlobalShared;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmChassisGraphic;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmGraphicInterface;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPvSwitchGraphic;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmSwitchTabPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWciLinkBundle;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWciLinkGraphic;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeGraphic;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SMFmPvWCIXTopPanel
extends SMFmTopologyPanel {
    private static final int NODE_SWITCH_HGAP = 250;
    private static final int NODE_VGAP = 15;
    private final int SWITCH_HEIGHT = 200;
    private final int SWITCH_WIDTH = 85;
    private static final Color SWITCH_UNSELECTED_COLOR = Color.lightGray;
    private static final Color SWITCH_SELECTED_COLOR = new Color(160, 160, 250);
    private int CHASSIS_WIDTH;
    private static final int CHASSIS_VGAP = 30;
    private static final int CHASSIS_LINK_HGAP = 15;
    private static final int CHASSIS_TEXT_HEIGHT = 12;
    private static final int CHASSIS_TEXT_WIDTH = 100;
    private static final Color CHASSIS_COLOR = new Color(180, 180, 250);
    private static final int CHASSIS_TYPE_HEIGHT = 15;
    private static final Color LINK_HIGHLIGHT_COLOR = new Color(150, 150, 255);
    private static final Color LINK_SELECT_COLOR = new Color(255, 80, 255);
    private int LINK_THICKNESS = 2;
    private static final int LINK_HGAP = 10;
    private static final int LINK_GROUP_HGAP = 10;
    private static final int PANEL_BORDER_WIDTH = 20;
    private static final int PANEL_BORDER_HEIGHT = 20;
    private static final int NODE_TEXT_HEIGHT = 12;
    private static final Color ERROR_COLOR = Color.red;
    private static final Border HIGHLIGHT_BORDER = BorderFactory.createLineBorder(Color.cyan);
    private Color previousColor;
    private Color prevSelectedLinkOrigColor;
    private JLabel prevSelectedLink;
    private int NODE_WIDTH;
    private int NODE_HEIGHT;
    private int NODE_HGAP;
    private int SWITCH_Y;
    private int SWITCH_X;
    private int bottomY;
    private int rightX;
    private ImageIcon nodeIcon;
    private SMFmPartitionData pData;
    private Vector chassisVector;
    private SMFmPvSwitchGraphic sanSwitch;
    private int numPorts;
    private int orientation = 0;
    private Map switchMap;
    private JButton upButton;
    private JButton downButton;
    private String currentSwitch;
    private Border previousSwitchBorder;
    private Map switchErrorMap;
    private SMFmSwitchTabPanel switchTabPane;
    int size;
    private Map nodeInfo;
    private Vector links;
    private int lnkCt;
    private int groupCt;
    private List linkComponents = new ArrayList();

    public SMFmPvWCIXTopPanel(SMFmPartitionData sMFmPartitionData, Vector vector, SMFmResourceAccess sMFmResourceAccess) {
        super(sMFmPartitionData, sMFmResourceAccess);
        this.setLayout(new CustomLayout());
        this.setBackground(Color.white);
        this.pData = sMFmPartitionData;
        this.chassisVector = vector;
        this.setFilter(SMFmConfGlobal.getI18NString("ALL"), true);
        this.setFilter(SMFmConfGlobal.getI18NString("FAILED"), false);
        this.setShowState(SMFmConfGlobal.getI18NString("LARGE_ICONS"), true);
        this.setShowState(SMFmConfGlobal.getI18NString("SMALL_ICON"), false);
        this.size = 1;
        this.numPorts = 8;
        this.redrawAll();
    }

    public void bringSwitchToFront(SMFmPvSwitchGraphic sMFmPvSwitchGraphic) {
        if (sMFmPvSwitchGraphic == null) {
            return;
        }
        SMFmNodeData sMFmNodeData = (SMFmNodeData)sMFmPvSwitchGraphic.getUserObject();
        String string = String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId();
        this.sanSwitch = sMFmPvSwitchGraphic;
        if (this.switchMap.get(string) != null) {
            this.currentSwitch = string;
            this.switchTabPane.setSelectedIndex(this.switchTabPane.indexOfTab(this.currentSwitch));
        }
    }

    public void createSwitchMap() {
        this.nodeInfo = new HashMap();
        this.switchMap = new HashMap();
        Vector vector = this.pData.getNodes();
        int n = 0;
        while (n < vector.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.elementAt(n);
            if (sMFmNodeData.getChassisType() == 5) {
                String string = String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId();
                this.switchMap.put(string, sMFmNodeData);
                NodeLinkInfo nodeLinkInfo = new NodeLinkInfo();
                nodeLinkInfo.isSwitch = true;
                this.nodeInfo.put(string, nodeLinkInfo);
            }
            ++n;
        }
    }

    public void display(Object object) {
    }

    private void drawChassis() {
        int n = 20;
        int n2 = 0;
        int n3 = this.rightX + 250;
        int n4 = 0;
        while (n4 < this.chassisVector.size()) {
            SMFmChassisData sMFmChassisData = (SMFmChassisData)this.chassisVector.elementAt(n4);
            int n5 = n3;
            if (n4 != 0) {
                n += n2 + 30;
            }
            SMFmChassisGraphic sMFmChassisGraphic = new SMFmChassisGraphic(sMFmChassisData, this.pData.getNodes(), n5, n, this.size, true, this.resAcc);
            n2 = sMFmChassisGraphic.getTotalHeight();
            this.add(sMFmChassisGraphic);
            Vector vector = sMFmChassisData.getWnodeList();
            int n6 = 0;
            while (n6 < vector.size()) {
                SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.get(n6);
                String string = String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId();
                NodeLinkInfo nodeLinkInfo = new NodeLinkInfo();
                nodeLinkInfo.x = sMFmChassisGraphic.getWnodeXCoordinate(sMFmNodeData) + sMFmChassisGraphic.getX();
                nodeLinkInfo.y = sMFmChassisGraphic.getWnodeYCoordinate(sMFmNodeData) + sMFmChassisGraphic.getY();
                nodeLinkInfo.chassisRightEdgeX = sMFmChassisGraphic.getX() + sMFmChassisGraphic.getTotalWidth();
                this.nodeInfo.put(string, nodeLinkInfo);
                ++n6;
            }
            if (this.rightX < n5 + sMFmChassisGraphic.getTotalWidth()) {
                this.rightX = n5 + sMFmChassisGraphic.getTotalWidth();
            }
            ++n4;
        }
        if (this.bottomY < n + n2) {
            this.bottomY = n + n2;
        }
    }

    private void drawNodeLinks() {
        Object object;
        NodeLinkInfo nodeLinkInfo;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        int n = this.links.size();
        int n2 = 0;
        while (n2 < n) {
            NodeLinkInfo nodeLinkInfo2;
            object5 = (SMFmWciLinkData)this.links.get(n2);
            object4 = ((SMFmWciLinkData)object5).getScHosts();
            object3 = ((SMFmWciLinkData)object5).getDomainIds();
            String string = String.valueOf(object4[0]) + object3[0];
            object2 = String.valueOf(object4[1]) + (String)object3[1];
            NodeLinkInfo nodeLinkInfo3 = (NodeLinkInfo)this.nodeInfo.get(string);
            NodeLinkInfo nodeLinkInfo4 = (NodeLinkInfo)this.nodeInfo.get(object2);
            if (string.compareTo((String)object2) < 0) {
                nodeLinkInfo2 = nodeLinkInfo3;
                nodeLinkInfo = nodeLinkInfo4;
            } else {
                nodeLinkInfo2 = nodeLinkInfo4;
                nodeLinkInfo = nodeLinkInfo3;
            }
            if (!nodeLinkInfo.isSwitch && !nodeLinkInfo2.isSwitch) {
                object = new LinkInTree(nodeLinkInfo2, nodeLinkInfo, true);
                if (treeSet.contains(object)) {
                    object = (LinkInTree)treeSet.tailSet(object).first();
                    ((LinkInTree)object).addLink((SMFmWciLinkData)object5);
                } else {
                    treeSet.add(object);
                    ((LinkInTree)object).addLink((SMFmWciLinkData)object5);
                }
                treeSet.add(object);
            }
            ++n2;
        }
        object5 = treeSet.iterator();
        this.lnkCt = 0;
        this.groupCt = 0;
        while (object5.hasNext()) {
            object4 = (LinkInTree)object5.next();
            object3 = object4.lData;
            int n3 = 0;
            while (n3 < ((ArrayList)object3).size()) {
                object2 = (SMFmWciLinkData)((ArrayList)object3).get(n3);
                int n4 = ((SMFmWciLinkData)object2).getStatus();
                boolean bl = (Boolean)this.filters.get(SMFmConfGlobal.getI18NString("ALL"));
                boolean bl2 = (Boolean)this.filters.get(SMFmConfGlobal.getI18NString("FAILED"));
                if (bl || bl2 && n4 != 0) {
                    nodeLinkInfo = object4.start;
                    object = object4.end;
                    int n5 = nodeLinkInfo.x + this.NODE_WIDTH;
                    int n6 = nodeLinkInfo.y + this.NODE_HEIGHT;
                    int n7 = nodeLinkInfo.numRight++;
                    int n8 = nodeLinkInfo.chassisRightEdgeX - n5;
                    int n9 = ((NodeLinkInfo)object).x + this.NODE_WIDTH;
                    int n10 = ((NodeLinkInfo)object).y;
                    int n11 = ((NodeLinkInfo)object).numRight++;
                    int n12 = ((NodeLinkInfo)object).chassisRightEdgeX - n9;
                    int n13 = this.NODE_HEIGHT / ((ArrayList)object3).size() + 1;
                    if (n13 < 2) {
                        n13 = 2;
                    }
                    SMFmWciLinkBundle sMFmWciLinkBundle = new SMFmWciLinkBundle();
                    n10 += n11 * n13;
                    int n14 = n5 + n8 + 15 + 10 * this.lnkCt + 10 * this.groupCt;
                    int n15 = n9 + n12 + 15 + 10 * this.lnkCt + 10 * this.groupCt;
                    SMFmWciLinkGraphic sMFmWciLinkGraphic = new SMFmWciLinkGraphic((SMFmWciLinkData)object2, n5, n6 -= n7 * n13, n14, n6, this.LINK_THICKNESS, this.resAcc);
                    sMFmWciLinkGraphic.addLinkAccessPoint(this, sMFmWciLinkBundle, (SMFmWciLinkData)object2, n14, n6, 5, 3);
                    sMFmWciLinkBundle.addLink(sMFmWciLinkGraphic);
                    this.add((Component)sMFmWciLinkGraphic, 0);
                    sMFmWciLinkGraphic = new SMFmWciLinkGraphic((SMFmWciLinkData)object2, n9, n10, n15, n10, this.LINK_THICKNESS, this.resAcc);
                    sMFmWciLinkGraphic.addLinkAccessPoint(this, sMFmWciLinkBundle, (SMFmWciLinkData)object2, n15, n10, 5, 3);
                    sMFmWciLinkBundle.addLink(sMFmWciLinkGraphic);
                    this.add((Component)sMFmWciLinkGraphic, 0);
                    sMFmWciLinkGraphic = new SMFmWciLinkGraphic((SMFmWciLinkData)object2, n14, n6, n15, n10, this.LINK_THICKNESS, this.resAcc);
                    this.add((Component)sMFmWciLinkGraphic, 0);
                    sMFmWciLinkBundle.addLink(sMFmWciLinkGraphic);
                    sMFmWciLinkGraphic.addAlarmIcon(this, sMFmWciLinkBundle, (SMFmWciLinkData)object2, n14 + (n15 - n14) / 2, n6 + (n10 - n6) / 2);
                    ++this.lnkCt;
                }
                ++n3;
            }
            ++this.groupCt;
        }
    }

    private void drawSwitch(Map map, String string) {
        SwitchMouseAdapter switchMouseAdapter;
        this.SWITCH_Y = this.bottomY / 2 - 100;
        this.SWITCH_X = 20;
        if (this.SWITCH_Y < 20) {
            this.SWITCH_Y = 20;
        }
        this.switchTabPane = new SMFmSwitchTabPanel(2);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            switchMouseAdapter = null;
            this.switchTabPane.addTab(string2, (Icon)((Object)switchMouseAdapter), null);
        }
        int n = this.switchTabPane.getMaxTabWidth();
        this.switchTabPane.removeAll();
        switchMouseAdapter = new SwitchMouseAdapter();
        Iterator iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            String string3 = (String)iterator2.next();
            SMFmNodeData sMFmNodeData = (SMFmNodeData)map.get(string3);
            SMFmPvSwitchGraphic sMFmPvSwitchGraphic = new SMFmPvSwitchGraphic(sMFmNodeData, this.SWITCH_X + n, this.SWITCH_Y, 85, 200, this.numPorts, this.orientation, this.resAcc);
            sMFmPvSwitchGraphic.addMouseListener(switchMouseAdapter);
            Icon icon = null;
            this.switchTabPane.addTab(string3, icon, sMFmPvSwitchGraphic);
            NodeLinkInfo nodeLinkInfo = (NodeLinkInfo)this.nodeInfo.get(string3);
            nodeLinkInfo.x = this.SWITCH_X + n + 85 + 4;
            nodeLinkInfo.y = this.SWITCH_Y + 200 / (this.numPorts + 1);
        }
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        this.switchTabPane.setBounds(this.SWITCH_X, this.SWITCH_Y, n + 85 + 4, 200);
        this.add(this.switchTabPane);
        if (this.switchTabPane.indexOfTab(string) != -1) {
            this.switchTabPane.setSelectedIndex(this.switchTabPane.indexOfTab(string));
        }
        this.sanSwitch = (SMFmPvSwitchGraphic)this.switchTabPane.getSelectedComponent();
        this.switchTabPane.addMouseListener(switchMouseAdapter);
        this.rightX = n + 85 + 4;
    }

    private void drawSwitchLinks(String string) {
        NodeLinkInfo nodeLinkInfo;
        NodeLinkInfo nodeLinkInfo2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.resetNodeLinkInfo();
        TreeSet<LinkInTree> treeSet = new TreeSet<LinkInTree>();
        int n = this.links.size();
        int n2 = 0;
        while (n2 < n) {
            block13: {
                NodeLinkInfo nodeLinkInfo3;
                NodeLinkInfo nodeLinkInfo4;
                block12: {
                    String string2;
                    block11: {
                        object4 = (SMFmWciLinkData)this.links.get(n2);
                        object3 = ((SMFmWciLinkData)object4).getScHosts();
                        object2 = ((SMFmWciLinkData)object4).getDomainIds();
                        int[] nArray = ((SMFmWciLinkData)object4).getParoliIds();
                        object = String.valueOf(object3[0]) + (String)object2[0];
                        string2 = String.valueOf(object3[1]) + (String)object2[1];
                        nodeLinkInfo2 = (NodeLinkInfo)this.nodeInfo.get(object);
                        nodeLinkInfo = (NodeLinkInfo)this.nodeInfo.get(string2);
                        if (!nodeLinkInfo2.isSwitch || !string.equals(object)) break block11;
                        nodeLinkInfo4 = nodeLinkInfo;
                        nodeLinkInfo3 = nodeLinkInfo2;
                        break block12;
                    }
                    if (!nodeLinkInfo.isSwitch || !string.equals(string2)) break block13;
                    nodeLinkInfo4 = nodeLinkInfo2;
                    nodeLinkInfo3 = nodeLinkInfo;
                }
                LinkInTree linkInTree = new LinkInTree(nodeLinkInfo4, nodeLinkInfo3);
                if (treeSet.contains(linkInTree)) {
                    linkInTree = treeSet.tailSet(linkInTree).first();
                    linkInTree.addLink((SMFmWciLinkData)object4);
                    ++nodeLinkInfo4.currentNumLeft;
                } else {
                    treeSet.add(linkInTree);
                    linkInTree.addLink((SMFmWciLinkData)object4);
                    ++nodeLinkInfo4.currentNumLeft;
                }
                treeSet.add(linkInTree);
            }
            ++n2;
        }
        object4 = treeSet.iterator();
        while (object4.hasNext()) {
            object3 = (LinkInTree)object4.next();
            object2 = object3.lData;
            int n3 = 0;
            while (n3 < ((ArrayList)object2).size()) {
                object = (SMFmWciLinkData)((ArrayList)object2).get(n3);
                int n4 = ((SMFmWciLinkData)object).getStatus();
                if (((Boolean)this.filters.get(SMFmConfGlobal.getI18NString("ALL"))).booleanValue() || ((Boolean)this.filters.get(SMFmConfGlobal.getI18NString("FAILED"))).booleanValue() && n4 != 0) {
                    nodeLinkInfo2 = object3.start;
                    nodeLinkInfo = object3.end;
                    int n5 = nodeLinkInfo2.x;
                    int n6 = nodeLinkInfo2.y;
                    int n7 = nodeLinkInfo2.numLeft++;
                    int n8 = nodeLinkInfo.x;
                    int n9 = nodeLinkInfo.y;
                    int n10 = nodeLinkInfo.numRight++;
                    this.setPortNumber(n10, (SMFmWciLinkData)object);
                    int n11 = this.NODE_HEIGHT / nodeLinkInfo2.currentNumLeft;
                    if (n11 < 2) {
                        n11 = 2;
                    }
                    int n12 = 200 / (this.numPorts + 1);
                    n6 = n6 + n7 * n11 + 2;
                    n9 = n9 + n10 * n12 + 2;
                    SMFmWciLinkGraphic sMFmWciLinkGraphic = new SMFmWciLinkGraphic((SMFmWciLinkData)object, n5, n6, n8, n9, this.LINK_THICKNESS, this.resAcc);
                    this.add((Component)sMFmWciLinkGraphic, 0);
                    this.linkComponents.add(sMFmWciLinkGraphic);
                    SMFmWciLinkBundle sMFmWciLinkBundle = new SMFmWciLinkBundle();
                    SMFmWciLinkGraphic sMFmWciLinkGraphic2 = sMFmWciLinkGraphic.addAlarmIcon(this, sMFmWciLinkBundle, (SMFmWciLinkData)object, n8 + (n5 - n8) / 2, n9 + (n6 - n9) / 2);
                    if (sMFmWciLinkGraphic2 != null) {
                        this.linkComponents.add(sMFmWciLinkGraphic2);
                    }
                    sMFmWciLinkBundle.addLink(sMFmWciLinkGraphic);
                }
                ++n3;
            }
        }
    }

    public JComponent getAdvanced() {
        return null;
    }

    public Object getDisplayObject(String string) {
        return this.toBeDisplayed;
    }

    public boolean getFilter(String string) {
        return (Boolean)this.filters.get(string);
    }

    public Vector getFilters() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        Enumeration enumeration = this.filters.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector.addElement(string);
            vector.addElement((String)this.filters.get(string));
        }
        vector.trimToSize();
        return vector;
    }

    public int getIconSize() {
        return this.size;
    }

    public boolean getShowState(String string) {
        return (Boolean)this.shows.get(string);
    }

    public Vector getShowStates() {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(SMFmConfGlobal.getI18NString("LARGE_ICONS"));
        if (this.getIconSize() == 1) {
            vector.addElement(new Boolean(true));
        } else {
            vector.addElement(new Boolean(false));
        }
        vector.addElement(SMFmConfGlobal.getI18NString("SMALL_ICONS"));
        if (this.getIconSize() == 0) {
            vector.addElement(new Boolean(true));
        } else {
            vector.addElement(new Boolean(false));
        }
        return vector;
    }

    public void highlight(Object object) {
        super.highlight(object);
        SMFmGraphicInterface sMFmGraphicInterface = this.getSelectedGraphicObject();
        if (sMFmGraphicInterface != null && sMFmGraphicInterface.getType() == 4) {
            SMFmPvSwitchGraphic sMFmPvSwitchGraphic = (SMFmPvSwitchGraphic)sMFmGraphicInterface;
            this.bringSwitchToFront(sMFmPvSwitchGraphic);
            this.removeComponents(this.linkComponents);
            this.drawSwitchLinks(this.currentSwitch);
            this.repaint();
            this.revalidate();
        }
    }

    public void initGraphics() {
        this.LINK_THICKNESS = 1;
        this.NODE_WIDTH = SMFmWnodeGraphic.getIconWidth(this.size);
        this.NODE_HEIGHT = SMFmWnodeGraphic.getIconHeight(this.size);
        this.NODE_HGAP = (this.CHASSIS_WIDTH - this.NODE_WIDTH) / 2;
        this.CHASSIS_WIDTH = SMFmChassisGraphic.getIconWidth(this.size);
        Collections.sort(this.pData.getNodes());
        this.drawSwitch(this.switchMap, this.currentSwitch);
        this.drawChassis();
        if (this.switchMap.size() > 0) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)this.switchMap.get(this.currentSwitch);
            this.drawSwitchLinks(String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId());
        }
        this.drawNodeLinks();
        int n = this.rightX + 20;
        int n2 = this.bottomY + 20;
        Dimension dimension = new Dimension(n, n2);
        this.setPreferredSize(dimension);
    }

    private void procSwitchErrors() {
        this.switchErrorMap = new HashMap();
        int n = this.links.size();
        int n2 = 0;
        while (n2 < n) {
            Integer n3;
            Integer n4;
            SMFmWciLinkData sMFmWciLinkData = (SMFmWciLinkData)this.links.get(n2);
            String[] stringArray = sMFmWciLinkData.getScHosts();
            String[] stringArray2 = sMFmWciLinkData.getDomainIds();
            String string = String.valueOf(stringArray[0]) + stringArray2[0];
            String string2 = String.valueOf(stringArray[1]) + stringArray2[1];
            int n5 = sMFmWciLinkData.getStatus();
            if (this.switchMap.get(string) != null && n5 != 0) {
                n4 = (Integer)this.switchErrorMap.get(string);
                n3 = new Integer(SMFmConfGlobalShared.getDefaultLinkSeverity(n5));
                if (n4 == null || n3.compareTo(n4) > 0) {
                    this.switchErrorMap.put(string, n3);
                }
            } else if (this.switchMap.get(string2) != null && n5 != 0) {
                n4 = (Integer)this.switchErrorMap.get(string2);
                n3 = new Integer(SMFmConfGlobalShared.getDefaultLinkSeverity(n5));
                if (n4 == null || n3.compareTo(n4) > 0) {
                    this.switchErrorMap.put(string2, n3);
                }
            }
            ++n2;
        }
    }

    public void redrawAll() {
        this.removeAll();
        this.createSwitchMap();
        this.links = this.pData.getLinks();
        this.procSwitchErrors();
        this.showErrorSwitch();
        this.initGraphics();
    }

    public void redrawAllDontShowErrorSwitch() {
        this.removeAll();
        this.createSwitchMap();
        this.links = this.pData.getLinks();
        this.procSwitchErrors();
        this.initGraphics();
    }

    public void removeComponents(List list) {
        if (list != null && list.size() != 0) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                this.remove((Component)list.get(n2));
                ++n2;
            }
        }
    }

    public void resetNodeLinkInfo() {
        ArrayList arrayList = new ArrayList(this.nodeInfo.values());
        int n = 0;
        while (n < arrayList.size()) {
            NodeLinkInfo nodeLinkInfo = (NodeLinkInfo)arrayList.get(n);
            nodeLinkInfo.reset();
            ++n;
        }
    }

    public void setFilter(String string, boolean bl) {
        this.filters.put(string, new Boolean(bl));
    }

    public void setFilterState(String string) {
        Enumeration enumeration = this.filters.keys();
        while (enumeration.hasMoreElements()) {
            this.filters.put(enumeration.nextElement(), new Boolean(false));
        }
        this.filters.put(string, new Boolean(true));
        this.redrawAll();
        this.repaint();
        this.revalidate();
    }

    public void setIconSize(int n) {
        this.size = n;
        this.redrawAll();
    }

    public void setPortNumber(int n, SMFmWciLinkData sMFmWciLinkData) {
        String[] stringArray = sMFmWciLinkData.getDomainIds();
        int[] nArray = sMFmWciLinkData.getParoliIds();
        this.sanSwitch.setPortNumber(n, stringArray[0] == null || stringArray[0].equals("") ? nArray[0] : nArray[1]);
    }

    public void setShowState(String string) {
        if (string.equals(SMFmConfGlobal.getI18NString("LARGE_ICONS"))) {
            if (this.getIconSize() != 1) {
                this.setIconSize(1);
                this.repaint();
                this.revalidate();
                this.getParent().repaint();
            }
        } else if (string.equals(SMFmConfGlobal.getI18NString("SMALL_ICONS")) && this.getIconSize() != 0) {
            this.setIconSize(0);
            this.repaint();
            this.revalidate();
            this.getParent().repaint();
        }
    }

    public void setShowState(String string, boolean bl) {
        this.shows.put(string, new Boolean(bl));
    }

    public void showErrorSwitch() {
        if (this.switchErrorMap.size() > 0) {
            this.currentSwitch = (String)this.switchErrorMap.keySet().iterator().next();
        } else if (this.switchMap.size() > 0 && this.currentSwitch == null) {
            this.currentSwitch = (String)this.switchMap.keySet().iterator().next();
        }
    }

    class SwitchMouseAdapter
    extends MouseAdapter {
        SwitchMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            SMFmPvSwitchGraphic sMFmPvSwitchGraphic = null;
            if (component instanceof SMFmSwitchTabPanel) {
                SMFmSwitchTabPanel sMFmSwitchTabPanel = (SMFmSwitchTabPanel)component;
                sMFmPvSwitchGraphic = (SMFmPvSwitchGraphic)sMFmSwitchTabPanel.getSelectedComponent();
            } else if (component instanceof SMFmPvSwitchGraphic) {
                sMFmPvSwitchGraphic = (SMFmPvSwitchGraphic)component;
            }
            SMFmPvWCIXTopPanel.this.bringSwitchToFront(sMFmPvSwitchGraphic);
            SMFmPvWCIXTopPanel.this.removeComponents(SMFmPvWCIXTopPanel.this.linkComponents);
            SMFmPvWCIXTopPanel.this.drawSwitchLinks(SMFmPvWCIXTopPanel.this.currentSwitch);
            SMFmPvWCIXTopPanel.this.repaint();
            SMFmPvWCIXTopPanel.this.revalidate();
        }
    }

    private class LinkInTree
    implements Comparable {
        public NodeLinkInfo start;
        public NodeLinkInfo end;
        public ArrayList lData = new ArrayList();
        public boolean reverse;

        public LinkInTree(NodeLinkInfo nodeLinkInfo, NodeLinkInfo nodeLinkInfo2) {
            this.start = nodeLinkInfo;
            this.end = nodeLinkInfo2;
            this.reverse = false;
        }

        public LinkInTree(NodeLinkInfo nodeLinkInfo, NodeLinkInfo nodeLinkInfo2, boolean bl) {
            this.start = nodeLinkInfo;
            this.end = nodeLinkInfo2;
            this.reverse = bl;
        }

        public void addLink(SMFmWciLinkData sMFmWciLinkData) {
            this.lData.add(sMFmWciLinkData);
        }

        public int compareTo(Object object) {
            LinkInTree linkInTree = (LinkInTree)object;
            int n = linkInTree.end.y - linkInTree.start.y - (this.end.y - this.start.y);
            if (n == 0) {
                n = this.end.y - linkInTree.end.y;
            }
            return this.reverse ? -n : n;
        }
    }

    private class NodeLinkInfo {
        public int x;
        public int y;
        public int numLeft;
        public int numRight;
        public int currentNumLeft;
        public int currentNumRight;
        public int chassisRightEdgeX;
        public boolean isSwitch;

        NodeLinkInfo() {
        }

        public void reset() {
            this.numLeft = 0;
            this.numRight = 0;
            this.currentNumLeft = 0;
            this.currentNumRight = 0;
        }
    }
}

