/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.CustomLayout;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmGraphicInterface;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmSwitchPopupMenu;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWnodeDetailsDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SMFmPvSwitchGraphic
extends JPanel
implements SMFmGraphicInterface {
    public static final int LEFT_SWITCH = 0;
    public static final int RIGHT_SWITCH = 1;
    private static final int TYPE = 4;
    private static final int PORT_WIDTH = 6;
    private static final int PORT_HEIGHT = 10;
    private static final int PORTNUM_WIDTH = 8;
    private static final int PORTNUM_HEIGHT = 10;
    private static final int PORTNUM_PORT_HGAP = 3;
    private static final int LABEL_SWITCH_VGAP = 3;
    private static final int LABEL_HEIGHT = 10;
    private static final float SWITCH_FONT_SIZE = 10.0f;
    private static final float PORTNUM_FONT_SIZE = 9.0f;
    private static final int TEXT_LABEL_WIDTH = 100;
    private static final int TEXT_LABEL_HEIGHT = 12;
    private static final float TEXT_LABEL_FONT_SIZE = 11.0f;
    private int SWITCH_WIDTH;
    private int SWITCH_HEIGHT;
    private float PORT_HGAP;
    private static final Color PORT_COLOR = Color.black;
    private static final Color SWITCH_SELECTED_COLOR = new Color(100, 100, 150);
    private static final Color SWITCH_TEXT_COLOR = new Color(220, 220, 220);
    private static final Color SWITCH_CASCADED_COLOR = new Color(204, 204, 204);
    private static final Color LED_ON_COLOR = new Color(0, 230, 0);
    private static final Color LED_OFF_COLOR = new Color(160, 160, 160);
    private static final Color LED_ERROR_COLOR = new Color(225, 0, 0);
    boolean cascaded;
    int orientation;
    private boolean selected;
    private int numPorts;
    int xCord;
    int yCord;
    private JLabel[] ports;
    private JLabel[] portNumbers;
    private SMFmNodeData nData;
    private SMFmSwitchPopupMenu POPUP_MENU;
    private SMFmResourceAccess resAcc;

    public SMFmPvSwitchGraphic(SMFmNodeData sMFmNodeData, int n, int n2, int n3, int n4, int n5, int n6, SMFmResourceAccess sMFmResourceAccess) {
        this.resAcc = sMFmResourceAccess;
        this.POPUP_MENU = new SMFmSwitchPopupMenu(sMFmResourceAccess);
        this.cascaded = false;
        this.nData = sMFmNodeData;
        this.numPorts = n5;
        this.orientation = n6;
        this.SWITCH_WIDTH = n3;
        this.SWITCH_HEIGHT = n4;
        this.PORT_HGAP = n4 / (n5 + 1);
        this.xCord = n;
        this.yCord = n2;
        this.setBounds(n, n2, n3, n4);
        this.redrawAll();
    }

    public static Color getBackgroundColor() {
        return SWITCH_SELECTED_COLOR;
    }

    public static Color getForegroundColor() {
        return SWITCH_TEXT_COLOR;
    }

    public int getIconHeight() {
        return this.SWITCH_HEIGHT;
    }

    public int getIconWidth() {
        return this.SWITCH_WIDTH;
    }

    public String getInfobarText() {
        String string = this.nData.getScHost();
        return string;
    }

    public JLabel getTextLabel() {
        if (this.isCascadedSwitch()) {
            return null;
        }
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(0);
        jLabel.setHorizontalAlignment(0);
        jLabel.setText(this.nData.getScHost());
        jLabel.setToolTipText(this.nData.getScHost());
        jLabel.setFont(jLabel.getFont().deriveFont(11.0f));
        int n = this.xCord - (100 - this.SWITCH_WIDTH) / 2;
        int n2 = this.yCord + this.SWITCH_HEIGHT;
        jLabel.setBounds(n, n2, 100, 12);
        return jLabel;
    }

    public int getTotalHeight() {
        return this.SWITCH_HEIGHT + 12;
    }

    public int getTotalWidth() {
        return this.SWITCH_WIDTH > 100 ? this.SWITCH_WIDTH : 100;
    }

    public int getType() {
        return 4;
    }

    public Object getUserObject() {
        return this.nData;
    }

    public void highlight() {
        this.setBorder(BorderFactory.createLineBorder(SMFmGraphicInterface.HIGHLIGHT_COLOR, 1));
        this.repaint();
        this.revalidate();
    }

    private void initPortNumLeft() {
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel(String.valueOf(n));
            jLabel.setForeground(Color.black);
            jLabel.setFont(jLabel.getFont().deriveFont(9.0f));
            jLabel.setBounds(9, (int)(this.PORT_HGAP * (float)(n + 1) - 5.0f), 8, 10);
            this.add(jLabel);
            ++n;
        }
    }

    private void initPortNumRight() {
        this.portNumbers = new JLabel[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel(String.valueOf(n));
            jLabel.setForeground(SWITCH_TEXT_COLOR);
            jLabel.setHorizontalAlignment(4);
            jLabel.setFont(jLabel.getFont().deriveFont(9.0f));
            jLabel.setBounds(this.SWITCH_WIDTH - 6 - 3 - 8, (int)(this.PORT_HGAP * (float)(n + 1) - 5.0f), 8, 10);
            this.add(jLabel);
            this.portNumbers[n] = jLabel;
            ++n;
        }
    }

    private void initPortsLeft() {
        this.ports = new JLabel[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(PORT_COLOR);
            jLabel.setOpaque(true);
            jLabel.setBounds(0, (int)(this.PORT_HGAP * (float)(n + 1) - 5.0f), 6, 10);
            this.add(jLabel);
            this.ports[n] = jLabel;
            ++n;
        }
    }

    private void initPortsRight() {
        this.ports = new JLabel[this.numPorts];
        int n = 0;
        while (n < this.numPorts) {
            JLabel jLabel = new JLabel();
            jLabel.setBackground(PORT_COLOR);
            jLabel.setOpaque(true);
            jLabel.setBounds(this.SWITCH_WIDTH - 6, (int)(this.PORT_HGAP * (float)(n + 1) - 5.0f), 6, 10);
            this.add(jLabel);
            this.ports[n] = jLabel;
            ++n;
        }
    }

    public boolean isCascadedSwitch() {
        return this.cascaded;
    }

    private void redrawAll() {
        this.setLayout(new CustomLayout());
        this.setBounds(this.xCord, this.yCord, this.SWITCH_WIDTH, this.SWITCH_HEIGHT);
        this.setBackground(SWITCH_SELECTED_COLOR);
        this.setForeground(SWITCH_TEXT_COLOR);
        this.setOpaque(true);
        this.setToolTipText(SMFmConfGlobal.getI18NString("SUN_FIRE_LINK_SWITCH"));
        JLabel jLabel = new JLabel(SMFmConfGlobal.getI18NString("SUN_FIRE_LINK"));
        jLabel.setFont(jLabel.getFont().deriveFont(10.0f));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBounds(0, 3, this.SWITCH_WIDTH, 10);
        jLabel.setForeground(SWITCH_TEXT_COLOR);
        this.add(jLabel);
        jLabel = new JLabel(SMFmConfGlobal.getI18NString("SWITCH"));
        jLabel.setFont(jLabel.getFont().deriveFont(10.0f));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBounds(0, 13, this.SWITCH_WIDTH, 10);
        jLabel.setForeground(SWITCH_TEXT_COLOR);
        this.add(jLabel);
        if (this.orientation == 0) {
            this.initPortsRight();
            this.initPortNumRight();
        } else {
            this.initPortNumLeft();
            this.initPortsLeft();
        }
    }

    public void setCascadedSwitch(boolean bl) {
        this.cascaded = bl;
        this.removeAll();
        this.redrawAll();
    }

    public void setPortNumber(int n, int n2) {
        if (n < this.numPorts && n2 < this.numPorts && !this.portNumbers[n].getText().equals(String.valueOf(n2))) {
            int n3 = 0;
            while (n3 < this.portNumbers.length) {
                if (this.portNumbers[n3].getText().equals(String.valueOf(n2))) {
                    String string = this.portNumbers[n].getText();
                    this.portNumbers[n].setText(String.valueOf(n2));
                    this.portNumbers[n].repaint();
                    this.portNumbers[n3].setText(string);
                    this.portNumbers[n3].repaint();
                }
                ++n3;
            }
        }
    }

    public void setUserObject(Object object) {
        this.nData = (SMFmNodeData)object;
    }

    public void showDetailsDialog() {
        SMFmWnodeDetailsDialog sMFmWnodeDetailsDialog = new SMFmWnodeDetailsDialog((Frame)((JFrame)this.getTopLevelAncestor()), this.nData, this.resAcc);
        sMFmWnodeDetailsDialog.show();
    }

    public void showPopupMenu(Component component, int n, int n2) {
        this.POPUP_MENU.show(component, n, n2);
    }

    public void unhighlight() {
        this.setBorder(null);
        this.repaint();
        this.revalidate();
    }
}

