/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.common.CustomLayout;
import com.sun.symon.apps.wci.fmconf.common.SMFmChassisData;
import com.sun.symon.apps.wci.fmconf.common.SMFmNodeData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.common.SMFmWciLinkSetData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmChassisGraphic;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmStripeIcon;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmTopologyPanel;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWciLinkSetBundle;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmWciLinkSetGraphic;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SMFmPvDirConnectTopPanel
extends SMFmTopologyPanel {
    private static final int MAX_NODES = 16;
    private static final int C_VGAP = 1;
    private static final int C_HGAP = 25;
    private static final int INITIAL_GAP = 10;
    private static final int CHASSIS_INITIAL_GAP = 60;
    int C_WIDTH;
    int N_WIDTH;
    int N_HEIGHT;
    Vector chassis;
    SMFmPartitionData pData;
    Map nodesInPartition;
    private Map nodeInfo;
    int size;
    private int rightX;
    private int bottomY;

    public SMFmPvDirConnectTopPanel(SMFmPartitionData sMFmPartitionData, Vector vector, SMFmResourceAccess sMFmResourceAccess) {
        super(sMFmPartitionData, sMFmResourceAccess);
        this.setLayout(new CustomLayout());
        this.rightX = 0;
        this.bottomY = 0;
        this.chassis = vector;
        this.pData = sMFmPartitionData;
        this.setBackground(Color.white);
        this.setFilter(SMFmConfGlobal.getI18NString("ALL"), true);
        this.setFilter(SMFmConfGlobal.getI18NString("FAILED"), false);
        this.setShowState(SMFmConfGlobal.getI18NString("LARGE_ICONS"), true);
        this.setShowState(SMFmConfGlobal.getI18NString("SMALL_ICONS"), false);
        this.nodeInfo = new HashMap();
        this.createPanel();
    }

    private void addChassis(SMFmChassisData sMFmChassisData, Point point) {
        Vector vector = sMFmChassisData.getWnodeList();
        int n = vector.size();
        SMFmChassisGraphic sMFmChassisGraphic = new SMFmChassisGraphic(sMFmChassisData, this.pData.getNodes(), 0, 0, this.size, this.resAcc);
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        sMFmChassisGraphic.setLocation(n2, n3);
        this.add(sMFmChassisGraphic);
        if (this.rightX < n2 + sMFmChassisGraphic.getTotalWidth()) {
            this.rightX = n2 + sMFmChassisGraphic.getTotalWidth();
        }
        if (this.bottomY < n3 + sMFmChassisGraphic.getTotalHeight()) {
            this.bottomY = n3 + sMFmChassisGraphic.getTotalHeight();
        }
        point.translate(25 + sMFmChassisGraphic.getTotalWidth(), 1 + sMFmChassisGraphic.getTotalHeight());
        Vector vector2 = sMFmChassisData.getWnodeList();
        int n4 = 0;
        while (n4 < vector2.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)vector2.elementAt(n4);
            String string = String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId();
            if (this.nodesInPartition.get(string) != null) {
                NodeLinkInfo nodeLinkInfo = new NodeLinkInfo();
                nodeLinkInfo.x = sMFmChassisGraphic.getWnodeXCoordinate(sMFmNodeData) + sMFmChassisGraphic.getX();
                nodeLinkInfo.y = sMFmChassisGraphic.getWnodeYCoordinate(sMFmNodeData) + sMFmChassisGraphic.getY();
                this.nodeInfo.put(string, nodeLinkInfo);
            }
            ++n4;
        }
    }

    private void addLinkSets(Vector vector) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = true;
        TreeSet<LinkInTree> treeSet = new TreeSet<LinkInTree>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            NodeLinkInfo nodeLinkInfo;
            NodeLinkInfo nodeLinkInfo2;
            object4 = (SMFmWciLinkSetData)vector.elementAt(n2);
            object3 = ((SMFmWciLinkSetData)object4).getScHosts();
            String[] stringArray = ((SMFmWciLinkSetData)object4).getDomainIds();
            object2 = String.valueOf(object3[0]) + stringArray[0];
            object = String.valueOf(object3[1]) + stringArray[1];
            NodeLinkInfo nodeLinkInfo3 = (NodeLinkInfo)this.nodeInfo.get(object2);
            NodeLinkInfo nodeLinkInfo4 = (NodeLinkInfo)this.nodeInfo.get(object);
            if (((String)object2).compareTo((String)object) < 0) {
                nodeLinkInfo2 = nodeLinkInfo3;
                nodeLinkInfo = nodeLinkInfo4;
            } else {
                nodeLinkInfo2 = nodeLinkInfo4;
                nodeLinkInfo = nodeLinkInfo3;
            }
            treeSet.add(new LinkInTree(nodeLinkInfo2, nodeLinkInfo, (SMFmWciLinkSetData)object4));
            ++nodeLinkInfo2.currentNumRight;
            ++nodeLinkInfo.currentNumTop;
            ++n2;
        }
        object4 = treeSet.iterator();
        while (object4.hasNext()) {
            int n3;
            object3 = (LinkInTree)object4.next();
            int n4 = object3.lData.getHighestSeverityForLinks();
            if ((!((Boolean)this.filters.get(SMFmConfGlobal.getI18NString("FAILED"))).booleanValue() || n4 <= 0) && !((Boolean)this.filters.get(SMFmConfGlobal.getI18NString("ALL"))).booleanValue()) continue;
            object2 = object3.start;
            object = object3.end;
            SMFmWciLinkSetBundle sMFmWciLinkSetBundle = new SMFmWciLinkSetBundle();
            int n5 = ((NodeLinkInfo)object2).x;
            int n6 = ((NodeLinkInfo)object2).y;
            int n7 = ((NodeLinkInfo)object2).numRight++;
            int n8 = ((NodeLinkInfo)object).x;
            int n9 = ((NodeLinkInfo)object).y;
            int n10 = ((NodeLinkInfo)object).numTop++;
            int n11 = this.N_HEIGHT / ((NodeLinkInfo)object2).currentNumRight;
            if (n11 < 2) {
                n11 = 2;
            }
            if ((n3 = this.N_WIDTH / ((NodeLinkInfo)object).currentNumTop) < 2) {
                n3 = 2;
            }
            n6 = n6 + n7 * n11 + 2;
            n8 = n8 + this.N_WIDTH - n10 * n3 - 4;
            SMFmWciLinkSetGraphic sMFmWciLinkSetGraphic = new SMFmWciLinkSetGraphic(object3.lData, n5 + this.N_WIDTH, n6, n8, n6, true, this.resAcc);
            sMFmWciLinkSetBundle.addLink(sMFmWciLinkSetGraphic);
            sMFmWciLinkSetGraphic.addLinkAccessPoint(this, sMFmWciLinkSetBundle, object3.lData, n8, n6, 5, 3, true);
            this.add((Component)sMFmWciLinkSetGraphic, 0);
            SMFmWciLinkSetGraphic sMFmWciLinkSetGraphic2 = new SMFmWciLinkSetGraphic(object3.lData, n8, n6, n8, n9, true, this.resAcc);
            sMFmWciLinkSetBundle.addLink(sMFmWciLinkSetGraphic2);
            this.add((Component)sMFmWciLinkSetGraphic2, 0);
            sMFmWciLinkSetGraphic2.addAlarmIcon(this, sMFmWciLinkSetBundle, object3.lData, n8, n6, true);
        }
    }

    private void addStripeIconLabel(int n) {
        SMFmStripeIcon sMFmStripeIcon = new SMFmStripeIcon(n, 15, 15, 10, Color.black);
        JLabel jLabel = new JLabel(String.valueOf(SMFmConfGlobal.getI18NString("LINK_STRIPE_STRING")) + " " + n, sMFmStripeIcon, 2);
        int n2 = jLabel.getPreferredSize().width;
        int n3 = jLabel.getPreferredSize().height;
        jLabel.setBounds(10, 10, n2, n3);
        this.add(jLabel);
        if (this.bottomY < n3) {
            this.bottomY = n3;
        }
        if (this.rightX < n2) {
            this.rightX = n2;
        }
    }

    private void createPanel() {
        Object object;
        this.rightX = 0;
        this.bottomY = 0;
        this.size = (Boolean)this.shows.get(SMFmConfGlobal.getI18NString("SMALL_ICONS")) != false ? 0 : 1;
        this.setIconSize(this.size);
        this.N_WIDTH = this.getWnodeIconWidth();
        this.N_HEIGHT = this.getWnodeIconHeight();
        this.C_WIDTH = this.getChassisWidth();
        Vector vector = this.pData.getNodes();
        this.nodesInPartition = new HashMap();
        int n = 0;
        while (n < vector.size()) {
            SMFmNodeData sMFmNodeData = (SMFmNodeData)vector.elementAt(n);
            object = String.valueOf(sMFmNodeData.getScHost()) + sMFmNodeData.getDomainId();
            this.nodesInPartition.put(object, sMFmNodeData);
            ++n;
        }
        Collections.sort(vector);
        this.addStripeIconLabel(this.pData.getStriping());
        Point point = new Point(10, 10 + this.bottomY);
        int n2 = 0;
        while (n2 < this.chassis.size()) {
            object = (SMFmChassisData)this.chassis.elementAt(n2);
            this.addChassis((SMFmChassisData)object, point);
            ++n2;
        }
        this.addLinkSets(SMFmPartitionData.convertLinksIntoLinkSets(this.pData.getLinks()));
        Dimension dimension = new Dimension(this.rightX + 25, this.bottomY + 1);
        this.setPreferredSize(dimension);
    }

    public void display(Object object) {
    }

    public JComponent getAdvanced() {
        return null;
    }

    public Object getDisplayObject(String string) {
        return this.toBeDisplayed;
    }

    public boolean getFilter(String string) {
        boolean bl = (Boolean)this.filters.get(string);
        return bl;
    }

    public Vector getFilters() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        Enumeration enumeration = this.filters.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector.addElement(string);
            vector.addElement((String)this.filters.get(string));
        }
        vector.trimToSize();
        return vector;
    }

    public boolean getShowState(String string) {
        boolean bl = (Boolean)this.shows.get(string);
        return bl;
    }

    public Vector getShowStates() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        Enumeration enumeration = this.shows.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            vector.addElement(string);
            vector.addElement((String)this.shows.get(string));
        }
        vector.trimToSize();
        return vector;
    }

    public void setFilter(String string, boolean bl) {
        this.filters.put(string, new Boolean(bl));
    }

    public void setFilterState(String string) {
        Enumeration enumeration = this.filters.keys();
        while (enumeration.hasMoreElements()) {
            this.filters.put(enumeration.nextElement(), new Boolean(false));
        }
        this.filters.put(string, new Boolean(true));
        this.removeAll();
        this.createPanel();
    }

    public void setShowState(String string) {
        Enumeration enumeration = this.shows.keys();
        while (enumeration.hasMoreElements()) {
            this.shows.put(enumeration.nextElement(), new Boolean(false));
        }
        this.shows.put(string, new Boolean(true));
        this.removeAll();
        this.createPanel();
    }

    public void setShowState(String string, boolean bl) {
        this.shows.put(string, new Boolean(bl));
    }

    private class LinkInTree
    implements Comparable {
        public NodeLinkInfo start;
        public NodeLinkInfo end;
        SMFmWciLinkSetData lData;

        LinkInTree(NodeLinkInfo nodeLinkInfo, NodeLinkInfo nodeLinkInfo2, SMFmWciLinkSetData sMFmWciLinkSetData) {
            this.start = nodeLinkInfo;
            this.end = nodeLinkInfo2;
            this.lData = sMFmWciLinkSetData;
        }

        public int compareTo(Object object) {
            LinkInTree linkInTree = (LinkInTree)object;
            int n = linkInTree.end.x - linkInTree.start.x - (this.end.x - this.start.x);
            if (n == 0) {
                return this.end.x - linkInTree.end.x;
            }
            return n;
        }
    }

    private class NodeLinkInfo {
        public int x;
        public int y;
        public int numTop;
        public int numRight;
        public int currentNumTop;
        public int currentNumRight;

        NodeLinkInfo() {
        }
    }
}

