/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPassAddEditEntry;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPassEntry;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPassExportDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPassImportDialog;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPassUserTableModel;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SMFmPasswordDialog
extends JDialog {
    private SMFmPassUserTableModel dataModel;
    private ListSelectionModel lSelMod;
    private JLabel label;
    private JMenuBar mb;
    private JMenu fileMenu;
    private JMenuItem newMenu;
    private JMenuItem openMenu;
    private JMenuItem saveMenu;
    private JMenuItem deleteMenu;
    private JMenuItem exitMenu;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonDelete;
    private JButton buttonExit;
    private JPanel textPane;
    private JScrollPane scrollPane;
    private JPanel buttonPane;
    private Container contentPane;
    private JTable table;
    private File textFile;
    private int selectedRow;
    private List password;
    private Vector columnNames;
    private JDialog dialog = this;
    private JFrame parent;
    private String fmNameStr;
    private String fileName;
    private static final String fixedTempDir = "/var/opt/SUNWsymon/passfiles";
    private String passFileContents;
    private SMFmResourceAccess resAcc;

    public SMFmPasswordDialog(JFrame jFrame, boolean bl, String string, SMFmResourceAccess sMFmResourceAccess) {
        super(jFrame, "", bl);
        this.parent = jFrame;
        this.resAcc = sMFmResourceAccess;
        this.setTitle(SMFmConfGlobal.getI18NString("PASSWORD_MANAGER_TITLE"));
        this.fmNameStr = string;
        this.initComponents();
        this.processMenuItems();
        this.tableProcessing();
        this.buttonProcessing();
        this.layoutComponents();
        this.pack();
    }

    private void addToContentPane(int n, int n2, int n3, int n4, JComponent jComponent, Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = n3;
        gridBagConstraints.weighty = n4;
        gridBagConstraints.fill = 1;
        container.add((Component)jComponent, gridBagConstraints);
    }

    private void buttonProcessing() {
        this.buttonAdd = new JButton(SMFmConfGlobal.getI18NString("ADD"));
        this.buttonAdd.setMnemonic(65);
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPassAddEditEntry sMFmPassAddEditEntry = new SMFmPassAddEditEntry(SMFmPasswordDialog.this.parent);
                if (!sMFmPassAddEditEntry.isCanceled()) {
                    if (!SMFmPasswordDialog.this.checkForDuplicates(sMFmPassAddEditEntry)) {
                        SMFmPasswordDialog.this.dataModel.addRow(new SMFmPassEntry(sMFmPassAddEditEntry.getAENodeName(), sMFmPassAddEditEntry.getAEDomainID(), sMFmPassAddEditEntry.getAEUserName()));
                        SMFmPasswordDialog.this.password.add(sMFmPassAddEditEntry.getAEPassword());
                    } else {
                        JOptionPane.showMessageDialog(null, SMFmConfGlobal.getI18NString("DUPLICATE_ENTRY_FOUND"), SMFmConfGlobal.getI18NString("ERROR"), 0);
                    }
                }
            }
        });
        this.buttonEdit = new JButton(SMFmConfGlobal.getI18NString("EDIT"));
        this.buttonEdit.setMnemonic(69);
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPassAddEditEntry sMFmPassAddEditEntry = new SMFmPassAddEditEntry(SMFmPasswordDialog.this.parent, SMFmPasswordDialog.this.dataModel.getNodeName(SMFmPasswordDialog.this.selectedRow), SMFmPasswordDialog.this.dataModel.getDomainID(SMFmPasswordDialog.this.selectedRow), (String)SMFmPasswordDialog.this.dataModel.getValueAt(SMFmPasswordDialog.this.selectedRow, 1), (String)SMFmPasswordDialog.this.password.get(SMFmPasswordDialog.this.selectedRow));
                if (!sMFmPassAddEditEntry.isCanceled()) {
                    if (!SMFmPasswordDialog.this.checkForDuplicates(sMFmPassAddEditEntry)) {
                        SMFmPasswordDialog.this.dataModel.setValueAt(SMFmPasswordDialog.this.formatDomainIDColonNode(sMFmPassAddEditEntry.getAENodeName(), sMFmPassAddEditEntry.getAEDomainID()), SMFmPasswordDialog.this.selectedRow, 0);
                        SMFmPasswordDialog.this.dataModel.setValueAt(sMFmPassAddEditEntry.getAEUserName(), SMFmPasswordDialog.this.selectedRow, 1);
                        SMFmPasswordDialog.this.password.set(SMFmPasswordDialog.this.selectedRow, sMFmPassAddEditEntry.getAEPassword());
                    } else {
                        JOptionPane.showMessageDialog(null, SMFmConfGlobal.getI18NString("DUPLICATE_ENTRY_FOUND"), SMFmConfGlobal.getI18NString("ERROR"), 0);
                    }
                }
            }
        });
        this.buttonDelete = new JButton(SMFmConfGlobal.getI18NString("DELETE"));
        this.buttonDelete.setMnemonic(68);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(SMFmPasswordDialog.this, SMFmConfGlobal.getI18NString("DO_YOU_REALLY_WANT_TO_DELETE_THIS_ENTRY"), SMFmConfGlobal.getI18NString("CONIFIRM_DELETE"), 0);
                if (n == 0) {
                    SMFmPasswordDialog.this.dataModel.removeRow(SMFmPasswordDialog.this.selectedRow);
                }
            }
        });
        this.buttonExit = new JButton(SMFmConfGlobal.getI18NString("CLOSE"));
        this.buttonExit.setMnemonic(67);
        this.buttonExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPasswordDialog.this.verifyAndSave();
                SMFmPasswordDialog.this.restartTable();
                SMFmPasswordDialog.this.closeDialog();
            }
        });
    }

    private boolean checkForDuplicates(SMFmPassAddEditEntry sMFmPassAddEditEntry) {
        int n = 0;
        while (n < this.dataModel.getRowCount()) {
            if ((sMFmPassAddEditEntry.isAddEntry() || n != this.selectedRow) && this.dataModel.getNodeName(n).compareTo(sMFmPassAddEditEntry.getAENodeName()) == 0 && this.dataModel.getDomainID(n).compareTo(sMFmPassAddEditEntry.getAEDomainID()) == 0 && ((String)this.dataModel.getValueAt(n, 1)).compareTo(sMFmPassAddEditEntry.getAEUserName()) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void deleteFile() {
    }

    private void exportFile() {
        this.writeVectorText();
        SMFmPassExportDialog sMFmPassExportDialog = new SMFmPassExportDialog(this.dialog, true, this.fmNameStr, fixedTempDir, this.passFileContents, this.resAcc);
        sMFmPassExportDialog.show();
        this.table.setRowSelectionInterval(0, 0);
        this.grayAndUngrayComponents(false);
    }

    private String formatDomainIDColonNode(String string, String string2) {
        return String.valueOf(string) + ":" + string2;
    }

    private void grayAndUngrayComponents(boolean bl) {
        if (bl) {
            this.label.setText(this.fileName);
            this.label.setEnabled(true);
            this.saveMenu.setEnabled(true);
            this.buttonAdd.setEnabled(true);
            this.buttonEdit.setEnabled(true);
            this.buttonDelete.setEnabled(true);
        } else {
            this.label.setText(SMFmConfGlobal.getI18NString("NO_TEXTFILE_IS_CURRENTLY_OPEN"));
            this.label.setEnabled(false);
            this.saveMenu.setEnabled(false);
            this.buttonAdd.setEnabled(false);
            this.buttonEdit.setEnabled(false);
            this.buttonDelete.setEnabled(false);
        }
    }

    private void importFile() {
        SMFmPassImportDialog sMFmPassImportDialog = new SMFmPassImportDialog(this.dialog, true, this.fmNameStr, fixedTempDir, this.resAcc);
        sMFmPassImportDialog.show();
        this.passFileContents = sMFmPassImportDialog.getPassText();
        this.vectorTextIntoBuffer();
        this.fileName = sMFmPassImportDialog.getPassFileName();
        this.table.setRowSelectionInterval(0, 0);
        this.grayAndUngrayComponents(true);
    }

    private void initComponents() {
        this.label = new JLabel("");
        this.label.setText(SMFmConfGlobal.getI18NString("NO_TEXTFILE_IS_CURRENTLY_OPEN"));
        this.label.setEnabled(false);
        this.mb = new JMenuBar();
        this.fileMenu = new JMenu(SMFmConfGlobal.getI18NString("FILE_MENU"));
        this.fileMenu.setMnemonic(70);
        this.setJMenuBar(this.mb);
        this.mb.add(this.fileMenu);
        this.newMenu = new JMenuItem(SMFmConfGlobal.getI18NString("NEW_MENUITEM"), 78);
        this.fileMenu.add(this.newMenu);
        this.fileMenu.addSeparator();
        this.openMenu = new JMenuItem(SMFmConfGlobal.getI18NString("OPEN_MENUITEM"), 79);
        this.fileMenu.add(this.openMenu);
        this.saveMenu = new JMenuItem(SMFmConfGlobal.getI18NString("SAVE_MENUITEM"), 83);
        this.fileMenu.add(this.saveMenu);
        this.fileMenu.addSeparator();
        this.deleteMenu = new JMenuItem(SMFmConfGlobal.getI18NString("DELETE_MENUITEM"), 68);
        this.deleteMenu.setEnabled(false);
        this.fileMenu.add(this.deleteMenu);
        this.fileMenu.addSeparator();
        this.exitMenu = new JMenuItem(SMFmConfGlobal.getI18NString("CLOSE"), 67);
        this.fileMenu.add(this.exitMenu);
        this.password = new ArrayList();
        this.columnNames = new Vector();
        this.columnNames.add(SMFmConfGlobal.getI18NString("NODENAME_DOMAINID"));
        this.columnNames.add(SMFmConfGlobal.getI18NString("USERNAME"));
    }

    private void layoutComponents() {
        this.textPane = new JPanel();
        this.textPane.setLayout(new FlowLayout());
        this.textPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.textPane.add(this.label);
        this.scrollPane = new JScrollPane(this.table);
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new FlowLayout());
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPane.add(this.buttonAdd);
        this.buttonPane.add(this.buttonEdit);
        this.buttonPane.add(this.buttonDelete);
        this.buttonPane.add(this.buttonExit);
        this.buttonAdd.setNextFocusableComponent(this.buttonAdd);
        this.buttonEdit.setNextFocusableComponent(this.buttonEdit);
        this.buttonDelete.setNextFocusableComponent(this.buttonDelete);
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new GridBagLayout());
        this.addToContentPane(0, 0, 1, 0, this.textPane, this.contentPane);
        this.addToContentPane(0, 1, 1, 1, this.scrollPane, this.contentPane);
        this.addToContentPane(0, 2, 1, 0, this.buttonPane, this.contentPane);
    }

    private void processMenuItems() {
        this.newMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPasswordDialog.this.verifyAndSave();
                SMFmPasswordDialog.this.restartTable();
            }
        });
        this.openMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPasswordDialog.this.verifyAndSave();
                SMFmPasswordDialog.this.restartTable();
                SMFmPasswordDialog.this.importFile();
            }
        });
        this.saveMenu.setEnabled(false);
        this.saveMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPasswordDialog.this.exportFile();
                SMFmPasswordDialog.this.restartTable();
            }
        });
        this.exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPasswordDialog.this.verifyAndSave();
                SMFmPasswordDialog.this.restartTable();
                SMFmPasswordDialog.this.closeDialog();
            }
        });
    }

    private void restartTable() {
        this.dataModel.clearTable(this.columnNames);
        this.password.clear();
        this.table.sizeColumnsToFit(-1);
        this.table.setRowSelectionInterval(0, 0);
        this.fileName = SMFmConfGlobal.getI18NString("NO_TEXTFILE_IS_CURRENTLY_OPEN");
        this.grayAndUngrayComponents(true);
    }

    private void tableProcessing() {
        this.dataModel = new SMFmPassUserTableModel(new Vector(), this.columnNames);
        this.table = new JTable(this.dataModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(4);
        this.table.sizeColumnsToFit(-1);
        this.dataModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == -1 || tableModelEvent.getType() == 1 || tableModelEvent.getType() == 0) {
                    SMFmPasswordDialog.this.lSelMod.clearSelection();
                }
            }
        });
        this.lSelMod = this.table.getSelectionModel();
        this.lSelMod.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    SMFmPasswordDialog.this.buttonAdd.setEnabled(true);
                    SMFmPasswordDialog.this.buttonEdit.setEnabled(true);
                    SMFmPasswordDialog.this.buttonDelete.setEnabled(true);
                    SMFmPasswordDialog.this.selectedRow = listSelectionModel.getMinSelectionIndex();
                } else {
                    SMFmPasswordDialog.this.buttonAdd.setEnabled(false);
                    SMFmPasswordDialog.this.buttonEdit.setEnabled(false);
                    SMFmPasswordDialog.this.buttonDelete.setEnabled(false);
                }
            }
        });
    }

    private boolean vectorTextIntoBuffer() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.passFileContents, "\n", false);
        boolean bl = false;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            n = string.indexOf(" ");
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if ((n = string3.indexOf("/")) == -1) {
                return false;
            }
            String string4 = string3.substring(0, n);
            this.dataModel.addRow(new SMFmPassEntry(string2, string4));
            String string5 = string3.substring(n + 1);
            this.password.add(string5);
        }
        return true;
    }

    private void verifyAndSave() {
        int n;
        if (this.dataModel.getRowCount() > 0 && (n = JOptionPane.showConfirmDialog(this, SMFmConfGlobal.getI18NString("DO_YOU_WANT_TO_SAVE_CHANGES_TO"), SMFmConfGlobal.getI18NString("SAVE_OR_DISCARD"), 0)) == 0) {
            this.exportFile();
        }
    }

    private boolean writeVectorText() {
        this.passFileContents = "";
        int n = 0;
        while (n < this.dataModel.getRowCount()) {
            String string = String.valueOf((String)this.dataModel.getValueAt(n, 0)) + " " + (String)this.dataModel.getValueAt(n, 1) + "/" + (String)this.password.get(n) + "\n";
            this.passFileContents = String.valueOf(this.passFileContents) + string;
            string = "";
            ++n;
        }
        return true;
    }
}

