/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.wci.fmconf.console.presentation;

import com.sun.symon.apps.wci.fmconf.common.SMFmFabricData;
import com.sun.symon.apps.wci.fmconf.common.SMFmPartitionData;
import com.sun.symon.apps.wci.fmconf.console.presentation.SMFmPartitionDialog;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmConfGlobal;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccess;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessEvent;
import com.sun.symon.apps.wci.fmconf.console.tools.SMFmResourceAccessListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class SMFmPartitionProperties
extends SMFmPartitionDialog {
    private JButton closeButton;
    Vector partitionRow;
    int partLevel;
    private SMFmPartitionData partitionData;
    private SMFmResourceAccessListener resAccListener;

    public SMFmPartitionProperties(JDialog jDialog, boolean bl, SMFmPartitionData sMFmPartitionData, SMFmResourceAccess sMFmResourceAccess) {
        super(jDialog, sMFmResourceAccess, "", bl, 1);
        this.partitionData = sMFmPartitionData;
        this.buildDialog();
    }

    public SMFmPartitionProperties(JFrame jFrame, boolean bl, SMFmPartitionData sMFmPartitionData, SMFmResourceAccess sMFmResourceAccess) {
        super(jFrame, sMFmResourceAccess, "", bl, 1);
        this.partitionData = sMFmPartitionData;
        this.buildDialog();
    }

    public void addButtonsToPanel() {
        this.closeButton = new JButton(SMFmConfGlobal.getI18NString("closeButton.label"));
        this.closeButton.setMnemonic(SMFmConfGlobal.getI18NString("closeButton.mnemonic").charAt(0));
        this.buttonPanel.add(this.closeButton);
    }

    private void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SMFmPartitionProperties.this.closeDialog();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SMFmPartitionProperties.this.closeDialog();
            }
        });
        StripeLevelListener stripeLevelListener = new StripeLevelListener();
        this.l1Button.addActionListener(stripeLevelListener);
        this.l2Button.addActionListener(stripeLevelListener);
        this.l4Button.addActionListener(stripeLevelListener);
        this.resAccListener = new SMFmResourceAccessListener(){

            public void fabricUpdateFailed(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmPartitionProperties.this.closeButton.setEnabled(true);
            }

            public void fabricUpdated(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmFabricData sMFmFabricData = sMFmResourceAccessEvent.getFabricData();
                if (sMFmFabricData == null || sMFmFabricData.getPartitionByName(SMFmPartitionProperties.this.partitionData.getName()) == null) {
                    SMFmConfGlobal.DebugPrint("Partition was deleted unexpectedly, dialog exiting");
                    SMFmPartitionProperties.this.closeDialog();
                } else {
                    SMFmPartitionProperties.this.procPartForProperties();
                    SMFmPartitionProperties.this.closeButton.setEnabled(true);
                }
            }

            public void fabricUpdating(SMFmResourceAccessEvent sMFmResourceAccessEvent) {
                SMFmPartitionProperties.this.closeButton.setEnabled(false);
            }
        };
        this.resAcc.addSMFmResourceAccessListener(this.resAccListener);
    }

    protected void addToolTips() {
        super.addToolTips();
    }

    private void buildDialog() {
        this.setTitle(String.valueOf(SMFmConfGlobal.getI18NString("PARTITION_PROP_TITLE")) + " " + this.partitionData.getName());
        this.procPartForProperties();
        this.addListeners();
        this.addToolTips();
    }

    private void closeDialog() {
        this.resAcc.removeSMFmResourceAccessListenr(this.resAccListener);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void disableAllPartProperties() {
        this.partNameText.setEditable(false);
        this.dcButton.setEnabled(false);
        this.wcixButton.setEnabled(false);
        this.l1Button.setEnabled(false);
        this.l2Button.setEnabled(false);
        this.l4Button.setEnabled(false);
    }

    private void enableStripeLevel(boolean bl) {
        this.l1Button.setEnabled(bl);
        this.l2Button.setEnabled(bl);
        this.l4Button.setEnabled(bl);
    }

    private void procPartForProperties() {
        if (this.partitionData != null) {
            String string = this.partitionData.getName();
            int n = this.partitionData.getMode();
            int n2 = this.partitionData.getTopoType();
            this.partLevel = this.partitionData.getStriping();
            String string2 = this.partitionData.getMasterHostname();
            this.partNameText.setText(string);
            this.dcButton.setSelected(n2 == 0);
            this.wcixButton.setSelected(n2 == 2);
            this.l1Button.setSelected(this.partLevel == 1);
            this.l2Button.setSelected(this.partLevel == 2);
            this.l4Button.setSelected(this.partLevel == 4);
        }
        this.disableAllPartProperties();
    }

    class StripeLevelListener
    implements ActionListener {
        StripeLevelListener() {
        }

        static /* synthetic */ SMFmPartitionProperties access$0(StripeLevelListener stripeLevelListener) {
            return stripeLevelListener.SMFmPartitionProperties.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(SMFmPartitionProperties.this, SMFmConfGlobal.getI18NString("APPROVE_STRIPE_CHANGE"), SMFmConfGlobal.getI18NString("WARNING"), 0, 2);
            int n2 = 0;
            if (actionEvent.getSource() == SMFmPartitionProperties.this.l1Button) {
                n2 = 1;
            } else if (actionEvent.getSource() == SMFmPartitionProperties.this.l2Button) {
                n2 = 2;
            } else if (actionEvent.getSource() == SMFmPartitionProperties.this.l4Button) {
                n2 = 4;
            }
            int n3 = n2;
            if (n == 0) {
                Runnable runnable = new Runnable(n3, this){
                    private final /* synthetic */ int val$newStripeLevel;
                    private final /* synthetic */ StripeLevelListener this$1;
                    {
                        this.val$newStripeLevel = n;
                        this.this$1 = stripeLevelListener;
                    }

                    public void run() {
                        StripeLevelListener.access$0((StripeLevelListener)this.this$1).resAcc.upgradePartition(SMFmPartitionProperties.access$1(StripeLevelListener.access$0(this.this$1)).getName(), this.val$newStripeLevel);
                        String string = StripeLevelListener.access$0((StripeLevelListener)this.this$1).resAcc.getErrorMessage();
                        if (string != null) {
                            JOptionPane.showMessageDialog(StripeLevelListener.access$0(this.this$1).getParent(), string, SMFmConfGlobal.ERROR_FLAG_PRFX, 0);
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            } else {
                switch (SMFmPartitionProperties.this.partLevel) {
                    case 1: {
                        SMFmPartitionProperties.this.l1Button.setSelected(true);
                        break;
                    }
                    case 2: {
                        SMFmPartitionProperties.this.l2Button.setSelected(true);
                        break;
                    }
                    case 4: {
                        SMFmPartitionProperties.this.l4Button.setSelected(true);
                        break;
                    }
                }
            }
        }
    }
}

